/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractComplexSquareMatrix;
import JSci.maths.AbstractComplexVector;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.LinearMath;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.groups.AbelianGroup;

public class ComplexSquareMatrix
extends AbstractComplexSquareMatrix {
    protected final double[][] matrixRe;
    protected final double[][] matrixIm;

    public ComplexSquareMatrix(double[][] dArray, double[][] dArray2) {
        super(dArray.length);
        if (!ArrayMath.isSquare(dArray)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        if (!ArrayMath.isSquare(dArray2)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.matrixRe = dArray;
        this.matrixIm = dArray2;
    }

    public ComplexSquareMatrix(int n) {
        this(new double[n][n], new double[n][n]);
    }

    public ComplexSquareMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        int n = 0;
        while (n < this.numRows) {
            if (complexArray[n].length != complexArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            int n2 = 0;
            while (n2 < this.numCols) {
                this.matrixRe[n][n2] = complexArray[n][n2].real();
                this.matrixIm[n][n2] = complexArray[n][n2].imag();
                ++n2;
            }
            ++n;
        }
    }

    public ComplexSquareMatrix(AbstractComplexVector[] abstractComplexVectorArray) {
        this(abstractComplexVectorArray.length);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                this.matrixRe[n][n2] = abstractComplexVectorArray[n2].getComponent(n).real();
                this.matrixIm[n][n2] = abstractComplexVectorArray[n2].getComponent(n).imag();
                ++n2;
            }
            ++n;
        }
    }

    public boolean equals(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix != null && this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    if (!abstractComplexMatrix.getElement(n, n2).equals(this.matrixRe[n][n2], this.matrixIm[n][n2])) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(Complex.toString(this.matrixRe[n][n2], this.matrixIm[n][n2]));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public AbstractDoubleMatrix real() {
        return new DoubleSquareMatrix(this.matrixRe);
    }

    public AbstractDoubleMatrix imag() {
        return new DoubleSquareMatrix(this.matrixIm);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return new Complex(this.matrixRe[n][n2], this.matrixIm[n][n2]);
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getRealElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrixRe[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getImagElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrixIm[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrixRe[n][n2] = complex.real();
        this.matrixIm[n][n2] = complex.imag();
    }

    public void setElement(int n, int n2, double d, double d2) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrixRe[n][n2] = d;
        this.matrixIm[n][n2] = d2;
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.numCols) {
                d2 += Math.sqrt(this.matrixRe[n][n2] * this.matrixRe[n][n2] + this.matrixIm[n][n2] * this.matrixIm[n][n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                d += this.matrixRe[n][n2] * this.matrixRe[n][n2] + this.matrixIm[n][n2] * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    public Complex det() {
        if (this.numRows == 2) {
            return new Complex(this.matrixRe[0][0] * this.matrixRe[1][1] - this.matrixIm[0][0] * this.matrixIm[1][1] - this.matrixRe[0][1] * this.matrixRe[1][0] + this.matrixIm[0][1] * this.matrixIm[1][0], this.matrixRe[0][0] * this.matrixIm[1][1] + this.matrixIm[0][0] * this.matrixRe[1][1] - this.matrixRe[0][1] * this.matrixIm[1][0] - this.matrixIm[0][1] * this.matrixRe[1][0]);
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = (ComplexSquareMatrix[])this.luDecompose(null);
        double d = complexSquareMatrixArray[1].matrixRe[0][0];
        double d2 = complexSquareMatrixArray[1].matrixIm[0][0];
        int n = 1;
        while (n < this.numRows) {
            double d3 = d * complexSquareMatrixArray[1].matrixRe[n][n] - d2 * complexSquareMatrixArray[1].matrixIm[n][n];
            d2 = d * complexSquareMatrixArray[1].matrixIm[n][n] + d2 * complexSquareMatrixArray[1].matrixRe[n][n];
            d = d3;
            ++n;
        }
        return new Complex(d * (double)this.LUpivot[this.numRows], d2 * (double)this.LUpivot[this.numRows]);
    }

    public Complex trace() {
        double d = this.matrixRe[0][0];
        double d2 = this.matrixIm[0][0];
        int n = 1;
        while (n < this.numRows) {
            d += this.matrixRe[n][n];
            d2 += this.matrixIm[n][n];
            ++n;
        }
        return new Complex(d, d2);
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.matrixRe[n][0];
            dArray2[n][0] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.matrixRe[n][n2];
                dArray2[n][n2] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] + abstractComplexSquareMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] + abstractComplexSquareMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] + abstractComplexSquareMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] + abstractComplexSquareMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] + complexSquareMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] + complexSquareMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexSquareMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexSquareMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] - abstractComplexSquareMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] - abstractComplexSquareMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] - abstractComplexSquareMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] - abstractComplexSquareMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] - complexSquareMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] - complexSquareMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexSquareMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexSquareMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.matrixRe[n][0] * d - this.matrixIm[n][0] * d2;
            dArray2[n][0] = this.matrixRe[n][0] * d2 + this.matrixIm[n][0] * d;
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.matrixRe[n][n2] * d - this.matrixIm[n][n2] * d2;
                dArray2[n][n2] = this.matrixRe[n][n2] * d2 + this.matrixIm[n][n2] * d;
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.matrixRe[n][0];
            dArray2[n][0] = d * this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.matrixRe[n][n2];
                dArray2[n][n2] = d * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.numCols == complexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = complexVector.getComponent(0);
                dArray[n] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                dArray2[n] = this.matrixIm[n][0] * complex.real() + this.matrixRe[n][0] * complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = complexVector.getComponent(n2);
                    int n3 = n;
                    dArray[n3] = dArray[n3] + (this.matrixRe[n][n2] * complex.real() - this.matrixIm[n][n2] * complex.imag());
                    int n4 = n;
                    dArray2[n4] = dArray2[n4] + (this.matrixIm[n][n2] * complex.real() + this.matrixRe[n][n2] * complex.imag());
                    ++n2;
                }
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    Complex complex = abstractComplexSquareMatrix.getElement(0, n2);
                    dArray[n][n2] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                    dArray2[n][n2] = this.matrixIm[n][0] * complex.real() + this.matrixRe[n][0] * complex.imag();
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        complex = abstractComplexSquareMatrix.getElement(n3, n2);
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complex.real() - this.matrixIm[n][n3] * complex.imag());
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixIm[n][n3] * complex.real() + this.matrixRe[n][n3] * complex.imag());
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numCols == complexSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][0] * complexSquareMatrix.matrixRe[0][n2] - this.matrixIm[n][0] * complexSquareMatrix.matrixIm[0][n2];
                    dArray2[n][n2] = this.matrixIm[n][0] * complexSquareMatrix.matrixRe[0][n2] + this.matrixRe[n][0] * complexSquareMatrix.matrixIm[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complexSquareMatrix.matrixRe[n3][n2] - this.matrixIm[n][n3] * complexSquareMatrix.matrixIm[n3][n2]);
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixIm[n][n3] * complexSquareMatrix.matrixRe[n3][n2] + this.matrixRe[n][n3] * complexSquareMatrix.matrixIm[n3][n2]);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexSquareMatrix directSum(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n;
        double[][] dArray = new double[this.numRows + abstractComplexSquareMatrix.numRows][this.numCols + abstractComplexSquareMatrix.numCols];
        double[][] dArray2 = new double[this.numRows + abstractComplexSquareMatrix.numRows][this.numCols + abstractComplexSquareMatrix.numCols];
        int n2 = 0;
        while (n2 < this.numRows) {
            n = 0;
            while (n < this.numCols) {
                dArray[n2][n] = this.matrixRe[n2][n];
                dArray2[n2][n] = this.matrixIm[n2][n];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < abstractComplexSquareMatrix.numRows) {
            int n3 = 0;
            while (n3 < abstractComplexSquareMatrix.numCols) {
                Complex complex = abstractComplexSquareMatrix.getElement(n, n3);
                dArray[n + this.numRows][n3 + this.numCols] = complex.real();
                dArray2[n + this.numRows][n3 + this.numCols] = complex.imag();
                ++n3;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexSquareMatrix tensor(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        double[][] dArray = new double[this.numRows * abstractComplexSquareMatrix.numRows][this.numCols * abstractComplexSquareMatrix.numCols];
        double[][] dArray2 = new double[this.numRows * abstractComplexSquareMatrix.numRows][this.numCols * abstractComplexSquareMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                int n3 = 0;
                while (n3 < abstractComplexSquareMatrix.numRows) {
                    int n4 = 0;
                    while (n4 < abstractComplexSquareMatrix.numCols) {
                        Complex complex = abstractComplexSquareMatrix.getElement(n3, n4);
                        dArray[n * abstractComplexSquareMatrix.numRows + n3][n2 * abstractComplexSquareMatrix.numCols + n4] = this.matrixRe[n][n2] * complex.real() - this.matrixIm[n][n2] * complex.imag();
                        dArray2[n * abstractComplexSquareMatrix.numRows + n3][n2 * abstractComplexSquareMatrix.numCols + n4] = this.matrixIm[n][n2] * complex.real() + this.matrixRe[n][n2] * complex.imag();
                        ++n4;
                    }
                    ++n2;
                }
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix conjugate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(this.matrixRe, dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexSquareMatrix inverse() {
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        double[][] dArray4 = new double[n][n];
        ComplexSquareMatrix[] complexSquareMatrixArray = (ComplexSquareMatrix[])this.luDecompose(null);
        double d = complexSquareMatrixArray[0].matrixRe[0][0] * complexSquareMatrixArray[0].matrixRe[0][0] + complexSquareMatrixArray[0].matrixIm[0][0] * complexSquareMatrixArray[0].matrixIm[0][0];
        dArray[0][0] = complexSquareMatrixArray[0].matrixRe[0][0] / d;
        dArray2[0][0] = -complexSquareMatrixArray[0].matrixIm[0][0] / d;
        d = complexSquareMatrixArray[1].matrixRe[0][0] * complexSquareMatrixArray[1].matrixRe[0][0] + complexSquareMatrixArray[1].matrixIm[0][0] * complexSquareMatrixArray[1].matrixIm[0][0];
        dArray3[0][0] = complexSquareMatrixArray[1].matrixRe[0][0] / d;
        dArray4[0][0] = -complexSquareMatrixArray[1].matrixIm[0][0] / d;
        int n2 = 1;
        while (n2 < n) {
            d = complexSquareMatrixArray[0].matrixRe[n2][n2] * complexSquareMatrixArray[0].matrixRe[n2][n2] + complexSquareMatrixArray[0].matrixIm[n2][n2] * complexSquareMatrixArray[0].matrixIm[n2][n2];
            dArray[n2][n2] = complexSquareMatrixArray[0].matrixRe[n2][n2] / d;
            dArray2[n2][n2] = -complexSquareMatrixArray[0].matrixIm[n2][n2] / d;
            d = complexSquareMatrixArray[1].matrixRe[n2][n2] * complexSquareMatrixArray[1].matrixRe[n2][n2] + complexSquareMatrixArray[1].matrixIm[n2][n2] * complexSquareMatrixArray[1].matrixIm[n2][n2];
            dArray3[n2][n2] = complexSquareMatrixArray[1].matrixRe[n2][n2] / d;
            dArray4[n2][n2] = -complexSquareMatrixArray[1].matrixIm[n2][n2] / d;
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            int n4 = n3 + 1;
            while (n4 < n) {
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                int n5 = n3;
                while (n5 < n4) {
                    d2 -= complexSquareMatrixArray[0].matrixRe[n4][n5] * dArray[n5][n3] - complexSquareMatrixArray[0].matrixIm[n4][n5] * dArray2[n5][n3];
                    d3 -= complexSquareMatrixArray[0].matrixIm[n4][n5] * dArray[n5][n3] + complexSquareMatrixArray[0].matrixRe[n4][n5] * dArray2[n5][n3];
                    d4 -= dArray3[n3][n5] * complexSquareMatrixArray[1].matrixRe[n5][n4] - dArray4[n3][n5] * complexSquareMatrixArray[1].matrixIm[n5][n4];
                    d5 -= dArray4[n3][n5] * complexSquareMatrixArray[1].matrixRe[n5][n4] + dArray3[n3][n5] * complexSquareMatrixArray[1].matrixIm[n5][n4];
                    ++n5;
                }
                d = complexSquareMatrixArray[0].matrixRe[n4][n4] * complexSquareMatrixArray[0].matrixRe[n4][n4] + complexSquareMatrixArray[0].matrixIm[n4][n4] * complexSquareMatrixArray[0].matrixIm[n4][n4];
                dArray[n4][n3] = (d2 * complexSquareMatrixArray[0].matrixRe[n4][n4] + d3 * complexSquareMatrixArray[0].matrixIm[n4][n4]) / d;
                dArray2[n4][n3] = (d3 * complexSquareMatrixArray[0].matrixRe[n4][n4] - d2 * complexSquareMatrixArray[0].matrixIm[n4][n4]) / d;
                d = complexSquareMatrixArray[1].matrixRe[n4][n4] * complexSquareMatrixArray[1].matrixRe[n4][n4] + complexSquareMatrixArray[1].matrixIm[n4][n4] * complexSquareMatrixArray[1].matrixIm[n4][n4];
                dArray3[n3][n4] = (d4 * complexSquareMatrixArray[1].matrixRe[n4][n4] + d5 * complexSquareMatrixArray[1].matrixIm[n4][n4]) / d;
                dArray4[n3][n4] = (d5 * complexSquareMatrixArray[1].matrixRe[n4][n4] - d4 * complexSquareMatrixArray[1].matrixIm[n4][n4]) / d;
                ++n4;
            }
            ++n3;
        }
        double[][] dArray5 = new double[n][n];
        double[][] dArray6 = new double[n][n];
        int n6 = 0;
        while (n6 < n) {
            int n7;
            int n8 = 0;
            while (n8 < n6) {
                n7 = n6;
                while (n7 < n) {
                    double[] dArray7 = dArray5[n6];
                    int n9 = this.LUpivot[n8];
                    dArray7[n9] = dArray7[n9] + (dArray3[n6][n7] * dArray[n7][n8] - dArray4[n6][n7] * dArray2[n7][n8]);
                    double[] dArray8 = dArray6[n6];
                    int n10 = this.LUpivot[n8];
                    dArray8[n10] = dArray8[n10] + (dArray4[n6][n7] * dArray[n7][n8] + dArray3[n6][n7] * dArray2[n7][n8]);
                    ++n7;
                }
                ++n8;
            }
            n7 = n6;
            while (n7 < n) {
                int n11 = n7;
                while (n11 < n) {
                    double[] dArray9 = dArray5[n6];
                    int n12 = this.LUpivot[n7];
                    dArray9[n12] = dArray9[n12] + (dArray3[n6][n11] * dArray[n11][n7] - dArray4[n6][n11] * dArray2[n11][n7]);
                    double[] dArray10 = dArray6[n6];
                    int n13 = this.LUpivot[n7];
                    dArray10[n13] = dArray10[n13] + (dArray4[n6][n11] * dArray[n11][n7] + dArray3[n6][n11] * dArray2[n11][n7]);
                    ++n11;
                }
                ++n7;
            }
            ++n6;
        }
        return new ComplexSquareMatrix(dArray5, dArray6);
    }

    public final AbstractComplexSquareMatrix[] luDecompose(int[] nArray) {
        int n;
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        double[][] dArray4 = new double[n2][n2];
        double[] dArray5 = new double[n2];
        if (nArray == null) {
            nArray = new int[n2 + 1];
        }
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        nArray[n2] = 1;
        int n4 = 0;
        while (n4 < n2) {
            double d;
            int n5;
            double d2;
            double d3;
            double d4;
            double d5;
            n = 0;
            while (n < n4) {
                d5 = this.matrixRe[nArray[n]][n4];
                double d6 = this.matrixIm[nArray[n]][n4];
                int n6 = 0;
                while (n6 < n) {
                    d5 -= dArray3[n][n6] * dArray3[n6][n4] - dArray4[n][n6] * dArray4[n6][n4];
                    d6 -= dArray4[n][n6] * dArray3[n6][n4] + dArray3[n][n6] * dArray4[n6][n4];
                    ++n6;
                }
                dArray3[n][n4] = d5;
                dArray4[n][n4] = d6;
                ++n;
            }
            d5 = 0.0;
            int n7 = n4;
            int n8 = n4;
            while (n8 < n2) {
                double d7 = this.matrixRe[nArray[n8]][n4];
                d4 = this.matrixIm[nArray[n8]][n4];
                int n9 = 0;
                while (n9 < n4) {
                    d7 -= dArray3[n8][n9] * dArray3[n9][n4] - dArray4[n8][n9] * dArray4[n9][n4];
                    d4 -= dArray4[n8][n9] * dArray3[n9][n4] + dArray3[n8][n9] * dArray4[n9][n4];
                    ++n9;
                }
                dArray3[n8][n4] = d7;
                dArray4[n8][n4] = d4;
                double d8 = d7 * d7 + d4 * d4;
                if (d8 > d5) {
                    d5 = d8;
                    n7 = n8;
                }
                ++n8;
            }
            if (n7 != n4) {
                System.arraycopy(dArray3[n4], 0, dArray5, 0, n4 + 1);
                System.arraycopy(dArray3[n7], 0, dArray3[n4], 0, n4 + 1);
                System.arraycopy(dArray5, 0, dArray3[n7], 0, n4 + 1);
                System.arraycopy(dArray4[n4], 0, dArray5, 0, n4 + 1);
                System.arraycopy(dArray4[n7], 0, dArray4[n4], 0, n4 + 1);
                System.arraycopy(dArray5, 0, dArray4[n7], 0, n4 + 1);
                int n10 = nArray[n4];
                nArray[n4] = nArray[n7];
                nArray[n7] = n10;
                nArray[n2] = -nArray[n2];
            }
            double d9 = dArray3[n4][n4];
            d4 = dArray4[n4][n4];
            if (Math.abs(d9) < Math.abs(d4)) {
                d3 = d9 / d4;
                d2 = d9 * d3 + d4;
                n5 = n4 + 1;
                while (n5 < n2) {
                    d = (dArray3[n5][n4] * d3 + dArray4[n5][n4]) / d2;
                    dArray4[n5][n4] = (dArray4[n5][n4] * d3 - dArray3[n5][n4]) / d2;
                    dArray3[n5][n4] = d;
                    ++n5;
                }
            } else {
                d3 = d4 / d9;
                d2 = d9 + d4 * d3;
                n5 = n4 + 1;
                while (n5 < n2) {
                    d = (dArray3[n5][n4] + dArray4[n5][n4] * d3) / d2;
                    dArray4[n5][n4] = (dArray4[n5][n4] - dArray3[n5][n4] * d3) / d2;
                    dArray3[n5][n4] = d;
                    ++n5;
                }
            }
            ++n4;
        }
        n = 0;
        while (n < n2) {
            dArray[n][n] = 1.0;
            int n11 = n + 1;
            while (n11 < n2) {
                dArray[n11][n] = dArray3[n11][n];
                dArray2[n11][n] = dArray4[n11][n];
                dArray3[n11][n] = 0.0;
                dArray4[n11][n] = 0.0;
                ++n11;
            }
            ++n;
        }
        this.LU = new ComplexSquareMatrix[2];
        this.LU[0] = new ComplexSquareMatrix(dArray, dArray2);
        this.LU[1] = new ComplexSquareMatrix(dArray3, dArray4);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractComplexSquareMatrix[] polarDecompose() {
        Complex complex;
        double[] dArray;
        int n = this.numRows;
        AbstractComplexVector[] abstractComplexVectorArray = new AbstractComplexVector[n];
        try {
            dArray = LinearMath.eigenSolveHermitian(this, abstractComplexVectorArray);
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return null;
        }
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        double[][] dArray4 = new double[n][n];
        double[][] dArray5 = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            double d = Math.abs(dArray[n2]);
            complex = abstractComplexVectorArray[n2].getComponent(0).conjugate();
            dArray2[n2][0] = dArray[n2] * complex.real() / d;
            dArray3[n2][0] = dArray[n2] * complex.imag() / d;
            dArray4[n2][0] = d * complex.real();
            dArray5[n2][0] = d * complex.imag();
            int n3 = 1;
            while (n3 < n) {
                complex = abstractComplexVectorArray[n2].getComponent(n3).conjugate();
                dArray2[n2][n3] = dArray[n2] * complex.real() / d;
                dArray3[n2][n3] = dArray[n2] * complex.imag() / d;
                dArray4[n2][n3] = d * complex.real();
                dArray5[n2][n3] = d * complex.imag();
                ++n3;
            }
            ++n2;
        }
        double[][] dArray6 = new double[n][n];
        double[][] dArray7 = new double[n][n];
        double[][] dArray8 = new double[n][n];
        double[][] dArray9 = new double[n][n];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n) {
                complex = abstractComplexVectorArray[0].getComponent(n4);
                dArray6[n4][n5] = dArray2[0][n5] * complex.real() - dArray3[0][n5] * complex.imag();
                dArray7[n4][n5] = dArray3[0][n5] * complex.real() + dArray2[0][n5] * complex.imag();
                dArray8[n4][n5] = dArray4[0][n5] * complex.real() - dArray5[0][n5] * complex.imag();
                dArray9[n4][n5] = dArray5[0][n5] * complex.real() + dArray4[0][n5] * complex.imag();
                int n6 = 1;
                while (n6 < n) {
                    complex = abstractComplexVectorArray[n6].getComponent(n4);
                    double[] dArray10 = dArray6[n4];
                    int n7 = n5;
                    dArray10[n7] = dArray10[n7] + (dArray2[n6][n5] * complex.real() - dArray3[n6][n5] * complex.imag());
                    double[] dArray11 = dArray7[n4];
                    int n8 = n5;
                    dArray11[n8] = dArray11[n8] + (dArray3[n6][n5] * complex.real() + dArray2[n6][n5] * complex.imag());
                    double[] dArray12 = dArray8[n4];
                    int n9 = n5;
                    dArray12[n9] = dArray12[n9] + (dArray4[n6][n5] * complex.real() - dArray5[n6][n5] * complex.imag());
                    double[] dArray13 = dArray9[n4];
                    int n10 = n5;
                    dArray13[n10] = dArray13[n10] + (dArray5[n6][n5] * complex.real() + dArray4[n6][n5] * complex.imag());
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        AbstractComplexSquareMatrix[] abstractComplexSquareMatrixArray = new ComplexSquareMatrix[]{new ComplexSquareMatrix(dArray6, dArray7), new ComplexSquareMatrix(dArray8, dArray9)};
        return abstractComplexSquareMatrixArray;
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            complexArray[n][0] = complexMapping.map(this.matrixRe[n][0], this.matrixIm[n][0]);
            int n2 = 1;
            while (n2 < this.numCols) {
                complexArray[n][n2] = complexMapping.map(this.matrixRe[n][n2], this.matrixIm[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }
}

