/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.AbstractDoubleSquareMatrix;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractIntegerMatrix;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.DiagonalMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerDiagonalMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.TridiagonalMatrix;

public class DoubleDiagonalMatrix
extends AbstractDoubleSquareMatrix
implements DiagonalMatrix {
    protected final double[] diag;

    public DoubleDiagonalMatrix(int n) {
        this(new double[n]);
    }

    public DoubleDiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n].length != dArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            this.diag[n] = dArray[n][n];
            ++n;
        }
    }

    public DoubleDiagonalMatrix(double[] dArray) {
        super(dArray.length);
        this.diag = dArray;
    }

    public static DoubleDiagonalMatrix identity(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 1.0;
            ++n2;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DiagonalMatrix) {
            if (this.numRows != abstractDoubleMatrix.rows() || this.numCols != abstractDoubleMatrix.columns()) {
                return false;
            }
            if (Math.abs(this.diag[0] - abstractDoubleMatrix.getElement(0, 0)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            int n = 1;
            while (n < this.numRows) {
                if (Math.abs(this.diag[n] - abstractDoubleMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[] nArray = new int[this.numRows];
        int n = 0;
        while (n < this.numRows) {
            nArray[n] = Math.round((float)this.diag[n]);
            ++n;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        double[] dArray = new double[this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[n] = this.diag[n];
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, new double[this.numRows]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diag[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n != n2) {
                throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diag[n] = d;
    }

    public boolean isSymmetric() {
        return true;
    }

    public double det() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d *= this.diag[n];
            ++n;
        }
        return d;
    }

    public double trace() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d += this.diag[n];
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d = Math.abs(this.diag[0]);
        int n = 1;
        while (n < this.numRows) {
            double d2 = Math.abs(this.diag[n]);
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d = ExtraMath.hypot(d, this.diag[n]);
            ++n;
        }
        return d;
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return this.infNorm();
    }

    public AbstractDoubleSquareMatrix add(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.add((DoubleDiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DiagonalMatrix) {
            return this.addDiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.add((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            int n2 = 0;
            while (n2 < this.numRows) {
                dArray[n2][0] = abstractDoubleSquareMatrix.getElement(n2, 0);
                n = 1;
                while (n < this.numCols) {
                    dArray[n2][n] = abstractDoubleSquareMatrix.getElement(n2, n);
                    ++n;
                }
                ++n2;
            }
            n = 0;
            while (n < this.numRows) {
                double[] dArray2 = dArray[n];
                int n3 = n;
                dArray2[n3] = dArray2[n3] + this.diag[n];
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(doubleSquareMatrix.matrix[n], 0, dArray[n], 0, this.numRows);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.numRows) {
                double[] dArray2 = dArray[n2];
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + this.diag[n2];
                ++n2;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (this.numRows == doubleTridiagonalMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(this.numRows);
            System.arraycopy(doubleTridiagonalMatrix.ldiag, 0, doubleTridiagonalMatrix2.ldiag, 0, doubleTridiagonalMatrix.ldiag.length);
            System.arraycopy(doubleTridiagonalMatrix.udiag, 0, doubleTridiagonalMatrix2.udiag, 0, doubleTridiagonalMatrix.udiag.length);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] + doubleTridiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                doubleTridiagonalMatrix2.diag[n] = this.diag[n] + doubleTridiagonalMatrix.diag[n];
                ++n;
            }
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix addTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n = this.numRows;
        if (n == abstractDoubleSquareMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] + abstractDoubleSquareMatrix.getElement(0, 0);
            doubleTridiagonalMatrix.udiag[0] = abstractDoubleSquareMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.ldiag[n2] = abstractDoubleSquareMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix.diag[n2] = this.diag[n2] + abstractDoubleSquareMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix.udiag[n2] = abstractDoubleSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix.ldiag[n] = abstractDoubleSquareMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix.diag[n] = this.diag[n] + abstractDoubleSquareMatrix.getElement(n, n);
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix add(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.numRows == doubleDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] + doubleDiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] + doubleDiagonalMatrix.diag[n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleDiagonalMatrix addDiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numRows == abstractDoubleSquareMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] + abstractDoubleSquareMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] + abstractDoubleSquareMatrix.getElement(n, n);
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleSquareMatrix subtract(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.subtract((DoubleDiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DiagonalMatrix) {
            return this.subtractDiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.subtract((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            int n2 = 0;
            while (n2 < this.numRows) {
                dArray[n2][0] = -abstractDoubleSquareMatrix.getElement(n2, 0);
                n = 1;
                while (n < this.numCols) {
                    dArray[n2][n] = -abstractDoubleSquareMatrix.getElement(n2, n);
                    ++n;
                }
                ++n2;
            }
            n = 0;
            while (n < this.numRows) {
                double[] dArray2 = dArray[n];
                int n3 = n;
                dArray2[n3] = dArray2[n3] + this.diag[n];
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            int n2 = 0;
            while (n2 < this.numRows) {
                dArray[n2][0] = -doubleSquareMatrix.matrix[n2][0];
                n = 1;
                while (n < this.numCols) {
                    dArray[n2][n] = -doubleSquareMatrix.matrix[n2][n];
                    ++n;
                }
                ++n2;
            }
            n = 0;
            while (n < this.numRows) {
                double[] dArray2 = dArray[n];
                int n3 = n;
                dArray2[n3] = dArray2[n3] + this.diag[n];
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] - doubleTridiagonalMatrix.diag[0];
            doubleTridiagonalMatrix2.udiag[0] = -doubleTridiagonalMatrix.udiag[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.ldiag[n2] = -doubleTridiagonalMatrix.ldiag[n2];
                doubleTridiagonalMatrix2.diag[n2] = this.diag[n2] - doubleTridiagonalMatrix.diag[n2];
                doubleTridiagonalMatrix2.udiag[n2] = -doubleTridiagonalMatrix.udiag[n2];
                ++n2;
            }
            doubleTridiagonalMatrix2.ldiag[n] = -doubleTridiagonalMatrix.ldiag[n];
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] - doubleTridiagonalMatrix.diag[n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix subtractTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n = this.numRows;
        if (n == abstractDoubleSquareMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] - abstractDoubleSquareMatrix.getElement(0, 0);
            doubleTridiagonalMatrix.udiag[0] = -abstractDoubleSquareMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.ldiag[n2] = -abstractDoubleSquareMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix.diag[n2] = this.diag[n2] - abstractDoubleSquareMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix.udiag[n2] = -abstractDoubleSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix.ldiag[n] = -abstractDoubleSquareMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix.diag[n] = this.diag[n] - abstractDoubleSquareMatrix.getElement(n, n);
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix subtract(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.numRows == doubleDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] - doubleDiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] - doubleDiagonalMatrix.diag[n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleDiagonalMatrix subtractDiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numRows == abstractDoubleSquareMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] - abstractDoubleSquareMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] - abstractDoubleSquareMatrix.getElement(n, n);
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        double[] dArray = new double[this.numRows];
        dArray[0] = d * this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = d * this.diag[n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        double[] dArray = new double[this.numRows];
        dArray[0] = this.diag[0] / d;
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = this.diag[n] / d;
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public double scalarProduct(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.scalarProduct((DoubleDiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.scalarProduct((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.scalarProduct((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double d = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * abstractDoubleSquareMatrix.getElement(n, n);
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double d = this.diag[0] * doubleSquareMatrix.matrix[0][0];
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * doubleSquareMatrix.matrix[n][n];
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (this.numRows == doubleTridiagonalMatrix.numRows) {
            double d = this.diag[0] * doubleTridiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * doubleTridiagonalMatrix.diag[n];
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.numRows == doubleDiagonalMatrix.numRows) {
            double d = this.diag[0] * doubleDiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * doubleDiagonalMatrix.diag[n];
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] * abstractDoubleVector.getComponent(0);
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] * abstractDoubleVector.getComponent(n);
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleSquareMatrix multiply(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.multiply((DoubleDiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DiagonalMatrix) {
            return this.multiplyDiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.multiply((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            int n = abstractDoubleSquareMatrix.columns();
            double[][] dArray = new double[this.numRows][n];
            int n2 = 0;
            while (n2 < this.numRows) {
                dArray[n2][0] = this.diag[0] * abstractDoubleSquareMatrix.getElement(n2, 0);
                int n3 = 1;
                while (n3 < n) {
                    dArray[n2][n3] = this.diag[n2] * abstractDoubleSquareMatrix.getElement(n2, n3);
                    ++n3;
                }
                ++n2;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleSquareMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.diag[0] * doubleSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < doubleSquareMatrix.numCols) {
                    dArray[n][n2] = this.diag[n] * doubleSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleTridiagonalMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == doubleTridiagonalMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] * doubleTridiagonalMatrix.diag[0];
            doubleTridiagonalMatrix2.udiag[0] = this.diag[0] * doubleTridiagonalMatrix.udiag[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.ldiag[n2] = this.diag[n2] * doubleTridiagonalMatrix.ldiag[n2];
                doubleTridiagonalMatrix2.diag[n2] = this.diag[n2] * doubleTridiagonalMatrix.diag[n2];
                doubleTridiagonalMatrix2.udiag[n2] = this.diag[n2] * doubleTridiagonalMatrix.udiag[n2];
                ++n2;
            }
            doubleTridiagonalMatrix2.ldiag[n] = this.diag[n] * doubleTridiagonalMatrix.ldiag[n];
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] * doubleTridiagonalMatrix.diag[n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleTridiagonalMatrix multiplyTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 0);
            doubleTridiagonalMatrix.udiag[0] = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.ldiag[n2] = this.diag[n2] * abstractDoubleSquareMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix.diag[n2] = this.diag[n2] * abstractDoubleSquareMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix.udiag[n2] = this.diag[n2] * abstractDoubleSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix.ldiag[n] = this.diag[n] * abstractDoubleSquareMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix.diag[n] = this.diag[n] * abstractDoubleSquareMatrix.getElement(n, n);
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleDiagonalMatrix multiply(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.numCols == doubleDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] * doubleDiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] * doubleDiagonalMatrix.diag[n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleDiagonalMatrix multiplyDiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] * abstractDoubleSquareMatrix.getElement(n, n);
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        return this;
    }

    public AbstractDoubleSquareMatrix inverse() {
        double[] dArray = new double[this.numRows];
        dArray[0] = 1.0 / this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = 1.0 / this.diag[n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public AbstractDoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        int n = 0;
        while (n < this.numRows) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.numRows] = 1;
        this.LU = new AbstractDoubleSquareMatrix[2];
        this.LU[0] = DoubleDiagonalMatrix.identity(this.numRows);
        this.LU[1] = this;
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[2];
        double[] dArray = new double[this.numRows];
        dArray[0] = Math.sqrt(this.diag[0]);
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = Math.sqrt(this.diag[n]);
            ++n;
        }
        abstractDoubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        abstractDoubleSquareMatrixArray[1] = abstractDoubleSquareMatrixArray[0];
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] qrDecompose() {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{DoubleDiagonalMatrix.identity(this.numRows), this};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int n = this.numRows;
        int n2 = n - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = -1.0;
            dArray2[n3] = Math.abs(this.diag[n3]);
            dArray3[n3] = this.diag[n3] < 0.0 ? 1.0 : -1.0;
            ++n3;
        }
        dArray[n2] = 1.0;
        dArray2[n2] = Math.abs(this.diag[n2]);
        dArray3[n2] = this.diag[n2] < 0.0 ? -1.0 : 1.0;
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleDiagonalMatrix(dArray), new DoubleDiagonalMatrix(dArray2), new DoubleDiagonalMatrix(dArray3)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        double[] dArray = new double[this.numRows];
        dArray[0] = mapping.map(this.diag[0]);
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = mapping.map(this.diag[n]);
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }
}

