/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractIntegerMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSparseSquareMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class DoubleSparseMatrix
extends AbstractDoubleMatrix {
    private double[] elements;
    private int[] colPos;
    private int[] rows;

    public DoubleSparseMatrix(int n, int n2) {
        super(n, n2);
        this.elements = new double[0];
        this.colPos = new int[0];
        this.rows = new int[this.numRows + 1];
    }

    public DoubleSparseMatrix(double[][] dArray) {
        super(dArray.length, dArray[0].length);
        int n;
        this.rows = new int[this.numRows + 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numRows) {
            if (dArray[n3].length != dArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            n = 0;
            while (n < this.numCols) {
                if (Math.abs(dArray[n3][n]) > GlobalSettings.ZERO_TOL) {
                    ++n2;
                }
                ++n;
            }
            ++n3;
        }
        this.elements = new double[n2];
        this.colPos = new int[n2];
        n2 = 0;
        n = 0;
        while (n < this.numRows) {
            this.rows[n] = n2;
            int n4 = 0;
            while (n4 < this.numCols) {
                if (Math.abs(dArray[n][n4]) > GlobalSettings.ZERO_TOL) {
                    this.elements[n2] = dArray[n][n4];
                    this.colPos[n2] = n4;
                    ++n2;
                }
                ++n4;
            }
            ++n;
        }
        this.rows[this.numRows] = n2;
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numRows == abstractDoubleMatrix.numRows && this.numCols == abstractDoubleMatrix.numCols) {
            if (abstractDoubleMatrix instanceof DoubleSparseMatrix) {
                DoubleSparseMatrix doubleSparseMatrix = (DoubleSparseMatrix)abstractDoubleMatrix;
                if (this.colPos.length != doubleSparseMatrix.colPos.length) {
                    return false;
                }
                int n = 1;
                while (n < this.rows.length) {
                    if (this.rows[n] != doubleSparseMatrix.rows[n]) {
                        return false;
                    }
                    ++n;
                }
                int n2 = 1;
                while (n2 < this.colPos.length) {
                    if (this.colPos[n2] != doubleSparseMatrix.colPos[n2]) {
                        return false;
                    }
                    if (Math.abs(this.elements[n2] - doubleSparseMatrix.elements[n2]) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            int n = 0;
            while (n < this.numRows) {
                int n3 = 0;
                while (n3 < this.numCols) {
                    if (Math.abs(this.getElement(n, n3) - abstractDoubleMatrix.getElement(n, n3)) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n3;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                nArray[n][n2] = Math.round((float)this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, new double[this.numRows][this.numCols]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    return this.elements[n3];
                }
                ++n3;
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
                return;
            }
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    this.elements[n3] = d;
                    return;
                }
                ++n3;
            }
            double[] dArray = this.elements;
            int[] nArray = this.colPos;
            this.elements = new double[dArray.length + 1];
            this.colPos = new int[nArray.length + 1];
            System.arraycopy(dArray, 0, this.elements, 0, this.rows[n]);
            System.arraycopy(nArray, 0, this.colPos, 0, this.rows[n]);
            int n4 = this.rows[n];
            while (n4 < this.rows[n + 1] && nArray[n4] < n2) {
                this.elements[n4] = dArray[n4];
                this.colPos[n4] = nArray[n4];
                ++n4;
            }
            this.elements[n4] = d;
            this.colPos[n4] = n2;
            System.arraycopy(dArray, n4, this.elements, n4 + 1, dArray.length - n4);
            System.arraycopy(nArray, n4, this.colPos, n4 + 1, nArray.length - n4);
            n4 = n + 1;
            while (n4 < this.rows.length) {
                int n5 = n4++;
                this.rows[n5] = this.rows[n5] + 1;
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = this.rows[n];
            while (n2 < this.rows[n + 1]) {
                d2 += Math.abs(this.elements[n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.colPos.length) {
            d += this.elements[n] * this.elements[n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public AbstractDoubleMatrix add(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleSparseMatrix) {
            return this.add((DoubleSparseMatrix)abstractDoubleMatrix);
        }
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.add((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.elements[n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] + abstractDoubleMatrix.getElement(n, 0);
                int n3 = 1;
                while (n3 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] + abstractDoubleMatrix.getElement(n, n3);
                    ++n3;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.elements[n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] + doubleMatrix.matrix[n][0];
                int n3 = 1;
                while (n3 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] + doubleMatrix.matrix[n][n3];
                    ++n3;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix add(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numRows == doubleSparseMatrix.numRows && this.numCols == doubleSparseMatrix.numCols) {
            DoubleSparseMatrix doubleSparseMatrix2 = new DoubleSparseMatrix(this.numRows, this.numCols);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    doubleSparseMatrix2.setElement(n, n2, this.getElement(n, n2) + doubleSparseMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix subtract(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleSparseMatrix) {
            return this.subtract((DoubleSparseMatrix)abstractDoubleMatrix);
        }
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.subtract((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.elements[n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] - abstractDoubleMatrix.getElement(n, 0);
                int n3 = 1;
                while (n3 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] - abstractDoubleMatrix.getElement(n, n3);
                    ++n3;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.elements[n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] - doubleMatrix.matrix[n][0];
                int n3 = 1;
                while (n3 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] - doubleMatrix.matrix[n][n3];
                    ++n3;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix subtract(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numRows == doubleSparseMatrix.numRows && this.numCols == doubleSparseMatrix.numCols) {
            DoubleSparseMatrix doubleSparseMatrix2 = new DoubleSparseMatrix(this.numRows, this.numCols);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    doubleSparseMatrix2.setElement(n, n2, this.getElement(n, n2) - doubleSparseMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numRows, this.numCols);
        doubleSparseMatrix.elements = new double[this.elements.length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseMatrix.elements[n] = d * this.elements[n];
            ++n;
        }
        return doubleSparseMatrix;
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numRows, this.numCols);
        doubleSparseMatrix.elements = new double[this.elements.length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseMatrix.elements[n] = this.elements[n] / d;
            ++n;
        }
        return doubleSparseMatrix;
    }

    public double scalarProduct(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.scalarProduct((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.numRows && this.numCols == abstractDoubleMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.elements[n2] * abstractDoubleMatrix.getElement(n, this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.elements[n2] * doubleMatrix.matrix[n][this.colPos[n2]];
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.elements[n2] * abstractDoubleVector.getComponent(this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleMatrix multiply(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleSparseMatrix) {
            return this.multiply((DoubleSparseMatrix)abstractDoubleMatrix);
        }
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.multiply((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numCols == abstractDoubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][abstractDoubleMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < abstractDoubleMatrix.numCols) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.elements[n3] * abstractDoubleMatrix.getElement(this.colPos[n3], n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == abstractDoubleMatrix.numCols) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        if (this.numCols == doubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.numCols) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.elements[n3] * doubleMatrix.matrix[this.colPos[n3]][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == doubleMatrix.numCols) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix multiply(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numCols == doubleSparseMatrix.numRows) {
            AbstractDoubleMatrix abstractDoubleMatrix = this.numRows == doubleSparseMatrix.numCols ? new DoubleSparseSquareMatrix(this.numRows) : new DoubleSparseMatrix(this.numRows, doubleSparseMatrix.numCols);
            int n = 0;
            while (n < abstractDoubleMatrix.numRows) {
                int n2 = 0;
                while (n2 < abstractDoubleMatrix.numCols) {
                    double d = 0.0;
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        d += this.elements[n3] * doubleSparseMatrix.getElement(this.colPos[n3], n2);
                        ++n3;
                    }
                    abstractDoubleMatrix.setElement(n, n2, d);
                    ++n2;
                }
                ++n;
            }
            return abstractDoubleMatrix;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numCols, this.numRows);
        int n = 0;
        while (n < this.numRows) {
            doubleSparseMatrix.setElement(0, n, this.getElement(n, 0));
            int n2 = 1;
            while (n2 < this.numCols) {
                doubleSparseMatrix.setElement(n2, n, this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return doubleSparseMatrix;
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numRows, this.numCols);
        doubleSparseMatrix.elements = new double[this.elements.length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseMatrix.elements[n] = mapping.map(this.elements[n]);
            ++n;
        }
        return doubleSparseMatrix;
    }
}

