/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.Complex;
import JSci.maths.NumericalConstants;

public final class FourierMath
extends AbstractMath
implements NumericalConstants {
    private FourierMath() {
    }

    public static Complex[] transform(Complex[] complexArray) {
        int n = complexArray.length;
        if (!FourierMath.isPowerOf2(n)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = FourierMath.numberOfBitsNeeded(n);
        int n3 = 0;
        while (n3 < n) {
            int n4 = FourierMath.reverseBits(n3, n2);
            dArray[n4] = complexArray[n3].real();
            dArray2[n4] = complexArray[n3].imag();
            ++n3;
        }
        FourierMath.fft(dArray, dArray2, Math.PI * 2);
        Complex[] complexArray2 = new Complex[n];
        int n5 = 0;
        while (n5 < n) {
            complexArray2[n5] = new Complex(dArray[n5], dArray2[n5]);
            ++n5;
        }
        return complexArray2;
    }

    public static Complex[] transform(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (!FourierMath.isPowerOf2(n)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        int n2 = FourierMath.numberOfBitsNeeded(n);
        int n3 = 0;
        while (n3 < n) {
            int n4 = FourierMath.reverseBits(n3, n2);
            dArray3[n4] = dArray[n3];
            dArray4[n4] = dArray2[n3];
            ++n3;
        }
        FourierMath.fft(dArray3, dArray4, Math.PI * 2);
        Complex[] complexArray = new Complex[n];
        int n5 = 0;
        while (n5 < n) {
            complexArray[n5] = new Complex(dArray3[n5], dArray4[n5]);
            ++n5;
        }
        return complexArray;
    }

    public static Complex[] transform(double[] dArray) {
        int n = dArray.length;
        if (!FourierMath.isPowerOf2(n)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n2 = FourierMath.numberOfBitsNeeded(n);
        int n3 = 0;
        while (n3 < n) {
            int n4 = FourierMath.reverseBits(n3, n2);
            dArray2[n4] = dArray[n3];
            ++n3;
        }
        FourierMath.fft(dArray2, dArray3, Math.PI * 2);
        Complex[] complexArray = new Complex[n];
        int n5 = 0;
        while (n5 < n) {
            complexArray[n5] = new Complex(dArray2[n5], dArray3[n5]);
            ++n5;
        }
        return complexArray;
    }

    public static Complex[] inverseTransform(Complex[] complexArray) {
        int n = complexArray.length;
        if (!FourierMath.isPowerOf2(n)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = FourierMath.numberOfBitsNeeded(n);
        int n3 = 0;
        while (n3 < n) {
            int n4 = FourierMath.reverseBits(n3, n2);
            dArray[n4] = complexArray[n3].real();
            dArray2[n4] = complexArray[n3].imag();
            ++n3;
        }
        FourierMath.fft(dArray, dArray2, Math.PI * -2);
        Complex[] complexArray2 = new Complex[n];
        double d = n;
        int n5 = 0;
        while (n5 < n) {
            complexArray2[n5] = new Complex(dArray[n5] / d, dArray2[n5] / d);
            ++n5;
        }
        return complexArray2;
    }

    public static Complex[] inverseTransform(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (!FourierMath.isPowerOf2(n)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        int n2 = FourierMath.numberOfBitsNeeded(n);
        int n3 = 0;
        while (n3 < n) {
            int n4 = FourierMath.reverseBits(n3, n2);
            dArray3[n4] = dArray[n3];
            dArray4[n4] = dArray2[n3];
            ++n3;
        }
        FourierMath.fft(dArray3, dArray4, Math.PI * -2);
        Complex[] complexArray = new Complex[n];
        double d = n;
        int n5 = 0;
        while (n5 < n) {
            complexArray[n5] = new Complex(dArray3[n5] / d, dArray4[n5] / d);
            ++n5;
        }
        return complexArray;
    }

    public static Complex[] inverseTransform(double[] dArray) {
        int n = dArray.length;
        if (!FourierMath.isPowerOf2(n)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n2 = FourierMath.numberOfBitsNeeded(n);
        int n3 = 0;
        while (n3 < n) {
            int n4 = FourierMath.reverseBits(n3, n2);
            dArray2[n4] = dArray[n3];
            ++n3;
        }
        FourierMath.fft(dArray2, dArray3, Math.PI * -2);
        Complex[] complexArray = new Complex[n];
        double d = n;
        int n5 = 0;
        while (n5 < n) {
            complexArray[n5] = new Complex(dArray2[n5] / d, dArray3[n5] / d);
            ++n5;
        }
        return complexArray;
    }

    private static void fft(double[] dArray, double[] dArray2, double d) {
        int n = dArray.length;
        int n2 = 1;
        int n3 = 2;
        while (n3 <= n) {
            double d2 = d / (double)n3;
            double d3 = Math.sin(0.5 * d2);
            d3 = 2.0 * d3 * d3;
            double d4 = Math.sin(d2);
            int n4 = 0;
            while (n4 < n) {
                double d5 = 1.0;
                double d6 = 0.0;
                int n5 = n4;
                int n6 = 0;
                while (n6 < n2) {
                    int n7 = n5 + n2;
                    double d7 = d5 * dArray[n7] - d6 * dArray2[n7];
                    double d8 = d5 * dArray2[n7] + d6 * dArray[n7];
                    dArray[n7] = dArray[n5] - d7;
                    dArray2[n7] = dArray2[n5] - d8;
                    int n8 = n5;
                    dArray[n8] = dArray[n8] + d7;
                    int n9 = n5++;
                    dArray2[n9] = dArray2[n9] + d8;
                    d5 -= d3 * d5 + d4 * d6;
                    d6 -= d3 * d6 - d4 * d5;
                    ++n6;
                }
                n4 += n3;
            }
            n2 = n3;
            n3 <<= 1;
        }
    }

    private static boolean isPowerOf2(int n) {
        int n2 = 1;
        int n3 = 2;
        while (n2 < 32) {
            if (n == n3) {
                return true;
            }
            ++n2;
            n3 <<= 1;
        }
        return false;
    }

    private static int numberOfBitsNeeded(int n) {
        if (n < 2) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while ((n & 1 << n2) <= 0) {
            ++n2;
        }
        return n2;
    }

    private static int reverseBits(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 << 1 | n & 1;
            n >>= 1;
            ++n4;
        }
        return n3;
    }

    public static Complex[] sort(Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = complexArray.length / 2;
        int n2 = 0;
        while (n2 < n) {
            complexArray2[n + n2] = complexArray[n2];
            complexArray2[n2] = complexArray[n + n2];
            ++n2;
        }
        return complexArray2;
    }
}

