/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.categories;

import JSci.maths.AbstractComplexMatrix;
import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.MathInteger;
import JSci.maths.algebras.BanachSpace;
import JSci.maths.algebras.HilbertSpace;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.categories.Category;
import JSci.maths.categories.UndefinedCompositionException;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public class Hilb
implements Category {
    public Category.Morphism identity(Object object) {
        return new LinearMap(ComplexDiagonalMatrix.identity(((HilbertSpace)object).dimension()));
    }

    public Object cardinality(Object object) {
        return new MathInteger(((HilbertSpace)object).dimension());
    }

    public Category.HomSet hom(Object object, Object object2) {
        return new OperatorSpace((HilbertSpace)object, (HilbertSpace)object2);
    }

    public class LinearMap
    implements BanachSpace.Member,
    Category.Morphism {
        private AbstractComplexMatrix matrix;

        public LinearMap(Complex[][] complexArray) {
            this.matrix = new ComplexMatrix(complexArray);
        }

        public LinearMap(AbstractComplexMatrix abstractComplexMatrix) {
            this.matrix = abstractComplexMatrix;
        }

        public Object domain() {
            return new HilbertSpace(this.matrix.columns());
        }

        public Object codomain() {
            return new HilbertSpace(this.matrix.rows());
        }

        public Object map(Object object) {
            return this.matrix.multiply((ComplexVector)object);
        }

        public Category.Morphism compose(Category.Morphism morphism) {
            if (morphism instanceof LinearMap) {
                LinearMap linearMap = (LinearMap)morphism;
                if (this.matrix.columns() == linearMap.matrix.rows()) {
                    return new LinearMap(linearMap.matrix.multiply(this.matrix));
                }
                throw new UndefinedCompositionException();
            }
            throw new IllegalArgumentException("Morphism is not a LinearMap.");
        }

        public double norm() {
            return this.matrix.frobeniusNorm();
        }

        public int dimension() {
            return this.matrix.rows() * this.matrix.columns();
        }

        public AbelianGroup.Member add(AbelianGroup.Member member) {
            if (member instanceof LinearMap) {
                return new LinearMap(this.matrix.add(((LinearMap)member).matrix));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }

        public AbelianGroup.Member negate() {
            return new LinearMap((AbstractComplexMatrix)this.matrix.negate());
        }

        public AbelianGroup.Member subtract(AbelianGroup.Member member) {
            if (member instanceof LinearMap) {
                return new LinearMap(this.matrix.subtract(((LinearMap)member).matrix));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }

        public Module.Member scalarMultiply(Ring.Member member) {
            if (member instanceof Complex) {
                return new LinearMap(this.matrix.scalarMultiply((Complex)member));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }

        public VectorSpace.Member scalarDivide(Field.Member member) {
            if (member instanceof Complex) {
                return new LinearMap(this.matrix.scalarMultiply((Complex)member));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }
    }

    public class OperatorSpace
    extends HilbertSpace
    implements Category.HomSet {
        private final int rows;
        private final int cols;

        public OperatorSpace(HilbertSpace hilbertSpace, HilbertSpace hilbertSpace2) {
            super(hilbertSpace.dimension() * hilbertSpace2.dimension());
            this.rows = hilbertSpace2.dimension();
            this.cols = hilbertSpace.dimension();
        }

        public VectorSpace.Member getVector(Complex[][] complexArray) {
            return new LinearMap(complexArray);
        }
    }
}

