/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.statistics.BetaDistribution;
import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class FDistribution
extends ProbabilityDistribution {
    private double p;
    private double q;
    private BetaDistribution beta;

    public FDistribution(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new OutOfRangeException("The degrees of freedom must be greater than zero.");
        }
        this.p = d;
        this.q = d2;
        this.beta = new BetaDistribution(this.p / 2.0, this.q / 2.0);
    }

    public double getDegreesOfFreedomP() {
        return this.p;
    }

    public double getDegreesOfFreedomQ() {
        return this.q;
    }

    public double probability(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        double d2 = this.q / (this.q + this.p * d);
        return this.beta.probability(1.0 - d2) * d2 * d2 * this.p / this.q;
    }

    public double cumulative(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return this.beta.cumulative(this.p * d / (this.q + this.p * d));
    }

    public double inverse(double d) {
        this.checkRange(d);
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.MAX_VALUE;
        }
        double d2 = this.beta.inverse(d);
        if (d2 < 2.23E-308) {
            return Double.MAX_VALUE;
        }
        return this.q / this.p * (d2 / (1.0 - d2));
    }
}

