/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class GeometricDistribution
extends ProbabilityDistribution {
    private double success;
    private double failure;

    public GeometricDistribution(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException("The probability should be between 0.0 and 1.0.");
        }
        this.success = d;
        this.failure = 1.0 - d;
    }

    public double getSuccessParameter() {
        return this.success;
    }

    public double getMean() {
        return 1.0 / this.success;
    }

    public double getVariance() {
        return this.failure / (this.success * this.success);
    }

    public double probability(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return this.success * Math.pow(this.failure, d - 1.0);
    }

    public double cumulative(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return 1.0 - Math.pow(this.failure, d);
    }

    public double inverse(double d) {
        this.checkRange(d);
        return Math.log(1.0 - d) / Math.log(this.failure);
    }
}

