/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import chemaxon.alchemist.Alchemist;
import chemaxon.alchemist.AlchemistBanner;
import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.AlchemistProgressLabel;
import chemaxon.alchemist.utils.AlchemistBrowserLauncher;
import chemaxon.alchemist.utils.AlchemistState;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public abstract class AlchemistController
implements PropertyChangeListener {
    protected AlchemistState state = new AlchemistState();
    protected Alchemist alchemist = null;
    private List<AlchemistPage> pages = new ArrayList<AlchemistPage>();
    private final List<AlchemistProgressLabel> progressLabelList = new ArrayList<AlchemistProgressLabel>();
    private int step = 0;
    private int targetStep = -1;
    private boolean enabled = true;
    public final Action BACK_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 7510970070606952320L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlchemistController.this.getAlchemist().isLastPageMode()) {
                AlchemistController.this.getAlchemist().setLastPageMode(false);
            }
            AlchemistController.this.setTargetStep(AlchemistController.this.getStep() - 1);
            AlchemistController.this.getPages().get(AlchemistController.this.getStep()).performLeavePage();
        }
    };
    public final Action NEXT_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -205821619711224492L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistController.this.setTargetStep(AlchemistController.this.getStep() + 1);
            AlchemistController.this.getPages().get(AlchemistController.this.getStep()).performLeavePage();
        }
    };
    public final Action CANCEL_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -4084341445234404483L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistController.this.alchemist.exitProgramActionHandler();
        }
    };
    public final Action FINISH_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -984266476409252056L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistController.this.FINISH_ACTION.setEnabled(false);
            AlchemistController.this.CANCEL_ACTION.setEnabled(false);
            AlchemistController.this.BACK_ACTION.setEnabled(false);
            AlchemistController.this.getAlchemist().setLastPageMode(true);
            AlchemistController.this.finishPressed();
        }
    };
    public final Action DONE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -7601943579551124346L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistController.this.BACK_ACTION.setEnabled(true);
            AlchemistController.this.CANCEL_ACTION.setEnabled(true);
        }
    };
    public final Action PROGRESS_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -984266476409252056L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistController.this.setTargetStep(e.getID());
            AlchemistController.this.getPages().get(AlchemistController.this.getStep()).performLeavePage();
        }
    };

    public AlchemistController(String title) {
        this(title, null);
    }

    public AlchemistController(String title, Image image) {
        this.alchemist = new Alchemist(title, image, this);
        this.initializeProperties();
    }

    protected void setBanner(AlchemistBanner banner) {
        this.alchemist.setBanner(banner);
    }

    protected void initAlchemist() {
        this.setStep(0);
        this.progressLabelList.get(this.getStep()).setState("active");
        this.getPages().get(this.getStep()).enterPage(this.state);
        this.alchemist.setPage(this.getPages().get(this.getStep()));
        this.alchemist.setProgressObjects(this.progressLabelList);
        this.setMoveEnabled();
    }

    protected void initializeProperties() {
        if (this.getPropertiesFile() != null) {
            try {
                this.state.loadProperties(this.getPropertiesFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void saveProperties() {
        if (this.getPropertiesFile() != null) {
            this.getPages().get(this.getStep()).performLeavePage();
            try {
                this.state.saveProperties(this.getPropertiesFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract void cancelPressed();

    protected abstract void finishPressed();

    protected final void addPage(String label, AlchemistPage page) {
        page.getNotifier().addPropertyChangeListener(this);
        this.getPages().add(page);
        this.progressLabelList.add(new AlchemistProgressLabel(label, this.progressLabelList.size(), this.PROGRESS_ACTION));
    }

    private boolean isCurrentPageCorrect() {
        return this.getPages().get(this.getStep()).isCorrect();
    }

    private boolean hasNext() {
        boolean hasNext = false;
        int count = this.getStep() + 1;
        while (count < this.getPages().size() && !hasNext) {
            hasNext = this.getPages().get(count++).isPageEnabled();
        }
        return hasNext;
    }

    public Alchemist getAlchemist() {
        return this.alchemist;
    }

    private void setMoveEnabled() {
        this.NEXT_ACTION.setEnabled(this.isCurrentPageCorrect() && this.hasNext() && this.enabled);
        this.FINISH_ACTION.setEnabled(this.isCurrentPageCorrect() && !this.hasNext() && this.enabled);
        this.BACK_ACTION.setEnabled(this.getStep() != 0 && this.enabled);
    }

    protected final void setStepEnabled(int step, boolean enabled) {
        if (step > this.getStep()) {
            this.getPages().get(step).setEnabled(enabled);
            this.progressLabelList.get(step).setState(enabled ? "normal" : "disabled");
        }
    }

    private final void navigateToPage() {
        if (this.getTargetStep() > this.getStep() && this.NEXT_ACTION.isEnabled() && this.getPages().get(this.getStep()).isCorrect()) {
            this.progressLabelList.get(this.getStep()).setState("done");
            this.getPages().get(this.getStep()).leavePage(this.state);
            this.setStep(this.getStep() + 1);
            this.getPages().get(this.getStep()).enterPage(this.state);
            this.progressLabelList.get(this.getStep()).setState("active");
            this.alchemist.setPage(this.getPages().get(this.getStep()));
            this.setMoveEnabled();
            if (this.getStep() < this.getTargetStep() && this.NEXT_ACTION.isEnabled() && this.getPages().get(this.getStep()).isCorrect()) {
                this.getPages().get(this.getStep()).performLeavePage();
            }
        } else if (this.getTargetStep() < this.getStep() && this.BACK_ACTION.isEnabled()) {
            this.progressLabelList.get(this.getStep()).setState("normal");
            this.getPages().get(this.getStep()).leavePage(this.state);
            this.setStep(this.getStep() - 1);
            this.getPages().get(this.getStep()).enterPage(this.state);
            this.progressLabelList.get(this.getStep()).setState("active");
            this.alchemist.setPage(this.getPages().get(this.getStep()));
            this.setMoveEnabled();
            if (this.getStep() > this.getTargetStep() && this.BACK_ACTION.isEnabled()) {
                this.getPages().get(this.getStep()).performLeavePage();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("Alchemist_Enable")) {
            this.enabled = (Boolean)evt.getNewValue();
            if (!this.enabled) {
                this.CANCEL_ACTION.setEnabled(this.enabled);
                this.FINISH_ACTION.setEnabled(this.enabled);
                this.NEXT_ACTION.setEnabled(this.enabled);
                this.BACK_ACTION.setEnabled(this.enabled);
                for (int i = 0; i < this.progressLabelList.size(); ++i) {
                    this.progressLabelList.get(i).setState("disabled");
                }
            } else {
                this.CANCEL_ACTION.setEnabled(true);
                for (int i = 0; i < this.progressLabelList.size(); ++i) {
                    if (i < this.getStep()) {
                        this.progressLabelList.get(i).setState("done");
                        continue;
                    }
                    if (i == this.getStep()) {
                        this.progressLabelList.get(i).setState("active");
                        continue;
                    }
                    this.progressLabelList.get(i).setState("normal");
                }
                this.setMoveEnabled();
            }
        } else if (evt.getPropertyName().equalsIgnoreCase("AlchemistPage_MoveNext")) {
            this.navigateToPage();
        } else if (this.enabled) {
            this.setMoveEnabled();
        }
    }

    public abstract File getPropertiesFile();

    public abstract String getHelpURL();

    protected void popupHelpInBrowser() {
        String url = this.getHelpURL();
        AlchemistBrowserLauncher.launchBrowser(url);
    }

    protected void licenseManagerInvoked() {
    }

    protected void setTargetStep(int targetStep) {
        this.targetStep = targetStep;
    }

    protected int getTargetStep() {
        return this.targetStep;
    }

    protected void setPages(List<AlchemistPage> pages) {
        this.pages = pages;
    }

    protected List<AlchemistPage> getPages() {
        return this.pages;
    }

    protected void setStep(int step) {
        this.step = step;
    }

    protected int getStep() {
        return this.step;
    }
}

