/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import chemaxon.alchemist.utils.AlchemistIconFactory;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;

public class AlchemistProgressLabel
extends JLabel {
    private static final long serialVersionUID = -2026203285204334201L;
    public static final String JUMP_TO_STEP = "JumpToStep";
    private final Action jumpAction;
    public static final String NORMAL = "normal";
    public static final String ACTIVE = "active";
    public static final String DONE = "done";
    public static final String DISABLED = "disabled";
    private String state = "normal";
    private String text = null;
    private final Map<String, Icon> iconMap = new HashMap<String, Icon>();
    private int id;

    public AlchemistProgressLabel(String text, int id) {
        this(text, id, null);
    }

    public AlchemistProgressLabel(String text, int id, Action jumpAction) {
        super(text);
        this.jumpAction = jumpAction;
        this.text = text;
        this.id = id;
        this.setCursor(jumpAction != null && !this.state.equals(DISABLED) && !this.state.equals(ACTIVE) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        this.iconMap.put(ACTIVE, AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/active.gif"));
        this.iconMap.put(DONE, AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/done.gif"));
        this.iconMap.put(DISABLED, AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/disabled.gif"));
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(2);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AlchemistProgressLabel.this.itemClicked();
            }
        });
        this.setForeground(Color.WHITE);
    }

    protected void itemClicked() {
        if (!this.state.equals(DISABLED) && !this.state.equals(ACTIVE) && this.jumpAction != null) {
            this.jumpAction.actionPerformed(new ActionEvent(this, this.id, JUMP_TO_STEP));
        }
    }

    private void refresh() {
        if (this.state != null) {
            Icon icon = this.iconMap.get(this.state);
            super.setIcon(icon);
            Font font = this.getFont();
            this.setFont(this.state.equalsIgnoreCase(ACTIVE) ? font.deriveFont(1) : font.deriveFont(0));
            this.setCursor(this.jumpAction != null && !this.state.equals(DISABLED) && !this.state.equals(ACTIVE) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        }
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
        this.refresh();
    }

    @Override
    public Icon getIcon() {
        return this.getIcon(this.state);
    }

    public Icon getIcon(String state) {
        return state != null ? this.iconMap.get(state) : null;
    }

    @Override
    public void setIcon(Icon icon) {
        this.setIcon(icon, this.state);
    }

    public void setIcon(Icon icon, String state) {
        if (state != null) {
            this.iconMap.put(state, icon);
            this.refresh();
        }
    }

    public void setCollapsed(boolean collapsed) {
        this.setText(collapsed ? "." : this.text);
    }
}

