/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import chemaxon.alchemist.utils.AlchemistProgressMonitor;
import chemaxon.util.SplashScreenUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;

public class AlchemistSplashScreen {
    private BufferedImage backgroundImage = null;
    private AlchemistProgressMonitor pMon = null;
    private Color progressColor = null;
    private Color barColor = null;
    private Dimension splashSize = null;
    private String imagePath = null;
    private JWindow splashWindow = null;
    private boolean wheelVisible = false;
    private static final float[] wheelThetas = new float[]{0.0f, 0.5235988f, 1.0471976f, 1.5707964f, 2.0943952f, 2.6179938f, (float)Math.PI, 3.6651914f, 4.1887903f, 4.712389f, 5.2359877f, 5.7595863f};
    private int[] wheelColors = new int[12];
    private static final int WHEEL_SIZE = 16;
    private static final int REFRESH_TIMER_INTERVAL = 100;
    private final Timer refreshTimer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlchemistSplashScreen.this.isWheelVisible()) {
                AlchemistSplashScreen.this.recalculateWheel();
            }
            AlchemistSplashScreen.this.getSplashWindow().repaint();
        }
    });

    protected void recalculateWheel() {
        int tmp = this.getWheelColors()[this.getWheelColors().length - 1];
        for (int i = this.getWheelColors().length - 1; i > 0; --i) {
            this.getWheelColors()[i] = this.getWheelColors()[i - 1];
        }
        this.getWheelColors()[0] = tmp;
    }

    public AlchemistSplashScreen() {
        this(null, null, null);
    }

    public AlchemistSplashScreen(AlchemistProgressMonitor pMon) {
        this(null, null, pMon);
    }

    public AlchemistSplashScreen(String imagePath) {
        this(imagePath, null, null);
    }

    public AlchemistSplashScreen(String imagePath, AlchemistProgressMonitor pMon) {
        this(imagePath, null, pMon);
    }

    public AlchemistSplashScreen(Dimension size) {
        this(null, size, null);
    }

    public AlchemistSplashScreen(Dimension size, AlchemistProgressMonitor pMon) {
        this(null, size, pMon);
    }

    public AlchemistSplashScreen(String imagePath, Dimension size) {
        this(imagePath, size, null);
    }

    public AlchemistSplashScreen(String imagePath, Dimension size, AlchemistProgressMonitor pMon) {
        this.imagePath = imagePath;
        this.splashSize = size == null ? new Dimension(390, 260) : size;
        this.setpMon(pMon);
        this.setProgressColor(Color.BLACK);
    }

    protected JWindow getSplashWindow() {
        if (this.splashWindow == null) {
            this.splashWindow = new JWindow();
            try {
                this.splashWindow.setAlwaysOnTop(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.splashWindow.getContentPane().setLayout(new BorderLayout());
            this.splashWindow.getContentPane().add((Component)new JPanel(){
                private static final long serialVersionUID = 3212614884067044472L;

                @Override
                protected void paintComponent(Graphics g) {
                    Graphics2D g2;
                    if (AlchemistSplashScreen.this.getBackgroundImage() != null) {
                        g2 = (Graphics2D)g.create();
                        g2.drawImage(AlchemistSplashScreen.this.getBackgroundImage(), 0, 0, AlchemistSplashScreen.this.getSplashWindow().getWidth(), AlchemistSplashScreen.this.getSplashWindow().getHeight(), null);
                        g2.dispose();
                    } else {
                        super.paintComponent(g);
                    }
                    if (AlchemistSplashScreen.this.getpMon() != null) {
                        g2 = (Graphics2D)g.create();
                        int percent = AlchemistSplashScreen.this.getpMon().getProgressPercent();
                        g2.setColor(AlchemistSplashScreen.this.getBarColor());
                        g2.fillRect(10, AlchemistSplashScreen.this.getSplashWindow().getHeight() - 30, (AlchemistSplashScreen.this.getSplashWindow().getWidth() - 20) * percent / 100, 5);
                        g2.setColor(AlchemistSplashScreen.this.getProgressColor());
                        g2.drawRect(10, AlchemistSplashScreen.this.getSplashWindow().getHeight() - 30, (AlchemistSplashScreen.this.getSplashWindow().getWidth() - 20) * percent / 100, 5);
                        String message = AlchemistSplashScreen.this.getpMon().getMessage();
                        if (message != null) {
                            g2.setFont(new Font("dialog", 1, 10));
                            g2.drawString(message, 31, AlchemistSplashScreen.this.getSplashWindow().getHeight() - 10);
                        }
                        g2.dispose();
                    }
                    if (AlchemistSplashScreen.this.isWheelVisible()) {
                        Graphics2D gWheel = (Graphics2D)g.create();
                        gWheel.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        gWheel.translate(10, AlchemistSplashScreen.this.getSplashWindow().getHeight() - 5 - 16);
                        for (int i = 0; i < 12; ++i) {
                            Graphics2D gTick = (Graphics2D)gWheel.create();
                            gTick.rotate(AlchemistSplashScreen.getWheelthetas()[i], 8.0, 8.0);
                            gTick.setColor(new Color(AlchemistSplashScreen.this.getWheelColors()[i % AlchemistSplashScreen.this.getWheelColors().length], true));
                            gTick.fillRoundRect(8, 0, 1, 4, 1, 1);
                            gTick.dispose();
                        }
                        gWheel.dispose();
                    }
                }
            }, "Center");
            this.splashWindow.setSize(this.splashSize);
            this.splashWindow.setLocationRelativeTo(null);
        }
        return this.splashWindow;
    }

    private void loadImage() {
        ImageIcon icon;
        URL url;
        this.setBackgroundImage(null);
        if (this.imagePath != null && (url = this.getSplashWindow().getClass().getResource(this.imagePath)) != null && (icon = new ImageIcon(url)) != null) {
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 5);
            image.getGraphics().drawImage(icon.getImage(), 0, 0, null);
            this.setBackgroundImage(image);
        }
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
        this.loadImage();
        this.getSplashWindow().repaint();
    }

    public AlchemistProgressMonitor getProgressMonitor() {
        return this.getpMon();
    }

    public void setProgressMonitor(AlchemistProgressMonitor pMon) {
        this.setpMon(pMon);
        if (pMon == null) {
            this.refreshTimer.stop();
            this.getSplashWindow().repaint();
        } else {
            this.refreshTimer.start();
        }
    }

    public Color getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(Color progressColor) {
        this.progressColor = progressColor;
        int r = progressColor.getRed();
        int g = progressColor.getGreen();
        int b = progressColor.getBlue();
        this.setBarColor(new Color(r, g, b, 100));
        for (int i = 0; i < this.getWheelColors().length; ++i) {
            this.getWheelColors()[i] = new Color(r, g, b, 80 + i * 15).getRGB();
        }
        this.getSplashWindow().repaint();
    }

    public Dimension getSplashSize() {
        return this.splashSize;
    }

    public void setSplashSize(Dimension splashSize) {
        this.splashSize = splashSize;
        this.getSplashWindow().setSize(this.splashSize);
    }

    public void show() {
        this.show(false);
    }

    public void show(boolean animating) {
        this.loadImage();
        this.refreshTimer.start();
        this.setWheelVisible(animating);
        this.getSplashWindow().setVisible(true);
    }

    public void dispose() {
        this.refreshTimer.stop();
        this.getSplashWindow().dispose();
        this.splashWindow = null;
    }

    protected void setWheelVisible(boolean wheelVisible) {
        this.wheelVisible = wheelVisible;
    }

    protected boolean isWheelVisible() {
        return this.wheelVisible;
    }

    protected void setBackgroundImage(BufferedImage backgroundImage) {
        this.backgroundImage = backgroundImage != null ? (BufferedImage)SplashScreenUtils.getSplashScreen(SplashScreenUtils.Product.Metabolizer, backgroundImage) : null;
    }

    protected BufferedImage getBackgroundImage() {
        return this.backgroundImage;
    }

    protected void setpMon(AlchemistProgressMonitor pMon) {
        this.pMon = pMon;
    }

    protected AlchemistProgressMonitor getpMon() {
        return this.pMon;
    }

    protected void setBarColor(Color barColor) {
        this.barColor = barColor;
    }

    protected Color getBarColor() {
        return this.barColor;
    }

    protected static float[] getWheelthetas() {
        return wheelThetas;
    }

    protected void setWheelColors(int[] wheelColors) {
        this.wheelColors = wheelColors;
    }

    protected int[] getWheelColors() {
        return this.wheelColors;
    }
}

