/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import chemaxon.alchemist.AlchemistApplication;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForMarvin;
import chemaxon.alchemist.utils.AlchemistInnerDialog;
import chemaxon.alchemist.utils.filefilters.XMLFileFilter;
import chemaxon.alchemist.utils.menu.AlchemistToggleAction;
import chemaxon.license.LicenseManagerGUI;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.marvin.uif.action.support.BundleBasedConfigurer;
import chemaxon.marvin.uif.aloe.AloeDockHandler;
import chemaxon.marvin.uif.builder.DefaultModuleConfiguration;
import chemaxon.marvin.uif.module.ConfigurationException;
import chemaxon.marvin.uif.module.Configurer;
import chemaxon.marvin.uif.module.GUIModule;
import chemaxon.marvin.util.Environment;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;

public class MarvinBasedAlchemistApplication
extends AlchemistApplication {
    private GUIModule guiModule = null;
    protected AloeDockHandler dockHandler = null;
    private AlchemistInnerDialog licenseDialog = null;
    protected final AbstractAction LICENSE_MANAGER_CLOSE_ACTION = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent e) {
            MarvinBasedAlchemistApplication.this.getLicenseDialog().setVisible(false);
            MarvinBasedAlchemistApplication.this.licenseManagerClosed();
        }
    };

    public MarvinBasedAlchemistApplication() {
        this.init();
    }

    public MarvinBasedAlchemistApplication(String appTitle, Image image, Container contentPane) {
        super(appTitle, image, contentPane);
        this.init();
    }

    public MarvinBasedAlchemistApplication(String appTitle, Image image) {
        super(appTitle, image);
        this.init();
    }

    public MarvinBasedAlchemistApplication(String appTitle) {
        super(appTitle);
        this.init();
    }

    private void init() {
        try {
            this.fileChooser = new AlchemistFileChooserForMarvin();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected AlchemistInnerDialog getLicenseDialog() {
        if (this.licenseDialog == null) {
            this.licenseDialog = AlchemistInnerDialog.createCustomBox("ChemAxon License Manager", new LicenseManagerGUI().createContentPanel(), new Action[]{this.LICENSE_MANAGER_CLOSE_ACTION});
            this.licenseDialog.setCloseAction(this.LICENSE_MANAGER_CLOSE_ACTION);
            this.licenseDialog.setVisible(false);
            this.addInnerDialog(this.licenseDialog);
            this.licenseDialog.setSize(this.getMinimumWindowWidth() - 50, this.getMinimumWindowHeight() - 50);
            AlchemistInnerDialog.setCentered(this.licenseDialog);
        }
        return this.licenseDialog;
    }

    @Override
    protected String getSaveFilterFormat() {
        String filterFormat = null;
        FileFilter lastSaveFileFilter = this.getSaveFilter();
        if (lastSaveFileFilter != null) {
            if (lastSaveFileFilter instanceof MolFileFilter) {
                filterFormat = ((MolFileFilter)lastSaveFileFilter).getFormat();
            } else if (lastSaveFileFilter instanceof XMLFileFilter) {
                filterFormat = "xml";
            }
        }
        return filterFormat;
    }

    protected void setMenuResources(String configPath, String bundleBaseName) {
        this.setMenuResources(configPath, bundleBaseName, null);
    }

    protected void setMenuResources(String configPath) {
        this.setMenuResources(configPath, null);
    }

    protected JToolBar getToolbar(String toolbarId) {
        if (this.getGuiModule() != null) {
            return this.getGuiModule().getToolBar(toolbarId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMenuResources(String configPath, String bundleBaseName, Configurer configurer) {
        block12: {
            try {
                URL configUrl = ClassLoader.getSystemResource(configPath);
                if (configUrl == null) break block12;
                InputStream stream = configUrl.openStream();
                try {
                    this.setGuiModule(new GUIModule(new DefaultModuleConfiguration(stream)));
                    if (configurer != null) {
                        this.getGuiModule().addConfigurer(configurer);
                    } else {
                        this.getGuiModule().addConfigurer(new DefaultActionConfigurer(this));
                    }
                    if (bundleBaseName != null) {
                        this.getGuiModule().getActions().addConfigurer(new BundleBasedConfigurer(ResourceBundle.getBundle(bundleBaseName)));
                    }
                    if (this.mainMenuBar != null) {
                        this.getEnabledLayerPanel().remove(this.mainMenuBar);
                    }
                    this.mainMenuBar = this.getGuiModule().getMenuBar();
                    if (this.mainMenuBar != null) {
                        this.mainMenuBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                        this.getEnabledLayerPanel().add((Component)this.mainMenuBar, "North");
                    }
                    this.dockHandler = new AloeDockHandler(this.getApplicationFrame().getRootPane(), this.getDockPane(), this.getGuiModule(), false);
                    this.dockHandler.setRootPane(this.getSuspendableContentPanel());
                    this.getGuiModule().bindComponent((JComponent)this.getContentPane());
                    String[] ids = this.getGuiModule().getToolBarIDs();
                    for (int i = 0; i < ids.length; ++i) {
                        this.setToolbarVisible(ids[i], this.getApplicationState().getProperty("AlchemistApplication_" + ids[i] + "Visible") == null ? true : (Boolean)this.getApplicationState().getProperty("AlchemistApplication_" + ids[i] + "Visible"));
                    }
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                AlchemistErrorDialog.showError(this.getApplicationFrame(), "Error while initializing menus", (Exception)e);
            }
            catch (ConfigurationException e) {
                AlchemistErrorDialog.showError(this.getApplicationFrame(), "Error while initializing menus", (Exception)e);
            }
        }
    }

    protected void setActionEnabled(String actionID, boolean enabled) {
        Action action;
        if (this.getGuiModule() != null && (action = this.getGuiModule().getActions().getAction(actionID)) != null) {
            action.setEnabled(enabled);
        }
    }

    protected void setActionsEnabled(String[] actionIDs, boolean enabled) {
        if (this.getGuiModule() != null) {
            for (int i = 0; i < actionIDs.length; ++i) {
                this.setActionEnabled(actionIDs[i], enabled);
            }
        }
    }

    protected void setActionsEnabled(String[] actionIDs, boolean[] enabled) {
        if (this.getGuiModule() != null) {
            for (int i = 0; i < actionIDs.length; ++i) {
                this.setActionEnabled(actionIDs[i], enabled[i]);
            }
        }
    }

    @Override
    protected void licenseManagerActionHandler() {
        this.getLicenseDialog().setVisible(true);
        this.setEnabled(false);
    }

    protected boolean[] isActionsEnabled(String[] actionIDs) {
        boolean[] values = new boolean[actionIDs.length];
        for (int i = 0; i < actionIDs.length; ++i) {
            values[i] = this.getGuiModule().getActions().getAction(actionIDs[i]).isEnabled();
        }
        return values;
    }

    protected FileFilter[] getOpenFileFilters() {
        return AlchemistFileChooserForMarvin.getDefaultOpenFileFilters();
    }

    @Override
    protected FileFilter[] getOpenFileFilters(String context) {
        return this.getOpenFileFilters();
    }

    protected FileFilter[] getSaveFileFilters() {
        return AlchemistFileChooserForMarvin.getDefaultSaveFileFilters();
    }

    @Override
    protected FileFilter[] getSaveFileFilters(String context) {
        return this.getSaveFileFilters();
    }

    public static void setLookAndFeel() {
        Environment.setSkinEnabled(false);
        if (!Environment.installPlasticLookAndFeel(true)) {
            AlchemistApplication.setLookAndFeel();
        }
    }

    public void setGuiModule(GUIModule guiModule) {
        this.guiModule = guiModule;
    }

    public GUIModule getGuiModule() {
        return this.guiModule;
    }

    public static class DefaultActionConfigurer
    implements Configurer {
        private final AlchemistApplication instance;

        public DefaultActionConfigurer(AlchemistApplication instance) {
            this.instance = instance;
        }

        @Override
        public void configure(Object action) {
            ((Action)action).putValue("AlchemistApplication_AppInstance", this.instance);
            if (action instanceof AlchemistToggleAction) {
                ((AlchemistToggleAction)action).initializeListener();
            }
        }
    }

    public static class LicenseManagerAction
    extends AbstractAction {
        private static final long serialVersionUID = 3222854582920316186L;
        public static final String ACTION_ID = "licenseManager";

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistApplication app = (AlchemistApplication)this.getValue("AlchemistApplication_AppInstance");
            if (app instanceof MarvinBasedAlchemistApplication) {
                ((MarvinBasedAlchemistApplication)app).licenseManagerActionHandler();
            }
        }
    }
}

