/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.AlchemistProfile;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigurationReaderFactory;
import chemaxon.alchemist.configbuilder.MarvinLicenseSupport;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationWriter;
import chemaxon.alchemist.configbuilder.structurechecker.StructureCheckerConfigBuilderAlchemist;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.config.struct.XMLFileFilter;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class ConfigBuilderPanelFactory {
    private static final String PROPERTY_KEY_LAST_CONFIGBUILDER_FOLDER = "LastUsedConfibuilderDir";
    public static final String DEFAULT_STANDARDIZER_ELEMENT_CONFIGURATION_PATH = "/chemaxon/alchemist/configbuilder/standardizer/StandardizerConfiguration.xml";
    public static final String DEFAULT_STRUCTURECHECKER_ELEMENT_CONFIGURATION_PATH = "/chemaxon/checkers/resource/defaultcheckerconfig.xml";

    public static ConfigBuilderPanel createStandardizerPanel() throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(false);
    }

    public static ConfigBuilderPanel createStandardizerPanel(AlchemistProfile profile) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(profile, false);
    }

    public static ConfigBuilderPanel createStandardizerPanel(String[] excludedElements) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(excludedElements, false);
    }

    public static ConfigBuilderPanel createStandardizerPanel(String[] excludedElements, AlchemistProfile profile) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(excludedElements, profile, false);
    }

    public static ConfigBuilderPanel createStandardizerPanel(boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(DEFAULT_STANDARDIZER_ELEMENT_CONFIGURATION_PATH, fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStandardizerPanel(AlchemistProfile profile, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(DEFAULT_STANDARDIZER_ELEMENT_CONFIGURATION_PATH, profile, fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStandardizerPanel(String[] excludedElements, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(DEFAULT_STANDARDIZER_ELEMENT_CONFIGURATION_PATH, excludedElements, null, fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStandardizerPanel(String[] excludedElements, AlchemistProfile profile, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(DEFAULT_STANDARDIZER_ELEMENT_CONFIGURATION_PATH, excludedElements, profile, fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStandardizerPanel(String elementConfigurationPath) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(elementConfigurationPath, false);
    }

    public static ConfigBuilderPanel createStandardizerPanel(String elementConfigurationPath, AlchemistProfile profile) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(elementConfigurationPath, profile, false);
    }

    public static ConfigBuilderPanel createStandardizerPanel(String elementConfigurationPath, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(elementConfigurationPath, new AlchemistProfile(), fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStandardizerPanel(String elementConfigurationPath, AlchemistProfile profile, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStandardizerPanel(elementConfigurationPath, null, profile, fileOpenSaveSupport);
    }

    private static ConfigBuilderPanel createStandardizerPanel(String elementConfigurationPath, String[] excludedElements, final AlchemistProfile profile, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        final ConfigBuilderPanel panel = new ConfigBuilderPanel(elementConfigurationPath, profile);
        panel.setLicenseSupport(new MarvinLicenseSupport());
        if (excludedElements != null) {
            panel.removeConfigElements(excludedElements);
        }
        if (fileOpenSaveSupport) {
            try {
                File file;
                final AlchemistFileChooserForJChem fileChooser = new AlchemistFileChooserForJChem(false);
                String lastPath = (String)profile.get(PROPERTY_KEY_LAST_CONFIGBUILDER_FOLDER);
                if (lastPath != null && (file = new File(lastPath)).canRead()) {
                    fileChooser.setCurrentDirectory(file);
                }
                fileChooser.setFileFilter(new XMLFileFilter());
                fileChooser.setMultiSelectionEnabled(false);
                AbstractAction openFileAction = new AbstractAction(){
                    private static final long serialVersionUID = -7222996678969846074L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fileChooser.setDialogTitle("Open Standardizer configuration file");
                        if (fileChooser.showOpenDialog(panel) == 0) {
                            profile.put(ConfigBuilderPanelFactory.PROPERTY_KEY_LAST_CONFIGBUILDER_FOLDER, fileChooser.getCurrentDirectory().getAbsolutePath());
                            try {
                                panel.readConfiguration(ConfigurationReaderFactory.createStandardizerConfigurationReader(fileChooser.getSelectedFile()));
                            }
                            catch (FileNotFoundException e1) {
                                AlchemistErrorDialog.showError("Could not open file", (Exception)e1);
                            }
                        }
                    }
                };
                AbstractAction saveFileAction = new AbstractAction(){
                    private static final long serialVersionUID = 4727775378533727484L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fileChooser.setDialogTitle("Save Standardizer configuration");
                        if (fileChooser.showSaveDialog(panel) == 0) {
                            try {
                                panel.writeConfiguration(new StandardizerConfigurationWriter(new FileOutputStream(fileChooser.getSelectedFile())));
                            }
                            catch (IOException e1) {
                                AlchemistErrorDialog.showError("Could not save file", (Exception)e1);
                            }
                        }
                    }
                };
                openFileAction.putValue("ShortDescription", "Open configuration file");
                openFileAction.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/opendocument.gif"));
                saveFileAction.putValue("ShortDescription", "Save configuration file");
                saveFileAction.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/savedocument.gif"));
                panel.setOpenFileAction(openFileAction);
                panel.setSaveFileAction(saveFileAction);
                panel.setFileSupportEnabled(true);
            }
            catch (Exception e) {
                panel.setFileSupportEnabled(false);
            }
        }
        return panel;
    }

    public static ConfigBuilderPanel createStructureCheckerPanel() throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStructureCheckerPanel(false);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(AlchemistProfile profile) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStructureCheckerPanel(profile, false);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(String[] excludedElements) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStructureCheckerPanel(excludedElements, false);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(String[] excludedElements, AlchemistProfile profile) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStructureCheckerPanel(excludedElements, profile, false);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStructureCheckerPanel(DEFAULT_STRUCTURECHECKER_ELEMENT_CONFIGURATION_PATH, fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(AlchemistProfile profile, boolean fileOpenSaveSupport) throws ValidationException, FileNotFoundException, MarshalException {
        return ConfigBuilderPanelFactory.createStructureCheckerPanel(DEFAULT_STRUCTURECHECKER_ELEMENT_CONFIGURATION_PATH, profile, fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(String[] excludedElements, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return StructureCheckerConfigBuilderAlchemist.createStructureCheckerPanel(DEFAULT_STRUCTURECHECKER_ELEMENT_CONFIGURATION_PATH, excludedElements, null, fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(String[] excludedElements, AlchemistProfile profile, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return StructureCheckerConfigBuilderAlchemist.createStructureCheckerPanel(DEFAULT_STRUCTURECHECKER_ELEMENT_CONFIGURATION_PATH, excludedElements, profile, fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(String elementConfigurationPath) throws MarshalException, ValidationException, FileNotFoundException {
        return ConfigBuilderPanelFactory.createStructureCheckerPanel(elementConfigurationPath, false);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(String elementConfigurationPath, AlchemistProfile profile) throws ValidationException, FileNotFoundException, MarshalException {
        return ConfigBuilderPanelFactory.createStructureCheckerPanel(elementConfigurationPath, profile, false);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(String elementConfigurationPath, boolean fileOpenSaveSupport) throws ValidationException, FileNotFoundException, MarshalException {
        return ConfigBuilderPanelFactory.createStructureCheckerPanel(elementConfigurationPath, new AlchemistProfile(), fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(String elementConfigurationPath, AlchemistProfile profile, boolean fileOpenSaveSupport) throws ValidationException, FileNotFoundException, MarshalException {
        return StructureCheckerConfigBuilderAlchemist.createStructureCheckerPanel(elementConfigurationPath, null, profile, fileOpenSaveSupport);
    }
}

