/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.configbuilder.ConfigElement;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class ConfigElementListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 4235697770529912189L;
    private boolean ignoreStatus = false;
    private boolean ignoreLicense = false;

    public ConfigElementListCellRenderer() {
        this(false);
    }

    public ConfigElementListCellRenderer(boolean ignoreStatus) {
        this.ignoreStatus = ignoreStatus;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof ConfigElement) {
            ConfigElement element = (ConfigElement)value;
            if (!label.getText().equals(element.getName())) {
                label.setText(element.getName());
            }
            if (!this.ignoreLicense && !element.isLicensed()) {
                label.setEnabled(false);
                label.setDisabledIcon(element.getDisabledIcon());
            } else if (label.getIcon() == null || !label.getIcon().equals(this.ignoreStatus ? element.getDefaultIcon() : element.getIcon())) {
                label.setIcon(this.ignoreStatus ? element.getDefaultIcon() : element.getIcon());
            }
        }
        return label;
    }

    public boolean isIgnoreStatus() {
        return this.ignoreStatus;
    }

    public void setIgnoreStatus(boolean ignoreStatus) {
        this.ignoreStatus = ignoreStatus;
    }

    public boolean isIgnoreLicense() {
        return this.ignoreLicense;
    }

    public void setIgnoreLicense(boolean ignoreLicense) {
        this.ignoreLicense = ignoreLicense;
    }
}

