/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.configbuilder.ConfigElementEditor;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ConfigElementPresentationChooser {
    private final Map<Class<?>, Class<?>> classMap = new HashMap();
    private final Map<Class<?>, ConfigElementEditor> instanceMap = new HashMap();

    public void put(Class<?> key, Class<?> value) {
        this.classMap.put(key, value);
    }

    public ConfigElementEditor get(Class<?> key) throws IllegalArgumentException {
        Class<?> editorClass = this.classMap.get(key);
        if (editorClass == null) {
            return null;
        }
        if (this.instanceMap.containsKey(editorClass)) {
            return this.instanceMap.get(editorClass);
        }
        Constructor<?>[] constructors = editorClass.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            try {
                ConfigElementEditor value = (ConfigElementEditor)constructors[i].newInstance(null);
                this.instanceMap.put(editorClass, value);
                return value;
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.classMap.isEmpty() && this.instanceMap.isEmpty();
    }

    public void clear() {
        this.classMap.clear();
        this.instanceMap.clear();
    }

    public boolean containsKey(Class<?> key) {
        return this.classMap.containsKey(key) || this.instanceMap.containsKey(key);
    }

    public Class<?> remove(Class<?> key) {
        if (this.classMap.containsKey(key)) {
            return this.classMap.remove(key);
        }
        return this.instanceMap.remove(key).getClass();
    }

    public int size() {
        return this.classMap.size() + this.instanceMap.size();
    }

    public ConfigElementEditor[] getEditorInstances() {
        return this.instanceMap.values().toArray(new ConfigElementEditor[this.instanceMap.size()]);
    }
}

