/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer;

import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanelFactory;
import chemaxon.alchemist.configbuilder.ConfigElementFactory;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationReader;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationWriter;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.swing.SwingUtilities;

public class StandardizerConfigBuilderApplet
extends Applet {
    private static final long serialVersionUID = 2502924191015398953L;
    private Exception lastException = null;
    private ConfigBuilderPanel configBuilderPanel = null;

    public StandardizerConfigBuilderApplet() {
        try {
            this.setConfigBuilderPanel(ConfigBuilderPanelFactory.createStandardizerPanel());
        }
        catch (Exception e) {
            this.lastException = e;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StandardizerConfigBuilderApplet.this.setLayout(new BorderLayout());
                if (StandardizerConfigBuilderApplet.this.getConfigBuilderPanel() != null) {
                    StandardizerConfigBuilderApplet.this.add((Component)StandardizerConfigBuilderApplet.this.getConfigBuilderPanel(), "Center");
                }
            }
        });
    }

    public boolean setConfiguration(String configuration) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(configuration.getBytes());
            StandardizerConfigurationReader reader = new StandardizerConfigurationReader(new ConfigElementFactory("/chemaxon/alchemist/configbuilder/standardizer/StandardizerConfiguration.xml"), inputStream);
            this.getConfigBuilderPanel().readConfiguration(reader);
        }
        catch (Exception e) {
            this.lastException = e;
            return false;
        }
        return true;
    }

    public String getConfiguration() {
        String result = "";
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StandardizerConfigurationWriter writer = new StandardizerConfigurationWriter(outputStream);
            this.getConfigBuilderPanel().writeConfiguration(writer);
            outputStream.flush();
            result = outputStream.toString();
        }
        catch (Exception e) {
            this.lastException = e;
        }
        return result;
    }

    public String getLastError() {
        String str = "";
        if (this.lastException != null) {
            str = this.lastException.getMessage();
            this.lastException = null;
        }
        return str;
    }

    public boolean hasError() {
        return this.lastException != null;
    }

    protected void setConfigBuilderPanel(ConfigBuilderPanel configBuilderPanel) {
        this.configBuilderPanel = configBuilderPanel;
    }

    protected ConfigBuilderPanel getConfigBuilderPanel() {
        return this.configBuilderPanel;
    }
}

