/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer;

import chemaxon.alchemist.configbuilder.AbstractConfigurationReader;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.ConfigElementFactory;
import chemaxon.alchemist.configbuilder.standardizer.configelements.AbstractSgroupsElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.AromatizeElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.Clean2DElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.Clean3DElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.ClearStereoElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.ContractGroupsElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.ConvertDoubleBondsElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.ConvertToEnhancedStereoElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.CreateGroupElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.ExpandElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.ExpandGroupsElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.RemoveAbsoluteStereoElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.RemoveExplicitHElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.RemoveFragmentElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.RemoveRGroupsElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.SetAbsoluteStereoElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.TransformElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.UngroupElement;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class StandardizerConfigurationReader
extends AbstractConfigurationReader {
    private static final String PROPERTY_VALUE_FALSE = "false";
    private static final String PROPERTY_KEY_PARTIAL = "Partial";
    private static final String PROPERTY_KEY_TEMPLATE_FILE = "TemplateFile";
    private static final String PROPERTY_KEY_TYPE = "Type";
    private final ConfigElementFactory factory;

    public StandardizerConfigurationReader(ConfigElementFactory factory, InputStream inputStream) {
        super(inputStream);
        this.factory = factory;
    }

    protected List<ConfigElement> getConfigElements(Element rootElement, String[] groupFilter) {
        Element actionsNode;
        ArrayList<ConfigElement> elementList = new ArrayList<ConfigElement>();
        if ("StandardizerConfiguration".equalsIgnoreCase(rootElement.getName()) && (actionsNode = (Element)rootElement.selectSingleNode("Actions")) != null) {
            int size = actionsNode.nodeCount();
            for (int i = 0; i < size; ++i) {
                String type;
                String act;
                if (!(actionsNode.node(i) instanceof Element)) continue;
                ConfigElement configElement = null;
                Element actionNode = (Element)actionsNode.node(i);
                String actionName = actionNode.getName();
                if (groupFilter != null && !this.hasGroup(actionNode, groupFilter)) continue;
                if ("Reaction".equalsIgnoreCase(actionName)) {
                    actionName = "Transformation";
                } else if ("ImplH".equalsIgnoreCase(actionName)) {
                    actionName = "RemoveExplicitH";
                } else if ("Hydrogenize".equalsIgnoreCase(actionName)) {
                    actionName = "AddExplicitH";
                } else if ("UnmapReaction".equalsIgnoreCase(actionName)) {
                    actionName = "Unmap";
                }
                if ("AbsoluteStereo".equalsIgnoreCase(actionName)) {
                    act = actionNode.attributeValue("Act", "");
                    configElement = "Clear".equalsIgnoreCase(act) ? this.factory.create(RemoveAbsoluteStereoElement.class) : this.factory.create(SetAbsoluteStereoElement.class);
                } else if ("AliasToAtom".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("AliasToGroup".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("Aromatize".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(AromatizeElement.class);
                    type = actionNode.attributeValue(PROPERTY_KEY_TYPE, "");
                    if ("chemaxon".equalsIgnoreCase(type) || "basic".equalsIgnoreCase(type) || "1".equals(type)) {
                        ((AromatizeElement)configElement).setType("basic");
                    } else if ("loose".equalsIgnoreCase(type)) {
                        ((AromatizeElement)configElement).setType("loose");
                    }
                } else if ("ClearIsotopes".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("ClearStereo".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(ClearStereoElement.class);
                    ((ClearStereoElement)configElement).setTetrahedral(false);
                    ((ClearStereoElement)configElement).setDoubleBond(false);
                    ((ClearStereoElement)configElement).setSingleUpOrDownBond(false);
                    type = actionNode.attributeValue(PROPERTY_KEY_TYPE, "All");
                    String[] options = type.split(",");
                    for (int j = 0; j < options.length; ++j) {
                        if (options[j].trim().equalsIgnoreCase("all") || options[j].trim().equalsIgnoreCase("Chirality")) {
                            ((ClearStereoElement)configElement).setTetrahedral(true);
                        }
                        if (options[j].trim().equalsIgnoreCase("all") || options[j].trim().equalsIgnoreCase("DoubleBond")) {
                            ((ClearStereoElement)configElement).setDoubleBond(true);
                        }
                        if (!options[j].trim().equalsIgnoreCase("all") && !options[j].trim().equalsIgnoreCase("SingleUpOrDownBond")) continue;
                        ((ClearStereoElement)configElement).setSingleUpOrDownBond(true);
                    }
                } else if ("Clean".equalsIgnoreCase(actionName)) {
                    if (actionNode.attributeValue("Dim", "").equalsIgnoreCase("3")) {
                        configElement = this.factory.create(Clean3DElement.class);
                    } else {
                        configElement = this.factory.create(Clean2DElement.class);
                        try {
                            type = actionNode.attributeValue(PROPERTY_KEY_TYPE, PROPERTY_KEY_PARTIAL);
                            ((Clean2DElement)configElement).setType(type);
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e.getMessage());
                            ((Clean2DElement)configElement).setType(PROPERTY_KEY_PARTIAL);
                        }
                        if (actionNode.attributeValue(PROPERTY_KEY_TYPE, PROPERTY_KEY_PARTIAL).equalsIgnoreCase("TemplateBased")) {
                            List<Molecule> moleculeList = null;
                            moleculeList = !"".equals(actionNode.attributeValue(PROPERTY_KEY_TEMPLATE_FILE, "")) ? this.inlineMolecules(actionNode.attributeValue(PROPERTY_KEY_TEMPLATE_FILE, "")) : this.decodeMolecules(actionNode.attributeValue("Templates", ""), true);
                            if (moleculeList != null) {
                                for (int j = 0; j < moleculeList.size(); ++j) {
                                    ((Clean2DElement)configElement).addTemplateMolecule(moleculeList.get(j));
                                }
                            }
                        }
                    }
                } else if ("ConvertDoubleBonds".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(ConvertDoubleBondsElement.class);
                    type = actionNode.attributeValue(PROPERTY_KEY_TYPE, "Wiggly");
                    try {
                        ((ConvertDoubleBondsElement)configElement).setType(type);
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println(e.getMessage());
                        ((ConvertDoubleBondsElement)configElement).setType("Wiggly");
                    }
                } else if ("ConvertToEnhancedStereo".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(ConvertToEnhancedStereoElement.class);
                    String absStereo = actionNode.attributeValue("AbsStereo", PROPERTY_VALUE_FALSE);
                    if (Boolean.parseBoolean(absStereo)) {
                        ((ConvertToEnhancedStereoElement)configElement).setAbsoluteStereo(true);
                    } else {
                        ((ConvertToEnhancedStereoElement)configElement).setAbsoluteStereo(false);
                    }
                    String defaultNonAbsStereoGroup = actionNode.attributeValue("DefaultNonAbsStereoGroup", "and");
                    try {
                        ((ConvertToEnhancedStereoElement)configElement).setDefaultNonAbsoluteStereoGroup(defaultNonAbsStereoGroup);
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println(e.getMessage());
                        ((ConvertToEnhancedStereoElement)configElement).setDefaultNonAbsoluteStereoGroup("and");
                    }
                } else if ("ConvertWedgeInterpretation".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("CreateGroup".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(CreateGroupElement.class);
                    for (Element definition : actionNode.selectNodes("GroupDefinition")) {
                        String abbr = definition.attributeValue("abbr", "");
                        String struct = definition.getTextTrim();
                        if ("".equals(abbr) || "".equals(struct)) continue;
                        try {
                            ((CreateGroupElement)configElement).addGroupData(abbr, MolImporter.importMol(struct));
                        }
                        catch (MolFormatException e) {}
                    }
                    if (((CreateGroupElement)configElement).getGroupList().size() > 0) {
                        ((CreateGroupElement)configElement).setListType("custom");
                    } else {
                        ((CreateGroupElement)configElement).setListType("default");
                    }
                } else if ("Dearomatize".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("Tautomerize".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("Map".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("MapReaction".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("Unmap".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("Mesomerize".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("Neutralize".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("Dehydrogenize".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(RemoveExplicitHElement.class);
                } else if ("RemoveAtomValues".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("RemoveAttachedData".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("RemoveExplicitH".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(RemoveExplicitHElement.class);
                    ((RemoveExplicitHElement)configElement).setCharged(Boolean.valueOf(actionNode.attributeValue("Charged", PROPERTY_VALUE_FALSE)));
                    ((RemoveExplicitHElement)configElement).setIsotopic(Boolean.valueOf(actionNode.attributeValue("Isotopic", PROPERTY_VALUE_FALSE)));
                    ((RemoveExplicitHElement)configElement).setLonely(Boolean.valueOf(actionNode.attributeValue("Lonely", PROPERTY_VALUE_FALSE)));
                    ((RemoveExplicitHElement)configElement).setMapped(Boolean.valueOf(actionNode.attributeValue("Mapped", PROPERTY_VALUE_FALSE)));
                    ((RemoveExplicitHElement)configElement).setRadical(Boolean.valueOf(actionNode.attributeValue("Radical", PROPERTY_VALUE_FALSE)));
                    ((RemoveExplicitHElement)configElement).setWedged(Boolean.valueOf(actionNode.attributeValue("Wedged", PROPERTY_VALUE_FALSE)));
                } else if ("RemoveStereoCareBox".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("Expand".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(ExpandElement.class);
                    String data = actionNode.attributeValue("Data", "Stoichiometry");
                    if (data.equalsIgnoreCase("Stoichiometry")) {
                        ((ExpandElement)configElement).setCustom(false);
                    } else {
                        ((ExpandElement)configElement).setCustom(true);
                        ((ExpandElement)configElement).setCustomData(data);
                    }
                } else if ("Sgroups".equalsIgnoreCase(actionName)) {
                    act = actionNode.attributeValue("Act", "Contract");
                    String exclude = actionNode.attributeValue("Exclude", "");
                    configElement = "Expand".equalsIgnoreCase(act) ? this.factory.create(ExpandGroupsElement.class) : ("Ungroup".equalsIgnoreCase(act) ? this.factory.create(UngroupElement.class) : this.factory.create(ContractGroupsElement.class));
                    ((AbstractSgroupsElement)configElement).setExclude(exclude);
                } else if ("AddExplicitH".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else if ("Transformation".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(TransformElement.class);
                    String strOpts = actionNode.attributeValue("SearchOptions", null);
                    MolSearchOptions searchOptions = Boolean.valueOf(actionNode.attributeValue("Exact", PROPERTY_VALUE_FALSE)) != false ? new MolSearchOptions(7) : new MolSearchOptions(2);
                    if (strOpts != null) {
                        searchOptions.setOptions(strOpts);
                    }
                    ((TransformElement)configElement).setSearchOptions(searchOptions);
                    ((TransformElement)configElement).setName(actionNode.attributeValue("ID", "Transform"));
                    List<Molecule> moleculeList = null;
                    moleculeList = actionNode.attributeValue(PROPERTY_KEY_TYPE, "").equalsIgnoreCase("Path") ? this.inlineMolecules(actionNode.attributeValue("Structure", "")) : this.decodeMolecules(actionNode.attributeValue("Structure", ""), true);
                    if (moleculeList != null && !moleculeList.isEmpty()) {
                        ((TransformElement)configElement).setStructure(moleculeList.get(0).toFormat("cxsmarts:+c"));
                    }
                } else if ("Removal".equalsIgnoreCase(actionName)) {
                    if (actionNode.attributeValue("Method", "keepLargest").equalsIgnoreCase("rgroups")) {
                        configElement = this.factory.create(RemoveRGroupsElement.class);
                    } else {
                        configElement = this.factory.create(RemoveFragmentElement.class);
                        String method = actionNode.attributeValue("Method", "keepLargest");
                        try {
                            ((RemoveFragmentElement)configElement).setMethod(method);
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e.getMessage());
                            ((RemoveFragmentElement)configElement).setMethod("keepLargest");
                        }
                        String measure = actionNode.attributeValue("Measure", "atomCount");
                        try {
                            ((RemoveFragmentElement)configElement).setMeasure(measure);
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e.getMessage());
                            ((RemoveFragmentElement)configElement).setMeasure("atomCount");
                        }
                    }
                } else if ("WedgeClean".equalsIgnoreCase(actionName)) {
                    configElement = this.factory.create(actionName);
                } else {
                    System.err.println("Unknown element: " + actionName);
                }
                if (configElement == null) continue;
                String[] groups = actionNode.attributeValue("Groups", "").split(",");
                if (groups[0].length() > 0) {
                    for (int j = 0; j < groups.length; ++j) {
                        configElement.addGroup(groups[j]);
                    }
                }
                elementList.add(configElement);
            }
        }
        return elementList;
    }

    private boolean hasGroup(Element element, String[] groupFilter) {
        String[] group = element.attributeValue("Groups", "").split(",");
        Arrays.sort(groupFilter);
        for (int i = 0; i < group.length; ++i) {
            if (Arrays.binarySearch(groupFilter, group[i]) < 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Molecule> inlineMolecules(String path) {
        ArrayList<Molecule> list = new ArrayList<Molecule>();
        try {
            MolImporter importer = new MolImporter(path);
            try {
                Molecule mol;
                while ((mol = importer.read()) != null) {
                    list.add(mol);
                }
            }
            finally {
                importer.close();
            }
        }
        catch (IOException e) {
            list.clear();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Molecule> decodeMolecules(String data, boolean queryMode) {
        ArrayList<Molecule> list = null;
        MolImporter importer = null;
        try {
            MDocument doc;
            importer = new MolImporter(new ByteArrayInputStream(data.replaceAll("\\\\n", "\n").getBytes()));
            importer.setQueryMode(queryMode);
            list = new ArrayList<Molecule>();
            while ((doc = importer.nextDoc()) != null) {
                list.add(doc.getPrimaryMolecule());
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (IOException e) {}
        }
        return list;
    }

    @Override
    public ConfigElement[] readConfiguration(String[] groupFilter) {
        List<Object> elementList = new ArrayList();
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(this.inputStream);
            elementList = this.getConfigElements(document.getRootElement(), groupFilter);
        }
        catch (DocumentException e) {
            // empty catch block
        }
        return elementList.toArray(new ConfigElement[elementList.size()]);
    }

    @Override
    public ConfigElement[] readConfiguration() {
        return this.readConfiguration(null);
    }
}

