/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.configelements;

import chemaxon.alchemist.configbuilder.ConfigElement;
import java.util.Arrays;
import java.util.Collection;
import org.dom4j.Element;

public class AromatizeElement
extends ConfigElement {
    public static final String PROPERTY_KEY_TYPE = "Type";
    public static final String PROPERTY_VALUE_BASIC = "basic";
    public static final String PROPERTY_VALUE_GENERAL = "general";
    public static final String PROPERTY_VALUE_LOOSE = "loose";
    private static final Collection<String> VALID_TYPE = Arrays.asList("basic", "general", "loose");
    private String type = "general";

    @Override
    public boolean isDefault() {
        return this.type.equals(PROPERTY_VALUE_GENERAL);
    }

    @Override
    public void store(Element parent) {
        Element e = super.store(parent, "Aromatize");
        e.addAttribute(PROPERTY_KEY_TYPE, this.type);
    }

    @Override
    protected void validate() {
        this.setValid(VALID_TYPE.contains(this.type));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws IllegalArgumentException {
        if (!VALID_TYPE.contains(type)) {
            throw new IllegalArgumentException("Allowed values: " + VALID_TYPE.toString());
        }
        String oldType = this.type;
        this.type = type;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TYPE, oldType, type);
        this.validate();
    }

    @Override
    public AromatizeElement clone() throws CloneNotSupportedException {
        return (AromatizeElement)super.clone();
    }

    @Override
    public boolean isLicensed() {
        return true;
    }
}

