/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.configelements;

import chemaxon.alchemist.configbuilder.AbstractSketchConfigElement;
import chemaxon.formats.MolExporter;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class CreateGroupElement
extends AbstractSketchConfigElement {
    private static final int DEFAULT_DISPLAY_OPTS = 478156100;
    public static final String PROPERTY_KEY_GROUPDATALISTCHANGED = "GroupDataListChanged";
    public static final String PROPERTY_KEY_LIST_TYPE = "listType";
    public static final String PROPERTY_VALUE_CUSTOM = "custom";
    public static final String PROPERTY_VALUE_DEFAULT = "default";
    private int selectedGroup = -1;
    private String listType = "default";
    private List<GroupData> groupList = new ArrayList<GroupData>();

    @Override
    protected void validate() {
        boolean valid = true;
        if (PROPERTY_VALUE_CUSTOM.equals(this.getListType())) {
            if (this.groupList.size() > 0) {
                for (GroupData data : this.groupList) {
                    if (data.getStructure().isEmpty()) {
                        valid = false;
                    } else {
                        if (!"".equals(data.getName().trim())) continue;
                        valid = false;
                    }
                    break;
                }
            } else {
                valid = false;
            }
        }
        this.setValid(valid);
    }

    @Override
    public boolean isDefault() {
        return PROPERTY_VALUE_DEFAULT.equals(this.listType);
    }

    @Override
    public CreateGroupElement clone() throws CloneNotSupportedException {
        CreateGroupElement element = (CreateGroupElement)super.clone();
        element.groupList = new ArrayList<GroupData>();
        for (GroupData data : this.groupList) {
            element.groupList.add(data.clone());
        }
        return element;
    }

    @Override
    public void store(Element parent) {
        Element element = super.store(parent, "CreateGroup");
        if (PROPERTY_VALUE_CUSTOM.equals(this.getListType())) {
            for (GroupData data : this.groupList) {
                Element definition = element.addElement("GroupDefinition");
                definition.addAttribute("abbr", data.getName());
                try {
                    definition.addText(MolExporter.exportToFormat(data.getStructure(), "cxsmiles:+c"));
                }
                catch (IOException e) {}
            }
        }
    }

    public void setListType(String value) {
        if (PROPERTY_VALUE_CUSTOM.equals(value)) {
            this.listType = PROPERTY_VALUE_CUSTOM;
        } else if (PROPERTY_VALUE_DEFAULT.equals(value)) {
            this.listType = PROPERTY_VALUE_DEFAULT;
        } else {
            throw new IllegalArgumentException("Invalid List Type. Valid types are custom and default");
        }
    }

    public String getListType() {
        return this.listType;
    }

    public List<GroupData> getGroupList() {
        return this.groupList;
    }

    public void addGroupData() {
        this.selectedGroup = -1;
        this.setMolecule(new Molecule());
        this.setEditorMode("external");
    }

    public void addGroupData(String name, Molecule structure) {
        this.groupList.add(new GroupData(name, structure));
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_GROUPDATALISTCHANGED, false, true);
        this.validate();
    }

    public void editGroupMolecule(int index) {
        this.selectedGroup = index;
        this.setMolecule(this.groupList.get(index).getStructure());
        this.setEditorMode("external");
    }

    public void setGroupData(int index, String name, Molecule structure) {
        this.groupList.get(index).setName(name);
        this.groupList.get(index).setStructure(structure);
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_GROUPDATALISTCHANGED, false, true);
        this.validate();
    }

    public void removeGroupData(int index) {
        this.groupList.remove(index);
        this.selectedGroup = -1;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_GROUPDATALISTCHANGED, false, true);
        this.validate();
    }

    public void removeAllGroupData() {
        this.groupList.clear();
        this.selectedGroup = -1;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_GROUPDATALISTCHANGED, false, true);
        this.validate();
    }

    @Override
    protected void accepted(Molecule molecule) {
        super.accepted(molecule);
        if (this.selectedGroup == -1) {
            this.groupList.add(new GroupData("Unnamed", molecule.cloneMolecule()));
        } else {
            this.groupList.get(this.selectedGroup).setStructure(molecule.cloneMolecule());
        }
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_GROUPDATALISTCHANGED, false, true);
        this.validate();
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_GROUPDATALISTCHANGED, false, true);
    }

    @Override
    protected int getDefaultDispOpts() {
        return 478156100;
    }

    public static final class GroupData
    implements Cloneable {
        private String name = null;
        private Molecule structure = null;

        public GroupData() {
            this("Unnamed", new Molecule());
        }

        public GroupData(String name, Molecule structure) {
            this.name = name;
            this.structure = structure;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setStructure(Molecule structure) {
            this.structure = structure;
        }

        public String getName() {
            return this.name;
        }

        public Molecule getStructure() {
            return this.structure;
        }

        public GroupData clone() throws CloneNotSupportedException {
            GroupData data = (GroupData)super.clone();
            data.name = this.name;
            data.structure = this.structure.cloneMolecule();
            return data;
        }
    }
}

