/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.configelements;

import chemaxon.alchemist.configbuilder.ConfigElement;
import java.util.Arrays;
import java.util.Collection;
import org.dom4j.Element;

public class RemoveFragmentElement
extends ConfigElement {
    public static final String PROPERTY_KEY_METHOD = "Method";
    public static final String PROPERTY_KEY_MEASURE = "Measure";
    public static final String PROPERTY_VALUE_KEEPLARGEST = "keepLargest";
    public static final String PROPERTY_VALUE_KEEPSMALLEST = "keepSmallest";
    public static final String PROPERTY_VALUE_REMOVELARGEST = "removeLargest";
    public static final String PROPERTY_VALUE_REMOVESMALLEST = "removeSmallest";
    public static final String PROPERTY_VALUE_ATOMCOUNT = "atomCount";
    public static final String PROPERTY_VALUE_MOLMASS = "molMass";
    private static final Collection<String> VALID_METHOD = Arrays.asList("keepLargest".toLowerCase(), "keepSmallest".toLowerCase(), "removeLargest".toLowerCase(), "removeSmallest".toLowerCase());
    private static final Collection<String> VALID_MEASURE = Arrays.asList("atomCount".toLowerCase(), "molMass".toLowerCase());
    private String method = "keepLargest";
    private String measure = "atomCount";

    @Override
    public boolean isDefault() {
        return this.method.equals(PROPERTY_VALUE_KEEPLARGEST) && this.measure.equals(PROPERTY_VALUE_ATOMCOUNT);
    }

    @Override
    public void store(Element parent) {
        Element e = super.store(parent, "Removal");
        e.addAttribute(PROPERTY_KEY_METHOD, this.method);
        e.addAttribute(PROPERTY_KEY_MEASURE, this.measure);
    }

    @Override
    protected void validate() {
        this.setValid(VALID_MEASURE.contains(this.measure.toLowerCase()) && VALID_METHOD.contains(this.method.toLowerCase()));
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) throws IllegalArgumentException {
        if (!VALID_METHOD.contains(method.toLowerCase())) {
            throw new IllegalArgumentException("Invalid value '" + method + "'\nAllowed values: " + VALID_METHOD.toString());
        }
        String oldMethod = this.method;
        this.method = method;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_METHOD, oldMethod, method);
        this.validate();
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) throws IllegalArgumentException {
        if (!VALID_MEASURE.contains(measure.toLowerCase())) {
            throw new IllegalArgumentException("Invalid value '" + measure + "'\nAllowed values: " + VALID_MEASURE.toString());
        }
        String oldMeasure = this.measure;
        this.measure = measure;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_MEASURE, oldMeasure, measure);
        this.validate();
    }

    @Override
    public RemoveFragmentElement clone() throws CloneNotSupportedException {
        return (RemoveFragmentElement)super.clone();
    }
}

