/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.editors;

import chemaxon.alchemist.configbuilder.AbstractConfigElementEditor;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.standardizer.configelements.CreateGroupElement;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.MoleculeTableCellRenderer;
import chemaxon.reaction.GroupDefinition;
import chemaxon.reaction.GroupList;
import chemaxon.reaction.StandardizerException;
import chemaxon.struc.Molecule;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class CreateGroupElementEditor
extends AbstractConfigElementEditor {
    private static Comparator<GroupDefinition> definitionComparator = new Comparator<GroupDefinition>(){

        @Override
        public int compare(GroupDefinition o1, GroupDefinition o2) {
            return o1.getAbbreviation().compareTo(o2.getAbbreviation());
        }
    };
    private JTable groupTable = null;
    private JRadioButton defaultGroupsButton = null;
    private JRadioButton customGroupsButton = null;
    private JScrollPane tableScroll = null;
    private JPanel tableHolder = null;
    private JPanel disabledTablePanel = null;
    private JPanel cardPanel = null;
    private JPanel buttonPanel = null;
    private static final List<GroupDefinition> DEFAULT_DEFINITION_LIST;
    private JComboBox definitionNameCombo = null;
    private boolean updating = false;
    private final TableCellEditor dummyEditor = new DefaultCellEditor(new JTextField()){
        private static final long serialVersionUID = 6437304938843739497L;
        private final JComponent component;
        {
            this.component = new JComponent(){
                private static final long serialVersionUID = 7017507498535946642L;
            };
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (row < CreateGroupElementEditor.this.getGroupTable().getRowCount() - 1) {
                ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).editGroupMolecule(row);
            } else {
                ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).addGroupData();
            }
            ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).addPropertyChangeListener("GroupDataListChanged", CreateGroupElementEditor.this.definitionChangeListener);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateGroupElementEditor.this.dummyEditor.cancelCellEditing();
                }
            });
            return this.component;
        }
    };
    private static final TableCellRenderer HELP_TEXT_RENDERER;
    private final PropertyChangeListener definitionChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == CreateGroupElementEditor.this.getElement()) {
                CreateGroupElementEditor.this.getElement().removePropertyChangeListener("GroupDataListChanged", this);
                CreateGroupElementEditor.this.updateTableFromModel();
            }
        }
    };
    private final Action SELECT_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 6567477875602595769L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CreateGroupElementEditor.this.getDefaultGroupsButton().isSelected()) {
                ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).setListType("default");
                ((CardLayout)CreateGroupElementEditor.this.getCardPanel().getLayout()).show(CreateGroupElementEditor.this.getCardPanel(), "disabled");
            } else if (CreateGroupElementEditor.this.getCustomGroupsButton().isSelected()) {
                ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).setListType("custom");
                ((CardLayout)CreateGroupElementEditor.this.getCardPanel().getLayout()).show(CreateGroupElementEditor.this.getCardPanel(), "enabled");
            }
            CreateGroupElementEditor.this.getTableScroll().repaint();
        }
    };
    private final Action IMPORT_DEFAULTS = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/importreaction.gif")){
        private static final long serialVersionUID = 529227556153389439L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CreateGroupElementEditor.this.getGroupTable().getRowCount() > 1 && JOptionPane.showConfirmDialog(CreateGroupElementEditor.this.getGroupTable().getRootPane(), "Do you want to import default abbreviation groups?\nCurrent list will be lost.", "Import default abbreviation groups", 0) != 0) {
                CreateGroupElementEditor.this.getGroupTable().requestFocusInWindow();
                return;
            }
            ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).removeAllGroupData();
            for (GroupDefinition definition : DEFAULT_DEFINITION_LIST) {
                Molecule molecule = definition.getGroup().cloneMolecule();
                molecule.expandSgroups();
                ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).addGroupData(definition.getAbbreviation(), molecule);
            }
            CreateGroupElementEditor.this.updateTableFromModel();
        }
    };
    private final Action MOVE_UP = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/up.gif")){
        private static final long serialVersionUID = -6850779896378582794L;

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = CreateGroupElementEditor.this.getGroupTable().getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                editor.cancelCellEditing();
            }
            int min = CreateGroupElementEditor.this.getGroupTable().getSelectionModel().getMinSelectionIndex();
            int max = CreateGroupElementEditor.this.getGroupTable().getSelectionModel().getMaxSelectionIndex();
            List<CreateGroupElement.GroupData> list = ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).getGroupList();
            CreateGroupElement.GroupData temp = list.get(min - 1);
            for (int i = min - 1; i < max; ++i) {
                list.set(i, list.get(i + 1));
            }
            list.set(max, temp);
            CreateGroupElementEditor.this.updateTableFromModel();
            CreateGroupElementEditor.this.getGroupTable().getSelectionModel().setSelectionInterval(min - 1, max - 1);
            CreateGroupElementEditor.this.getGroupTable().scrollRectToVisible(CreateGroupElementEditor.this.getGroupTable().getCellRect(min - 1, 0, true));
        }
    };
    private final Action MOVE_DOWN = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/down.gif")){
        private static final long serialVersionUID = -9033319957551300646L;

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = CreateGroupElementEditor.this.getGroupTable().getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                editor.cancelCellEditing();
            }
            int min = CreateGroupElementEditor.this.getGroupTable().getSelectionModel().getMinSelectionIndex();
            int max = CreateGroupElementEditor.this.getGroupTable().getSelectionModel().getMaxSelectionIndex();
            List<CreateGroupElement.GroupData> list = ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).getGroupList();
            CreateGroupElement.GroupData temp = list.get(max + 1);
            for (int i = max; i >= min; --i) {
                list.set(i + 1, list.get(i));
            }
            list.set(min, temp);
            CreateGroupElementEditor.this.updateTableFromModel();
            CreateGroupElementEditor.this.getGroupTable().getSelectionModel().setSelectionInterval(min + 1, max + 1);
            CreateGroupElementEditor.this.getGroupTable().scrollRectToVisible(CreateGroupElementEditor.this.getGroupTable().getCellRect(max + 1, 0, true));
        }
    };
    private final Action DELETE_SELECTED = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/clear.gif")){
        private static final long serialVersionUID = -7807954099697722026L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(CreateGroupElementEditor.this.getGroupTable().getRootPane(), "Do you want to remove selected abbreviation group" + (CreateGroupElementEditor.this.getGroupTable().getSelectedRowCount() > 1 ? "s" : "") + "?", "Import default abbreviation groups", 0) != 0) {
                CreateGroupElementEditor.this.getGroupTable().requestFocusInWindow();
                return;
            }
            TableCellEditor editor = CreateGroupElementEditor.this.getGroupTable().getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                editor.cancelCellEditing();
            }
            int min = CreateGroupElementEditor.this.getGroupTable().getSelectionModel().getMinSelectionIndex();
            int max = CreateGroupElementEditor.this.getGroupTable().getSelectionModel().getMaxSelectionIndex();
            for (int i = 0; i < max - min + 1; ++i) {
                ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).removeGroupData(min);
            }
            CreateGroupElementEditor.this.updateTableFromModel();
        }
    };

    public CreateGroupElementEditor() {
        this.IMPORT_DEFAULTS.putValue("ShortDescription", "Import ChemAxon Default Abbreviation Groups");
        this.MOVE_UP.putValue("ShortDescription", "Move selected values upwards in the list");
        this.MOVE_DOWN.putValue("ShortDescription", "Move selected values downwards in the list");
        this.DELETE_SELECTED.putValue("ShortDescription", "Removes selected Groups from the list");
    }

    private JComboBox getDefinitionNameCombo() {
        if (this.definitionNameCombo == null) {
            this.definitionNameCombo = new JComboBox();
            this.definitionNameCombo.setEditable(true);
            for (GroupDefinition definition : DEFAULT_DEFINITION_LIST) {
                this.definitionNameCombo.addItem(definition.getAbbreviation());
            }
        }
        return this.definitionNameCombo;
    }

    private void updateTableFromModel() {
        List<CreateGroupElement.GroupData> dataList = ((CreateGroupElement)this.getElement()).getGroupList();
        this.updating = true;
        DefaultTableModel model = (DefaultTableModel)this.getGroupTable().getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        for (CreateGroupElement.GroupData data : dataList) {
            model.addRow(new Object[]{data.getName(), data.getStructure()});
        }
        model.addRow(new Object[]{null, null});
        this.updating = false;
    }

    private boolean isRowEmpty(int row) {
        String name = (String)this.getGroupTable().getValueAt(row, 0);
        Molecule molecule = (Molecule)this.getGroupTable().getValueAt(row, 1);
        return !(name != null && !"".equals(name) || molecule != null && !molecule.isEmpty());
    }

    private JTable getGroupTable() {
        if (this.groupTable == null) {
            this.groupTable = new JTable(new DefaultTableModel(new Object[]{"Abbreviation", "Structure"}, 1)){
                private static final long serialVersionUID = 1253686426798681346L;

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    if (row == this.getRowCount() - 1 || CreateGroupElementEditor.this.isRowEmpty(row)) {
                        return HELP_TEXT_RENDERER;
                    }
                    return super.getCellRenderer(row, column);
                }
            };
            this.groupTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.getDefinitionNameCombo()));
            this.groupTable.getColumnModel().getColumn(1).setCellRenderer(new MoleculeTableCellRenderer());
            this.groupTable.getColumnModel().getColumn(1).setCellEditor(this.dummyEditor);
            this.groupTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (!CreateGroupElementEditor.this.updating) {
                        if (e.getType() == 0 && e.getColumn() == 0 && e.getFirstRow() != -1) {
                            for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                                if (CreateGroupElementEditor.this.isRowEmpty(row)) continue;
                                int index = Collections.binarySearch(DEFAULT_DEFINITION_LIST, new GroupDefinition(String.valueOf(CreateGroupElementEditor.this.getGroupTable().getModel().getValueAt(row, 0)), new Molecule()), definitionComparator);
                                Molecule mol = new Molecule();
                                String name = String.valueOf(CreateGroupElementEditor.this.getGroupTable().getValueAt(row, 0));
                                if (index > -1) {
                                    mol = ((GroupDefinition)DEFAULT_DEFINITION_LIST.get(index)).getGroup().cloneMolecule();
                                    mol.expandSgroups();
                                }
                                if (row < CreateGroupElementEditor.this.getGroupTable().getRowCount() - 1) {
                                    if (CreateGroupElementEditor.this.getGroupTable().getValueAt(row, 1) instanceof Molecule && !((Molecule)CreateGroupElementEditor.this.getGroupTable().getValueAt(row, 1)).isEmpty() && (mol.isEmpty() || JOptionPane.showConfirmDialog(CreateGroupElementEditor.this.getGroupTable().getRootPane(), "Do you want to update structure?", "Default group found", 0) != 0)) {
                                        mol = (Molecule)CreateGroupElementEditor.this.getGroupTable().getValueAt(row, 1);
                                    }
                                    ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).setGroupData(row, name, mol);
                                    continue;
                                }
                                ((CreateGroupElement)CreateGroupElementEditor.this.getElement()).addGroupData(name, mol);
                            }
                            CreateGroupElementEditor.this.updateTableFromModel();
                        }
                        if (!CreateGroupElementEditor.this.isRowEmpty(CreateGroupElementEditor.this.getGroupTable().getRowCount() - 1)) {
                            CreateGroupElementEditor.this.updating = true;
                            ((DefaultTableModel)CreateGroupElementEditor.this.getGroupTable().getModel()).addRow(new Object[]{null, null});
                            CreateGroupElementEditor.this.updating = false;
                        }
                    }
                }
            });
            this.groupTable.setSelectionMode(1);
            this.groupTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        CreateGroupElementEditor.this.updateButtons();
                    }
                }
            });
            this.groupTable.setRowHeight(50);
            this.groupTable.getSelectionModel().setSelectionInterval(-1, -1);
        }
        return this.groupTable;
    }

    private void updateButtons() {
        this.MOVE_UP.setEnabled(this.getGroupTable().getSelectionModel().getMinSelectionIndex() > 0);
        this.MOVE_DOWN.setEnabled(this.getGroupTable().getSelectionModel().getMaxSelectionIndex() > -1 && this.getGroupTable().getSelectionModel().getMaxSelectionIndex() < this.getGroupTable().getRowCount() - 2);
        this.DELETE_SELECTED.setEnabled(this.getGroupTable().getSelectedRowCount() > 0 && this.getGroupTable().getSelectionModel().getMaxSelectionIndex() < this.getGroupTable().getRowCount() - 1);
    }

    private JRadioButton getDefaultGroupsButton() {
        if (this.defaultGroupsButton == null) {
            this.defaultGroupsButton = new JRadioButton(this.SELECT_ACTION);
            this.defaultGroupsButton.setText("Use default abbreviated groups");
        }
        return this.defaultGroupsButton;
    }

    private JRadioButton getCustomGroupsButton() {
        if (this.customGroupsButton == null) {
            this.customGroupsButton = new JRadioButton(this.SELECT_ACTION);
            this.customGroupsButton.setText("Define abbreviated groups");
        }
        return this.customGroupsButton;
    }

    @Override
    protected void initialize() {
        super.initialize();
        ButtonGroup group = new ButtonGroup();
        group.add(this.getCustomGroupsButton());
        group.add(this.getDefaultGroupsButton());
    }

    @Override
    public void setElement(ConfigElement element) {
        super.setElement(element);
        if ("custom".equals(((CreateGroupElement)this.getElement()).getListType())) {
            this.getCustomGroupsButton().setSelected(true);
        } else {
            this.getDefaultGroupsButton().setSelected(true);
        }
        this.updateTableFromModel();
        this.updateButtons();
        this.SELECT_ACTION.actionPerformed(null);
    }

    private JPanel getDisabledTablePanel() {
        if (this.disabledTablePanel == null) {
            this.disabledTablePanel = new JPanel(){
                private static final long serialVersionUID = -2593751314282436032L;

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    Graphics2D g2 = (Graphics2D)g.create();
                    CreateGroupElementEditor.this.getTableScroll().paint(g2);
                    g2.setColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g2.dispose();
                }
            };
        }
        return this.disabledTablePanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
            this.buttonPanel.add(new JButton(this.MOVE_UP));
            this.buttonPanel.add(new JButton(this.MOVE_DOWN));
            this.buttonPanel.add(new JButton(this.IMPORT_DEFAULTS));
            this.buttonPanel.add(new JButton(this.DELETE_SELECTED));
            for (Component component : this.buttonPanel.getComponents()) {
                component.setMinimumSize(new Dimension(23, 23));
                component.setPreferredSize(new Dimension(23, 23));
                component.setMaximumSize(new Dimension(23, 23));
            }
        }
        return this.buttonPanel;
    }

    private JPanel getTableHolder() {
        if (this.tableHolder == null) {
            this.tableHolder = new JPanel(new BorderLayout());
            this.tableHolder.add((Component)this.getTableScroll(), "Center");
            this.tableHolder.add((Component)this.getButtonPanel(), "East");
        }
        return this.tableHolder;
    }

    private JScrollPane getTableScroll() {
        if (this.tableScroll == null) {
            this.tableScroll = new JScrollPane(this.getGroupTable(), 20, 31);
            this.tableScroll.getViewport().setBackground(Color.WHITE);
        }
        return this.tableScroll;
    }

    private JPanel getCardPanel() {
        if (this.cardPanel == null) {
            this.cardPanel = new JPanel(new CardLayout());
            this.cardPanel.add((Component)this.getTableHolder(), "enabled");
            this.cardPanel.add((Component)this.getDisabledTablePanel(), "disabled");
        }
        return this.cardPanel;
    }

    @Override
    protected LayoutManager getMainLayout() {
        return new FormLayout("4dlu, fill:pref:grow, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 2dlu, fill:min:grow, 4dlu");
    }

    @Override
    protected void addComponents() {
        CellConstraints cc = new CellConstraints();
        this.mainPanel.add((Component)this.getTitle("Specify Create Group Options"), cc.xy(2, 2));
        this.mainPanel.add((Component)this.getDefaultGroupsButton(), cc.xy(2, 4));
        this.mainPanel.add((Component)this.getCustomGroupsButton(), cc.xy(2, 6));
        this.mainPanel.add((Component)this.getCardPanel(), cc.xy(2, 8));
    }

    static {
        HELP_TEXT_RENDERER = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -6536920187863978125L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
                label.setForeground(Color.LIGHT_GRAY);
                label.setHorizontalTextPosition(0);
                label.setVerticalTextPosition(0);
                label.setAlignmentX(0.5f);
                if (column == 0) {
                    label.setText("<Select or type an Abbreviation>");
                } else {
                    label.setText("<Double click to edit structure>");
                }
                return label;
            }
        };
        List<GroupDefinition> definitionList = null;
        try {
            definitionList = GroupList.getDefaultAbbrevgroup();
        }
        catch (StandardizerException e) {
            definitionList = Collections.emptyList();
        }
        Collections.sort(definitionList, definitionComparator);
        DEFAULT_DEFINITION_LIST = definitionList;
    }
}

