/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.editors;

import chemaxon.alchemist.configbuilder.AbstractConfigElementEditor;
import chemaxon.alchemist.configbuilder.standardizer.configelements.RemoveFragmentElement;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class RemoveFragmentElementEditor
extends AbstractConfigElementEditor {
    private JComboBox methodCombo = null;
    private JRadioButton molMassRadio = null;
    private JRadioButton atomCountRadio = null;
    private JLabel tooltipLabel = null;
    private final Method[] METHOD_VALUES = new Method[]{new Method("keepLargest", "Keep largest", "Keep the largest fragment, remove all other"), new Method("keepSmallest", "Keep smallest", "Keep the smallest fragment, remove all other"), new Method("removeLargest", "Remove largest", "Remove the largest fragment, if there are more then one fragments"), new Method("removeSmallest", "Remove smallest", "Remove the smallest fragment, if there are more then one fragments")};
    private final Action SELECT_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -8885073095773905591L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RemoveFragmentElementEditor.this.getAtomCountRadio().isSelected()) {
                ((RemoveFragmentElement)RemoveFragmentElementEditor.this.getElement()).setMeasure("atomCount");
            } else {
                ((RemoveFragmentElement)RemoveFragmentElementEditor.this.getElement()).setMeasure("molMass");
            }
        }
    };

    @Override
    protected void addComponents() {
        CellConstraints cc = new CellConstraints();
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(this.getAtomCountRadio());
        radioButtonGroup.add(this.getMolMassRadio());
        this.mainPanel.add((Component)this.getTitle(this.getElement().getTooltip()), cc.xyw(2, 2, 3));
        this.mainPanel.add((Component)this.getMethodCombo(), cc.xy(2, 4));
        this.mainPanel.add((Component)this.getTooltipLabel(), cc.xy(4, 4));
        this.mainPanel.add((Component)this.getAtomCountRadio(), cc.xyw(2, 6, 3));
        this.mainPanel.add((Component)this.getMolMassRadio(), cc.xyw(2, 8, 3));
    }

    @Override
    protected LayoutManager getMainLayout() {
        return new FormLayout("4dlu, default, 2dlu, fill:default:grow, 4dlu", "4dlu, min, 2dlu, default, 2dlu, default, 2dlu, default, 4dlu");
    }

    @Override
    protected void initialize() {
        super.initialize();
        for (int i = 0; i < this.METHOD_VALUES.length; ++i) {
            if (!((RemoveFragmentElement)this.getElement()).getMethod().equalsIgnoreCase(this.METHOD_VALUES[i].id)) continue;
            this.getMethodCombo().setSelectedIndex(i);
        }
        if (((RemoveFragmentElement)this.getElement()).getMeasure().equalsIgnoreCase("atomCount")) {
            this.getAtomCountRadio().setSelected(true);
        } else {
            this.getMolMassRadio().setSelected(true);
        }
    }

    protected JComboBox getMethodCombo() {
        if (this.methodCombo == null) {
            this.methodCombo = new JComboBox<Method>(this.METHOD_VALUES);
            this.methodCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemoveFragmentElementEditor.this.getTooltipLabel().setText(((Method)RemoveFragmentElementEditor.this.getMethodCombo().getSelectedItem()).tooltip);
                    ((RemoveFragmentElement)RemoveFragmentElementEditor.this.getElement()).setMethod(((Method)RemoveFragmentElementEditor.this.getMethodCombo().getSelectedItem()).id);
                }
            });
        }
        return this.methodCombo;
    }

    protected JLabel getTooltipLabel() {
        if (this.tooltipLabel == null) {
            this.tooltipLabel = new JLabel(this.METHOD_VALUES[0].tooltip);
        }
        return this.tooltipLabel;
    }

    protected JRadioButton getAtomCountRadio() {
        if (this.atomCountRadio == null) {
            this.atomCountRadio = new JRadioButton(this.SELECT_ACTION);
            this.atomCountRadio.setText("Depends on the number of atoms");
        }
        return this.atomCountRadio;
    }

    private JRadioButton getMolMassRadio() {
        if (this.molMassRadio == null) {
            this.molMassRadio = new JRadioButton(this.SELECT_ACTION);
            this.molMassRadio.setText("Depends on the molecule mass");
        }
        return this.molMassRadio;
    }

    private static final class Method {
        String id;
        String label;
        String tooltip;

        Method(String id, String label, String tooltip) {
            this.id = id;
            this.label = label;
            this.tooltip = tooltip;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Method) {
                return this.id.equalsIgnoreCase(((Method)obj).id);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

