/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.standardizer.editors;

import chemaxon.alchemist.configbuilder.AbstractConfigElementEditor;
import chemaxon.alchemist.configbuilder.standardizer.configelements.AbstractSgroupsElement;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SgroupsElementEditor
extends AbstractConfigElementEditor {
    JLabel titleLabel = null;
    JLabel excludeLabel = null;
    JTextField excludeField = null;

    private JLabel getExcludeLabel() {
        if (this.excludeLabel == null) {
            this.excludeLabel = new JLabel("Exclude");
        }
        return this.excludeLabel;
    }

    private JTextField getExcludeField() {
        if (this.excludeField == null) {
            this.excludeField = new JTextField(){
                private static final long serialVersionUID = 4425495382931515902L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (SgroupsElementEditor.this.excludeField.getText().length() == 0) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.GRAY);
                        String text = "<Comma separated list of gorup names to be exluded. Ex: 'Ph' or 'Ph,Tos'>";
                        Font font = SgroupsElementEditor.this.excludeField.getFont();
                        float height = SgroupsElementEditor.this.excludeField.getFontMetrics(font).getLineMetrics(text, g2).getHeight();
                        float top = ((float)SgroupsElementEditor.this.excludeField.getHeight() - height) / 2.0f;
                        float left = (float)(SgroupsElementEditor.this.excludeField.getWidth() - SgroupsElementEditor.this.excludeField.getFontMetrics(font).stringWidth(text)) / 2.0f;
                        g2.drawString(text, left, top + height - 4.0f);
                        g2.dispose();
                    }
                }
            };
            this.excludeField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    ((AbstractSgroupsElement)SgroupsElementEditor.this.getElement()).setExclude(SgroupsElementEditor.this.excludeField.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.excludeField;
    }

    private JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = this.getTitle(this.getElement().getTooltip());
        }
        return this.titleLabel;
    }

    @Override
    protected void addComponents() {
        CellConstraints cc = new CellConstraints();
        this.mainPanel.add((Component)this.getTitleLabel(), cc.xywh(2, 2, 3, 1));
        this.mainPanel.add((Component)this.getExcludeLabel(), cc.xy(2, 4));
        this.mainPanel.add((Component)this.getExcludeField(), cc.xy(4, 4));
    }

    @Override
    protected LayoutManager getMainLayout() {
        return new FormLayout("4dlu, pref, 2dlu, fill:pref:grow, 4dlu", "4dlu, min, 2dlu, min, 4dlu");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getTitleLabel().setText("<html><b>" + this.getElement().getTooltip() + "</b></html>");
        this.getExcludeField().setText(((AbstractSgroupsElement)this.getElement()).getExclude());
    }
}

