/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.structurechecker;

import chemaxon.alchemist.AlchemistProfile;
import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.structurechecker.StructureCheckerConfigurationReader;
import chemaxon.alchemist.configbuilder.structurechecker.StructureCheckerConfigurationWriter;
import chemaxon.alchemist.configbuilder.structurechecker.configelements.StructureCheckerWrapper;
import chemaxon.alchemist.configbuilder.structurechecker.configelements.SubstructureCheckerWrapper;
import chemaxon.alchemist.utils.AboutDialogFactory;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooser;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.alchemist.utils.filefilters.XMLFileFilter;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerFactory;
import chemaxon.checkers.SubstructureChecker;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.util.DotfileUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class StructureCheckerConfigBuilderAlchemist
extends MarvinBasedAlchemistApplication
implements AlchemistLaunchable {
    public static final String DEFAULT_STRUCTURECHECKER_ELEMENT_CONFIGURATION_PATH = "/chemaxon/checkers/resource/defaultcheckerconfig.xml";
    private static final String PROPERTY_KEY_LAST_CONFIGBUILDER_FOLDER = "LastUsedConfibuilderDir";
    private static final String APPLICATION_TITLE = "Structure Checker Editor " + VersionInfo.MARVIN_VERSION;
    private static final String SAVE_FILE_CHOOSER_TITLE = "Save Structure Checker Configuration File";
    private static final String OPEN_FILE_CHOOSER_TITLE = "Open Structure Checker Configuration File";
    private static final FileFilter[] FILE_FILTERS = new FileFilter[]{new XMLFileFilter()};
    private static final String MENU_CONFIGURATION_PATH = "chemaxon/alchemist/configbuilder/structurechecker/StructureCheckerConfigBuilderAlchemistMenuConfiguration.xml";
    private static final String DEFAULT_PROFILE_PATH = DotfileUtil.getDotFile("/alchemist/structurechecker_configbuilder.profile").getAbsolutePath();
    private static final String DEFAULT_PROPERTIES_PATH = DotfileUtil.getDotFile("/alchemist/structurechecker_configbuilder_properties.xml").getAbsolutePath();
    private static final String MAIN_TOOLBAR_ID = "mainToolBar";
    private ConfigBuilderPanel configBuilderPanel = null;
    private JToolBar toolBar = null;

    public static ConfigBuilderPanel createStructureCheckerPanel(String elementConfigurationPath, String[] excludedElements, AlchemistProfile profile, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        return StructureCheckerConfigBuilderAlchemist.createStructureCheckerPanel(elementConfigurationPath, DotfileUtil.getDotFile("userdefinedcheckers.xml").getAbsolutePath(), excludedElements, profile, fileOpenSaveSupport);
    }

    public static ConfigBuilderPanel createStructureCheckerPanel(String elementConfigurationPath, String externalConfigurationPath, String[] excludedElements, final AlchemistProfile profile, boolean fileOpenSaveSupport) throws MarshalException, ValidationException, FileNotFoundException {
        final ConfigBuilderPanel panel = new ConfigBuilderPanel((String)null, profile);
        StructureCheckerFactory factory = new StructureCheckerFactory(elementConfigurationPath, externalConfigurationPath);
        List<StructureChecker> checkers = factory.getAvailableCheckers();
        Collections.sort(checkers, new Comparator<StructureChecker>(){

            @Override
            public int compare(StructureChecker o1, StructureChecker o2) {
                return o1.getDescriptor().getName().compareTo(o2.getDescriptor().getName());
            }
        });
        for (StructureChecker checker : checkers) {
            StructureCheckerWrapper wrapper = null;
            String editorClassName = null;
            if (checker instanceof SubstructureChecker) {
                wrapper = new SubstructureCheckerWrapper();
                editorClassName = "chemaxon.alchemist.configbuilder.structurechecker.editors.SubstructureCheckerWrapperEditor";
            } else {
                wrapper = new StructureCheckerWrapper();
                editorClassName = "chemaxon.alchemist.configbuilder.structurechecker.editors.StructureCheckerWrapperEditor";
            }
            wrapper.setItem(checker);
            panel.addConfigElement(wrapper, editorClassName);
        }
        panel.setDefaultHelpText("Select a checker from the list on the left, and press 'Add >' button to append it to the checking queue on the right. You can change the order of checkers with the up and down arrow buttons on the right side. The current configuration can be saved for future use.\n\nSome checkers have options that can be set if you select the corresponding checkers in the checking queue on the right. You can also select what action to perform in case of an issue. Automatic fixers are provided for many cases, but manual modification is available as an option as well.");
        if (excludedElements != null) {
            panel.removeConfigElements(excludedElements);
        }
        if (fileOpenSaveSupport) {
            try {
                File file;
                final AlchemistFileChooser fileChooser = new AlchemistFileChooser();
                String lastPath = (String)profile.get(PROPERTY_KEY_LAST_CONFIGBUILDER_FOLDER);
                if (lastPath != null && (file = new File(lastPath)).canRead()) {
                    fileChooser.setCurrentDirectory(file);
                }
                fileChooser.setFileFilter(new XMLFileFilter());
                fileChooser.setMultiSelectionEnabled(false);
                AbstractAction openFileAction = new AbstractAction(){
                    private static final long serialVersionUID = 3217071483141808308L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fileChooser.setDialogTitle("Open Structure Checker configuration file");
                        if (fileChooser.showOpenDialog(panel) == 0) {
                            profile.put(StructureCheckerConfigBuilderAlchemist.PROPERTY_KEY_LAST_CONFIGBUILDER_FOLDER, fileChooser.getCurrentDirectory().getAbsolutePath());
                            try {
                                panel.readConfiguration(new StructureCheckerConfigurationReader(new FileInputStream(fileChooser.getSelectedFile())));
                            }
                            catch (FileNotFoundException e1) {
                                AlchemistErrorDialog.showError("Could not open file", (Exception)e1);
                            }
                        }
                    }
                };
                AbstractAction saveFileAction = new AbstractAction(){
                    private static final long serialVersionUID = 3014835676759109925L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fileChooser.setDialogTitle("Save Structure Checker configuration");
                        if (fileChooser.showSaveDialog(panel) == 0) {
                            try {
                                panel.writeConfiguration(new StructureCheckerConfigurationWriter(new FileOutputStream(fileChooser.getSelectedFile())));
                            }
                            catch (IOException e1) {
                                AlchemistErrorDialog.showError("Could not save file", (Exception)e1);
                            }
                        }
                    }
                };
                openFileAction.putValue("ShortDescription", "Open configuration file");
                openFileAction.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/opendocument.gif"));
                saveFileAction.putValue("ShortDescription", "Save configuration file");
                saveFileAction.putValue("SmallIcon", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/savedocument.gif"));
                panel.setOpenFileAction(openFileAction);
                panel.setSaveFileAction(saveFileAction);
                panel.setFileSupportEnabled(true);
            }
            catch (Exception e) {
                panel.setFileSupportEnabled(false);
            }
        }
        return panel;
    }

    public StructureCheckerConfigBuilderAlchemist() {
        super(APPLICATION_TITLE, AlchemistIconFactory.getImage("/chemaxon/alchemist/images/structurechecker.png"));
        this.initialize();
    }

    private void initialize() {
        this.setDocumentPathInFrameTitle(true);
        this.setMenuResources(MENU_CONFIGURATION_PATH);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getConfigBuilderPanel(), "Center");
        this.getContentPane().add((Component)this.getToolBar(), "North");
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.getToolbar(MAIN_TOOLBAR_ID);
            this.toolBar.setFloatable(false);
        }
        return this.toolBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JComponent getConfigBuilderPanel() {
        if (this.configBuilderPanel == null) {
            try {
                AlchemistProfile profile = new AlchemistProfile();
                try {
                    FileInputStream inputStream = new FileInputStream(DEFAULT_PROFILE_PATH);
                    try {
                        profile.read(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.configBuilderPanel = StructureCheckerConfigBuilderAlchemist.createStructureCheckerPanel(DEFAULT_STRUCTURECHECKER_ELEMENT_CONFIGURATION_PATH, null, profile, false);
                this.configBuilderPanel.setProfile(profile);
                this.configBuilderPanel.setFileSupportEnabled(false);
            }
            catch (MarshalException e) {
                e.printStackTrace();
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (this.configBuilderPanel == null) {
                return new JPanel();
            }
        }
        return this.configBuilderPanel;
    }

    protected static void createAndShowGUI() {
        try {
            StructureCheckerConfigBuilderAlchemist.setLookAndFeel();
            StructureCheckerConfigBuilderAlchemist configBuilder = new StructureCheckerConfigBuilderAlchemist();
            configBuilder.show();
        }
        catch (Exception e) {
            AlchemistErrorDialog.showError(e);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StructureCheckerConfigBuilderAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    protected Dimension getDefaultWindowSize() {
        return new Dimension(800, 600);
    }

    @Override
    protected String getOpenFileChooserTitle() {
        return OPEN_FILE_CHOOSER_TITLE;
    }

    @Override
    protected String getSaveFileChooserTitle() {
        return SAVE_FILE_CHOOSER_TITLE;
    }

    @Override
    protected FileFilter[] getOpenFileFilters() {
        return FILE_FILTERS;
    }

    @Override
    protected FileFilter[] getSaveFileFilters() {
        return FILE_FILTERS;
    }

    @Override
    protected String getPropertyFilePath() {
        return DEFAULT_PROPERTIES_PATH;
    }

    @Override
    protected void newDocumentActionHandler() {
        super.newDocumentActionHandler();
        this.configBuilderPanel.clear();
    }

    @Override
    protected void openDocumentActionHandler(final String path) {
        Thread loadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StructureCheckerConfigBuilderAlchemist.this.disableContent(true);
                try {
                    StructureCheckerConfigurationReader reader = new StructureCheckerConfigurationReader(new FileInputStream(path));
                    StructureCheckerConfigBuilderAlchemist.this.configBuilderPanel.readConfiguration(reader);
                    StructureCheckerConfigBuilderAlchemist.super.openDocumentActionHandler(path);
                }
                catch (FileNotFoundException e) {
                    StructureCheckerConfigBuilderAlchemist.this.showError("File not found: " + path, e);
                }
                catch (Exception e) {
                    StructureCheckerConfigBuilderAlchemist.this.showError("Problem occured while opening file: " + path, e);
                }
                StructureCheckerConfigBuilderAlchemist.this.enableContent();
            }
        });
        loadThread.setPriority(4);
        loadThread.start();
    }

    @Override
    protected void saveDocumentActionHandler() {
        super.saveDocumentActionHandler();
        if (this.getDocumentPath() != null) {
            Thread saveThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    StructureCheckerConfigBuilderAlchemist.this.disableContent(true);
                    try {
                        StructureCheckerConfigurationWriter writer = new StructureCheckerConfigurationWriter(new FileOutputStream(StructureCheckerConfigBuilderAlchemist.this.getDocumentPath()));
                        StructureCheckerConfigBuilderAlchemist.this.configBuilderPanel.writeConfiguration(writer);
                    }
                    catch (IOException e) {
                        StructureCheckerConfigBuilderAlchemist.this.showError("Can not write file: " + StructureCheckerConfigBuilderAlchemist.this.getDocumentPath(), e);
                    }
                    catch (Exception e) {
                        StructureCheckerConfigBuilderAlchemist.this.showError("Problem occured while saving file: " + StructureCheckerConfigBuilderAlchemist.this.getDocumentPath(), e);
                    }
                    StructureCheckerConfigBuilderAlchemist.this.enableContent();
                }
            });
            saveThread.setPriority(4);
            saveThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exitProgramActionHandler() {
        if (this.configBuilderPanel != null) {
            this.configBuilderPanel.updateProfile();
            try {
                FileOutputStream outputStream = new FileOutputStream(DEFAULT_PROFILE_PATH);
                try {
                    this.configBuilderPanel.getProfile().write(outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.exitProgramActionHandler();
    }

    @Override
    public void launch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StructureCheckerConfigBuilderAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    protected void licenseManagerClosed() {
        super.licenseManagerClosed();
        if (this.configBuilderPanel != null) {
            this.configBuilderPanel.refreshLicenses();
        }
    }

    @Override
    protected void aboutActionHandler() {
        AboutDialogFactory.createAboutDialog("Structure Checker Editor", "/chemaxon/alchemist/images/about/standardizer-64.png").setVisible(true);
    }
}

