/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder.structurechecker.editors;

import chemaxon.alchemist.configbuilder.AbstractConfigElementEditor;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.structurechecker.configelements.StructureCheckerWrapper;
import chemaxon.checkers.FixMode;
import chemaxon.checkers.StructureChecker;
import chemaxon.fixers.StructureFixer;
import chemaxon.marvin.sketch.swing.checker.editor.CheckerEditor;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerEditorInstanceProvider;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StructureCheckerWrapperEditor
extends AbstractConfigElementEditor {
    private JRadioButton askRadio = null;
    private JRadioButton skipRadio = null;
    private JRadioButton fixRadio = null;
    protected ButtonGroup fixModeRadioButtonGroup = null;
    private JTextField title = null;
    private JComboBox fixersCombo = null;
    private boolean initializing = false;
    private Component editor = null;
    private JPanel checkerOptionsHolder = null;
    private final PropertyChangeListener wrappedCheckerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            StructureCheckerWrapperEditor.this.handleElementChange(evt);
        }
    };

    protected JRadioButton getAskRadio() {
        if (this.askRadio == null) {
            this.askRadio = new JRadioButton(new AbstractAction("Manual fix"){
                private static final long serialVersionUID = -9108776215305935908L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerWrapperEditor.this.setFixMode(FixMode.ASK);
                }
            });
            this.askRadio.setToolTipText("No automated fix attempt, user will be prompted when checker finds this issue.");
        }
        return this.askRadio;
    }

    protected JRadioButton getSkipRadio() {
        if (this.skipRadio == null) {
            this.skipRadio = new JRadioButton(new AbstractAction("Do not fix"){
                private static final long serialVersionUID = -7802725629222988172L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerWrapperEditor.this.setFixMode(FixMode.DO_NOT_FIX);
                }
            });
            this.skipRadio.setToolTipText("No automated fix attempt, molecule will be unchanged.");
        }
        return this.skipRadio;
    }

    protected JRadioButton getFixRadio() {
        if (this.fixRadio == null) {
            this.fixRadio = new JRadioButton(new AbstractAction("Fix"){
                private static final long serialVersionUID = -12404417426607409L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerWrapperEditor.this.setFixMode(FixMode.FIX);
                }
            });
            this.fixRadio.setToolTipText("Automatically applies the selected fix if possible.");
        }
        return this.fixRadio;
    }

    protected JComboBox getFixersCombo() {
        if (this.fixersCombo == null) {
            this.fixersCombo = new JComboBox();
            this.fixersCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !StructureCheckerWrapperEditor.this.isInitializing()) {
                        Object obj = StructureCheckerWrapperEditor.this.getFixersCombo().getSelectedItem();
                        ((StructureCheckerWrapper)StructureCheckerWrapperEditor.this.getElement()).setFixerClassName(obj == null ? null : obj.getClass().getName());
                    }
                }
            });
            this.fixersCombo.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 72152552588013191L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof StructureFixer) {
                        label.setText(((StructureFixer)value).getName());
                    }
                    return label;
                }
            });
            this.fixersCombo.setEditable(false);
        }
        return this.fixersCombo;
    }

    protected void setFixMode(FixMode fixMode) {
        ((StructureCheckerWrapper)this.getElement()).setFixMode(fixMode);
        this.getFixersCombo().setEnabled(FixMode.FIX.equals((Object)fixMode));
    }

    @Override
    protected void initialize() {
        this.setInitializing(true);
        super.initialize();
        switch (((StructureCheckerWrapper)this.getElement()).getFixMode()) {
            case ASK: {
                this.getAskRadio().setSelected(true);
                break;
            }
            case FIX: {
                this.getFixRadio().setSelected(true);
                break;
            }
            case DO_NOT_FIX: {
                this.getSkipRadio().setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid fixmode occurred");
            }
        }
        if (((StructureCheckerWrapper)this.getElement()).getItem().getDescriptor().getCustomName() != null) {
            this.getTitle().setText(((StructureCheckerWrapper)this.getElement()).getItem().getDescriptor().getCustomName());
        } else {
            this.getTitle().setText(((StructureCheckerWrapper)this.getElement()).getItem().getDescriptor().getName());
        }
        this.updateFixers();
        this.getFixersCombo().setEnabled(FixMode.FIX.equals((Object)((StructureCheckerWrapper)this.getElement()).getFixMode()));
        int index = -1;
        for (int i = 0; i < this.getFixersCombo().getItemCount(); ++i) {
            if (!this.getFixersCombo().getItemAt(i).getClass().getName().equals(((StructureCheckerWrapper)this.getElement()).getFixerClassName())) continue;
            index = i;
        }
        if (index == -1 && this.getFixersCombo().getItemCount() > 0) {
            index = 0;
        }
        this.getFixersCombo().setSelectedIndex(index);
        Object obj = this.getFixersCombo().getSelectedItem();
        ((StructureCheckerWrapper)this.getElement()).setFixerClassName(obj == null ? null : obj.getClass().getName());
        if (this.editor != null) {
            this.mainPanel.remove(this.editor);
            this.editor = null;
        }
        this.getTitle().setFocusable(false);
        this.getTitle().setEditable(false);
        CheckerEditor checkerEditor = CheckerEditorInstanceProvider.getEditor(((StructureCheckerWrapper)this.getElement()).getItem());
        if (checkerEditor != null) {
            this.editor = checkerEditor.getEditorComponent(((StructureCheckerWrapper)this.getElement()).getItem());
            if (checkerEditor instanceof DefaultCheckerEditor) {
                this.editor = ((DefaultCheckerEditor)checkerEditor).getUndecoratedEditorComponent();
                this.getTitle().setFocusable(((DefaultCheckerEditor)checkerEditor).isRenamable());
                this.getTitle().setEditable(((DefaultCheckerEditor)checkerEditor).isRenamable());
            }
            this.getCheckerOptionsHolder().setVisible(true);
        }
        if (this.editor == null) {
            this.editor = new JPanel();
            this.getCheckerOptionsHolder().setVisible(false);
        }
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).setOpaque(false);
            ((JComponent)this.editor).setBorder(null);
        }
        this.getCheckerOptionsHolder().removeAll();
        this.getCheckerOptionsHolder().add(this.editor, "Center");
        this.mainPanel.validate();
        this.mainPanel.repaint();
        this.setInitializing(false);
    }

    private JPanel getCheckerOptionsHolder() {
        if (this.checkerOptionsHolder == null) {
            this.checkerOptionsHolder = new JPanel(new BorderLayout());
            this.checkerOptionsHolder.setBorder(BorderFactory.createTitledBorder("Checker Options"));
        }
        return this.checkerOptionsHolder;
    }

    @Override
    protected void addComponents() {
        CellConstraints cc = new CellConstraints();
        this.fixModeRadioButtonGroup = new ButtonGroup();
        this.fixModeRadioButtonGroup.add(this.getAskRadio());
        this.fixModeRadioButtonGroup.add(this.getFixRadio());
        this.fixModeRadioButtonGroup.add(this.getSkipRadio());
        this.mainPanel.add((Component)this.getTitle(), cc.xyw(2, 2, 3));
        this.mainPanel.add((Component)this.getCheckerOptionsHolder(), cc.xy(4, 4, CellConstraints.DEFAULT, CellConstraints.TOP));
        JPanel leftPanel = new JPanel((LayoutManager)new FormLayout("4dlu, pref, 2dlu, pref, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 4dlu"));
        leftPanel.setBorder(BorderFactory.createTitledBorder("Fixer Options"));
        leftPanel.add((Component)this.getAskRadio(), cc.xy(2, 2));
        leftPanel.add((Component)this.getSkipRadio(), cc.xy(2, 4));
        leftPanel.add((Component)this.getFixRadio(), cc.xy(2, 6));
        leftPanel.add((Component)this.getFixersCombo(), cc.xy(4, 6));
        this.mainPanel.add((Component)leftPanel, cc.xy(2, 4, CellConstraints.LEFT, CellConstraints.TOP));
    }

    @Override
    protected LayoutManager getMainLayout() {
        return new FormLayout("4dlu, fill:pref, 12dlu, fill:min:grow, 4dlu", "4dlu, min, 2dlu, pref, 4dlu");
    }

    protected JTextField getTitle() {
        if (this.title == null) {
            JLabel label = super.getTitle("");
            this.title = new JTextField();
            this.title.setForeground(label.getForeground());
            this.title.setFont(label.getFont().deriveFont(1));
            this.title.setBackground(label.getBackground());
            this.title.setBorder(label.getBorder());
            this.title.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    if (!StructureCheckerWrapperEditor.this.isInitializing() && StructureCheckerWrapperEditor.this.getElement() instanceof StructureCheckerWrapper) {
                        ((StructureCheckerWrapper)StructureCheckerWrapperEditor.this.getElement()).getItem().getDescriptor().setCustomName(StructureCheckerWrapperEditor.this.title.getText().trim());
                        ((StructureCheckerWrapper)StructureCheckerWrapperEditor.this.getElement()).getItem().getDescriptor().setName(StructureCheckerWrapperEditor.this.title.getText().trim());
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.title;
    }

    protected List<StructureFixer> getAvailableFixers() {
        return StructureCheckerWrapper.getAvailableFixers(((StructureCheckerWrapper)this.getElement()).getItem());
    }

    protected void updateFixers() {
        this.getFixersCombo().removeAllItems();
        List<StructureFixer> fixerList = this.getAvailableFixers();
        if (!fixerList.isEmpty()) {
            for (StructureFixer fixer : fixerList) {
                this.getFixersCombo().addItem(fixer);
            }
            this.getFixRadio().setEnabled(true);
            this.getFixersCombo().setVisible(true);
        } else {
            this.getFixRadio().setEnabled(false);
            this.getFixersCombo().setVisible(false);
        }
    }

    protected void setInitializing(boolean initializing) {
        this.initializing = initializing;
    }

    protected boolean isInitializing() {
        return this.initializing;
    }

    @Override
    public void setElement(ConfigElement element) {
        StructureChecker checker;
        if (this.getElement() instanceof StructureCheckerWrapper) {
            checker = ((StructureCheckerWrapper)this.getElement()).getItem();
            checker.removePropertyChangeListener(this.wrappedCheckerListener);
            checker.getDescriptor().removePropertyChangeListener(this.wrappedCheckerListener);
        }
        super.setElement(element);
        if (this.getElement() instanceof StructureCheckerWrapper) {
            checker = ((StructureCheckerWrapper)this.getElement()).getItem();
            checker.addPropertyChangeListener(this.wrappedCheckerListener);
            checker.getDescriptor().addPropertyChangeListener(this.wrappedCheckerListener);
        }
    }

    protected void handleElementChange(PropertyChangeEvent evt) {
        if (!this.isInitializing() && this.getElement() != null) {
            if ("VALID".equals(evt.getPropertyName())) {
                this.getElement().getPropertyChangeSupport().firePropertyChange("ConfigElement_Valid", evt.getOldValue(), evt.getNewValue());
            } else {
                this.getElement().getPropertyChangeSupport().firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }
    }
}

