/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.markushview;

import chemaxon.alchemist.markushview.MarkushViewerComponent;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class CompactMarkushViewer
extends JPanel {
    private MarkushViewerComponent markushViewer;
    private JToggleButton autoSizeFragmentsButton;
    private JToggleButton alwaysShowScaffoldButton;
    private JToggleButton nestingViewButton;
    private JToggleButton molsInTreeButton;
    private JToggleButton separatorLinesButton;
    private JToggleButton nodeLinesButton;
    private JButton collapseTreeButton;
    private JButton expandTreeButton;
    private JButton helpButton;
    private JPanel tools;
    private static final String MARKUSH_VIEWER_AUTOSIZE_FRAGMENTS = "/chemaxon/alchemist/images/toolbar/autoresizefragments.gif";
    private static final String MARKUSH_VIEWER_AUTOSHOW_SCAFFOLD = "/chemaxon/alchemist/images/toolbar/alwaysshowscaffold.gif";
    private static final String MARKUSH_VIEWER_SHOW_NESTING_VIEW = "/chemaxon/alchemist/images/toolbar/linear_24.png";
    private static final String MARKUSH_VIEWER_SHOW_MOLECULES_IN_TREE = "/chemaxon/alchemist/images/toolbar/nodepic_24.png";
    private static final String MARKUSH_VIEWER_SHOW_SEPARATOR_LINES = "/chemaxon/alchemist/images/toolbar/showseparatorlines.png";
    private static final String MARKUSH_VIEWER_SHOW_NODE_LINES = "/chemaxon/alchemist/images/toolbar/shownodelines.png";
    private static final String MARKUSH_VIEWER_COLLAPSE_TREE = "/chemaxon/alchemist/images/toolbar/collapseall.png";
    private static final String MARKUSH_VIEWER_EXPAND_TREE = "/chemaxon/alchemist/images/toolbar/expandall.png";
    private static final String MARKUSH_VIEWER_HELP = "/chemaxon/alchemist/images/help24.png";

    public CompactMarkushViewer() {
        this.createToolBar();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMarkushViewer(), "Center");
        this.add((Component)this.getTools(), "North");
    }

    private void createToolBar() {
        this.autoSizeFragmentsButton = new JToggleButton(AlchemistIconFactory.getIcon(MARKUSH_VIEWER_AUTOSIZE_FRAGMENTS), this.getMarkushViewer().isAutosizeFragments());
        this.alwaysShowScaffoldButton = new JToggleButton(AlchemistIconFactory.getIcon(MARKUSH_VIEWER_AUTOSHOW_SCAFFOLD), this.getMarkushViewer().isAlwaysShowScaffold());
        this.nestingViewButton = new JToggleButton(AlchemistIconFactory.getIcon(MARKUSH_VIEWER_SHOW_NESTING_VIEW), this.getMarkushViewer().isNestingViewVisible());
        this.molsInTreeButton = new JToggleButton(AlchemistIconFactory.getIcon(MARKUSH_VIEWER_SHOW_MOLECULES_IN_TREE), this.getMarkushViewer().isNodeMoleculeVisible());
        this.separatorLinesButton = new JToggleButton(AlchemistIconFactory.getIcon(MARKUSH_VIEWER_SHOW_SEPARATOR_LINES), this.getMarkushViewer().isStepLineVisible());
        this.nodeLinesButton = new JToggleButton(AlchemistIconFactory.getIcon(MARKUSH_VIEWER_SHOW_NODE_LINES), this.getMarkushViewer().isNodeLineVisible());
        this.collapseTreeButton = new JButton(AlchemistIconFactory.getIcon(MARKUSH_VIEWER_COLLAPSE_TREE));
        this.expandTreeButton = new JButton(AlchemistIconFactory.getIcon(MARKUSH_VIEWER_EXPAND_TREE));
        this.helpButton = new JButton(AlchemistIconFactory.getIcon(MARKUSH_VIEWER_HELP));
        this.addActions();
        this.setSizes();
        this.setToolTips();
        this.addButtons();
    }

    private void setSizes() {
        this.setButtonSize(this.autoSizeFragmentsButton);
        this.setButtonSize(this.alwaysShowScaffoldButton);
        this.setButtonSize(this.nestingViewButton);
        this.setButtonSize(this.molsInTreeButton);
        this.setButtonSize(this.separatorLinesButton);
        this.setButtonSize(this.nodeLinesButton);
        this.setButtonSize(this.collapseTreeButton);
        this.setButtonSize(this.expandTreeButton);
        this.setButtonSize(this.helpButton);
    }

    private void addActions() {
        this.autoSizeFragmentsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompactMarkushViewer.this.getMarkushViewer().setAutosizeFragments(!CompactMarkushViewer.this.getMarkushViewer().isAutosizeFragments());
            }
        });
        this.alwaysShowScaffoldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompactMarkushViewer.this.getMarkushViewer().setAlwaysShowScaffold(!CompactMarkushViewer.this.getMarkushViewer().isAlwaysShowScaffold());
            }
        });
        this.nestingViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompactMarkushViewer.this.getMarkushViewer().setNestingViewVisible(!CompactMarkushViewer.this.getMarkushViewer().isNestingViewVisible());
            }
        });
        this.molsInTreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompactMarkushViewer.this.getMarkushViewer().setNodeMoleculeVisible(!CompactMarkushViewer.this.getMarkushViewer().isNodeMoleculeVisible());
            }
        });
        this.separatorLinesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompactMarkushViewer.this.getMarkushViewer().setStepLineVisible(!CompactMarkushViewer.this.getMarkushViewer().isStepLineVisible());
            }
        });
        this.nodeLinesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompactMarkushViewer.this.getMarkushViewer().setNodeLineVisible(!CompactMarkushViewer.this.getMarkushViewer().isNodeLineVisible());
            }
        });
        this.collapseTreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompactMarkushViewer.this.getMarkushViewer().collapseTree();
            }
        });
        this.expandTreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompactMarkushViewer.this.getMarkushViewer().expandTree();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompactMarkushViewer.this.getMarkushViewer().showHelp();
            }
        });
    }

    public MarkushViewerComponent getMarkushViewer() {
        if (this.markushViewer == null) {
            this.markushViewer = new MarkushViewerComponent();
        }
        return this.markushViewer;
    }

    private void setButtonSize(JComponent comp) {
        comp.setMinimumSize(new Dimension(32, 32));
        comp.setMaximumSize(comp.getMinimumSize());
        comp.setPreferredSize(comp.getMinimumSize());
        comp.setSize(comp.getMinimumSize());
    }

    private JPanel getTools() {
        if (this.tools == null) {
            this.tools = new JPanel();
            this.tools.setLayout(new BoxLayout(this.tools, 0));
        }
        return this.tools;
    }

    public void setMolecule(List<Molecule> moleculeList) {
        this.getMarkushViewer().setMolecules(moleculeList);
    }

    public void setMolecule(Molecule molecule) {
        this.getMarkushViewer().setMolecule(molecule);
    }

    private void setToolTips() {
        this.autoSizeFragmentsButton.setToolTipText("Auto size Fragments.");
        this.alwaysShowScaffoldButton.setToolTipText("Always display Scaffold in Fragments.");
        this.nestingViewButton.setToolTipText("Show nesting view.");
        this.molsInTreeButton.setToolTipText("Display Molecules in tree.");
        this.separatorLinesButton.setToolTipText("Show separator lines");
        this.nodeLinesButton.setToolTipText("Show node lines");
        this.collapseTreeButton.setToolTipText("Collapse molecule tree.");
        this.expandTreeButton.setToolTipText("Expand all calculated nodes.");
        this.helpButton.setToolTipText("Show help.");
    }

    private void addButtons() {
        this.getTools().add(this.autoSizeFragmentsButton);
        this.getTools().add(this.alwaysShowScaffoldButton);
        this.getTools().add(this.nestingViewButton);
        this.getTools().add(this.molsInTreeButton);
        this.getTools().add(this.separatorLinesButton);
        this.getTools().add(this.nodeLinesButton);
        this.getTools().add(this.collapseTreeButton);
        this.getTools().add(this.expandTreeButton);
        this.getTools().add(this.helpButton);
    }
}

