/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.markushview;

import chemaxon.alchemist.markushview.MarkushViewerComponent;
import chemaxon.alchemist.markushview.MoleculeTitleUtils;
import chemaxon.alchemist.utils.AlchemistLinearMoleculeView;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public final class MarkushLinearViewFactory {
    public static JPanel createMarkushLinearView(Integer moleculeID, RgMolecule molecule, List<Integer> rGroupNumbers, int dispOpts, int dispOptsExt, Color[] colors) {
        JPanel panel = MarkushLinearViewFactory.createEmptyMarkushLinearPanel(moleculeID, molecule);
        ArrayList<String> arrowTexts = new ArrayList<String>();
        ArrayList<Molecule> molecules = new ArrayList<Molecule>();
        Molecule scaffold = new Molecule();
        scaffold.fuse(molecule.getRoot().getGraphUnion());
        if (colors != null) {
            MarkushViewerComponent.createDocumentFor(scaffold, colors);
        }
        scaffold.setGUIContracted(true);
        molecules.add(scaffold.cloneMoleculeWithDocument());
        if (!rGroupNumbers.isEmpty()) {
            arrowTexts.add("R" + rGroupNumbers.get(0));
            if (rGroupNumbers.size() > 1) {
                for (int i = 0; i < rGroupNumbers.size() - 1; ++i) {
                    arrowTexts.add("R" + rGroupNumbers.get(i + 1));
                    molecules.add(MarkushLinearViewFactory.createMoleculeFromRGroup(molecule, rGroupNumbers.get(i), rGroupNumbers.get(i + 1), colors));
                }
            }
            molecules.add(MarkushLinearViewFactory.createMoleculeFromRGroup(molecule, rGroupNumbers.get(rGroupNumbers.size() - 1), null, colors));
        }
        panel.add(MarkushLinearViewFactory.createLinearView(molecules, arrowTexts.toArray(new String[arrowTexts.size()]), dispOpts, dispOptsExt));
        return panel;
    }

    private static Molecule createMoleculeFromRGroup(RgMolecule molecule, int rGroupSearchAreaID, Integer targetID, Color[] colors) {
        Molecule tmpMol = new Molecule();
        int index = molecule.findRgroupIndex(rGroupSearchAreaID);
        for (int i = 0; i < molecule.getRgroupMemberCount(index); ++i) {
            MoleculeGraph graph = molecule.getRgroupMemberG(index, i).getGraphUnion();
            if (targetID != null) {
                for (MolAtom atom : graph.getAtomArray()) {
                    if (atom.getAtno() != 134 || atom.getRgroup() != targetID.intValue()) continue;
                    tmpMol.fuse(graph);
                }
                continue;
            }
            tmpMol.fuse(graph);
        }
        Molecule mol = tmpMol.cloneMolecule();
        if (colors != null) {
            MarkushViewerComponent.createDocumentFor(mol, colors);
        }
        CleanUtil.arrangeComponents(mol, true, true);
        mol.setGUIContracted(true);
        return mol;
    }

    private static JPanel createEmptyMarkushLinearPanel(Integer moleculeID, Molecule molecule) {
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        if (moleculeID != null) {
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), MoleculeTitleUtils.createSimpleMarkushTitle(molecule.getName(), moleculeID + 1, -2) + " nesting view"));
        }
        panel.setLayout(new GridLayout(1, 1));
        return panel;
    }

    private static AlchemistLinearMoleculeView createLinearView(List<Molecule> molecules, String[] arrowTexts, int dispOpts, int dispOptsExt) {
        final AlchemistLinearMoleculeView linear = new AlchemistLinearMoleculeView(1);
        linear.setShowArrows(true);
        linear.setMoleculeList(molecules, Collections.<String, String>emptyMap(), arrowTexts);
        linear.setBackground(Color.WHITE);
        linear.setDispOpts(dispOpts);
        linear.setDispOptsExt(dispOptsExt);
        linear.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                linear.redoLayout();
                linear.repaint();
            }
        });
        return linear;
    }
}

