/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.markushview;

import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MarkushNestingViewPanel
extends JPanel {
    private List<JPanel> linears;
    private List<AlchemistTreeNode> nodes;
    private JPanel linearPanel = new JPanel(new GridLayout(1, 1));
    private JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
    private JButton previousButton = new JButton("Previous");
    private JButton nextButton;
    private int currentLinearIndex = 0;
    public static final String PROPERTY_KEY_NODES_UPDATED = "nodesUpdated";

    public MarkushNestingViewPanel() {
        super(new BorderLayout());
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkushNestingViewPanel.this.changeCurrentIndex(false);
                if (MarkushNestingViewPanel.this.currentLinearIndex == 0) {
                    MarkushNestingViewPanel.this.previousButton.setEnabled(false);
                }
                if (MarkushNestingViewPanel.this.currentLinearIndex == MarkushNestingViewPanel.this.linears.size() - 2) {
                    MarkushNestingViewPanel.this.nextButton.setEnabled(true);
                }
                MarkushNestingViewPanel.this.linearPanel.removeAll();
                MarkushNestingViewPanel.this.linearPanel.add((Component)MarkushNestingViewPanel.this.linears.get(MarkushNestingViewPanel.this.currentLinearIndex));
                MarkushNestingViewPanel.this.linearPanel.validate();
                MarkushNestingViewPanel.this.linearPanel.repaint();
                MarkushNestingViewPanel.this.fireChanged();
            }
        });
        this.previousButton.setEnabled(false);
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkushNestingViewPanel.this.changeCurrentIndex(true);
                if (MarkushNestingViewPanel.this.currentLinearIndex == MarkushNestingViewPanel.this.linears.size() - 1) {
                    MarkushNestingViewPanel.this.nextButton.setEnabled(false);
                }
                if (MarkushNestingViewPanel.this.currentLinearIndex == 1) {
                    MarkushNestingViewPanel.this.previousButton.setEnabled(true);
                }
                MarkushNestingViewPanel.this.linearPanel.removeAll();
                MarkushNestingViewPanel.this.linearPanel.add((Component)MarkushNestingViewPanel.this.linears.get(MarkushNestingViewPanel.this.currentLinearIndex));
                MarkushNestingViewPanel.this.linearPanel.repaint();
                MarkushNestingViewPanel.this.linearPanel.validate();
                MarkushNestingViewPanel.this.fireChanged();
            }
        });
        this.nextButton.setEnabled(false);
        this.buttonPanel.setMinimumSize(new Dimension(500, 1));
        this.linearPanel.setMinimumSize(new Dimension(1, 1));
        this.buttonPanel.add(this.previousButton);
        this.buttonPanel.add(this.nextButton);
        this.add((Component)this.linearPanel, "Center");
        this.add((Component)this.buttonPanel, "East");
    }

    private void changeCurrentIndex(boolean increase) {
        int change = increase ? 1 : -1;
        this.changeNodeTag(this.currentLinearIndex);
        this.currentLinearIndex += change;
        this.changeNodeTag(this.currentLinearIndex);
    }

    private void fireChanged() {
        this.firePropertyChange(PROPERTY_KEY_NODES_UPDATED, false, true);
    }

    private void changeNodeTag(int index) {
        AlchemistTreeNode node;
        if (this.getNodes() != null && this.getNodes().size() > index && (node = this.getNodes().get(index)) != null) {
            node.setTagged(!node.isTagged());
        }
    }

    public void setContent(List<JPanel> linears, List<AlchemistTreeNode> nodes) {
        this.resetLinears(null);
        if (linears != null && !linears.isEmpty()) {
            if (linears.size() > 1) {
                this.previousButton.setEnabled(this.currentLinearIndex != 0);
                this.nextButton.setEnabled(this.currentLinearIndex != linears.size() - 1);
            }
            this.linearPanel.removeAll();
            this.linearPanel.add(linears.get(0));
        }
        this.linears = linears;
        this.nodes = nodes;
        if (nodes != null && !nodes.isEmpty()) {
            this.changeNodeTag(this.currentLinearIndex);
        }
        this.linearPanel.repaint();
        this.linearPanel.validate();
    }

    public void resetLinears(JLabel label) {
        this.linearPanel.removeAll();
        if (label != null) {
            this.linearPanel.add(label);
        }
        this.currentLinearIndex = 0;
        this.previousButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.linearPanel.repaint();
        this.linearPanel.validate();
    }

    public List<AlchemistTreeNode> getNodes() {
        return this.nodes;
    }
}

