/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.markushview;

import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.markushview.MarkushViewerComponent;
import chemaxon.alchemist.utils.AboutDialogFactory;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public final class MarkushViewAlchemist
extends MarvinBasedAlchemistApplication
implements AlchemistLaunchable {
    private MarkushViewerComponent markushViewerComponent = null;

    public MarkushViewAlchemist() {
        super("Markush Viewer - " + VersionInfo.JCHEM_VERSION, AlchemistIconFactory.getImage("/chemaxon/alchemist/images/markushviewer48.png"));
        this.init();
    }

    public boolean isShowPath() {
        return this.getMarkushViewerComponent().isNestingViewVisible();
    }

    public void setShowPath(boolean newValue) {
        this.getMarkushViewerComponent().setNestingViewVisible(newValue);
    }

    private void init() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MarkushViewAlchemist.this.setDocumentPathInFrameTitle(true);
                MarkushViewAlchemist.this.setMenuResources("chemaxon/alchemist/markushview/resources/menu.xml");
                MarkushViewAlchemist.this.getContentPane().setLayout(new BorderLayout());
                MarkushViewAlchemist.this.getContentPane().add(MarkushViewAlchemist.this.getMarkushViewerComponent());
                MarkushViewAlchemist.this.getApplicationFrame().setMinimumSize(new Dimension(250, 250));
            }
        });
    }

    private MarkushViewerComponent getMarkushViewerComponent() {
        if (this.markushViewerComponent == null) {
            this.markushViewerComponent = new MarkushViewerComponent();
            this.markushViewerComponent.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MarkushViewAlchemist.this.notifier.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            });
        }
        return this.markushViewerComponent;
    }

    private static MarkushViewAlchemist createAndShowGUI() {
        MarkushViewAlchemist.setLookAndFeel();
        MarkushViewAlchemist app = new MarkushViewAlchemist();
        app.show();
        return app;
    }

    public void setMolecules(List<Molecule> moleculeList) {
        this.disableContent(true);
        this.getMarkushViewerComponent().setMolecules(moleculeList);
        this.enableContent();
    }

    @Override
    protected void helpActionHandler() {
        this.getMarkushViewerComponent().showHelp();
    }

    @Override
    protected void aboutActionHandler() {
        AboutDialogFactory.createAboutDialog("Markush Viewer", "/chemaxon/alchemist/images/about/markushviewer-64.png", VersionInfo.JCHEM_VERSION).setVisible(true);
    }

    @Override
    protected void openDocumentActionHandler(final String path) {
        super.openDocumentActionHandler(path);
        Thread fileOpenThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MarkushViewAlchemist.this.disableContent(true);
                ArrayList<Molecule> moleculeList = new ArrayList<Molecule>();
                MolImporter importer = null;
                try {
                    importer = new MolImporter(path);
                    Molecule molecule = importer.read();
                    while (molecule != null) {
                        moleculeList.add(molecule);
                        molecule = importer.read();
                    }
                    MarkushViewAlchemist.this.setMolecules(moleculeList);
                }
                catch (IOException e) {
                    MarkushViewAlchemist.this.setMolecules(new ArrayList<Molecule>());
                    AlchemistErrorDialog.showError(MarkushViewAlchemist.this.getApplicationFrame(), "File import failed.", (Exception)e);
                }
                finally {
                    MarkushViewAlchemist.this.enableContent();
                    if (importer != null) {
                        try {
                            importer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        fileOpenThread.setPriority(4);
        fileOpenThread.start();
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MarkushViewAlchemist app = MarkushViewAlchemist.createAndShowGUI();
                if (args.length > 0) {
                    app.openDocumentActionHandler(args[0]);
                }
            }
        });
    }

    public void toggleNestingView() {
        this.getMarkushViewerComponent().setNestingViewVisible(!this.getMarkushViewerComponent().isNestingViewVisible());
    }

    @Override
    public void launch() {
        MarkushViewAlchemist.main(new String[0]);
    }

    public boolean isNodeLineVisible() {
        return this.getMarkushViewerComponent().isNodeLineVisible();
    }

    public boolean isStepLineVisible() {
        return this.getMarkushViewerComponent().isStepLineVisible();
    }

    public boolean isAlwaysShowScaffold() {
        return this.getMarkushViewerComponent().isAlwaysShowScaffold();
    }

    public boolean isAutosizeFragments() {
        return this.getMarkushViewerComponent().isAutosizeFragments();
    }

    public void toggleAlwaysShowScaffold() {
        this.getMarkushViewerComponent().setAlwaysShowScaffold(!this.getMarkushViewerComponent().isAlwaysShowScaffold());
    }

    public void toggleAutoSizeFragments() {
        this.getMarkushViewerComponent().setAutosizeFragments(!this.getMarkushViewerComponent().isAutosizeFragments());
    }

    public void toggleStepLinesVisible() {
        this.getMarkushViewerComponent().setStepLineVisible(!this.getMarkushViewerComponent().isStepLineVisible());
    }

    public void toggleMoleculesInTreeVisible() {
        this.getMarkushViewerComponent().setNodeMoleculeVisible(!this.getMarkushViewerComponent().isNodeMoleculeVisible());
    }

    public boolean isMoleculesInTreeVisible() {
        return this.getMarkushViewerComponent().isNodeMoleculeVisible();
    }

    public void toggleNodeLinesVisible() {
        this.getMarkushViewerComponent().setNodeLineVisible(!this.getMarkushViewerComponent().isNodeLineVisible());
    }

    public void collapseTree() {
        this.getMarkushViewerComponent().collapseTree();
    }

    public void expandTree() {
        this.getMarkushViewerComponent().expandTree();
    }

    public boolean isAtomPropertiesVisible() {
        return this.getMarkushViewerComponent().isAtomPropertiesVisible();
    }

    public boolean isLonePairsVisible() {
        return this.getMarkushViewerComponent().isLonePairsVisible();
    }

    public boolean isValanceErrorVisible() {
        return this.getMarkushViewerComponent().isValanceErrorVisible();
    }

    public void toggleAtomPropertiesVisible() {
        this.getMarkushViewerComponent().toggleAtomPropertiesVisible();
    }

    public void toggleLonePairsVisible() {
        this.getMarkushViewerComponent().toggleLonePairsVisible();
    }

    public void toggleValanceErrorVisible() {
        this.getMarkushViewerComponent().toggleValanceErrorVisible();
    }

    public void toggleEZLabelsVisible() {
        this.getMarkushViewerComponent().toggleEZLabelsVisible();
    }

    public boolean isEZLabelsVisible() {
        return this.getMarkushViewerComponent().isEZLabelsVisible();
    }

    public void toggleRSLabelsVisible() {
        this.getMarkushViewerComponent().toggleRSLabelsVisible();
    }

    public boolean isRSLabelsVisible() {
        return this.getMarkushViewerComponent().isRSLabelsVisible();
    }

    public void setImpliciHVisible(MarkushViewerComponent.ImplicitHVisibilityType type) {
        this.getMarkushViewerComponent().setImpliciHVisible(type);
    }

    public boolean isImplicitHVisibilityEquals(MarkushViewerComponent.ImplicitHVisibilityType type) {
        return this.getMarkushViewerComponent().isImplicitHVisibilityEquals(type);
    }
}

