/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.markushview;

public final class MoleculeTitleUtils {
    public static final int NO_RGROUP_NUMBER_NEEDED = -2;
    public static final String MARKUSH = "Markush";
    public static final String MOLECULE = "Molecule";

    public static String createMoleculeTitle(String prefix, String suffix, String moleculeName, int moleculeNumber, boolean addPrefixToMolName, boolean addSuffixToMolName) {
        return MoleculeTitleUtils.createMarkushTitle(prefix, null, suffix, moleculeName, moleculeNumber, addPrefixToMolName, false, addSuffixToMolName, -2);
    }

    public static String createSimpleMoleculeTitle(String moleculeName, int moleculeNumber) {
        return MoleculeTitleUtils.createMoleculeTitle(MOLECULE, null, moleculeName, moleculeNumber, false, false);
    }

    public static String createSimpleMarkushTitle(String moleculeName, int moleculeNumber, int rGroupNumber) {
        return MoleculeTitleUtils.createMarkushTitle(MARKUSH, null, null, moleculeName, moleculeNumber, false, false, false, rGroupNumber);
    }

    public static String createMarkushTitle(String prefix, String infix, String suffix, String moleculeName, int moleculeNumber, boolean addPrefixToMolName, boolean addInfixToMolName, boolean addSuffixToMolName, int rGroupNumber) {
        String tempPrefix = prefix == null ? "" : prefix;
        String tempInfix = infix == null ? "" : infix;
        String tempSuffix = suffix == null ? "" : suffix;
        String tempMoleculeName = moleculeName == null ? "" : moleculeName;
        String rGroupText = "";
        if (rGroupNumber != -2) {
            rGroupText = ", " + (rGroupNumber > -1 ? "R" + rGroupNumber : "Scaffold");
        }
        return tempMoleculeName.isEmpty() ? tempPrefix + "(" + moleculeNumber + ")" + tempInfix + rGroupText + tempSuffix : (addPrefixToMolName ? tempPrefix : "") + tempMoleculeName + (addInfixToMolName ? tempInfix : "") + rGroupText + (addSuffixToMolName ? tempSuffix : "");
    }
}

