/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.markushview;

import chemaxon.alchemist.markushview.MarkushViewerComponent;
import chemaxon.alchemist.markushview.MoleculeTitleUtils;
import chemaxon.alchemist.markushview.RGroupFragmentView;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.swing.moleculeview.MoleculeViewComponent;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class RGroupViewPane
extends JScrollPane {
    private JPanel mainPanel;
    private List<RGroupFragmentView> rViews = new ArrayList<RGroupFragmentView>();
    private List<Integer> autoScaffoldIndexes = new ArrayList<Integer>();
    private MolPainterCommon common;
    private static final Dimension DEFAULT_MINIMUM_SIZE = new Dimension(100, 100);
    public static final int NOT_AN_RGROUP = -1;
    private static final Dimension DEFAULT_PREFERRED_SIZE = new Dimension(200, 200);
    private static final int SMALL_PANEL_HEIGHT = 120;
    private static final int MEDIUM_PANEL_HEIGHT = 180;
    private static final int LARGE_PANEL_HEIGHT = 240;
    private static final int DEFAULT_DEFINITIONS_COLUMN_NUMBER = 4;
    private static final double MEDIUM_MOLECULE_BOND_HEIGHT_SUP = 3.5;
    private static final double SMALL_MOLECULE_BOND_HEIGHT_SUP = 1.5;
    private static final int SCAFFOLD_BORDER_THICKNESS = 2;
    private Component resizedView;
    private Point previousPoint;
    private Point currentPoint;
    private Color defaultBackGroundColor;
    private static final int DRAG_MARGIN = 10;
    private MouseListener resizeMouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            RGroupViewPane.this.setPreviousPoint(null);
            RGroupViewPane.this.setCurrentPoint(null);
            RGroupViewPane.this.repaint();
            RGroupViewPane.this.validate();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (RGroupViewPane.shiftOrCtrlDown(e)) {
                return;
            }
            Component pointedComponent = e.getComponent().getComponentAt(e.getPoint());
            if (pointedComponent != null) {
                Rectangle inner = new Rectangle();
                if (pointedComponent.getHeight() > 10) {
                    inner.setLocation(pointedComponent.getX(), pointedComponent.getY());
                    inner.setSize(pointedComponent.getWidth(), pointedComponent.getHeight() - 10);
                }
                if (pointedComponent.getBounds().contains(e.getPoint()) && !inner.contains(e.getPoint())) {
                    RGroupViewPane.this.setResizedView(pointedComponent);
                    RGroupViewPane.this.setPreviousPoint(e.getPoint());
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getButton() != 1) {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
            }
            RGroupViewPane.this.setCurrentPoint(null);
        }
    };
    private MouseMotionListener resizeMouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getButton() == 1) {
                return;
            }
            Component pointedComponent = e.getComponent().getComponentAt(e.getPoint());
            if (pointedComponent != null) {
                Rectangle inner = new Rectangle();
                if (pointedComponent.getHeight() > 10) {
                    inner.setLocation(pointedComponent.getX(), pointedComponent.getY());
                    inner.setSize(pointedComponent.getWidth(), pointedComponent.getHeight() - 10);
                }
                e.getComponent().setCursor(pointedComponent.getBounds().contains(e.getPoint()) && !inner.contains(e.getPoint()) ? new Cursor(8) : Cursor.getDefaultCursor());
                RGroupViewPane.this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (RGroupViewPane.shiftOrCtrlDown(e) || RGroupViewPane.this.getPreviousPoint() == null || RGroupViewPane.this.getResizedView() == null) {
                return;
            }
            RGroupViewPane.this.setCurrentPoint(e.getPoint());
            int heightChange = e.getY() - RGroupViewPane.this.getPreviousPoint().y;
            RGroupViewPane.this.getResizedView().setPreferredSize(new Dimension((int)RGroupViewPane.this.getResizedView().getPreferredSize().getWidth(), (int)RGroupViewPane.this.getResizedView().getPreferredSize().getHeight() + heightChange > 50 ? (int)RGroupViewPane.this.getResizedView().getPreferredSize().getHeight() + heightChange : 50));
            RGroupViewPane.this.getResizedView().setMaximumSize(new Dimension((int)RGroupViewPane.this.getResizedView().getMaximumSize().getWidth(), (int)RGroupViewPane.this.getResizedView().getMaximumSize().getHeight() + heightChange > 50 ? (int)RGroupViewPane.this.getResizedView().getMaximumSize().getHeight() + heightChange : 50));
            RGroupViewPane.this.setPreviousPoint(RGroupViewPane.this.getCurrentPoint());
            RGroupViewPane.this.mainPanel.repaint();
            RGroupViewPane.this.getResizedView().invalidate();
            RGroupViewPane.this.getResizedView().repaint();
        }
    };

    public RGroupViewPane(MolPainterCommon common) {
        super(20, 31);
        this.resetContent(null);
        this.getVerticalScrollBar().setUnitIncrement(30);
        this.common = common;
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public List<RGroupFragmentView> getRViews() {
        return this.rViews;
    }

    public void setRViews(List<RGroupFragmentView> views) {
        this.rViews = views;
    }

    public List<Integer> getAutoScaffoldIndexes() {
        return this.autoScaffoldIndexes;
    }

    public void setAutoScaffoldIndexes(List<Integer> autoScaffoldIndexes) {
        this.autoScaffoldIndexes = autoScaffoldIndexes;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void addFragmentView(int moleculeID, int rGroupID, RgMolecule molecule, boolean autoSize, boolean autoScaffold, boolean show, Color[] colors, Integer colorIndex) {
        Color color = null;
        if (colors != null && colorIndex != null) {
            color = colors[colorIndex];
        }
        RGroupFragmentView rView = this.createRView(moleculeID, rGroupID, molecule, color);
        int rIndex = molecule.findRgroupIndex(rGroupID);
        int top = rGroupID == -1 ? 1 : molecule.getRgroupMemberCount(rIndex);
        int rows = rGroupID == -1 ? 1 : (int)Math.ceil((double)molecule.getRgroupMemberCount(rIndex) / 4.0);
        JPanel grayBackGroundPanel = this.createGrayBackgroundPanel(rows);
        rView.getPanel().add(grayBackGroundPanel);
        double maxHeight = this.addComponents(rGroupID, molecule, rView, rIndex, top, grayBackGroundPanel, colors);
        this.setRViewSize(rGroupID, autoSize, autoScaffold, rView, rows, maxHeight /= 1.54);
        this.getMainPanel().add(rView.getPanel());
        this.getMainPanel().validate();
        if (autoScaffold) {
            this.autoScaffoldIndexes.add(this.rViews.size());
        }
        this.rViews.add(rView);
        rView.getPanel().setVisible(show);
    }

    private RGroupFragmentView createRView(int moleculeID, int rGroupID, RgMolecule molecule, Color color) {
        RGroupFragmentView rView = new RGroupFragmentView();
        rView.getPanel().setBorder(new TitledBorder(new LineBorder(rGroupID == -1 ? Color.BLACK : Color.LIGHT_GRAY, 2, false), MoleculeTitleUtils.createSimpleMarkushTitle(molecule.getName(), moleculeID + 1, rGroupID), 0, 0, null, color != null ? color : (rGroupID == -1 ? Color.BLACK : Color.GRAY)));
        rView.getPanel().setOpaque(true);
        rView.getPanel().setBackground(Color.WHITE);
        rView.getPanel().setLayout(new GridLayout(1, 1));
        return rView;
    }

    private void setRViewSize(int rGroupID, boolean autoSize, boolean autoScaffold, RGroupFragmentView rView, int rows, double maxHeight) {
        rView.setPreferredHeight(rows * (rGroupID == -1 || maxHeight >= 3.5 ? 240 : (maxHeight >= 1.5 ? 180 : 120)));
        rView.setDefaultHeight(rows * 180);
        rView.setAutoScaffold(autoScaffold);
        rView.getPanel().setPreferredSize(new Dimension(0, autoSize ? rView.getPreferredHeight() : rows * 180));
        rView.getPanel().setMaximumSize(new Dimension(Integer.MAX_VALUE, autoSize ? rView.getPreferredHeight() : rows * 180));
    }

    private JPanel createGrayBackgroundPanel(int rows) {
        JPanel grayBackGroundPanel = new JPanel();
        grayBackGroundPanel.setOpaque(true);
        grayBackGroundPanel.setBackground(new Color(230, 230, 230, 255));
        grayBackGroundPanel.setLayout(new GridLayout(rows, 4, 1, 1));
        return grayBackGroundPanel;
    }

    private double addComponents(int rGroupID, RgMolecule molecule, RGroupFragmentView rView, int rIndex, int top, JPanel grayBackGroundPanel, Color[] colors) {
        double maxHeight = 0.0;
        for (int i = 0; i < top; ++i) {
            Molecule graphMol = new Molecule();
            graphMol.fuse(rIndex == -1 ? molecule.getRoot().getGraphUnion() : molecule.getRgroupMemberG(rIndex, i));
            Molecule currentMolecule = graphMol.cloneMolecule();
            double moleculeHeight = currentMolecule.calcHeight();
            MoleculeViewComponent comp = RGroupViewPane.createComponent(this.common, rGroupID, currentMolecule, colors);
            grayBackGroundPanel.add(comp);
            rView.getFragments().add(comp);
            if (!(moleculeHeight > maxHeight)) continue;
            maxHeight = moleculeHeight;
        }
        return maxHeight;
    }

    public void resetContent(JLabel label) {
        if (this.getMainPanel() != null) {
            this.remove(this.getMainPanel());
            this.rViews.clear();
            this.autoScaffoldIndexes.clear();
            this.validate();
        }
        this.mainPanel = new JPanel(){

            @Override
            public void paintChildren(Graphics g) {
                super.paintChildren(g);
                if (RGroupViewPane.this.currentPoint != null) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.drawLine(0, ((RGroupViewPane)RGroupViewPane.this).currentPoint.y, RGroupViewPane.this.mainPanel.getWidth(), ((RGroupViewPane)RGroupViewPane.this).currentPoint.y);
                    g2.dispose();
                }
            }
        };
        this.defaultBackGroundColor = this.mainPanel.getBackground();
        this.setViewportView(this.getMainPanel());
        if (label != null) {
            this.getMainPanel().removeMouseMotionListener(this.resizeMouseMotionListener);
            this.getMainPanel().removeMouseListener(this.resizeMouseListener);
            this.getMainPanel().setLayout(new GridLayout(1, 1));
            this.getMainPanel().add(label);
            this.repaint();
            this.validate();
        } else {
            this.getMainPanel().addMouseListener(this.resizeMouseListener);
            this.getMainPanel().addMouseMotionListener(this.resizeMouseMotionListener);
            this.getMainPanel().setLayout(new BoxLayout(this.getMainPanel(), 1));
            this.getMainPanel().setOpaque(true);
            this.getMainPanel().setBackground(Color.WHITE);
        }
    }

    private static MoleculeViewComponent createComponent(MolPainterCommon molPainterCommon, int rGroupID, Molecule molecule, Color[] colors) {
        MoleculeViewComponent comp = new MoleculeViewComponent(molPainterCommon);
        if (colors != null) {
            MarkushViewerComponent.createDocumentFor(molecule, colors).setMainMoleculeGraph(molecule);
        }
        comp.setMinimumSize(DEFAULT_MINIMUM_SIZE);
        comp.setPreferredSize(DEFAULT_PREFERRED_SIZE);
        comp.setTranslateEnabled(true);
        comp.setZoomEnabled(true);
        comp.setFitOnResize(true);
        comp.setResizeOnDoubleClick(true);
        comp.setMolecule(molecule);
        return comp;
    }

    public void setMolPainterCommon(MolPainterCommon common) {
        this.common = common;
    }

    public void addScaffold(int molID, RgMolecule rgMolecule, boolean autosize, boolean show, Color[] colors, Integer colorIndex) {
        this.addFragmentView(molID, -1, rgMolecule, autosize, true, show, colors, colorIndex);
    }

    public void addDefinitions(int molID, int rGroupID, RgMolecule rgMolecule, boolean autosize, Color[] colors, Integer colorIndex) {
        this.addFragmentView(molID, rGroupID, rgMolecule, autosize, false, true, colors, colorIndex);
    }

    private static final boolean shiftOrCtrlDown(MouseEvent e) {
        return (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() || e.isShiftDown();
    }

    public Component getResizedView() {
        return this.resizedView;
    }

    public void setResizedView(Component resizedView) {
        this.resizedView = resizedView;
    }

    public Point getPreviousPoint() {
        return this.previousPoint;
    }

    public void setPreviousPoint(Point previousPoint) {
        this.previousPoint = previousPoint;
    }

    private Point getCurrentPoint() {
        return this.currentPoint;
    }

    private void setCurrentPoint(Point currentPoint) {
        this.currentPoint = currentPoint;
    }

    public void switchLabelWithContent(boolean labelToScaffold, String labelText) {
        this.mainPanel.removeAll();
        if (labelToScaffold && this.rViews != null && !this.rViews.isEmpty()) {
            this.mainPanel.addMouseListener(this.resizeMouseListener);
            this.mainPanel.addMouseMotionListener(this.resizeMouseMotionListener);
            this.mainPanel.setLayout(new BoxLayout(this.getMainPanel(), 1));
            this.mainPanel.setBackground(Color.WHITE);
            for (RGroupFragmentView view : this.rViews) {
                this.mainPanel.add(view.getPanel());
            }
        } else {
            String text = labelText == null ? "" : labelText;
            this.currentPoint = null;
            this.mainPanel.removeMouseListener(this.resizeMouseListener);
            this.mainPanel.removeMouseMotionListener(this.resizeMouseMotionListener);
            this.mainPanel.setLayout(new GridLayout(1, 1));
            this.mainPanel.add(new JLabel(text, 0));
            this.mainPanel.setBackground(this.defaultBackGroundColor);
        }
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }
}

