/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.metabolizer;

import chemaxon.alchemist.AlchemistSplashScreen;
import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.metabolizer.MetabolizerPanelHandler;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeNode;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeView;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeViewFileDataProvider;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeViewInteractiveDataProvider;
import chemaxon.alchemist.metabolizer.moleculetree.IterableDefaultTreeModel;
import chemaxon.alchemist.metabolizer.moleculetree.export.MoleculeTreeExporter;
import chemaxon.alchemist.metabolizer.moleculetree.export.SimpleMoleculeExporter;
import chemaxon.alchemist.metabolizer.moleculetree.export.SimpleReactionExporter;
import chemaxon.alchemist.reactor.ReactorInputPanel;
import chemaxon.alchemist.utils.AboutDialogFactory;
import chemaxon.alchemist.utils.AlchemistBrowserLauncher;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.AlchemistFileChooserForMarvin;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistInnerDialog;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.alchemist.utils.AlchemistProgressMonitor;
import chemaxon.alchemist.utils.ProgressMonitorWrapper;
import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.marvin.util.ExternalFileLoader;
import chemaxon.metabolizer.Metabolizer;
import chemaxon.metabolizer.MetabolizerException;
import chemaxon.metabolizer.MetabolizerUtilities;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.DotfileUtil;
import chemaxon.util.FindCodeBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MetabolizerAlchemist
extends MarvinBasedAlchemistApplication
implements AlchemistLaunchable {
    private static final String PROPERTY_KEY_SYNTHETIC_ACCESS = "synthetic-access";
    public static final String FILETOOLBAR = "fileToolbar";
    public static final String ZOOMTOOLBAR = "zoomToolbar";
    public static final String RUNTOOLBAR = "runToolbar";
    public static final String EXCLUDETOOLBAR = "excludeToolbar";
    public static final String EXPANDTOOLBAR = "expandToolbar";
    public static final String DISPLAYTOOLBAR = "displayToolbar";
    private static final String MENU_CONFIGURATION_PATH = "chemaxon/alchemist/metabolizer/MetabolizerAlchemistMenuConfiguration.xml";
    private static final String MENU_BUNDLE_BASENAME = "chemaxon/alchemist/metabolizer/MetabolizerAlchemistMenuProperties";
    public static final String PROPRETY_KEY_MAJOR_METABOLITE_LIMIT = "AlchemistApplication_MajorMetaboliteLimit";
    public static final String PROPRETY_KEY_MINOR_METABOLITE_LIMIT = "AlchemistApplication_MinorMetaboliteLimit";
    public static final String PROPERTY_KEY_FILETOOLBAR_VISIBLE = "AlchemistApplication_fileToolbarVisible";
    public static final String PROPERTY_KEY_ZOOMTOOLBAR_VISIBLE = "AlchemistApplication_zoomToolbarVisible";
    public static final String PROPERTY_KEY_RUNTOOLBAR_VISIBLE = "AlchemistApplication_runToolbarVisible";
    public static final String PROPERTY_KEY_EXCLUDETOOLBAR_VISIBLE = "AlchemistApplication_excludeToolbarVisible";
    public static final String PROPERTY_KEY_EXPANDTOOLBAR_VISIBLE = "AlchemistApplication_expandToolbarVisible";
    public static final String PROPERTY_KEY_DISPLAYTOOLBAR_VISIBLE = "AlchemistApplication_displayToolbarVisible";
    public static final String PROPERTY_KEY_TERMINATION_CONDITION = "AlchemistApplication_TerminationCondition";
    public static final String PROPERTY_KEY_REACTION_LIBRARY_PATH = "MetabolizerInteractiveViewNewDialog_LibraryFilePath";
    public static final String PROPERTY_KEY_AUTOSHOW_NEWPANEL = "AlchemistApplication_autoShowNewPanel";
    private static final String DEFAULT_LIBRARY_PATH_RELATIVE_TO_CODEBASE = "/../doc/user/config_downloadables/chemaxon_biotransformation_library_demo.mrv";
    private static final float DEFAULT_FAST_BATCHMODE_TOLERANCE = 0.1f;
    private static final String PERSISTENT_PROPERTY_PATH = "/alchemist/.metabolizer_interactive";
    private static final String SPLASH_IMAGE_PATH = "/chemaxon/alchemist/images/metabolizer_splash.jpg";
    private Map<String, Boolean> suspendedToolbarActions = null;
    private boolean isPackedViewShowing = false;
    private Map<String, MoleculeTreeExporter> exporterMap = null;
    private AlchemistTreeView treeView = null;
    private AlchemistTreeViewInteractiveDataProvider interactiveProvider = null;
    private ReactorInputPanel libraryHandler = null;
    private static AlchemistSplashScreen splash = null;
    private MetabolizerUtilities batchMetabolizerUtilities = null;
    private Metabolizer batchMetabolizer = null;
    private boolean documentcreated = false;
    private boolean initialized = false;
    private AlchemistProgressMonitor initProgressMonitor = null;
    private static final MolFileFilter[] FILE_FILTERS = new MolFileFilter[]{new MolFileFilter("mrv"), new MolFileFilter("smiles"), new MolFileFilter("rdf")};
    volatile boolean libraryBlocksNewDialog = false;

    public MetabolizerAlchemist() {
        super("Metabolizer " + VersionInfo.JCHEM_VERSION, AlchemistIconFactory.getImage("/chemaxon/alchemist/images/metabolizer.png"));
        try {
            this.fileChooser = new AlchemistFileChooserForJChem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInitProgressMonitor(new AlchemistProgressMonitor(100L));
        this.getInitProgressMonitor().setMessage("Initializing Application...");
        if (MetabolizerAlchemist.getSplash() != null) {
            MetabolizerAlchemist.getSplash().setProgressMonitor(this.getInitProgressMonitor());
        }
    }

    @Override
    public void show() {
        Thread init = new Thread(new Runnable(){

            @Override
            public void run() {
                MetabolizerAlchemist.this.initializeBeforeShow();
            }
        });
        init.setPriority(5);
        init.start();
    }

    private Molecule[] getSubstrates() {
        AlchemistTreeNode root = (AlchemistTreeNode)this.getTreeView().getModel().getRoot();
        ArrayList<Molecule> substrateList = new ArrayList<Molecule>(root.getChildCount());
        for (int i = 0; i < root.getChildCount(); ++i) {
            Molecule mol = ((AlchemistTreeNode)root.getChildAt(i)).getMolecule();
            mol.clearProperties();
            substrateList.add(mol);
        }
        return substrateList.toArray(new Molecule[substrateList.size()]);
    }

    private void resetMetabolism() {
        Molecule[] substrates = this.getSubstrates();
        if (substrates != null && substrates.length > 0) {
            this.getTreeView().close();
            this.setNewDocumentActionStates();
            this.interactiveProvider.setSubstrates(substrates);
            this.getTreeView().setDataProvider(this.interactiveProvider);
            this.getTreeView().setReactionNameMap(this.getReactionNamesMap());
        } else {
            this.newDocumentActionHandler();
        }
    }

    public void createNewMetabolism(Molecule[] substrates) {
        this.getTreeView().close();
        this.setNewDocumentActionStates();
        this.interactiveProvider.setSubstrates(substrates);
        this.getTreeView().setDataProvider(this.interactiveProvider);
        this.getTreeView().setReactionNameMap(this.getReactionNamesMap());
        this.documentcreated = true;
    }

    private Map<String, String> getReactionNamesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.getLibraryHandler().getReactions().length; ++i) {
            String key = this.getLibraryHandler().getReactions()[i].getProperty("Synthesis Code");
            if (!"".equals(key)) continue;
            String value = this.getLibraryHandler().getReactions()[i].getProperty("NAME");
            if (value == null || "".equals(key)) {
                value = key;
            }
            map.put(key, value);
        }
        return map;
    }

    protected synchronized void initializeBeforeShow() {
        if (!this.isInitialized()) {
            this.setDocumentPathInFrameTitle(true);
            this.getInitProgressMonitor().set(5);
            this.exporterMap = new HashMap<String, MoleculeTreeExporter>();
            this.exporterMap.put("exportSimpleMolecule", new SimpleMoleculeExporter());
            this.exporterMap.put("exportSimpleReaction", new SimpleReactionExporter());
            this.getInitProgressMonitor().set(10);
            this.setMenuResources(MENU_CONFIGURATION_PATH, MENU_BUNDLE_BASENAME, new MarvinBasedAlchemistApplication.DefaultActionConfigurer(this));
            this.setNewDocumentActionStates();
            this.getInitProgressMonitor().set(15);
            this.getInitProgressMonitor().set(20);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.getTreeView(), "Center");
            this.getInitProgressMonitor().set(25);
            this.getInitProgressMonitor().set(30);
            Float fmaj = (Float)this.getApplicationState().getProperty(PROPRETY_KEY_MAJOR_METABOLITE_LIMIT);
            if (fmaj != null) {
                this.getTreeView().setMajorMetaboliteLimit(fmaj.floatValue());
            }
            this.getInitProgressMonitor().set(35);
            Float fmin = (Float)this.getApplicationState().getProperty(PROPRETY_KEY_MINOR_METABOLITE_LIMIT);
            if (fmin != null) {
                this.getTreeView().setMinorMetaboliteLimit(fmin.floatValue());
            }
            this.getInitProgressMonitor().set(55);
            this.getTreeView().setTerminationCondition((String)this.getApplicationState().getProperty(PROPERTY_KEY_TERMINATION_CONDITION));
            String reactionLibraryPath = (String)this.getApplicationState().getProperty(PROPERTY_KEY_REACTION_LIBRARY_PATH);
            if (reactionLibraryPath == null) {
                reactionLibraryPath = FindCodeBase.getCodeBaseDir() + DEFAULT_LIBRARY_PATH_RELATIVE_TO_CODEBASE;
                this.getApplicationState().setPersistentProperty(PROPERTY_KEY_REACTION_LIBRARY_PATH, reactionLibraryPath);
            }
            this.getLibraryHandler().getNotifier().addPropertyChangeListener("ReactorInputPanel_Initialized", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue().equals("Panel_Normal")) {
                        if (!MetabolizerAlchemist.this.isInitialized()) {
                            Boolean b;
                            MetabolizerAlchemist.this.getInitProgressMonitor().set(90);
                            MetabolizerAlchemist.this.setExporterActionsEnabled();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (MetabolizerAlchemist.getSplash() != null) {
                                        MetabolizerAlchemist.getSplash().dispose();
                                    }
                                    MetabolizerAlchemist.super.show();
                                    try {
                                        MetabolizerAlchemist.this.getApplicationFrame().setAlwaysOnTop(true);
                                        MetabolizerAlchemist.this.getApplicationFrame().setAlwaysOnTop(false);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    AlchemistInnerDialog.setCentered(MetabolizerPanelHandler.getDialog(MetabolizerAlchemist.this, MetabolizerPanelHandler.DialogID.LIBRARY_OPTIONS));
                                }
                            });
                            if (!MetabolizerAlchemist.this.libraryBlocksNewDialog && ((b = (Boolean)MetabolizerAlchemist.this.getApplicationState().getProperty(MetabolizerAlchemist.PROPERTY_KEY_AUTOSHOW_NEWPANEL)) == null || b.booleanValue())) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MetabolizerPanelHandler.showNewMetabolismDialog(MetabolizerAlchemist.this);
                                        if (MetabolizerAlchemist.this.libraryBlocksNewDialog) {
                                            MetabolizerPanelHandler.getDialog(MetabolizerAlchemist.this, MetabolizerPanelHandler.DialogID.NEW_METABOLISM).setVisible(false);
                                        }
                                        MetabolizerAlchemist.this.libraryBlocksNewDialog = true;
                                        MetabolizerAlchemist.this.setInitialized(true);
                                        MetabolizerAlchemist.this.getLibraryHandler().setInitializing(false);
                                        MetabolizerAlchemist.this.getContentPane().validate();
                                    }
                                });
                                return;
                            }
                            MetabolizerAlchemist.this.setInitialized(true);
                        }
                        MetabolizerAlchemist.this.enableContent();
                    } else if (evt.getNewValue().equals("Panel_Disabled")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MetabolizerAlchemist.this.disableContent(true);
                            }
                        });
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MetabolizerAlchemist.this.getContentPane().validate();
                        }
                    });
                }
            });
            MetabolizerPanelHandler.getDialog(this, MetabolizerPanelHandler.DialogID.LIBRARY_OPTIONS);
            this.getLibraryHandler().setInitializing(true);
            this.getInitProgressMonitor().setMessage("Loading Reaction Library...");
            final String path = reactionLibraryPath;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MetabolizerAlchemist.this.getLibraryHandler().setReactionFilePath(path);
                }
            });
        }
    }

    public AlchemistTreeView getTreeView() {
        if (this.treeView == null) {
            this.treeView = new AlchemistTreeView(){
                private static final long serialVersionUID = -2227156997935094134L;
                private Molecule parentMolecule = null;
                private Molecule[][] children = null;

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    if (MetabolizerAlchemist.this.isPackedViewShowing()) {
                        int i;
                        AlchemistMoleculeTreeNode parent = (AlchemistMoleculeTreeNode)MetabolizerAlchemist.this.getTreeView().getSelectionPath().getLastPathComponent();
                        int dim = (int)Math.ceil(Math.sqrt(parent.getChildCount()));
                        this.children = new Molecule[dim][dim];
                        this.parentMolecule = parent.getMolecule();
                        for (int i2 = 0; i2 < dim; ++i2) {
                            for (int j = 0; j < dim; ++j) {
                                if (i2 * dim + j >= parent.getChildCount()) continue;
                                this.children[i2][j] = ((AlchemistMoleculeTreeNode)parent.getChildAt(i2 * dim + j)).getMolecule();
                            }
                        }
                        int w = this.getWidth() / (this.children.length + 1);
                        int h = this.getHeight() / this.children.length;
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(new Color(255, 255, 255, 200));
                        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g2.translate(13, (this.getHeight() - h) / 2 + 13);
                        AlchemistMoleculePainter.drawMolecule(2, 2, this.parentMolecule, (Graphics)g2, w - 8, h - 8);
                        g2.setColor(Color.LIGHT_GRAY);
                        g2.drawRect(1, 1, w - 7, h - 7);
                        g2.dispose();
                        int hc = 0;
                        for (i = 0; i < this.children.length && this.children[i][0] != null; ++i) {
                            ++hc;
                        }
                        for (i = 0; i < this.children.length; ++i) {
                            for (int j = 0; j < this.children.length; ++j) {
                                if (this.children[i][j] == null) continue;
                                g2 = (Graphics2D)g.create();
                                g2.translate((double)((j + 1) * w), ((float)i + ((float)this.children.length - (float)hc) / 2.0f) * (float)h);
                                AlchemistMoleculePainter.drawMolecule(3, 3, this.children[i][j], (Graphics)g2, w - 6, h - 6);
                                g2.dispose();
                            }
                        }
                        g2 = (Graphics2D)g.create();
                        g2.setColor(Color.LIGHT_GRAY);
                        for (i = 1; i < this.children.length; ++i) {
                            int left = w + w / 2;
                            int top = (int)((float)(this.children.length - hc) / 2.0f * (float)h);
                            if (this.children[i][0] != null) {
                                g2.drawLine(left, i * h + top, this.children.length * w + w / 2, i * h + top);
                            }
                            g2.drawLine((i - 1) * w + w / 2 + left, top + h / 2, (i - 1) * w + w / 2 + left, top + hc * h - h / 2);
                        }
                        g2.dispose();
                    }
                }
            };
            this.treeView.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    MetabolizerAlchemist.this.setBatchCalcActionsEnabled(MetabolizerAlchemist.this.getTreeView().getSelectionPaths());
                    MetabolizerAlchemist.this.setSubstrateActionsEnabled(MetabolizerAlchemist.this.getTreeView().getSelectionPaths());
                    MetabolizerAlchemist.this.setExporterActionsEnabled();
                }
            });
            this.treeView.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MetabolizerAlchemist.this.setExporterActionsEnabled();
                }
            });
            this.treeView.addExporters(this.exporterMap.values().toArray(new MoleculeTreeExporter[this.exporterMap.size()]));
            this.treeView.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    MetabolizerAlchemist.this.setDocumentChanged(true);
                }

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    MetabolizerAlchemist.this.setDocumentChanged(true);
                    MetabolizerAlchemist.this.setBatchCalcActionsEnabled(MetabolizerAlchemist.this.getTreeView().getSelectionPaths());
                }
            });
            this.treeView.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (!MetabolizerAlchemist.this.isPackedViewShowing() && e.getKeyCode() == 16 && e.isControlDown() && MetabolizerAlchemist.this.canShowPackedView()) {
                        MetabolizerAlchemist.this.setPackedViewShowing(true);
                    } else {
                        MetabolizerAlchemist.this.setPackedViewShowing(false);
                    }
                    MetabolizerAlchemist.this.getTreeView().repaint();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (!MetabolizerAlchemist.this.isPackedViewShowing() && e.getKeyCode() == 16 && e.isControlDown() && MetabolizerAlchemist.this.canShowPackedView()) {
                        MetabolizerAlchemist.this.setPackedViewShowing(true);
                    } else {
                        MetabolizerAlchemist.this.setPackedViewShowing(false);
                    }
                    MetabolizerAlchemist.this.getTreeView().repaint();
                }
            });
        }
        return this.treeView;
    }

    protected boolean canShowPackedView() {
        TreePath[] paths = this.getTreeView().getSelectionPaths();
        if (paths != null && paths.length == 1) {
            return this.getTreeView().isExpanded(paths[0]);
        }
        return false;
    }

    protected void setExporterActionsEnabled() {
        for (String name : this.exporterMap.keySet()) {
            if (this.getTreeView().getSelectionCount() > 0) {
                if (this.getTreeView().getSelectionCount() > 1) {
                    this.setActionEnabled(name, this.exporterMap.get(name).canExportMultipleSelection());
                    continue;
                }
                this.setActionEnabled(name, true);
                continue;
            }
            this.setActionEnabled(name, false);
        }
    }

    protected void setBatchCalcActionsEnabled(TreePath[] path) {
        boolean state = false;
        if (path != null && path.length == 1) {
            AlchemistMoleculeTreeNode node = (AlchemistMoleculeTreeNode)path[0].getLastPathComponent();
            state = !((IterableDefaultTreeModel)this.treeView.getModel()).isNodeRealParent(node);
        }
        this.setActionEnabled("batchCalc", state);
        this.setActionEnabled("fastBatchCalc", state);
    }

    protected static void createAndShowGUI() {
        block2: {
            try {
                MetabolizerAlchemist.setLookAndFeel();
                UIManager.getDefaults().put("Tree.hash", Color.WHITE);
                MetabolizerAlchemist trw = new MetabolizerAlchemist();
                trw.show();
            }
            catch (Exception e) {
                AlchemistErrorDialog.showError(e);
                if (MetabolizerAlchemist.getSplash() == null) break block2;
                MetabolizerAlchemist.getSplash().dispose();
            }
        }
    }

    public static void showSplashScreen() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MetabolizerAlchemist.setSplash(new AlchemistSplashScreen(MetabolizerAlchemist.SPLASH_IMAGE_PATH, new Dimension(525, 278)));
                    MetabolizerAlchemist.getSplash().setProgressColor(Color.WHITE);
                    MetabolizerAlchemist.getSplash().show(true);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void launch() {
        MetabolizerAlchemist.main(new String[0]);
    }

    public static void main(String[] args) {
        MetabolizerAlchemist.showSplashScreen();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MetabolizerAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    protected String getPropertyFilePath() {
        return DotfileUtil.getDotFile(PERSISTENT_PROPERTY_PATH).getAbsolutePath();
    }

    @Override
    protected FileFilter[] getSaveFileFilters() {
        return FILE_FILTERS;
    }

    @Override
    protected FileFilter[] getOpenFileFilters() {
        return FILE_FILTERS;
    }

    @Override
    protected FileFilter[] getOpenFileFilters(String context) {
        if ("MetabolizerNewProjectPanel".equals(context)) {
            return AlchemistFileChooserForMarvin.getDefaultOpenFileFilters();
        }
        return this.getOpenFileFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openDocumentActionHandler(String fileName) {
        super.openDocumentActionHandler(fileName);
        ArrayList<Molecule> substrateList = new ArrayList<Molecule>();
        MolImporter importer = null;
        try {
            importer = new MolImporter(fileName);
            Molecule mol = importer.read();
            while (mol != null && mol.getProperty("METABOLIZER_SYNTHESISLEVEL") != null && mol.getProperty("METABOLIZER_SYNTHESISLEVEL").equalsIgnoreCase("0")) {
                substrateList.add(mol);
                mol = importer.read();
            }
        }
        catch (IOException e) {
            this.showError("Can not open file", e);
            return;
        }
        finally {
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (IOException e) {}
        }
        if (substrateList.isEmpty()) {
            this.showError("Not a valid metabolism file", null);
            return;
        }
        AlchemistTreeViewFileDataProvider provider = new AlchemistTreeViewFileDataProvider(fileName, true);
        try {
            provider.open();
            AlchemistTreeNode[] nodes = provider.getTreeData(null, null);
            this.getTreeView().close();
            this.setActionEnabled("batchCalc", false);
            this.setActionEnabled("fastBatchCalc", false);
            this.interactiveProvider.setSubstrates(substrateList.toArray(new Molecule[substrateList.size()]));
            this.getTreeView().setDataProvider(this.interactiveProvider, nodes);
            this.getTreeView().setReactionNameMap(this.getReactionNamesMap());
        }
        catch (IOException e) {
            this.showError("Can not open file", e);
            return;
        }
        finally {
            try {
                provider.close();
            }
            catch (IOException e) {}
        }
        this.setExporterActionsEnabled();
        this.documentcreated = true;
    }

    @Override
    protected void saveDocumentActionHandler() {
        super.saveDocumentActionHandler();
        if (this.getDocumentPath() != null) {
            Thread saveThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MetabolizerAlchemist.this.disableContent(true);
                    String opts = MetabolizerAlchemist.this.getSaveFilterFormat();
                    if ("smiles".equalsIgnoreCase(opts)) {
                        opts = "smiles:qTSynthesis Code:METABOLIZER_SYNTHESISLEVEL:METABOLIZER_PARENTSYNTHESISCODE:SPEED_CATEGORY:CHILDDEPTH:PRODUCTION:ACCUMULATION:TRANSMISSIVITY:STABILITY:PARENTS:METABOLIC_TREE_COUNT";
                    }
                    FileOutputStream oStream = null;
                    MolExporter exporter = null;
                    try {
                        oStream = new FileOutputStream(MetabolizerAlchemist.this.getDocumentPath());
                        exporter = new MolExporter(oStream, opts);
                        TreeModel treeModel = MetabolizerAlchemist.this.getTreeView().getModel();
                        synchronized (treeModel) {
                            Iterator<Molecule> iterator = MetabolizerAlchemist.this.getTreeView().iterator();
                            while (iterator.hasNext()) {
                                exporter.write(iterator.next());
                            }
                        }
                    }
                    catch (Exception e) {
                        MetabolizerAlchemist.this.showError("Can not save file", e);
                    }
                    finally {
                        try {
                            if (exporter != null) {
                                exporter.close();
                            }
                            if (oStream != null) {
                                oStream.close();
                            }
                        }
                        catch (Exception e2) {}
                    }
                    MetabolizerAlchemist.this.enableContent();
                    MetabolizerAlchemist.this.setExporterActionsEnabled();
                }
            });
            saveThread.setPriority(4);
            saveThread.start();
        }
    }

    protected void resetDocumentActionHandler() {
        if (JOptionPane.showConfirmDialog(this.getApplicationFrame(), "Do you want to reset?\nAll calculated molecules will be lost!", "Reset Metabolism", 0) == 0) {
            this.resetMetabolism();
        }
    }

    @Override
    protected void newDocumentActionHandler() {
        super.newDocumentActionHandler();
        MetabolizerPanelHandler.showNewMetabolismDialog(this);
    }

    public void batchModeActionHandler(final boolean fastAction) {
        this.suspendToolbar("stopBatchCalc");
        this.setActionEnabled("stopBatchCalc", true);
        this.getTreeView().setCursor(Cursor.getPredefinedCursor(3));
        this.setDocumentChanged(true);
        Thread batchCalcThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int level = (Integer)MetabolizerAlchemist.this.getGuiModule().getActions().getAction("spinBatchCalc").getValue("spinBatchCalc");
                MetabolizerAlchemist.this.getBatchMetabolizer().setProgressMonitor(new ProgressMonitorWrapper(MetabolizerAlchemist.this.getTreeView().getProgressMonitor()));
                MetabolizerAlchemist.this.getBatchMetabolizer().setLevelCount(level);
                MetabolizerAlchemist.this.getBatchMetabolizer().setGeneratingSubstrates(true);
                MetabolizerAlchemist.this.getBatchMetabolizer().setMetabolicPathwayTolerance(fastAction ? 0.1f : 0.0f);
                try {
                    MetabolizerAlchemist.this.getBatchMetabolizer().setTermCondition(MetabolizerAlchemist.this.getTreeView().getTerminationCondition());
                }
                catch (MetabolizerException e2) {
                    MetabolizerAlchemist.this.showError("Error when performing batch calculation", e2);
                }
                if (MetabolizerAlchemist.this.getBatchMetabolizerUtilities() == null) {
                    MetabolizerAlchemist.this.setBatchMetabolizerUtilities(new MetabolizerUtilities());
                }
                MetabolizerAlchemist.this.getBatchMetabolizerUtilities().setCanceled(false);
                TreePath[] paths = MetabolizerAlchemist.this.getTreeView().getSelectionPaths();
                for (int i = 0; i < paths.length && !MetabolizerAlchemist.this.getBatchMetabolizerUtilities().isCanceled(); ++i) {
                    AlchemistMoleculeTreeNode node = (AlchemistMoleculeTreeNode)paths[i].getLastPathComponent();
                    try {
                        MetabolizerAlchemist.this.getTreeView().setNodeLoading(node, true);
                        File out = File.createTempFile("metabolizer", "tmpdata");
                        out.deleteOnExit();
                        Molecule mol = node.getReaction();
                        MetabolizerAlchemist.this.getBatchMetabolizer().setSubstrates(new Molecule[]{mol});
                        MetabolizerAlchemist.this.getBatchMetabolizerUtilities().generateMetabolitesWithChildDepth(MetabolizerAlchemist.this.getBatchMetabolizer(), out, "smiles:qTSynthesis Code:METABOLIZER_SYNTHESISLEVEL:METABOLIZER_PARENTSYNTHESISCODE:SPEED_CATEGORY:CHILDDEPTH:PRODUCTION:ACCUMULATION:TRANSMISSIVITY:STABILITY:PARENTS:METABOLIC_TREE_COUNT", "reaction");
                        if (!MetabolizerAlchemist.this.getBatchMetabolizerUtilities().isCanceled()) {
                            AlchemistTreeViewFileDataProvider provider = new AlchemistTreeViewFileDataProvider(out.getAbsolutePath(), true);
                            provider.open();
                            AlchemistTreeNode[] nodeArray = provider.getTreeData(null, MetabolizerAlchemist.this.getTreeView().getProgressMonitor());
                            while (node.getChildCount() > 0) {
                                MetabolizerAlchemist.this.getTreeView().removeNodeFromParent((AlchemistMoleculeTreeNode)node.getChildAt(0));
                            }
                            MetabolizerAlchemist.this.getTreeView().addNodes(nodeArray);
                            provider.close();
                            MolImporter importer = null;
                            try {
                                importer = new MolImporter(out.getAbsolutePath());
                                Molecule batchRoot = importer.read();
                                node.setChildrenDepth(Integer.parseInt(batchRoot.getProperty("CHILDDEPTH")) + 1);
                            }
                            catch (IOException e) {
                            }
                            finally {
                                try {
                                    if (importer != null) {
                                        importer.close();
                                    }
                                }
                                catch (IOException e) {}
                            }
                            node.setChildrenLoaded(true);
                        }
                        MetabolizerAlchemist.this.getTreeView().setNodeLoading(node, false);
                    }
                    catch (MetabolizerException e1) {
                        MetabolizerAlchemist.this.showError("Calculation failed", e1);
                    }
                    catch (IOException e) {
                        MetabolizerAlchemist.this.showError("Calculation failed", e);
                    }
                    if (!node.isChildrenLoaded()) continue;
                    MetabolizerAlchemist.this.getTreeView().expandPath(paths[i]);
                }
                MetabolizerAlchemist.this.restoreToolbar();
                MetabolizerAlchemist.this.setActionEnabled("stopBatchCalc", false);
                MetabolizerAlchemist.this.getTreeView().setCursor(Cursor.getPredefinedCursor(0));
                if (MetabolizerAlchemist.this.getBatchMetabolizerUtilities().isCanceled()) {
                    MetabolizerAlchemist.this.getTreeView().repaint();
                }
                MetabolizerAlchemist.this.setBatchCalcActionsEnabled(MetabolizerAlchemist.this.getTreeView().getSelectionPaths());
            }
        });
        batchCalcThread.setPriority(4);
        batchCalcThread.start();
    }

    public MetabolizerUtilities getBatchMetabolizerUtilities() {
        return this.batchMetabolizerUtilities;
    }

    public void markDocumentAsChanged() {
        this.setDocumentChanged(true);
    }

    public MoleculeTreeExporter getExporter(String id) {
        return this.exporterMap.get(id);
    }

    public void resetDocument() {
        this.resetDocumentActionHandler();
    }

    @Override
    protected void aboutActionHandler() {
        AboutDialogFactory.createAboutDialog("Metabolizer", "/chemaxon/alchemist/images/about/metabolizer-64.png", VersionInfo.JCHEM_VERSION).setVisible(true);
    }

    private void setNewDocumentActionStates() {
        this.setActionEnabled("batchCalc", false);
        this.setActionEnabled("fastBatchCalc", false);
        this.setActionEnabled("stopBatchCalc", false);
        this.setActionEnabled("addSubstrate", true);
        this.setActionEnabled("editSubstrate", false);
        this.setActionEnabled("removeSubstrate", false);
    }

    protected void setSubstrateActionsEnabled(TreePath[] selection) {
        if (selection != null && selection.length > 0) {
            boolean valid = true;
            for (int i = 0; i < selection.length && valid; ++i) {
                valid = valid && ((AlchemistMoleculeTreeNode)selection[i].getLastPathComponent()).getParent() == this.getTreeView().getModel().getRoot();
            }
            this.setActionEnabled("editSubstrate", valid && selection.length == 1);
            this.setActionEnabled("removeSubstrate", valid);
        } else {
            this.setActionEnabled("editSubstrate", false);
            this.setActionEnabled("removeSubstrate", false);
        }
        this.setActionEnabled("addSubstrate", true);
    }

    @Override
    protected void helpActionHandler() {
        try {
            ExternalFileLoader loader = new ExternalFileLoader("doc/user/metabolizer.html");
            if (loader.getFileOutJar() != null) {
                AlchemistBrowserLauncher.launchBrowser(new File(loader.getFileOutJar()).toURI().toURL().toString());
            } else {
                loader = new ExternalFileLoader("../../jchem/jchemsite/doc/user/metabolizer.html");
                if (loader.getFileOutJar() != null) {
                    AlchemistBrowserLauncher.launchBrowser(new File(loader.getFileOutJar()).toURI().toURL().toString());
                } else {
                    AlchemistBrowserLauncher.launchBrowser("http://www.chemaxon.com/jchem/doc/user/metabolizer.html");
                }
            }
        }
        catch (Exception e) {
            try {
                AlchemistBrowserLauncher.launchBrowser("http://www.chemaxon.com/jchem/doc/user/metabolizer.html");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addSubstrateActionHandler() {
        AlchemistInnerDialog sketchDialog = MetabolizerPanelHandler.getDialog(this, MetabolizerPanelHandler.DialogID.SKETCH_PANEL);
        sketchDialog.putClientProperty("Synthesiscode", null);
        sketchDialog.putClientProperty("SketchStructureToEdit", new Molecule());
        sketchDialog.setVisible(true);
    }

    public void editSubstrateActionHandler() {
        TreePath[] selection = this.getTreeView().getSelectionPaths();
        boolean valid = selection.length == 1;
        String code = null;
        Molecule mol = new Molecule();
        for (int i = 0; i < selection.length && valid; ++i) {
            valid = valid && ((AlchemistMoleculeTreeNode)selection[i].getLastPathComponent()).getParent() == this.getTreeView().getModel().getRoot();
            code = ((AlchemistMoleculeTreeNode)selection[i].getLastPathComponent()).getUniqueID();
            mol = ((AlchemistMoleculeTreeNode)selection[i].getLastPathComponent()).getMolecule();
        }
        if (code != null) {
            AlchemistInnerDialog sketchDialog = MetabolizerPanelHandler.getDialog(this, MetabolizerPanelHandler.DialogID.SKETCH_PANEL);
            sketchDialog.putClientProperty("Synthesiscode", code);
            sketchDialog.putClientProperty("SketchStructureToEdit", mol);
            sketchDialog.setVisible(true);
        }
    }

    public void removeSubstrateActionHandler() {
        int i;
        if (JOptionPane.showConfirmDialog(this.getContentPane(), "Remove selected substrate(s)?", "Remove substrates", 0) != 0) {
            return;
        }
        TreePath[] selection = this.getTreeView().getSelectionPaths();
        ArrayList<String> removeList = new ArrayList<String>();
        boolean valid = true;
        for (i = 0; i < selection.length && valid; ++i) {
            valid = valid && ((AlchemistMoleculeTreeNode)selection[i].getLastPathComponent()).getParent() == this.getTreeView().getModel().getRoot();
            removeList.add(((AlchemistMoleculeTreeNode)selection[i].getLastPathComponent()).getUniqueID());
        }
        if (valid) {
            for (i = 0; i < removeList.size(); ++i) {
                this.getTreeView().removeSubstrate((String)removeList.get(i));
            }
        }
    }

    protected ReactorInputPanel getLibraryHandler() {
        if (this.libraryHandler == null) {
            this.libraryHandler = new ReactorInputPanel();
            this.libraryHandler.setReverseOptionVisible(false);
        }
        return this.libraryHandler;
    }

    public boolean isDocumentCreated() {
        return this.documentcreated;
    }

    public void setReactionLibrary(RxnMolecule[] reactions, boolean calculateDominance) {
        try {
            this.interactiveProvider = new AlchemistTreeViewInteractiveDataProvider(this.getLibraryHandler().getReactions(), calculateDominance);
            this.setBatchMetabolizer(new Metabolizer(true));
            this.getBatchMetabolizer().setReactions(this.getLibraryHandler().getReactions());
        }
        catch (MetabolizerException e1) {
            e1.printStackTrace();
        }
    }

    private void suspendToolbar(String excludedAction) {
        String[] stringArray;
        if (excludedAction == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = excludedAction;
        }
        this.suspendToolbar(stringArray);
    }

    protected void restoreToolbar() {
        if (this.suspendedToolbarActions != null && this.getGuiModule() != null) {
            for (String name : this.suspendedToolbarActions.keySet()) {
                this.getGuiModule().getActions().getAction(name).setEnabled(this.suspendedToolbarActions.get(name));
            }
            this.suspendedToolbarActions = null;
        }
    }

    private void suspendToolbar(String[] excludedActions) {
        if (this.suspendedToolbarActions == null && this.getGuiModule() != null) {
            this.suspendedToolbarActions = new HashMap<String, Boolean>();
            String[] actionIDs = this.getGuiModule().getActions().getActionIDs();
            if (excludedActions != null) {
                Arrays.sort(excludedActions);
            }
            for (int i = 0; i < actionIDs.length; ++i) {
                if (excludedActions != null && Arrays.binarySearch(excludedActions, actionIDs[i]) >= 0) continue;
                this.suspendedToolbarActions.put(actionIDs[i], this.getGuiModule().getActions().getAction(actionIDs[i]).isEnabled());
                this.getGuiModule().getActions().getAction(actionIDs[i]).setEnabled(false);
            }
        }
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public void setInitProgressMonitor(AlchemistProgressMonitor initProgressMonitor) {
        this.initProgressMonitor = initProgressMonitor;
    }

    public AlchemistProgressMonitor getInitProgressMonitor() {
        return this.initProgressMonitor;
    }

    public static void setSplash(AlchemistSplashScreen splash) {
        MetabolizerAlchemist.splash = splash;
    }

    public static AlchemistSplashScreen getSplash() {
        return splash;
    }

    public void setPackedViewShowing(boolean isPackedViewShowing) {
        this.isPackedViewShowing = isPackedViewShowing;
    }

    public boolean isPackedViewShowing() {
        return this.isPackedViewShowing;
    }

    public void setBatchMetabolizer(Metabolizer batchMetabolizer) {
        this.batchMetabolizer = batchMetabolizer;
    }

    public Metabolizer getBatchMetabolizer() {
        return this.batchMetabolizer;
    }

    public void setBatchMetabolizerUtilities(MetabolizerUtilities batchMetabolizerUtilities) {
        this.batchMetabolizerUtilities = batchMetabolizerUtilities;
    }
}

