/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.metabolizer.moleculetree;

import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeNode;
import chemaxon.alchemist.metabolizer.moleculetree.AlchemistTreeViewDataProvider;
import chemaxon.alchemist.utils.AlchemistProgressMonitor;
import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Timer;

public class AlchemistTreeViewFileDataProvider
implements AlchemistTreeViewDataProvider {
    private File inputFile = null;
    private MolImporter importer = null;
    private AlchemistProgressMonitor progressMonitor = null;
    private static final int PROGRESS_TIMER_INTERVAL = 200;
    private boolean addVirtuals = false;
    private final Timer progressTimer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AlchemistTreeViewFileDataProvider.this.getProgressMonitor().setTaskValue(AlchemistTreeViewFileDataProvider.this.getImporter().tell());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    });

    public AlchemistTreeViewFileDataProvider(String inputFilePath) {
        this(new File(inputFilePath));
    }

    public AlchemistTreeViewFileDataProvider(String inputFilePath, boolean addVirtuals) {
        this(new File(inputFilePath), addVirtuals);
    }

    public AlchemistTreeViewFileDataProvider(File inputFile) {
        this(inputFile, false);
    }

    public AlchemistTreeViewFileDataProvider(File inputFile, boolean addVirtuals) {
        this.inputFile = inputFile;
        this.addVirtuals = addVirtuals;
    }

    @Override
    public void open() throws IOException {
        if (this.getImporter() != null) {
            this.close();
        }
        this.setImporter(new MolImporter(this.inputFile.getAbsolutePath()));
    }

    @Override
    public void close() throws IOException {
        this.getImporter().close();
        this.setImporter(null);
    }

    public synchronized AlchemistMoleculeTreeNode[] getTreeData(AlchemistTreeNode parent, AlchemistProgressMonitor monitor) throws IOException {
        if (monitor != null) {
            this.setProgressMonitor(monitor);
            this.getProgressMonitor().reset();
            this.getProgressMonitor().setTaskLength(this.inputFile.length());
            this.progressTimer.start();
        }
        ArrayList<AlchemistMoleculeTreeNode> list = new ArrayList<AlchemistMoleculeTreeNode>();
        Molecule mol = this.getImporter().read();
        HashMap<String, Integer> notParents = new HashMap<String, Integer>();
        while (mol != null) {
            AlchemistMoleculeTreeNode node = new AlchemistMoleculeTreeNode(mol);
            node.setChildrenLoaded(true);
            notParents.put(node.getUniqueID(), list.size());
            if (node.getParentID() != null) {
                notParents.remove(node.getParentID());
            }
            list.add(node);
            mol = this.getImporter().read();
        }
        if (this.addVirtuals) {
            for (String name : notParents.keySet()) {
                AlchemistMoleculeTreeNode node = (AlchemistMoleculeTreeNode)list.get((Integer)notParents.get(name));
                node.setChildrenLoaded(false);
                node.setChildrenDepth(0);
                AlchemistMoleculeTreeNode virtual = new AlchemistMoleculeTreeNode(new Molecule());
                virtual.setUniqueID("virtual" + node.getUniqueID());
                virtual.setParentID(node.getUniqueID());
                list.add(virtual);
            }
        }
        AlchemistMoleculeTreeNode[] nodes = list.toArray(new AlchemistMoleculeTreeNode[list.size()]);
        if (this.getProgressMonitor() != null) {
            this.getProgressMonitor().setDone(true);
            this.progressTimer.stop();
        }
        return nodes;
    }

    @Override
    public AlchemistMoleculeTreeNode[] addSubstrate(Molecule mol) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSubstrate(String synthCode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public AlchemistMoleculeTreeNode[] updateSubstrate(String synthCode, Molecule mol) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected void setImporter(MolImporter importer) {
        this.importer = importer;
    }

    protected MolImporter getImporter() {
        return this.importer;
    }

    protected void setProgressMonitor(AlchemistProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    protected AlchemistProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }
}

