/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.moleculeeditor;

import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForMarvin;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.alchemist.utils.AlchemistMoleculeEditor;
import chemaxon.alchemist.utils.AlchemistTableSizeConfigurerComponent;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.util.DotfileUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.SwingPropertyChangeSupport;

public class MoleculeFileEditorAlchemist
extends MarvinBasedAlchemistApplication
implements AlchemistLaunchable {
    private static final String PROPERTY_KEY_COLUMN_COUNT = "AlchemistMoleculeFileEditor_ColumnCount";
    private static final String PROPERTY_KEY_ROW_COUNT = "AlchemistMoleculeFileEditor_RowCount";
    private static final String PERSISTENT_PROPERTY_PATH = "/alchemist/.moleculefileeditor";
    private static final String MENU_CONFIGURATION_PATH = "chemaxon/alchemist/moleculeeditor/MoleculeFileEditorAlchemistMenuConfiguration.xml";
    private static final String MENU_BUNDLE_BASENAME = "chemaxon/alchemist/moleculeeditor/MoleculeFileEditorAlchemistMenuProperties";
    private static final String DEFAULT_TOOLBAR = "mainToolBar";
    private static final String APP_TITLE = "Alchemist Molecule File Editor " + VersionInfo.MARVIN_VERSION;
    private JPanel mainPanel = null;
    private AlchemistMoleculeEditor editor = null;
    private SwingPropertyChangeSupport notifier = null;
    private JToolBar toolBar = null;
    private AlchemistTableSizeConfigurerComponent tableSizeConfigurer = null;
    private JPopupMenu configurerPopupMenu = null;

    public static void createAndShowGUI() {
        MoleculeFileEditorAlchemist.setLookAndFeel();
        MoleculeFileEditorAlchemist app = new MoleculeFileEditorAlchemist();
        app.show();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MoleculeFileEditorAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    protected Dimension getDefaultWindowSize() {
        return new Dimension(800, 600);
    }

    public MoleculeFileEditorAlchemist() {
        super(APP_TITLE);
        this.initialize();
    }

    private void initialize() {
        this.setDocumentPathInFrameTitle(true);
        this.setMenuResources(MENU_CONFIGURATION_PATH, MENU_BUNDLE_BASENAME, new MarvinBasedAlchemistApplication.DefaultActionConfigurer(this));
        this.fileChooser = new AlchemistFileChooserForMarvin(true);
        this.notifier = new SwingPropertyChangeSupport(this);
        this.notifier.addPropertyChangeListener("Alchemist_Enable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Boolean) {
                    boolean value = (Boolean)evt.getNewValue();
                    MoleculeFileEditorAlchemist.this.setActionEnabled("applyChanges", !value);
                    MoleculeFileEditorAlchemist.this.setActionEnabled("discardChanges", !value);
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getMainPanel(), "Center");
        this.getContentPane().add((Component)this.getToolBar(), "North");
        this.getApplicationFrame().setTitle(APP_TITLE + " - " + "Untitled");
        Integer colCount = (Integer)this.getApplicationState().getProperty(PROPERTY_KEY_COLUMN_COUNT);
        Integer rowCount = (Integer)this.getApplicationState().getProperty(PROPERTY_KEY_ROW_COUNT);
        if (colCount != null) {
            this.getEditor().setColCount(colCount);
        }
        if (rowCount != null) {
            this.getEditor().setRowCount(rowCount);
        }
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.getToolbar(DEFAULT_TOOLBAR);
            if (this.toolBar != null) {
                this.toolBar.setFloatable(false);
            }
        }
        return this.toolBar;
    }

    protected AlchemistMoleculeEditor getEditor() {
        if (this.editor == null) {
            this.editor = new AlchemistMoleculeEditor(3, 1, false, this.notifier);
            this.setActionEnabled("applyChanges", false);
            this.setActionEnabled("discardChanges", false);
            this.notifier.addPropertyChangeListener("Alchemist_Enable", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MoleculeFileEditorAlchemist.this.setActionsEditMode((Boolean)evt.getNewValue() == false);
                }
            });
            this.editor.addListSelectionListerer(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        MoleculeFileEditorAlchemist.this.setActionEnabled("editMolecule", MoleculeFileEditorAlchemist.this.editor.isNonEmptyCellSelected());
                        MoleculeFileEditorAlchemist.this.setActionEnabled("removeMolecule", MoleculeFileEditorAlchemist.this.editor.isNonEmptyCellSelected());
                    }
                }
            });
            this.setActionEnabled("editMolecule", this.editor.isNonEmptyCellSelected());
            this.setActionEnabled("removeMolecule", this.editor.isNonEmptyCellSelected());
        }
        return this.editor;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getEditor(), "Center");
        }
        return this.mainPanel;
    }

    protected AlchemistTableSizeConfigurerComponent getTableSizeConfigurer() {
        if (this.tableSizeConfigurer == null) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MoleculeFileEditorAlchemist.this.getConfigurerPopupMenu() != null && MoleculeFileEditorAlchemist.this.getConfigurerPopupMenu().isVisible()) {
                        MoleculeFileEditorAlchemist.this.getConfigurerPopupMenu().setVisible(false);
                        if (MoleculeFileEditorAlchemist.this.getEditor().getColCount() != MoleculeFileEditorAlchemist.this.getTableSizeConfigurer().getCurrentColCount()) {
                            MoleculeFileEditorAlchemist.this.getEditor().setColCount(MoleculeFileEditorAlchemist.this.getTableSizeConfigurer().getCurrentColCount());
                        }
                        if (MoleculeFileEditorAlchemist.this.getEditor().getRowCount() != MoleculeFileEditorAlchemist.this.getTableSizeConfigurer().getCurrentRowCount()) {
                            MoleculeFileEditorAlchemist.this.getEditor().setRowCount(MoleculeFileEditorAlchemist.this.getTableSizeConfigurer().getCurrentRowCount());
                        }
                        MoleculeFileEditorAlchemist.this.getApplicationState().setPersistentProperty(MoleculeFileEditorAlchemist.PROPERTY_KEY_COLUMN_COUNT, MoleculeFileEditorAlchemist.this.getEditor().getColCount());
                        MoleculeFileEditorAlchemist.this.getApplicationState().setPersistentProperty(MoleculeFileEditorAlchemist.PROPERTY_KEY_ROW_COUNT, MoleculeFileEditorAlchemist.this.getEditor().getRowCount());
                    }
                }
            };
            this.tableSizeConfigurer = new AlchemistTableSizeConfigurerComponent(listener, this.getEditor().getRowCount(), this.getEditor().getColCount(), this.getEditor().getMaxRowCount(), this.getEditor().getMaxColCount());
        }
        return this.tableSizeConfigurer;
    }

    protected JPopupMenu getConfigurerPopupMenu() {
        if (this.configurerPopupMenu == null) {
            this.configurerPopupMenu = new JPopupMenu();
            this.configurerPopupMenu.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.configurerPopupMenu.add(this.getTableSizeConfigurer());
        }
        return this.configurerPopupMenu;
    }

    @Override
    protected String getOpenFileChooserTitle() {
        return "Open Molecule File";
    }

    @Override
    protected String getPropertyFilePath() {
        return DotfileUtil.getDotFile(PERSISTENT_PROPERTY_PATH).getAbsolutePath();
    }

    @Override
    protected String getSaveFileChooserTitle() {
        return "Save Molecule File";
    }

    @Override
    protected void newDocumentActionHandler() {
        super.newDocumentActionHandler();
        this.editor.clear();
        this.refreshDocumentHeader();
    }

    @Override
    protected void openDocumentActionHandler(String path) {
        super.openDocumentActionHandler(path);
        this.editor.importMolecules(path);
        this.refreshDocumentHeader();
    }

    @Override
    protected void saveDocumentActionHandler() {
        super.saveDocumentActionHandler();
        try {
            File tmpFile = File.createTempFile("moleculefileeditor", ".tmp");
            tmpFile.deleteOnExit();
            int position = this.editor.getScrollPosition();
            this.editor.writeToFile(tmpFile, this.getDocumentFormat());
            this.editor.clear();
            FileInputStream istream = new FileInputStream(tmpFile);
            FileChannel input = istream.getChannel();
            FileOutputStream ostream = new FileOutputStream(this.getDocumentPath());
            FileChannel output = ostream.getChannel();
            input.transferTo(0L, input.size(), output);
            input.close();
            output.close();
            ostream.flush();
            istream.close();
            ostream.close();
            tmpFile.delete();
            this.editor.importMolecules(this.getDocumentPath());
            this.editor.setScrollPosition(position);
        }
        catch (IOException e1) {
            AlchemistErrorDialog.showError(this.getApplicationFrame(), "Save Failed", (Exception)e1);
        }
        this.refreshDocumentHeader();
    }

    protected void setActionsEditMode(boolean value) {
        this.setActionEnabled("newDocument", !value);
        this.setActionEnabled("openDocument", !value);
        this.setActionEnabled("saveDocument", !value);
        this.setActionEnabled("saveDocumentAs", !value);
        this.setActionEnabled("addMolecule", !value);
        this.setActionEnabled("setGridSize", !value);
        this.setActionEnabled("editMolecule", !value && this.editor.isNonEmptyCellSelected());
        this.setActionEnabled("removeMolecule", !value && this.editor.isNonEmptyCellSelected());
    }

    protected void addMolecule() {
        this.editor.addMolecule();
    }

    protected void editMolecule() {
        this.editor.editMolecule();
    }

    protected void removeMolecule() {
        this.editor.removeMolecule();
    }

    protected void applyChanges() {
        this.setDocumentChanged(true);
        this.editor.applyChanges();
    }

    protected void discardChanges() {
        this.editor.cancelChanges();
    }

    protected void setGridSize(ActionEvent e) {
        Rectangle bounds = ((JComponent)e.getSource()).getBounds();
        this.getTableSizeConfigurer().setCurrentColCount(this.getEditor().getColCount());
        this.getTableSizeConfigurer().setCurrentRowCount(this.getEditor().getRowCount());
        this.getConfigurerPopupMenu().show((JComponent)e.getSource(), 0, bounds.height);
    }

    @Override
    public void launch() {
        MoleculeFileEditorAlchemist.main(null);
    }

    public static class SetGridSizeAction
    extends AbstractAction {
        private static final long serialVersionUID = 2273241870765561241L;
        public static final String ACTION_ID = "setGridSize";

        @Override
        public void actionPerformed(ActionEvent e) {
            MoleculeFileEditorAlchemist app = (MoleculeFileEditorAlchemist)this.getValue("AlchemistApplication_AppInstance");
            app.setGridSize(e);
        }
    }

    public static class DiscardChangesAction
    extends AbstractAction {
        public static final String ACTION_ID = "discardChanges";
        private static final long serialVersionUID = 6754981040160223782L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MoleculeFileEditorAlchemist app = (MoleculeFileEditorAlchemist)this.getValue("AlchemistApplication_AppInstance");
            app.discardChanges();
        }
    }

    public static class ApplyChangesAction
    extends AbstractAction {
        public static final String ACTION_ID = "applyChanges";
        private static final long serialVersionUID = -6118415171587742295L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MoleculeFileEditorAlchemist app = (MoleculeFileEditorAlchemist)this.getValue("AlchemistApplication_AppInstance");
            app.applyChanges();
        }
    }

    public static class RemoveMoleculeAction
    extends AbstractAction {
        public static final String ACTION_ID = "removeMolecule";
        private static final long serialVersionUID = -1525070555184015680L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MoleculeFileEditorAlchemist app = (MoleculeFileEditorAlchemist)this.getValue("AlchemistApplication_AppInstance");
            app.removeMolecule();
        }
    }

    public static class EditMoleculeAction
    extends AbstractAction {
        public static final String ACTION_ID = "editMolecule";
        private static final long serialVersionUID = -1317692050311589609L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MoleculeFileEditorAlchemist app = (MoleculeFileEditorAlchemist)this.getValue("AlchemistApplication_AppInstance");
            app.editMolecule();
        }
    }

    public static class AddMoleculeAction
    extends AbstractAction {
        public static final String ACTION_ID = "addMolecule";
        private static final long serialVersionUID = 3016950506284985619L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MoleculeFileEditorAlchemist app = (MoleculeFileEditorAlchemist)this.getValue("AlchemistApplication_AppInstance");
            app.addMolecule();
        }
    }
}

