/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor;

import chemaxon.alchemist.AlchemistTask;
import chemaxon.alchemist.utils.AbstractAlchemistMoleculeEditor;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.formats.MolExporter;
import chemaxon.reaction.ConcurrentReactorProcessor;
import chemaxon.reaction.Reactor;
import chemaxon.reaction.Standardizer;
import chemaxon.struc.Molecule;
import chemaxon.util.iterator.MoleculeIterator;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class ReactorAlchemistTask
extends AlchemistTask {
    public static final String PROPERTY_KEY_WAITING_FOR_MANUAL_SELECTION = "ReactorAlchemistTask_WaitingForManualSelection";
    private static final int MAXIMUM_ERROR_COUNT = 1000;
    private final AlchemistState state;
    private long exportedMolecules = 0L;
    private long reactionCount = 0L;
    private boolean ignoreErrors = false;
    private MolExporter exporter = null;
    private boolean productsNeeded;
    private boolean isManualMode;
    private ConcurrentReactorProcessor processor = new ConcurrentReactorProcessor();
    private BlockingQueue<Molecule> sampleQueue = new ArrayBlockingQueue<Molecule>(5);
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private List<Molecule[]> currentSet = null;
    private Molecule[] currentReactants = null;
    private List<Molecule[]> manualResult = null;

    public long getExportedMolecules() {
        return this.exportedMolecules;
    }

    ReactorAlchemistTask(AlchemistState state) {
        this.state = state;
    }

    @Override
    protected void finished() {
        this.statMessage = this.canceled ? "Process has been canceled.\n\n" : "Process completed.\n\n";
        this.statMessage = this.statMessage + "Reactions done: \t" + this.reactionCount + "\n" + (this.productsNeeded ? "Products exported: \t" : "Reactions exported: \t") + this.exportedMolecules + "\n" + "Time elapsed: \t\t" + this.calcTime() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculate() {
        ArrayList<Exception> errorList = new ArrayList<Exception>();
        while (!this.canceled && !this.done) {
            try {
                this.currentSet = this.processor.reactNext();
                this.currentReactants = this.processor.getReactants();
                double progress = this.processor.getProgress();
                long l = this.current = progress == -1.0 ? 1L : (long)((int)(progress * 100.0));
                if (this.currentSet != null) {
                    int i;
                    if (this.isManualMode && this.currentSet.size() > 1) {
                        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_WAITING_FOR_MANUAL_SELECTION, false, true);
                        ReactorAlchemistTask reactorAlchemistTask = this;
                        synchronized (reactorAlchemistTask) {
                            this.wait();
                        }
                        ++this.reactionCount;
                        for (Molecule[] result : this.manualResult) {
                            for (i = 0; i < result.length; ++i) {
                                this.exporter.write(result[i]);
                                ++this.exportedMolecules;
                            }
                        }
                        continue;
                    }
                    for (Molecule[] currentResult : this.currentSet) {
                        if (this.sampleQueue.size() < 1) {
                            if (currentResult.length == 1) {
                                try {
                                    this.sampleQueue.add(currentResult[0].cloneMolecule());
                                }
                                catch (IllegalStateException e) {}
                            } else {
                                Molecule mol = new Molecule();
                                for (int i2 = 0; i2 < currentResult.length; ++i2) {
                                    mol.fuse(currentResult[i2]);
                                }
                                try {
                                    this.sampleQueue.add(mol.cloneMolecule());
                                }
                                catch (IllegalStateException e) {
                                    // empty catch block
                                }
                            }
                        }
                        ++this.reactionCount;
                        for (i = 0; i < currentResult.length; ++i) {
                            this.exporter.write(currentResult[i]);
                            ++this.exportedMolecules;
                        }
                    }
                    continue;
                }
                this.done = true;
            }
            catch (Exception e) {
                if (!this.ignoreErrors) {
                    this.canceled = true;
                    AlchemistErrorDialog.showError("Reactor failed", e);
                    continue;
                }
                if (errorList.size() < 1000) {
                    Exception ex = new Exception("Error at reaction No. " + (this.reactionCount + 1L) + " ", e);
                    errorList.add(ex);
                    continue;
                }
                errorList.add(new Exception("Too many problems occured.", e));
                this.canceled = true;
            }
        }
        try {
            this.exporter.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.ignoreErrors && !errorList.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (int j = 0; j < errorList.size(); ++j) {
                Exception exception = (Exception)errorList.get(j);
                buffer.append("#" + (j + 1) + " " + exception.getMessage());
                buffer.append(exception.getCause().getMessage());
                buffer.append("\n\n");
            }
            AlchemistErrorDialog.showError("There were problems during the process", new Exception(buffer.toString()));
        }
    }

    @Override
    protected long initializeTask() {
        this.done = false;
        this.canceled = false;
        this.exportedMolecules = 0L;
        this.reactionCount = 0L;
        Reactor reactor = new Reactor();
        try {
            boolean reversed = (Boolean)this.state.getProperty("ReactorInputPanel_Reversed");
            Molecule reaction = (Molecule)this.state.getProperty("ReactorInputPanel_SelectedReaction");
            Boolean[] gens = (Boolean[])this.state.getProperty("ReactorOptionsPanel_GenerateBooleanSynthesisCodeFromFilename");
            if (!reversed && ((Boolean)this.state.getProperty("ReactorOptionsPanel_GenerateSynthesisCode")).booleanValue()) {
                if (((Boolean)this.state.getProperty("ReactorOptionsPanel_GenerateSchemaSynthesisCodeFromFilename")).booleanValue()) {
                    reaction.setProperty((String)this.state.getProperty("ReactorOptionsPanel_OutputSynthesisCodeField"), (String)this.state.getProperty("ReactorInputPanel_ReactionFileName") + "#" + this.state.getProperty("ReactorInputPanel_Index"));
                    reactor.setReactionIDPropertyName((String)this.state.getProperty("ReactorOptionsPanel_OutputSynthesisCodeField"));
                } else {
                    reactor.setReactionIDPropertyName((String)this.state.getProperty("ReactorOptionsPanel_SchemaSynthesisCodeField"));
                }
                String[] inputs = (String[])this.state.getProperty("ReactorOptionsPanel_InputSynthesisCodeFields");
                for (int i = 0; i < inputs.length; ++i) {
                    if (!gens[i].booleanValue()) continue;
                    inputs[i] = "ReactorOptionsPanel_OutputSynthesisCodeField";
                }
                reactor.setComponentIDPropertyNames(inputs, new String[]{(String)this.state.getProperty("ReactorOptionsPanel_OutputSynthesisCodeField")});
            }
            reactor.setReaction(reaction);
            reactor.setReverse(reversed);
            File productStandardizationFile = (File)this.state.getProperty("ReactorOptionsPanel_ProductStandardizationFile");
            if (productStandardizationFile.exists()) {
                reactor.setProductStandardizer(new Standardizer((File)this.state.getProperty("ReactorOptionsPanel_ProductStandardizationFile")));
            }
            reactor.setOutputReactionMappingStyle((Integer)this.state.getProperty("ReactorOptionsPanel_MappingStyle"));
            reactor.setShowUnsuccessfulReactions((Boolean)this.state.getProperty("ReactorOptionsPanel_GenerateUnsuccesfulReactions"));
            reactor.setSingle((Boolean)this.state.getProperty("ReactorOptionsPanel_Unambigous"));
            reactor.setIgnoreRules((Integer)this.state.getProperty("ReactorOptionsPanel_Ignore"));
            if (this.state.getProperty("ReactorOptionsPanel_OutputType").equals("Reaction")) {
                reactor.setResultType(1);
                this.productsNeeded = false;
            } else if (this.state.getProperty("ReactorOptionsPanel_OutputType").equals("Product")) {
                reactor.setResultType(0);
                this.productsNeeded = true;
            } else if (this.state.getProperty("ReactorOptionsPanel_OutputType").equals("Fused reaction")) {
                reactor.setResultType(4);
                this.productsNeeded = false;
            }
            int[] ratio = (int[])this.state.getProperty("ReactorOptionsPanel_ReactantRatio");
            boolean allOneRatio = true;
            if (ratio != null) {
                for (int i = 0; i < ratio.length && allOneRatio; ++i) {
                    if (ratio[i] == 1) continue;
                    allOneRatio = false;
                }
                if (!allOneRatio) {
                    reactor.setRatio(ratio);
                }
            }
            if (allOneRatio) {
                String[][] source = (String[][])this.state.getProperty("SourcePropertyNames");
                String[][] target = (String[][])this.state.getProperty("TargetPropertyNames");
                if (source != null && target != null) {
                    reactor.setCopyReactantProperties(source, target);
                }
            }
            if (this.state.getProperty("PatternBasedPropertyMap") instanceof Map) {
                reactor.setCopyReactantProperties((Map)this.state.getProperty("PatternBasedPropertyMap"));
            }
            int[] originalIndexes = (int[])this.state.getProperty("ReactorOptionsPanel_IncludedProducts");
            int[] newIndexes = new int[originalIndexes.length];
            for (int i = 0; i < originalIndexes.length; ++i) {
                newIndexes[i] = originalIndexes[i] + 1;
            }
            reactor.setProductIndexes(newIndexes);
            ArrayList<MoleculeIterator> iteratorList = new ArrayList<MoleculeIterator>();
            MoleculeIterator[] iterators = (MoleculeIterator[])this.state.getProperty("ReactorReactantSelector_ReactantIteratorArray");
            String[] sources = (String[])this.state.getProperty("ReactorReactantSelector_ReactantInputSources");
            for (int i = 0; i < iterators.length; ++i) {
                MoleculeIterator iterator;
                MoleculeIterator moleculeIterator = iterator = iterators[i] instanceof AbstractAlchemistMoleculeEditor.MoleculeIteratorImpl ? (MoleculeIterator)((AbstractAlchemistMoleculeEditor.MoleculeIteratorImpl)iterators[i]).clone() : iterators[i];
                if (!reversed && ((Boolean)this.state.getProperty("ReactorOptionsPanel_GenerateSynthesisCode")).booleanValue() && gens[i].booleanValue()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(sources[i]);
                    builder.append(i + 1);
                    builder.append("#");
                    iterator = new CountPropertyInjectorMoleculeIterator(iterators[i] instanceof AbstractAlchemistMoleculeEditor.MoleculeIteratorImpl ? (MoleculeIterator)((AbstractAlchemistMoleculeEditor.MoleculeIteratorImpl)iterators[i]).clone() : iterators[i], builder.toString(), "ReactorOptionsPanel_OutputSynthesisCodeField");
                }
                iteratorList.add(iterator);
            }
            String mode = (String)this.state.getProperty("ReactorOptionsPanel_MultipleProcMode");
            this.processor.setReactor(reactor);
            this.processor.setReactantIterators(iteratorList.toArray(new MoleculeIterator[iterators.length]), mode.equalsIgnoreCase("Combinatorial") ? 1 : 0);
            String outputFormat = ((String)this.state.getProperty("ReactorOptionsPanel_OutputFormat")).equals("smiles") ? "smiles:q" : (String)this.state.getProperty("ReactorOptionsPanel_OutputFormat");
            String outputFilePath = (String)this.state.getProperty("ReactorOptionsPanel_OutputPath");
            this.exporter = new MolExporter(new FileOutputStream(outputFilePath), outputFormat);
            this.exporter.setClean(2, null, MolExporter.FILTER_DIM0);
            this.ignoreErrors = (Boolean)this.state.getProperty("ReactorOptionsPanel_IgnoreErrors");
            this.isManualMode = (Boolean)this.state.getProperty("ReactorOptionsPanel_ManualSelection");
        }
        catch (Exception e) {
            this.canceled = true;
            AlchemistErrorDialog.showError("Reactor failed", e);
        }
        return this.canceled ? 0L : 100L;
    }

    public boolean isProductsNeeded() {
        return this.productsNeeded;
    }

    public Molecule getSampleMolecule() {
        try {
            return this.sampleQueue.poll(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public long getReactionCount() {
        return this.reactionCount;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ReactorAlchemistTask clone = (ReactorAlchemistTask)super.clone();
        clone.processor = new ConcurrentReactorProcessor();
        clone.sampleQueue = new ArrayBlockingQueue<Molecule>(5);
        clone.exporter = null;
        clone.propertyChangeSupport = new PropertyChangeSupport(clone);
        return clone;
    }

    List<Molecule[]> getCurrentSet() {
        return this.currentSet;
    }

    Molecule[] getCurrentReactants() {
        return this.currentReactants;
    }

    void setManualResult(List<Molecule[]> result) {
        this.manualResult = result;
    }

    private static final class CountPropertyInjectorMoleculeIterator
    implements MoleculeIterator {
        private final MoleculeIterator iterator;
        private final String propertyName;
        private final String prefix;
        private long counter = 1L;

        public CountPropertyInjectorMoleculeIterator(MoleculeIterator iterator, String prefix, String propertyName) {
            this.iterator = iterator;
            this.propertyName = propertyName;
            this.prefix = prefix;
        }

        @Override
        public Molecule next() {
            Molecule mol = this.iterator.next();
            if (mol != null) {
                mol.setProperty(this.propertyName, this.prefix + this.counter++);
            }
            return mol;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Throwable getThrowable() {
            return this.iterator.getThrowable();
        }

        @Override
        public double estimateProgress() {
            return this.iterator.estimateProgress();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

