/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.reactor.reactioneditor.ReactionEditorPanel;
import chemaxon.alchemist.utils.AbstractFilterListModel;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.ListableMolecule;
import chemaxon.alchemist.utils.NumberedRenderer;
import chemaxon.alchemist.utils.SimpleAlchemistMoleculeView;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReactorInputPanel
extends AlchemistPage {
    private static final String PROPERTY_KEY_SERIAL = "serial";
    private static final int NUMBER_OF_RECENT_FILES = 10;
    public static final String PROPERTY_KEY_RECENT_FILES_PREFIX = "ReactorInputPanel_RecentFile";
    private final MouseAdapter doubleClickListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                if (ReactorInputPanel.this.getCmbReactionFile().getSelectedItem() != null) {
                    ReactorInputPanel.this.SET_STATE_ACTION.actionPerformed(new ActionEvent(this, 0, ReactorInputPanel.STATE_SHOW_EDITOR_EDIT));
                } else if (ReactorInputPanel.this.allowManualMode) {
                    ReactorInputPanel.this.getSketchPane().setMol(ReactorInputPanel.this.getLstReactions().getModel().getSize() > 0 ? ((ListableMolecule)ReactorInputPanel.this.getLstReactions().getModel().getElementAt(0)).getMolecule() : new Molecule());
                    ReactorInputPanel.this.panelState = ReactorInputPanel.PANEL_SKETCH;
                    ((CardLayout)ReactorInputPanel.this.getContentPanel().getLayout()).show(ReactorInputPanel.this.getContentPanel(), ReactorInputPanel.PANEL_SKETCH);
                    ReactorInputPanel.this.getNotifier().firePropertyChange(ReactorInputPanel.PROPERTY_KEY_PANEL_STATE, null, ReactorInputPanel.this.panelState);
                }
            }
        }
    };
    public static final String PROPERTY_KEY_REACTION_FILE_NAME = "ReactorInputPanel_ReactionFileName";
    public static final String PROPERTY_KEY_REACTION_INDEX = "ReactorInputPanel_Index";
    public static final String PROPERTY_KEY_REACTION_LIST = "ReactorInputPanel_ReactionList";
    public static final String PROPERTY_KEY_REVERSED = "ReactorInputPanel_Reversed";
    public static final String PROPERTY_KEY_REACTION_LAST_USED_DIR = "ReactorInputPanel_LastUsedDir";
    public static final String PROPERTY_KEY_REACTION_LAST_USED_REACTION_FILE = "ReactorInputPanel_LastUsedReactionFile";
    public static final String PROPERTY_KEY_SELECTED_REACTION = "ReactorInputPanel_SelectedReaction";
    public static final String PROPERTY_KEY_SELECTED_REACTION_NAME = "ReactorInputPanel_SelectedReactionName";
    public static final String PROPERTY_KEY_PANEL_STATE = "ReactorInputPanel_Initialized";
    public static final String PANEL_NORMAL = "Panel_Normal";
    public static final String PANEL_DISABLED = "Panel_Disabled";
    public static final String PANEL_EDITOR = "Panel_Editor";
    public static final String PANEL_SKETCH = "Panel_Sketch";
    private String panelState = null;
    private static final String PROPERTY_EXAMPLE = "EXAMPLE";
    private static final String STATE_SHOW_EDITOR_EDIT = "Edit";
    private static final String STATE_SHOW_EDITOR_NEW = "New";
    private static final long serialVersionUID = -264880069432070545L;
    private JPanel pnlContent = null;
    private JPanel disabledPanel = null;
    private JCheckBox chkReversed = null;
    private JScrollPane scrlpReactions = null;
    protected JList lstReactions = null;
    protected JComboBox cmbReactionFile = null;
    private JPanel pnlFile = null;
    private JLabel jLabel = null;
    private JButton buttOpenFile = null;
    protected AlchemistFileChooserForJChem openDialog = null;
    private JPanel pnlInfo = null;
    private ClickableSimpleAlchemistMoleculeView mview = null;
    private ReactionEditorPanel editor = null;
    private JButton buttEdit = null;
    private JButton buttNew = null;
    private JButton clearButton = null;
    private MSketchPane sketchPane = null;
    private JPanel sketchPanel = null;
    private JTextArea filterText = null;
    private boolean initializing = false;
    private BufferedImage disabledImage = null;
    private final boolean allowManualMode;
    private final Action OPEN_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 8190137561307637751L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int rVal;
            if (ReactorInputPanel.this.openDialog != null && (rVal = ReactorInputPanel.this.openDialog.showOpenDialog(null)) == 0) {
                File file = ReactorInputPanel.this.openDialog.getSelectedFile();
                ReactorInputPanel.this.openReactionFile(file);
            }
        }
    };
    protected final Action SET_STATE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -5052201959456212554L;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equalsIgnoreCase(ReactorInputPanel.STATE_SHOW_EDITOR_EDIT) || event.getActionCommand().equalsIgnoreCase(ReactorInputPanel.STATE_SHOW_EDITOR_NEW)) {
                ReactorInputPanel.this.getContentPanel().add((Component)ReactorInputPanel.this.getEditor(), ReactorInputPanel.PANEL_EDITOR);
                final String actionCommand = event.getActionCommand();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReactorInputPanel.this.setTopTextVisible(false);
                        ReactorInputPanel.this.getEditor().setPreferredSize(ReactorInputPanel.this.getSize());
                        ReactorInputPanel.this.getEditor().setEnabled(false);
                        ReactorInputPanel.this.setPanelState(ReactorInputPanel.PANEL_EDITOR);
                        ((CardLayout)ReactorInputPanel.this.getContentPanel().getLayout()).show(ReactorInputPanel.this.getContentPanel(), ReactorInputPanel.PANEL_EDITOR);
                        ReactorInputPanel.this.getNotifier().firePropertyChange(ReactorInputPanel.PROPERTY_KEY_PANEL_STATE, null, ReactorInputPanel.this.getPanelState());
                    }
                });
                Thread loadThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (ReactorInputPanel.this.cmbReactionFile.getSelectedItem() != null) {
                            ReactorInputPanel.this.getEditor().setReactionFile(actionCommand.equalsIgnoreCase(ReactorInputPanel.STATE_SHOW_EDITOR_EDIT) ? ReactorInputPanel.this.cmbReactionFile.getSelectedItem().toString() : "");
                            ReactorInputPanel.this.getEditor().setSelectedReaction(actionCommand.equalsIgnoreCase(ReactorInputPanel.STATE_SHOW_EDITOR_EDIT) ? ReactorInputPanel.this.lstReactions.getSelectedIndex() : 0);
                        } else {
                            ReactorInputPanel.this.getEditor().clear();
                            ReactorInputPanel.this.getEditor().setReactionFile("");
                        }
                        ReactorInputPanel.this.getEditor().refresh();
                    }
                });
                loadThread.setPriority(4);
                loadThread.start();
                ReactorInputPanel.this.getNotifier().firePropertyChange("Alchemist_Enable", true, false);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReactorInputPanel.this.setTopTextVisible(true);
                        ReactorInputPanel.this.getEditor().clear();
                        ReactorInputPanel.this.getEditor().setVisible(false);
                        ReactorInputPanel.this.getContentPanel().remove(ReactorInputPanel.this.getEditor());
                        ReactorInputPanel.this.setPanelState(ReactorInputPanel.PANEL_NORMAL);
                        ((CardLayout)ReactorInputPanel.this.getContentPanel().getLayout()).show(ReactorInputPanel.this.getContentPanel(), ReactorInputPanel.PANEL_NORMAL);
                        ReactorInputPanel.this.getNotifier().firePropertyChange(ReactorInputPanel.PROPERTY_KEY_PANEL_STATE, null, ReactorInputPanel.this.getPanelState());
                    }
                });
                int selectedIndex = ReactorInputPanel.this.lstReactions.getSelectedIndex();
                if (event.getActionCommand().equalsIgnoreCase("Apply")) {
                    ReactorInputPanel.this.readReactionFile(new File(ReactorInputPanel.this.cmbReactionFile.getSelectedItem().toString()), true);
                } else if (event.getActionCommand().startsWith("Apply")) {
                    ReactorInputPanel.this.readReactionFile(new File(event.getActionCommand().split("Apply")[1]), true);
                    ReactorInputPanel.this.setItemToCombo(event.getActionCommand().split("Apply")[1]);
                }
                ReactorInputPanel.this.lstReactions.setSelectedIndex(ReactorInputPanel.this.lstReactions.getModel().getSize() > selectedIndex ? selectedIndex : 0);
                ReactorInputPanel.this.getNotifier().firePropertyChange("Alchemist_Enable", false, true);
            }
        }
    };
    private JSplitPane splitPane = null;
    private JPanel contentPanel = null;

    public ReactorInputPanel() {
        this(false);
    }

    public ReactorInputPanel(boolean allowManualMode) {
        this.allowManualMode = allowManualMode;
        this.initialize();
    }

    protected ReactionEditorPanel getEditor() {
        if (this.editor == null) {
            this.editor = new ReactionEditorPanel(1, this.SET_STATE_ACTION);
        }
        return this.editor;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(351, 338));
        this.add((Component)this.getContentPanel(), "Center");
        try {
            this.openDialog = new AlchemistFileChooserForJChem();
            this.openDialog.addReactionOpenFileFilters();
            this.openDialog.setDialogTitle("Open reaction library");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isCorrect() {
        Object selected = this.getLstReactions().getSelectedValue();
        if (selected instanceof ListableMolecule) {
            return ((ListableMolecule)selected).getMolecule().isReaction() && PANEL_NORMAL.equals(this.panelState);
        }
        return false;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.pnlContent = new JPanel();
            CellConstraints cc = new CellConstraints();
            this.pnlContent.setLayout((LayoutManager)new FormLayout("4dlu, fill:min:grow, 4dlu", "4dlu, min, 2dlu, fill:pref:grow, 2dlu, min, 2dlu, min, 4dlu"));
            this.pnlContent.add((Component)this.getPnlFile(), cc.xy(2, 2));
            this.pnlContent.add((Component)this.getScrlpReactions(), cc.xy(2, 4));
            this.pnlContent.add((Component)this.getFilterText(), cc.xy(2, 6));
            this.pnlContent.add((Component)this.getChkReversed(), cc.xy(2, 8));
        }
        return this.pnlContent;
    }

    private JCheckBox getChkReversed() {
        if (this.chkReversed == null) {
            this.chkReversed = new JCheckBox("Reverse direction");
        }
        return this.chkReversed;
    }

    private JScrollPane getScrlpReactions() {
        if (this.scrlpReactions == null) {
            this.scrlpReactions = new JScrollPane();
            this.scrlpReactions.setViewportView(this.getLstReactions());
        }
        return this.scrlpReactions;
    }

    private JList getLstReactions() {
        if (this.lstReactions == null) {
            this.lstReactions = new JList(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (ReactorInputPanel.this.allowManualMode && ReactorInputPanel.this.lstReactions.getModel().getSize() < 1) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        AlchemistGraphicsUtilities.renderMessageOnComponent(g, "<Open a reaction file, or double-click here to draw a reaction>", Color.GRAY, this.getWidth(), this.getHeight());
                    }
                }
            };
            this.lstReactions.setModel(new AbstractFilterListModel(){

                @Override
                protected boolean filter(Object element) {
                    if (ReactorInputPanel.this.getFilterText().getText().length() == 0) {
                        return true;
                    }
                    Molecule molecule = ((ListableMolecule)element).getMolecule();
                    StringBuilder haystack = new StringBuilder();
                    haystack.append(String.valueOf(molecule.getProperty("NAME")).toLowerCase() + " ");
                    haystack.append(String.valueOf(molecule.getProperty("AUTHOR")).toLowerCase() + " ");
                    haystack.append(String.valueOf(molecule.getProperty("REFERENCES")).toLowerCase() + " ");
                    String[] needles = ReactorInputPanel.this.getFilterText().getText().toLowerCase().split(" ");
                    for (int i = 0; i < needles.length; ++i) {
                        if (!haystack.toString().contains(needles[i])) continue;
                        return true;
                    }
                    return false;
                }
            });
            this.lstReactions.setSelectionMode(0);
            this.lstReactions.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.lstReactions.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ReactorInputPanel.this.updateReactionView();
                    ReactorInputPanel.this.getButtEdit().setEnabled(ReactorInputPanel.this.lstReactions.getModel().getSize() != 0 && ReactorInputPanel.this.getCmbReactionFile().getSelectedItem() != null);
                    ReactorInputPanel.this.getNotifier().firePropertyChange(ReactorInputPanel.PROPERTY_KEY_REACTION_LIST, null, ((AbstractFilterListModel)ReactorInputPanel.this.lstReactions.getModel()).elements());
                }
            });
            this.lstReactions.setCellRenderer(new NumberedRenderer(this.lstReactions.getCellRenderer()));
            this.lstReactions.addMouseListener(this.getDoubleClickListener());
        }
        return this.lstReactions;
    }

    private JTextArea getFilterText() {
        if (this.filterText == null) {
            this.filterText = new JTextArea(){

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    if (ReactorInputPanel.this.getFilterText().getText().length() == 0) {
                        Graphics g2 = g.create();
                        AlchemistGraphicsUtilities.renderMessageOnComponent(g2, "<Type keywords to narrow reaction list>", Color.GRAY, this.getWidth(), this.getHeight());
                        g2.dispose();
                    }
                }
            };
            this.filterText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    ((AbstractFilterListModel)ReactorInputPanel.this.getLstReactions().getModel()).filter();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
            this.filterText.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        return this.filterText;
    }

    private JComboBox getCmbReactionFile() {
        if (this.cmbReactionFile == null) {
            this.cmbReactionFile = new JComboBox();
            this.cmbReactionFile.setPrototypeDisplayValue("use my width");
            this.cmbReactionFile.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    label.setToolTipText(label.getText());
                    return label;
                }
            });
            this.cmbReactionFile.setEditable(false);
            this.cmbReactionFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorInputPanel.this.cmbReactionFile.setToolTipText(ReactorInputPanel.this.cmbReactionFile.getSelectedItem() == null ? "No file selected" : ReactorInputPanel.this.cmbReactionFile.getSelectedItem().toString());
                    ReactorInputPanel.this.getNotifier().firePropertyChange(ReactorInputPanel.PROPERTY_KEY_REACTION_LAST_USED_REACTION_FILE, null, ReactorInputPanel.this.cmbReactionFile.getSelectedItem() == null ? "" : ReactorInputPanel.this.cmbReactionFile.getSelectedItem().toString());
                    if (!ReactorInputPanel.this.initializing && ReactorInputPanel.this.cmbReactionFile.getSelectedItem() != null) {
                        final File f = new File(ReactorInputPanel.this.cmbReactionFile.getSelectedItem().toString());
                        ((AbstractFilterListModel)ReactorInputPanel.this.lstReactions.getModel()).clear();
                        if (f.canRead()) {
                            ReactorInputPanel.this.setDisabledImage(AlchemistGraphicsUtilities.createDisabledImage(ReactorInputPanel.this.getContentPanel()));
                            ReactorInputPanel.this.getNotifier().firePropertyChange("Alchemist_Enable", true, false);
                            ReactorInputPanel.this.setPanelState(ReactorInputPanel.PANEL_DISABLED);
                            ((CardLayout)ReactorInputPanel.this.getContentPanel().getLayout()).show(ReactorInputPanel.this.getContentPanel(), ReactorInputPanel.PANEL_DISABLED);
                            ReactorInputPanel.this.getNotifier().firePropertyChange(ReactorInputPanel.PROPERTY_KEY_PANEL_STATE, null, ReactorInputPanel.this.getPanelState());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ReactorInputPanel.this.readReactionFile(f, true);
                                    ReactorInputPanel.this.setPanelState(ReactorInputPanel.PANEL_NORMAL);
                                    ((CardLayout)ReactorInputPanel.this.getContentPanel().getLayout()).show(ReactorInputPanel.this.getContentPanel(), ReactorInputPanel.PANEL_NORMAL);
                                    ReactorInputPanel.this.getNotifier().firePropertyChange(ReactorInputPanel.PROPERTY_KEY_PANEL_STATE, null, ReactorInputPanel.this.getPanelState());
                                    ReactorInputPanel.this.getNotifier().firePropertyChange("Alchemist_Enable", false, true);
                                }
                            });
                        } else {
                            AlchemistErrorDialog.showError("Could not open file: " + f.getAbsolutePath());
                        }
                    }
                }
            });
        }
        return this.cmbReactionFile;
    }

    private JPanel getPnlFile() {
        if (this.pnlFile == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Reaction File:");
            CellConstraints cc = new CellConstraints();
            this.pnlFile = new JPanel((LayoutManager)new FormLayout("2dlu, min, 2dlu, fill:min:grow, 2dlu, min, 2dlu, min, 2dlu, min, 2dlu, min, 4dlu", "4dlu, fill:pref, 4dlu"));
            this.pnlFile.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.pnlFile.add((Component)this.jLabel, cc.xy(2, 2));
            this.pnlFile.add((Component)this.getCmbReactionFile(), cc.xy(4, 2));
            this.pnlFile.add((Component)this.getClearButton(), cc.xy(6, 2));
            this.pnlFile.add((Component)this.getButtOpenFile(), cc.xy(8, 2));
            this.pnlFile.add((Component)this.getButtNew(), cc.xy(10, 2));
            this.pnlFile.add((Component)this.getButtEdit(), cc.xy(12, 2));
        }
        return this.pnlFile;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton(new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/clear.gif")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((AbstractFilterListModel)ReactorInputPanel.this.lstReactions.getModel()).clear();
                    ReactorInputPanel.this.getCmbReactionFile().setSelectedItem(null);
                }
            });
        }
        return this.clearButton;
    }

    private JButton getButtOpenFile() {
        if (this.buttOpenFile == null) {
            this.buttOpenFile = new JButton(this.OPEN_ACTION);
            this.buttOpenFile.setText("Open");
        }
        return this.buttOpenFile;
    }

    protected JButton getButtEdit() {
        if (this.buttEdit == null) {
            this.buttEdit = new JButton(this.SET_STATE_ACTION);
            this.buttEdit.setText(STATE_SHOW_EDITOR_EDIT);
            this.buttEdit.setMnemonic(69);
        }
        return this.buttEdit;
    }

    private JButton getButtNew() {
        if (this.buttNew == null) {
            this.buttNew = new JButton(this.SET_STATE_ACTION);
            this.buttNew.setText(STATE_SHOW_EDITOR_NEW);
        }
        return this.buttNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readReactionFile(File fileToRead, boolean silent) {
        MolImporter importer = null;
        try {
            ((AbstractFilterListModel)this.lstReactions.getModel()).clear();
            importer = new MolImporter(fileToRead, "");
            Molecule mol = importer.read();
            while (mol != null) {
                ListableMolecule item = new ListableMolecule(mol);
                ((AbstractFilterListModel)this.lstReactions.getModel()).addElement(item);
                mol = importer.read();
            }
            importer.close();
            if (this.lstReactions.getModel().getSize() != 0) {
                this.lstReactions.setSelectedIndex(0);
            }
            this.openDialog.setCurrentDirectory(fileToRead.getParentFile());
        }
        catch (IOException e) {
            if (!silent) {
                AlchemistErrorDialog.showError("Error occured while opening file", (Exception)e);
            }
        }
        finally {
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private JPanel getPnlInfo() {
        if (this.pnlInfo == null) {
            this.pnlInfo = new JPanel();
            this.pnlInfo.setPreferredSize(new Dimension(0, 100));
            this.pnlInfo.setLayout(new BorderLayout());
            this.pnlInfo.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.mview = new ClickableSimpleAlchemistMoleculeView();
            this.mview.setMinimumSize(new Dimension(0, 100));
            this.pnlInfo.add((Component)this.mview, "Center");
        }
        return this.pnlInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateReactionView() {
        if (this.lstReactions.getSelectedIndex() != -1) {
            Molecule selectedmolecule = ((ListableMolecule)this.lstReactions.getSelectedValue()).getMolecule();
            if (selectedmolecule.getProperty(PROPERTY_EXAMPLE) != null) {
                String examples = selectedmolecule.getProperty(PROPERTY_EXAMPLE);
                if (examples != null) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(examples.getBytes());
                    MolImporter imp = null;
                    try {
                        imp = new MolImporter(bis);
                        Molecule xmol = imp.read();
                        imp.close();
                        this.mview.setMolecule(0, 0, xmol);
                    }
                    catch (Exception e) {
                        this.mview.setMolecule(0, 0, new Molecule());
                    }
                    finally {
                        try {
                            if (imp != null) {
                                imp.close();
                            }
                        }
                        catch (IOException e) {}
                    }
                } else {
                    try {
                        this.mview.setMolecule(0, 0, selectedmolecule);
                    }
                    catch (Exception e) {
                        this.mview.setMolecule(0, 0, new Molecule());
                    }
                }
            } else {
                try {
                    this.mview.setMolecule(0, 0, selectedmolecule);
                }
                catch (Exception e) {
                    this.mview.setMolecule(0, 0, new Molecule());
                }
            }
        } else {
            this.mview.setMolecule(0, 0, new Molecule());
        }
    }

    @Override
    public void enterPage(AlchemistState state) {
        String lastfile;
        this.setInitializing(true);
        this.getEditor().enterPage(state);
        int index = 1;
        String recent = null;
        do {
            if ((recent = (String)state.getProperty(PROPERTY_KEY_RECENT_FILES_PREFIX + index)) != null) {
                this.addItemToCombo(recent);
            }
            ++index;
        } while (recent != null);
        String path = (String)state.getProperty(PROPERTY_KEY_REACTION_LAST_USED_DIR);
        if (path != null) {
            this.openDialog.setCurrentDirectory(new File(path));
        }
        if ((lastfile = (String)state.getProperty(PROPERTY_KEY_REACTION_LAST_USED_REACTION_FILE)) != null && new File(lastfile).canRead()) {
            this.setItemToCombo(lastfile);
            if (this.lstReactions.getModel().getSize() == 0) {
                this.readReactionFile(new File(lastfile), true);
            }
        }
        this.getButtEdit().setEnabled(this.lstReactions.getModel().getSize() != 0);
        this.setInitializing(false);
    }

    @Override
    public void leavePage(AlchemistState state) {
        this.getEditor().leavePage(state);
        state.setPersistentProperty(PROPERTY_KEY_REACTION_LAST_USED_DIR, this.openDialog.getCurrentDirectory().getAbsolutePath());
        if (this.getCmbReactionFile().getSelectedItem() != null) {
            state.setPersistentProperty(PROPERTY_KEY_REACTION_LAST_USED_REACTION_FILE, this.cmbReactionFile.getSelectedItem().toString());
            state.setProperty(PROPERTY_KEY_REACTION_FILE_NAME, new File(this.getReactionFilePath()).getName());
        } else {
            state.setProperty(PROPERTY_KEY_REACTION_LAST_USED_REACTION_FILE, null);
            state.setProperty(PROPERTY_KEY_REACTION_FILE_NAME, "Sketched reaction");
        }
        ListableMolecule reaction = (ListableMolecule)this.lstReactions.getSelectedValue();
        if (reaction != null) {
            state.setProperty(PROPERTY_KEY_SELECTED_REACTION, reaction.getMolecule());
            state.setProperty(PROPERTY_KEY_SELECTED_REACTION_NAME, reaction.toString());
        }
        state.setProperty(PROPERTY_KEY_REVERSED, this.getChkReversed().isSelected());
        for (int i = 0; i < this.cmbReactionFile.getModel().getSize(); ++i) {
            state.setPersistentProperty(PROPERTY_KEY_RECENT_FILES_PREFIX + (i + 1), this.cmbReactionFile.getItemAt(i).toString());
        }
        state.setProperty(PROPERTY_KEY_REACTION_INDEX, this.getLstReactions().getSelectedIndex() + 1);
    }

    public void setReactionFilePath(String path) {
        this.openReactionFile(new File(path));
    }

    public String getReactionFilePath() {
        return this.getCmbReactionFile().getSelectedItem().toString();
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setBorder(null);
            this.splitPane.setOrientation(0);
            this.splitPane.setName("splitPane");
            this.splitPane.setBottomComponent(this.getPnlInfo());
            this.splitPane.setTopComponent(this.getPnlContent());
            this.splitPane.setResizeWeight(1.0);
        }
        return this.splitPane;
    }

    protected synchronized void openReactionFile(final File file) {
        this.setDisabledImage(AlchemistGraphicsUtilities.createDisabledImage(this.getContentPanel()));
        Thread loadingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReactorInputPanel.this.getContentPanel().setCursor(Cursor.getPredefinedCursor(3));
                ((CardLayout)ReactorInputPanel.this.getContentPanel().getLayout()).show(ReactorInputPanel.this.getContentPanel(), ReactorInputPanel.PANEL_DISABLED);
                ReactorInputPanel.this.setPanelState(ReactorInputPanel.PANEL_DISABLED);
                ReactorInputPanel.this.getNotifier().firePropertyChange(ReactorInputPanel.PROPERTY_KEY_PANEL_STATE, null, ReactorInputPanel.this.getPanelState());
                ReactorInputPanel.this.readReactionFile(file, true);
                ReactorInputPanel.this.setItemToCombo(file.getAbsolutePath());
                ReactorInputPanel.this.getButtEdit().setEnabled(ReactorInputPanel.this.lstReactions.getModel().getSize() != 0);
                ((CardLayout)ReactorInputPanel.this.getContentPanel().getLayout()).show(ReactorInputPanel.this.getContentPanel(), ReactorInputPanel.PANEL_NORMAL);
                ReactorInputPanel.this.setPanelState(ReactorInputPanel.PANEL_NORMAL);
                ReactorInputPanel.this.getNotifier().firePropertyChange(ReactorInputPanel.PROPERTY_KEY_PANEL_STATE, null, ReactorInputPanel.this.getPanelState());
                ReactorInputPanel.this.getContentPanel().setCursor(Cursor.getDefaultCursor());
            }
        });
        loadingThread.setPriority(4);
        loadingThread.start();
    }

    protected void setItemToCombo(String item) {
        this.addItemToCombo(item);
        this.cmbReactionFile.setSelectedItem(item);
    }

    private void addItemToCombo(String item) {
        boolean found = false;
        for (int i = 0; i < this.cmbReactionFile.getModel().getSize() && !found; ++i) {
            if (!this.cmbReactionFile.getItemAt(i).equals(item)) continue;
            found = true;
        }
        if (!found) {
            ((MutableComboBoxModel)this.cmbReactionFile.getModel()).insertElementAt(item, 0);
        }
        if (this.cmbReactionFile.getModel().getSize() > 10) {
            ((MutableComboBoxModel)this.cmbReactionFile.getModel()).removeElementAt(this.cmbReactionFile.getModel().getSize() - 1);
        }
    }

    private JPanel getDisabledPanel() {
        if (this.disabledPanel == null) {
            this.disabledPanel = new JPanel(){
                private static final long serialVersionUID = -4094584661561155032L;

                @Override
                public void paintComponent(Graphics g) {
                    if (ReactorInputPanel.this.getDisabledImage() != null) {
                        g.drawImage(ReactorInputPanel.this.getDisabledImage(), 0, 0, null);
                    }
                }
            };
        }
        return this.disabledPanel;
    }

    protected JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            CardLayout cl = new CardLayout();
            this.contentPanel.setLayout(cl);
            this.contentPanel.add((Component)this.getSplitPane(), PANEL_NORMAL);
            this.contentPanel.add((Component)this.getDisabledPanel(), PANEL_DISABLED);
            this.contentPanel.add((Component)this.getSketchPanel(), PANEL_SKETCH);
            cl.show(this.contentPanel, PANEL_NORMAL);
            this.setPanelState(PANEL_NORMAL);
            this.getNotifier().firePropertyChange(PROPERTY_KEY_PANEL_STATE, null, this.getPanelState());
        }
        return this.contentPanel;
    }

    private MSketchPane getSketchPane() {
        if (this.sketchPane == null) {
            this.sketchPane = new MSketchPane();
        }
        return this.sketchPane;
    }

    private void hideSketch() {
        this.panelState = PANEL_NORMAL;
        ((CardLayout)this.getContentPanel().getLayout()).show(this.getContentPanel(), PANEL_NORMAL);
        this.getNotifier().firePropertyChange(PROPERTY_KEY_PANEL_STATE, null, this.panelState);
        this.updateReactionView();
    }

    private JPanel getSketchPanel() {
        if (this.sketchPanel == null) {
            this.sketchPanel = new JPanel(new BorderLayout());
            this.sketchPanel.add((Component)this.getSketchPane(), "Center");
            JPanel southPanel = new JPanel();
            southPanel.setLayout(new BoxLayout(southPanel, 0));
            southPanel.add(Box.createHorizontalGlue());
            southPanel.add(new JButton(new AbstractAction("Accept"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Molecule mol = ReactorInputPanel.this.getSketchPane().getDocument().cloneMainMolecule();
                    mol.setProperty("NAME", "Sketched reaction");
                    if (ReactorInputPanel.this.lstReactions.getModel().getSize() < 1) {
                        ((AbstractFilterListModel)ReactorInputPanel.this.getLstReactions().getModel()).addElement(new ListableMolecule(mol));
                    } else {
                        ((AbstractFilterListModel)ReactorInputPanel.this.getLstReactions().getModel()).setElementAt(new ListableMolecule(mol), 0);
                    }
                    ReactorInputPanel.this.hideSketch();
                }
            }));
            southPanel.add(new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorInputPanel.this.hideSketch();
                }
            }));
            southPanel.add(Box.createHorizontalGlue());
            this.sketchPanel.add((Component)southPanel, "South");
        }
        return this.sketchPanel;
    }

    public RxnMolecule[] getReactions() {
        RxnMolecule[] reactions = new RxnMolecule[this.getLstReactions().getModel().getSize()];
        for (int i = 0; i < reactions.length; ++i) {
            reactions[i] = RxnMolecule.getReaction(((ListableMolecule)this.getLstReactions().getModel().getElementAt(i)).getMolecule());
        }
        return reactions;
    }

    public String getPanelState() {
        return this.panelState;
    }

    public void setReverseOptionVisible(boolean visible) {
        this.getChkReversed().setVisible(visible);
    }

    public boolean isReverseOptionVisible() {
        return this.getChkReversed().isVisible();
    }

    public void setInitializing(boolean b) {
        this.initializing = b;
    }

    protected MouseAdapter getDoubleClickListener() {
        return this.doubleClickListener;
    }

    protected void setDisabledImage(BufferedImage disabledImage) {
        this.disabledImage = disabledImage;
    }

    protected BufferedImage getDisabledImage() {
        return this.disabledImage;
    }

    protected void setPanelState(String panelState) {
        this.panelState = panelState;
    }

    protected boolean isInitializing() {
        return this.initializing;
    }

    private final class ClickableSimpleAlchemistMoleculeView
    extends SimpleAlchemistMoleculeView {
        private static final long serialVersionUID = -1261058181862222612L;

        protected ClickableSimpleAlchemistMoleculeView() {
            super(1, 1, false);
            this.view.addMouseListener(ReactorInputPanel.this.getDoubleClickListener());
        }
    }
}

