/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor;

import chemaxon.alchemist.AlchemistTask;
import chemaxon.alchemist.commonpages.ProgressPanel;
import chemaxon.alchemist.reactor.ReactorAlchemistTask;
import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.SimpleAlchemistMoleculeView;
import chemaxon.marvin.MolPrinter;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ReactorProgressPanel
extends ProgressPanel {
    public static final String PROPERTY_KEY_SHOW_SAMPLES = "ReactorProgressPanel_ShowSamples";
    private static final String PROGRESS_CAPTION = "<html>Operation in progress...<br><br><br></html>";
    private static final long serialVersionUID = 6589131714283199389L;
    private static final int SAMPLE_REFRESH_RATE = 3000;
    private static final String SAMPLE_PANEL = "SamplePanel";
    private static final String SELECTION_PANEL = "SelectionPanel";
    private SimpleAlchemistMoleculeView sampleView;
    private JCheckBox sampleCheckBox;
    private JLabel messageLabel;
    private JPanel panel;
    private JPanel cardHolderPanel;
    private JPanel selectorPanel;
    private JPanel selectorGrid;
    private long lastChecked = 0L;
    private List<Molecule[]> reactorResults = null;
    boolean[] selectionState = null;

    @Override
    public void refreshInformations() {
        super.refreshInformations();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactorProgressPanel.this.setCaption("<html><center>" + ReactorProgressPanel.this.getCurrentTask().getReactionCount() + " reactions performed, " + ReactorProgressPanel.this.getCurrentTask().getExportedMolecules() + (ReactorProgressPanel.this.getCurrentTask().isProductsNeeded() ? " products exported<br>" : " reactions exported<br>") + "elapsed time: " + ReactorProgressPanel.this.getCurrentTask().getElapsedTime() + "<br>" + "estimated time left: " + ReactorProgressPanel.this.getCurrentTask().getEstimatedTime() + "</center></html>", 1);
                if (ReactorProgressPanel.this.getSampleCheckBox().isSelected()) {
                    try {
                        Molecule mol;
                        if (ReactorProgressPanel.this.getLastChecked() + 3000L < System.currentTimeMillis() && (mol = ReactorProgressPanel.this.getCurrentTask().getSampleMolecule()) != null) {
                            ReactorProgressPanel.this.getSampleView().setMolecule(0, 0, mol);
                            ReactorProgressPanel.this.setLastChecked(System.currentTimeMillis());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public ReactorProgressPanel(Action doneAction, AlchemistTask task) {
        super(doneAction, task);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setSampleCheckBox(new JCheckBox("Show samples (may reduce performance)"));
        this.getSampleCheckBox().setOpaque(false);
        this.getSampleCheckBox().setAlignmentX(0.5f);
        this.getSampleCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReactorProgressPanel.this.getSampleView().setVisible(ReactorProgressPanel.this.getSampleCheckBox().isSelected());
            }
        });
        this.addProgressCustomComponent(Box.createVerticalStrut(20));
        this.addProgressCustomComponent(this.getSampleCheckBox());
        this.getMessageLabel().setVisible(false);
        this.addProgressCustomComponent(this.getMessageLabel());
        this.addProgressCustomComponent(Box.createVerticalStrut(20));
        this.addProgressCustomComponent(this.getCardHolderPanel());
    }

    @Override
    public void enterPage(AlchemistState state) {
        super.enterPage(state);
        this.setCaption(PROGRESS_CAPTION, 1);
        String reactionName = (String)state.getProperty("ReactorInputPanel_SelectedReactionName");
        String[] reactantSources = (String[])state.getProperty("ReactorReactantSelector_ReactantInputSources");
        String reverse = (Boolean)state.getProperty("ReactorInputPanel_Reversed") != false ? "yes" : "no";
        String unambigous = (Boolean)state.getProperty("ReactorOptionsPanel_Unambigous") != false ? "yes" : "no";
        String unsuccesful = (Boolean)state.getProperty("ReactorOptionsPanel_GenerateUnsuccesfulReactions") != false ? "yes" : "no";
        String manual = (Boolean)state.getProperty("ReactorOptionsPanel_ManualSelection") != false ? "yes" : "no";
        String mapping = (String)state.getProperty("ReactorOptionsPanel_MappingStyleName");
        String ignore = (String)state.getProperty("ReactorOptionsPanel_IgnoreName");
        String outputType = (String)state.getProperty("ReactorOptionsPanel_OutputType");
        String combination = (String)state.getProperty("ReactorOptionsPanel_MultipleProcMode");
        String outputPath = (String)state.getProperty("ReactorOptionsPanel_OutputPath");
        String outputFormat = (String)state.getProperty("ReactorOptionsPanel_OutputFormat");
        int[] ratio = (int[])state.getProperty("ReactorOptionsPanel_ReactantRatio");
        if (ratio == null) {
            ratio = new int[reactantSources.length];
            for (int i = 0; i < ratio.length; ++i) {
                ratio[i] = 1;
            }
        }
        StringBuffer ratioStrBuff = new StringBuffer();
        for (int i = 0; i < ratio.length; ++i) {
            ratioStrBuff.append(ratio[i]);
            if (i >= ratio.length - 1) continue;
            ratioStrBuff.append(':');
        }
        ignore = ignore.replaceAll("\\|", "\n\t\t\t");
        if ("".equals("")) {
            ignore = "none";
        }
        StringBuffer msgBuff = new StringBuffer(205);
        msgBuff.append("Reaction:\t\t");
        msgBuff.append(reactionName);
        msgBuff.append("\n\nReactant input:\t");
        for (int i = 0; i < reactantSources.length; ++i) {
            msgBuff.append(reactantSources[i]);
            msgBuff.append("\n\t\t");
        }
        msgBuff.append("\nReactant combination:\t");
        msgBuff.append(combination);
        msgBuff.append("\n\nMapping style:\t");
        msgBuff.append(mapping);
        msgBuff.append("\nRatio:\t\t");
        msgBuff.append(ratioStrBuff.toString());
        msgBuff.append("\nReverse direction:\t");
        msgBuff.append(reverse);
        msgBuff.append("\nUnambigous only:\t");
        msgBuff.append(unambigous);
        msgBuff.append("\nUnsuccesful reactions:\t");
        msgBuff.append(unsuccesful);
        msgBuff.append("\nManual selection:\t");
        msgBuff.append(manual);
        msgBuff.append("\n\nIgnore rules:\t\t");
        msgBuff.append(ignore);
        msgBuff.append("\n\nOutput\ttype:\t");
        msgBuff.append(outputType);
        msgBuff.append("\n\tpath:\t");
        msgBuff.append(outputPath);
        msgBuff.append("\n\tformat:\t" + outputFormat + "\n");
        this.setMessage(msgBuff.toString(), 0);
        Boolean samplesVisible = (Boolean)state.getProperty(PROPERTY_KEY_SHOW_SAMPLES);
        this.getSampleCheckBox().setSelected(samplesVisible == null ? true : samplesVisible);
        this.getSampleView().setVisible(this.getSampleCheckBox().isSelected());
        this.setOutputFilePath(outputPath);
        JPanel customResult = new JPanel();
        customResult.setOpaque(false);
        customResult.setLayout(new BorderLayout());
        customResult.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        customResult.add((Component)this.getResultButton(), "East");
        this.setResultCustomPanel(customResult);
        if (outputType.equalsIgnoreCase("Reaction")) {
            this.getResultView().setColCount(1);
            this.getResultView().setRowCount(1);
        } else {
            int cols = ((int[])state.getProperty("ReactorOptionsPanel_IncludedProducts")).length;
            this.getResultView().setColCount(cols);
            this.getResultView().setRowCount(4);
        }
    }

    @Override
    protected ReactorAlchemistTask getCurrentTask() {
        return (ReactorAlchemistTask)super.getCurrentTask();
    }

    @Override
    public void runTask() {
        this.runTask(5);
    }

    @Override
    public void runTask(int priority) {
        this.runTask(priority, null);
    }

    public void runTask(final int priority, final PropertyChangeListener listener) {
        this.setProgressValue(0);
        this.setMessage("Initializing...", 1);
        this.setBottomText("Initializing...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AlchemistTask clonedTask = (AlchemistTask)ReactorProgressPanel.this.task.clone();
                    ReactorProgressPanel.this.setCurrentTask(clonedTask);
                    if (listener != null) {
                        ReactorProgressPanel.this.getCurrentTask().getPropertyChangeSupport().addPropertyChangeListener(listener);
                    }
                    ReactorProgressPanel.this.getCurrentTask().go(priority);
                    ReactorProgressPanel.this.startRefresh();
                }
                catch (CloneNotSupportedException e) {
                    Object clonedTask = null;
                }
            }
        });
    }

    @Override
    public void leavePage(AlchemistState state) {
        super.leavePage(state);
        this.getSampleView().clear();
        this.getResultView().clear();
        state.setPersistentProperty(PROPERTY_KEY_SHOW_SAMPLES, this.getSampleCheckBox().isSelected());
    }

    @Override
    public void setPanelState(int state) {
        super.setPanelState(state);
        if (state == 2) {
            this.getResultButton().setEnabled(this.getCurrentTask().getExportedMolecules() > 0L);
        }
    }

    protected void setSampleCheckBox(JCheckBox sampleCheckBox) {
        this.sampleCheckBox = sampleCheckBox;
    }

    protected JCheckBox getSampleCheckBox() {
        return this.sampleCheckBox;
    }

    private JLabel getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel("Toggle out unwanted results");
            this.messageLabel.setAlignmentX(0.5f);
        }
        return this.messageLabel;
    }

    protected JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.setBackground(Color.WHITE);
            this.panel.add((Component)this.getSampleView(), "Center");
        }
        return this.panel;
    }

    protected void setLastChecked(long lastChecked) {
        this.lastChecked = lastChecked;
    }

    protected long getLastChecked() {
        return this.lastChecked;
    }

    protected SimpleAlchemistMoleculeView getSampleView() {
        if (this.sampleView == null) {
            this.sampleView = new SimpleAlchemistMoleculeView(1, 1, false);
            this.sampleView.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 100), 1));
        }
        return this.sampleView;
    }

    private JPanel getSelectorGrid() {
        if (this.selectorGrid == null) {
            this.selectorGrid = new JPanel();
            this.selectorGrid.setBackground(Color.WHITE);
            this.selectorGrid.setLayout(new BoxLayout(this.selectorGrid, 1));
        }
        return this.selectorGrid;
    }

    private JPanel getSelectorPanel() {
        if (this.selectorPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.selectorPanel = new JPanel((LayoutManager)new FormLayout("4dlu, fill:min:grow, pref, fill:min:grow, 4dlu", "4dlu, fill:min:grow, 2dlu, pref, 4dlu"));
            this.selectorPanel.add((Component)new JButton(new AbstractAction("Accept"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorProgressPanel.this.hideManualSelectionPanel();
                    ArrayList<Molecule[]> selectedMolecules = new ArrayList<Molecule[]>();
                    for (int i = 0; i < ReactorProgressPanel.this.reactorResults.size(); ++i) {
                        if (!ReactorProgressPanel.this.selectionState[i]) continue;
                        selectedMolecules.add((Molecule[])ReactorProgressPanel.this.reactorResults.get(i));
                    }
                    ReactorProgressPanel.this.getCurrentTask().setManualResult(selectedMolecules);
                    ReactorAlchemistTask reactorAlchemistTask = ReactorProgressPanel.this.getCurrentTask();
                    synchronized (reactorAlchemistTask) {
                        ReactorProgressPanel.this.getCurrentTask().notify();
                    }
                }
            }), cc.xy(3, 4));
            JScrollPane scrollPane = new JScrollPane(20, 31);
            scrollPane.setViewportView(this.getSelectorGrid());
            scrollPane.setBorder(BorderFactory.createLineBorder(new Color(0.9f, 0.9f, 0.9f)));
            scrollPane.setBackground(Color.WHITE);
            this.selectorPanel.add((Component)scrollPane, cc.xyw(2, 2, 3));
            this.selectorPanel.setBackground(Color.WHITE);
        }
        return this.selectorPanel;
    }

    private JPanel getCardHolderPanel() {
        if (this.cardHolderPanel == null) {
            CardLayout layout = new CardLayout();
            this.cardHolderPanel = new JPanel(layout);
            this.cardHolderPanel.add((Component)this.getPanel(), SAMPLE_PANEL);
            this.cardHolderPanel.add((Component)this.getSelectorPanel(), SELECTION_PANEL);
            this.cardHolderPanel.setBackground(Color.WHITE);
            layout.show(this.cardHolderPanel, SAMPLE_PANEL);
        }
        return this.cardHolderPanel;
    }

    void showManualSelectionPanel() {
        Molecule molecule;
        int i;
        this.timer.stop();
        this.getSampleCheckBox().setVisible(false);
        this.getMessageLabel().setVisible(true);
        this.refreshInformations();
        this.reactorResults = this.getCurrentTask().getCurrentSet();
        Molecule[] reactants = this.getCurrentTask().getCurrentReactants();
        ArrayList<Molecule> manualSelectionList = new ArrayList<Molecule>();
        for (i = 0; i < this.reactorResults.size(); ++i) {
            int j;
            Molecule[] product = this.reactorResults.get(i);
            if (product.length <= 0) continue;
            if (product[0].isReaction()) {
                molecule = product[0].cloneMolecule();
                molecule.clean(2, null);
                manualSelectionList.add(molecule);
                continue;
            }
            RxnMolecule reaction = new RxnMolecule();
            for (j = 0; j < reactants.length; ++j) {
                reaction.addComponent(reactants[j].cloneMolecule(), 0);
            }
            for (j = 0; j < product.length; ++j) {
                reaction.addComponent(product[j].cloneMolecule(), 1);
            }
            reaction.clean(2, null);
            manualSelectionList.add(reaction);
        }
        this.getSelectorGrid().removeAll();
        this.selectionState = new boolean[manualSelectionList.size()];
        for (i = 0; i < manualSelectionList.size(); ++i) {
            final int index = i;
            molecule = (Molecule)manualSelectionList.get(i);
            this.selectionState[i] = true;
            final JPanel panel = new JPanel(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    MolPrinter printer = new MolPrinter(molecule);
                    Dimension size = new Dimension(this.getWidth() - 10, this.getHeight() - 10);
                    printer.setScale(printer.maxScale(size));
                    printer.setDispopts(AlchemistMoleculePainter.DEFAULT_DISPLAY_OPTIONS);
                    printer.setBackgroundColor(this.getBackground());
                    AlchemistMoleculePainter.drawMolecule(5, 5, printer, g, size);
                }
            };
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createLoweredBevelBorder()));
            panel.setBackground(new Color(0.9f, 0.9f, 0.9f));
            panel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    boolean bl = ReactorProgressPanel.this.selectionState[index] = !ReactorProgressPanel.this.selectionState[index];
                    if (ReactorProgressPanel.this.selectionState[index]) {
                        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createLoweredBevelBorder()));
                        panel.setBackground(new Color(0.9f, 0.9f, 0.9f));
                    } else {
                        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createRaisedBevelBorder()));
                        panel.setBackground(Color.WHITE);
                    }
                    ReactorProgressPanel.this.getSelectorGrid().repaint();
                }
            });
            panel.setPreferredSize(new Dimension(270, 140));
            this.getSelectorGrid().add(panel);
        }
        ((CardLayout)this.getCardHolderPanel().getLayout()).show(this.getCardHolderPanel(), SELECTION_PANEL);
    }

    void hideManualSelectionPanel() {
        this.timer.start();
        this.getMessageLabel().setVisible(false);
        this.getSampleCheckBox().setVisible(true);
        ((CardLayout)this.getCardHolderPanel().getLayout()).show(this.getCardHolderPanel(), SAMPLE_PANEL);
    }
}

