/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor.reactioneditor;

import java.util.HashMap;
import java.util.Map;

public final class Properties {
    public static final String PROPERTY_AUTHOR = "AUTHOR";
    public static final String PROPERTY_EXAMPLE = "EXAMPLE";
    public static final String PROPERTY_NAME = "NAME";
    public static final String PROPERTY_STANDARDIZATION = "STANDARDIZATION";
    public static final String PROPERTY_REAGENTS = "REAGENTS";
    public static final String PROPERTY_REFERENCES = "REFERENCES";
    public static final String PROPERTY_EXCLUDE = "EXCLUDE";
    public static final String PROPERTY_EXPLAINEXCLUDE = "EXPLAIN_EXCLUDE";
    public static final String PROPERTY_REACTIVITY = "REACTIVITY";
    public static final String PROPERTY_EXPLAINREACTIVITY = "EXPLAIN_REACTIVITY";
    public static final String PROPERTY_SELECTIVITY = "SELECTIVITY";
    public static final String PROPERTY_EXPLAINSELECTIVITY = "EXPLAIN_SELECTIVITY";
    public static final String PROPERTY_TOLERANCE = "TOLERANCE";
    public static final String PROPERTY_EXPLAINTOLERANCE = "EXPLAIN_TOLERANCE";
    public static final String PROPERTY_SYNTHESISCODE = "Synthesis Code";
    public static final String[] CHEMAXON_RESERVED_PROPERTIES = new String[]{"EXAMPLE", "NAME", "EXCLUDE", "EXPLAIN_EXCLUDE", "REACTIVITY", "EXPLAIN_REACTIVITY", "SELECTIVITY", "EXPLAIN_SELECTIVITY", "TOLERANCE", "EXPLAIN_TOLERANCE", "STANDARDIZATION"};
    private static final Map<String, String> FRIENDLY_NAME_MAP = new HashMap<String, String>();

    private Properties() {
    }

    public static boolean isReserved(String propertyName) {
        for (int i = 0; i < CHEMAXON_RESERVED_PROPERTIES.length; ++i) {
            if (!CHEMAXON_RESERVED_PROPERTIES[i].equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static String getUserFriendlyName(String propertyName) {
        String propName = propertyName;
        if (FRIENDLY_NAME_MAP.containsKey(propName)) {
            propName = FRIENDLY_NAME_MAP.get(propName);
        }
        return Character.toUpperCase(propName.charAt(0)) + propName.substring(1).toLowerCase();
    }

    static {
        FRIENDLY_NAME_MAP.put(PROPERTY_EXPLAINEXCLUDE, "Exclude Description");
        FRIENDLY_NAME_MAP.put(PROPERTY_EXPLAINREACTIVITY, "Reactivity Description");
        FRIENDLY_NAME_MAP.put(PROPERTY_EXPLAINTOLERANCE, "Tolerance Description");
        FRIENDLY_NAME_MAP.put(PROPERTY_EXPLAINSELECTIVITY, "Selectivity Description");
    }
}

