/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor.reactioneditor;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanelFactory;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.ConfigElementFactory;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationReader;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationWriter;
import chemaxon.alchemist.reactor.reactioneditor.Properties;
import chemaxon.alchemist.reactor.reactioneditor.ReactionExampleEditor;
import chemaxon.alchemist.reactor.reactioneditor.ReactionRuleEditor;
import chemaxon.alchemist.reactor.reactioneditor.ReactorPropertyEditorPanel;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooserForJChem;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.AlchemistTableSizeConfigurerComponent;
import chemaxon.alchemist.utils.ListableMolecule;
import chemaxon.alchemist.utils.NumberedComboBoxRenderer;
import chemaxon.alchemist.utils.NumberedRenderer;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.reaction.tester.ReactionExampleTester;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.iterator.MoleculeIteratorFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.SwingPropertyChangeSupport;

public class ReactionEditorPanel
extends AlchemistPage
implements PropertyChangeListener {
    private static final String PROPERTY_VALUE_SAVE_REACTION_FILE = "Save Reaction File";
    private static final String NO_FILE = "Untitled";
    public static final String PROPERTY_KEY_FILE_CHANGED = "ReactionEditorPanel_FileChanged";
    private static final int PROPERTY_VALUE_WRITE_REACTION_FILE_SUCCESS = 0;
    private static final int PROPERTY_VALUE_WRITE_REACTION_FILE_VETO = 1;
    private static final int PROPERTY_VALUE_WRITE_REACTION_FILE_FAILURE = -1;
    private final SwingPropertyChangeSupport notifier = new SwingPropertyChangeSupport(this);
    private static final long serialVersionUID = 3994434556439425010L;
    private static final String PROPERTY_KEY_LAST_USED_DIR = "ReactionEditorPanel_LastUsedDir";
    private String lastUsedDir = null;
    public static final int STANDALONE_MODE = 0;
    public static final int EMBEDDED_MODE = 1;
    public static final String APPLY = "Apply";
    public static final String CANCEL = "Cancel";
    private static final String DEFAULT_REACTION_NAME = "New reaction ";
    JPopupMenu fileMenuPopup = new JPopupMenu("File Operations");
    private final List<String> properties = new ArrayList<String>();
    private Molecule lastEdited;
    private MSketchPane schemaSketch = null;
    private final UserSettings sketchUserSettings = new UserSettings("ReactionEditorPanel_Marvin.properties");
    private JScrollPane scrlpReactions = null;
    private JList lstReactions = null;
    private JTabbedPane tbdpMain = null;
    private JPanel pnlSchema = null;
    private ReactorPropertyEditorPanel pnlProperties = null;
    private JPanel pnlList = null;
    private JPanel pnlCommand = null;
    private JButton buttApply = null;
    private JButton buttCancel = null;
    private JPanel pnlButtonHolder = null;
    private AlchemistFileChooserForJChem fileChooser = null;
    private JComboBox cmbReactions = null;
    private JPanel pnlCombo = null;
    private JPanel pnlComboSwitch = null;
    private JToggleButton jToggleButton = null;
    private JLabel lblInfo = null;
    private ReactionExampleEditor exampleEditor = null;
    private JTabbedPane pnlRules = null;
    private ReactionRuleEditor ruleEditor = null;
    private JTextField nameField = null;
    private DefaultComboBoxModel listModel = new DefaultComboBoxModel();
    private JPopupMenu configurerPopupMenu = null;
    private int mode = 0;
    protected Action leaveAction = null;
    private String currentFormat = null;
    private File output = null;
    private int lastSelected = -1;
    private int currentMolNum;
    private int maxMolNum;
    private JTextPane testPane;
    private JPanel orderButtonPanel = null;
    private JButton moveSelectionUpButton = null;
    private JButton moveSelectionDownButton = null;
    private JButton orderAlphabeticalAscButton = null;
    private JButton orderAlphabeticalDescButton = null;
    private int lastTabIndex = -1;
    private AlchemistTableSizeConfigurerComponent tableSizeConfigurer = null;
    private final Action TEST_CURRENT_REACTION_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 8847515115231649760L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReactionEditorPanel.this.getLstReactions().getSelectedValue() != null) {
                Molecule reaction = ((ListableMolecule)ReactionEditorPanel.this.getLstReactions().getSelectedValue()).getMolecule();
                ReactionEditorPanel.this.getTestPane().setText(ReactionExampleTester.testReactionExamples(reaction, true));
            }
        }
    };
    private final Action TEST_LIBRARY_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -8839426959838912987L;

        @Override
        public void actionPerformed(ActionEvent e) {
            LinkedList<Molecule> reactions = new LinkedList<Molecule>();
            for (int i = 0; i < ReactionEditorPanel.this.getListModel().getSize(); ++i) {
                reactions.add(((ListableMolecule)ReactionEditorPanel.this.getListModel().getElementAt(i)).getMolecule());
            }
            ReactionEditorPanel.this.getTestPane().setText(ReactionExampleTester.testReactionExamples(MoleculeIteratorFactory.createMoleculeIterator(reactions)));
        }
    };
    private final Action EXAMPLE_EDITOR_RESIZE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 7335989167206112344L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionEditorPanel.this.setGridSize(e);
        }
    };
    private JPanel testPanel = null;
    private final JButton testCurrentReaction = new JButton(this.TEST_CURRENT_REACTION_ACTION);
    private final JButton testLibrary = new JButton(this.TEST_LIBRARY_ACTION);
    private JButton exampleEditorResizeButton = null;
    private Timer loadProgressBarRefreshTimer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReactionEditorPanel.this.updateProgressBar((int)((float)ReactionEditorPanel.this.getCurrentMolNum() / (float)(ReactionEditorPanel.this.getMaxMolNum() + 1) * 100.0f));
                }
            });
        }
    });
    private final Action SORT_LIBRARY_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 7613441568611787319L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionEditorPanel.this.saveCurrentReactionToList();
            Molecule templateMolecule = new Molecule();
            ReactionEditorPanel.this.getPnlProperties().setReactionProperties(templateMolecule);
            String[] templateKeys = templateMolecule.properties().getKeys();
            for (int it = 0; it < ReactionEditorPanel.this.getListModel().getSize(); ++it) {
                Molecule currentMolecule = ((ListableMolecule)ReactionEditorPanel.this.getListModel().getElementAt(it)).getMolecule();
                MPropertyContainer oldProperties = currentMolecule.properties();
                MPropertyContainer orderedProperties = new MPropertyContainer();
                for (int i = 0; i < templateKeys.length; ++i) {
                    if (oldProperties.get(templateKeys[i]) == null) continue;
                    orderedProperties.set(templateKeys[i], oldProperties.get(templateKeys[i]));
                    oldProperties.set(templateKeys[i], null);
                }
                String[] keysLeft = oldProperties.getKeys();
                for (int j = 0; j < keysLeft.length; ++j) {
                    orderedProperties.set(keysLeft[j], oldProperties.get(keysLeft[j]));
                    oldProperties.set(keysLeft[j], null);
                }
                String[] allKeys = orderedProperties.getKeys();
                for (int k = 0; k < allKeys.length; ++k) {
                    oldProperties.set(allKeys[k], orderedProperties.get(allKeys[k]));
                }
            }
        }
    };
    private final Action APPLY_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -2048415516713231576L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ReactionEditorPanel.this.saveCurrentReactionToList();
            if (ReactionEditorPanel.this.getOutput() != null) {
                int leaveOption = JOptionPane.showConfirmDialog(ReactionEditorPanel.this, "File exists. Do You want to Overwrite?", ReactionEditorPanel.PROPERTY_VALUE_SAVE_REACTION_FILE, 1);
                if (leaveOption == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReactionEditorPanel.this.refreshPanelInformations();
                        }
                    });
                    int status = ReactionEditorPanel.this.writeReactionFile(ReactionEditorPanel.this.getOutput(), ReactionEditorPanel.this.getCurrentFormat());
                    if (status == 0) {
                        ReactionEditorPanel.this.leaveAction.actionPerformed(new ActionEvent(ReactionEditorPanel.this, 0, ReactionEditorPanel.APPLY + ReactionEditorPanel.this.getOutput()));
                    }
                } else if (leaveOption == 1) {
                    ReactionEditorPanel.this.leaveAction.actionPerformed(new ActionEvent(ReactionEditorPanel.this, 0, ReactionEditorPanel.CANCEL));
                }
            } else if (ReactionEditorPanel.this.getFileChooser() != null) {
                ReactionEditorPanel.this.getFileChooser().clearChoosableFileFilters();
                ReactionEditorPanel.this.getFileChooser().addReactionLibrarySaveFileFilters();
                ReactionEditorPanel.this.getFileChooser().setDialogTitle(ReactionEditorPanel.PROPERTY_VALUE_SAVE_REACTION_FILE);
                int rVal = ReactionEditorPanel.this.getFileChooser().showSaveDialog(ReactionEditorPanel.this);
                if (rVal == 0) {
                    ReactionEditorPanel.this.setOutput(ReactionEditorPanel.this.getFileChooser().getSelectedFile());
                    String path = ReactionEditorPanel.this.getOutput().getAbsolutePath();
                    ReactionEditorPanel.this.setLastUsedDir(ReactionEditorPanel.this.getFileChooser().getCurrentDirectory().getAbsolutePath());
                    String extension = ((MolFileFilter)ReactionEditorPanel.this.getFileChooser().getFileFilter()).getExtension();
                    if (!path.endsWith(extension)) {
                        path = path + "." + extension;
                        ReactionEditorPanel.this.setOutput(new File(path));
                    }
                    if (ReactionEditorPanel.this.getOutput().exists()) {
                        int leaveOption = JOptionPane.showConfirmDialog(ReactionEditorPanel.this, "File exists. Do You want to Overwrite?", ReactionEditorPanel.PROPERTY_VALUE_SAVE_REACTION_FILE, 1);
                        if (leaveOption == 0) {
                            int status = ReactionEditorPanel.this.writeReactionFile(ReactionEditorPanel.this.getOutput(), ((MolFileFilter)ReactionEditorPanel.this.getFileChooser().getFileFilter()).getFormat());
                            if (status == 0) {
                                ReactionEditorPanel.this.leaveAction.actionPerformed(new ActionEvent(ReactionEditorPanel.this, 0, ReactionEditorPanel.APPLY + ReactionEditorPanel.this.getOutput()));
                            }
                        } else if (leaveOption == 1) {
                            ReactionEditorPanel.this.leaveAction.actionPerformed(new ActionEvent(ReactionEditorPanel.this, 0, ReactionEditorPanel.CANCEL));
                        }
                    } else {
                        int status = ReactionEditorPanel.this.writeReactionFile(ReactionEditorPanel.this.getOutput(), ((MolFileFilter)ReactionEditorPanel.this.getFileChooser().getFileFilter()).getFormat());
                        if (status == 0) {
                            ReactionEditorPanel.this.leaveAction.actionPerformed(new ActionEvent(ReactionEditorPanel.this, 0, ReactionEditorPanel.APPLY + ReactionEditorPanel.this.getOutput()));
                        }
                    }
                }
            }
        }
    };
    private final Action ADD_REACTION_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -1668170655229986803L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int count = 1;
            for (int i = 0; i < ReactionEditorPanel.this.getCmbReactions().getItemCount(); ++i) {
                if (!ReactionEditorPanel.this.getCmbReactions().getItemAt(i).toString().equalsIgnoreCase(ReactionEditorPanel.DEFAULT_REACTION_NAME + count)) continue;
                ++count;
            }
            ListableMolecule molecule = new ListableMolecule(new Molecule());
            molecule.setName(ReactionEditorPanel.DEFAULT_REACTION_NAME + count);
            ReactionEditorPanel.this.getListModel().addElement(molecule);
            ReactionEditorPanel.this.getLstReactions().setSelectedIndex(ReactionEditorPanel.this.getListModel().getSize() - 1);
        }
    };
    private final Action REMOVE_REACTION_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 5646945320193118153L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selectedIndexes = ReactionEditorPanel.this.getLstReactions().getSelectedIndices();
            Object[] selected = ReactionEditorPanel.this.getLstReactions().getSelectedValues();
            if (selectedIndexes.length > 0 && JOptionPane.showConfirmDialog(ReactionEditorPanel.this, "Delete selected " + (selectedIndexes.length > 1 ? "Reactions" : "Reaction") + " from the list?", "Reaction Editor", 0) == 0) {
                ReactionEditorPanel.this.setLastSelected(-1);
                for (int i = 0; i < selected.length; ++i) {
                    ReactionEditorPanel.this.getListModel().removeElement(selected[i]);
                }
                if (ReactionEditorPanel.this.getListModel().getSize() != 0) {
                    if (selectedIndexes[0] < ReactionEditorPanel.this.getListModel().getSize()) {
                        ReactionEditorPanel.this.getLstReactions().setSelectedIndex(selectedIndexes[0]);
                        ReactionEditorPanel.this.getCmbReactions().setSelectedIndex(selectedIndexes[0]);
                        ReactionEditorPanel.this.setLastSelected(selectedIndexes[0]);
                    } else {
                        ReactionEditorPanel.this.getLstReactions().setSelectedIndex(selectedIndexes[0] - 1);
                        ReactionEditorPanel.this.getCmbReactions().setSelectedIndex(selectedIndexes[0] - 1);
                        ReactionEditorPanel.this.setLastSelected(selectedIndexes[0] - 1);
                    }
                    ReactionEditorPanel.this.refreshPanelInformations();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReactionEditorPanel.this.clearEditor();
                            ReactionEditorPanel.this.setReactionFile("", 0);
                            ReactionEditorPanel.this.getCmbReactions().setSelectedIndex(0);
                        }
                    });
                }
            }
        }
    };
    private final Action OPEN_REACTION_FILE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 8511826577780552817L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReactionEditorPanel.this.getFileChooser() != null) {
                ReactionEditorPanel.this.getFileChooser().clearChoosableFileFilters();
                ReactionEditorPanel.this.getFileChooser().addReactionLibraryOpenFileFilters();
                ReactionEditorPanel.this.getFileChooser().setDialogTitle("Open Reaction File");
                int rVal = ReactionEditorPanel.this.getFileChooser().showOpenDialog(ReactionEditorPanel.this);
                if (rVal == 0) {
                    ReactionEditorPanel.this.setLastUsedDir(ReactionEditorPanel.this.getFileChooser().getCurrentDirectory().getAbsolutePath());
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ReactionEditorPanel.this.setReactionFile(ReactionEditorPanel.this.getFileChooser().getSelectedFile().getAbsolutePath());
                            ReactionEditorPanel.this.setSelectedReaction(0);
                            ReactionEditorPanel.this.setLastSelected(0);
                        }
                    });
                    thread.setPriority(4);
                    thread.start();
                }
            }
        }
    };
    private final Action SAVE_REACTION_FILE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -5489237236610082960L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionEditorPanel.this.saveCurrentReactionToList();
            ReactionEditorPanel.this.refreshPanelInformations();
            ReactionEditorPanel.this.saveReactionFile();
        }
    };
    private final Action SAVE_REACTION_FILE_AS_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 6917466982866041344L;

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReactionEditorPanel.this.saveCurrentReactionToList();
                    ReactionEditorPanel.this.refreshPanelInformations();
                    ReactionEditorPanel.this.saveReactionFileAs();
                }
            });
        }
    };
    private final Action IMPORT_REACTIONS_FROM_FILE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -9193913744578095107L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReactionEditorPanel.this.getFileChooser() != null) {
                ReactionEditorPanel.this.getFileChooser().clearChoosableFileFilters();
                ReactionEditorPanel.this.getFileChooser().addReactionLibraryOpenFileFilters();
                ReactionEditorPanel.this.getFileChooser().setDialogTitle("Import Reactions from File");
                int rVal = ReactionEditorPanel.this.getFileChooser().showOpenDialog(ReactionEditorPanel.this);
                if (rVal == 0) {
                    ReactionEditorPanel.this.setLastUsedDir(ReactionEditorPanel.this.getFileChooser().getCurrentDirectory().getAbsolutePath());
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ReactionEditorPanel.this.readReactionFile(ReactionEditorPanel.this.getFileChooser().getSelectedFile(), true);
                            int selectedReaction = ReactionEditorPanel.this.getLstReactions().getSelectedIndex();
                            ReactionEditorPanel.this.getLstReactions().clearSelection();
                            ReactionEditorPanel.this.setSelectedReaction(selectedReaction);
                        }
                    });
                    thread.setPriority(4);
                    thread.start();
                }
            }
        }
    };
    private final Action EXPORT_REACTIONS_TO_FILE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 6080582983290529892L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionEditorPanel.this.saveCurrentReactionToList();
            ReactionEditorPanel.this.refreshPanelInformations();
            ReactionEditorPanel.this.exportReactionToFile();
        }
    };
    private final Action NEW_REACTION_LIBRARY_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 1946432548704198766L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReactionEditorPanel.this.getListModel().getSize() > 0) {
                if (JOptionPane.showConfirmDialog(ReactionEditorPanel.this, "Are you sure?\nAll unsaved changes will be lost!", "New Reaction File", 0) == 0) {
                    ReactionEditorPanel.this.clearEditor();
                    ReactionEditorPanel.this.setReactionFile("");
                }
            } else {
                ReactionEditorPanel.this.clearEditor();
                ReactionEditorPanel.this.setReactionFile("");
            }
        }
    };
    private AbstractAction ADD_EXAMPLE_ACTION;
    private AbstractAction APPLY_EDIT_EXAMPLE_ACTION;
    private AbstractAction CANCEL_EDIT_EXAMPLE_ACTION;
    private AbstractAction REMOVE_EXAMPLE_ACTION;
    private AbstractAction EDIT_EXAMPLE_ACTION;
    private final AbstractAction ADD_PROPERTY_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -4769895469789262137L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionEditorPanel.this.getPnlProperties().addProperty();
        }
    };
    private final AbstractAction REMOVE_PROPERTY_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 7192275407628311099L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionEditorPanel.this.getPnlProperties().removeProperty();
        }
    };
    protected final AbstractAction SELECTION_UP = new AbstractAction(){
        private static final long serialVersionUID = 8310890280658316114L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos = ReactionEditorPanel.this.getLstReactions().getSelectedIndex();
            int length = ReactionEditorPanel.this.getLstReactions().getSelectedIndices().length;
            if (pos > 0) {
                ListableMolecule element = (ListableMolecule)ReactionEditorPanel.this.getListModel().getElementAt(pos - 1);
                ReactionEditorPanel.this.getListModel().removeElement(element);
                ReactionEditorPanel.this.getListModel().insertElementAt(element, pos + length - 1);
                ReactionEditorPanel.this.setLastSelected(ReactionEditorPanel.this.getLastSelected() - 1);
            }
            ReactionEditorPanel.this.SELECTION_UP.setEnabled(ReactionEditorPanel.this.getLstReactions().getSelectedIndex() > 0);
            ReactionEditorPanel.this.SELECTION_DOWN.setEnabled(ReactionEditorPanel.this.getLstReactions().getSelectedIndex() > -1 && ReactionEditorPanel.this.getLstReactions().getSelectedIndex() + length - 1 < ReactionEditorPanel.this.getLstReactions().getModel().getSize() - 1);
        }
    };
    protected final AbstractAction SELECTION_DOWN = new AbstractAction(){
        private static final long serialVersionUID = 206597427211792282L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            int pos = ReactionEditorPanel.this.getLstReactions().getSelectedIndex();
            if (pos + (length = ReactionEditorPanel.this.getLstReactions().getSelectedIndices().length) - 1 < ReactionEditorPanel.this.getListModel().getSize() - 1) {
                ListableMolecule element = (ListableMolecule)ReactionEditorPanel.this.getListModel().getElementAt(pos + length);
                ReactionEditorPanel.this.getListModel().removeElement(element);
                ReactionEditorPanel.this.getListModel().insertElementAt(element, pos);
                ReactionEditorPanel.this.setLastSelected(ReactionEditorPanel.this.getLastSelected() + 1);
                ReactionEditorPanel.this.getLstReactions().setSelectionInterval(pos + 1, pos + length);
            }
            ReactionEditorPanel.this.SELECTION_UP.setEnabled(ReactionEditorPanel.this.getLstReactions().getSelectedIndex() > 0);
            ReactionEditorPanel.this.SELECTION_DOWN.setEnabled(ReactionEditorPanel.this.getLstReactions().getSelectedIndex() > -1 && ReactionEditorPanel.this.getLstReactions().getSelectedIndex() + length - 1 < ReactionEditorPanel.this.getLstReactions().getModel().getSize() - 1);
        }
    };
    private final AbstractAction REACTION_ALPHABETIC_ASC = new AbstractAction(){
        private static final long serialVersionUID = 7281607587057283794L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionEditorPanel.this.sortReactionList(false);
        }
    };
    private final AbstractAction REACTION_ALPHABETIC_DESC = new AbstractAction(){
        private static final long serialVersionUID = 3181615622806887077L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionEditorPanel.this.sortReactionList(true);
        }
    };
    private JPanel northPanel = null;
    private JToolBar mainToolBar = null;
    private JButton addReactionToolButton = null;
    private JButton removeReactionToolButton = null;
    private JButton openFileToolButton = null;
    private JButton saveFileToolButton = null;
    private JButton saveFileAsToolButton = null;
    private JButton importReactionsToolButton = null;
    private JButton exportReactionToFileToolButton = null;
    private JButton addExampleToolButton = null;
    private JButton applyEditExampleToolButton = null;
    private JButton cancelEditExampleToolButton = null;
    private JButton editExampleToolButton = null;
    private JButton removeExampleToolButton = null;
    private JButton addPropertyToolButton = null;
    private JButton removePropertyToolButton = null;
    private JButton newLibraryToolButton = null;
    private JButton sortLibraryToolButton = null;
    private JPanel northSectionPanel = null;
    private JPanel reactionStandardizationPanel = null;
    private ConfigBuilderPanel[] configBuilderPanels = null;
    private JCheckBox separatedConfigBuilders = null;
    private JTabbedPane configPane = new JTabbedPane();
    private static final String REACTANT = "reactant";
    private boolean loading = false;
    private JPanel contentPanel = null;

    public ReactionEditorPanel() {
        this.initialize();
    }

    public ReactionEditorPanel(PropertyChangeListener listener) {
        this.notifier.addPropertyChangeListener(listener);
        this.initialize();
    }

    public ReactionEditorPanel(int mode, Action leaveAction) {
        this.initialize(mode, leaveAction);
    }

    public ReactionEditorPanel(int mode, Action leaveAction, PropertyChangeListener listener) {
        this.notifier.addPropertyChangeListener(listener);
        this.initialize(mode, leaveAction);
    }

    private void initialize() {
        try {
            this.setFileChooser(new AlchemistFileChooserForJChem(true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setExampleEditor(new ReactionExampleEditor(this));
        this.ADD_EXAMPLE_ACTION = this.getExampleEditor().getADD_MOLECULE_ACTION();
        this.APPLY_EDIT_EXAMPLE_ACTION = this.getExampleEditor().getAPPLY_MOLECULE_EDIT_ACTION();
        this.APPLY_EDIT_EXAMPLE_ACTION.setEnabled(false);
        this.CANCEL_EDIT_EXAMPLE_ACTION = this.getExampleEditor().getCANCEL_MOLECULE_EDIT_ACTION();
        this.CANCEL_EDIT_EXAMPLE_ACTION.setEnabled(false);
        this.EDIT_EXAMPLE_ACTION = this.getExampleEditor().getEDIT_MOLECULE_ACTION();
        this.REMOVE_EXAMPLE_ACTION = this.getExampleEditor().getREMOVE_MOLECULE_ACTION();
        this.ruleEditor = new ReactionRuleEditor();
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(545, 315));
        this.add((Component)this.getContentPanel(), "Center");
        this.getPnlList();
        this.testCurrentReaction.setText("Test current reaction");
        this.testLibrary.setText("Test all reactions");
        this.EXAMPLE_EDITOR_RESIZE_ACTION.setEnabled(false);
    }

    private JButton getMoveSelectionUpButton() {
        if (this.moveSelectionUpButton == null) {
            this.moveSelectionUpButton = new JButton(this.SELECTION_UP);
            this.moveSelectionUpButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/up.gif"));
            this.moveSelectionUpButton.setPreferredSize(new Dimension(24, 24));
        }
        return this.moveSelectionUpButton;
    }

    private JButton getMoveSelectionDownButton() {
        if (this.moveSelectionDownButton == null) {
            this.moveSelectionDownButton = new JButton(this.SELECTION_DOWN);
            this.moveSelectionDownButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/down.gif"));
            this.moveSelectionDownButton.setPreferredSize(new Dimension(24, 24));
        }
        return this.moveSelectionDownButton;
    }

    private JButton getOrderAlphabeticalAsc() {
        if (this.orderAlphabeticalAscButton == null) {
            this.orderAlphabeticalAscButton = new JButton(this.REACTION_ALPHABETIC_ASC);
            this.orderAlphabeticalAscButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/sortlibrary.gif"));
            this.orderAlphabeticalAscButton.setPreferredSize(new Dimension(24, 24));
        }
        return this.orderAlphabeticalAscButton;
    }

    private JButton getOrderAlphabeticalDesc() {
        if (this.orderAlphabeticalDescButton == null) {
            this.orderAlphabeticalDescButton = new JButton(this.REACTION_ALPHABETIC_DESC);
            this.orderAlphabeticalDescButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/sortlibrarydesc.gif"));
            this.orderAlphabeticalDescButton.setPreferredSize(new Dimension(24, 24));
        }
        return this.orderAlphabeticalDescButton;
    }

    private JPanel getOrderButtonPanel() {
        if (this.orderButtonPanel == null) {
            this.orderButtonPanel = new JPanel();
            this.orderButtonPanel.setLayout(new BoxLayout(this.orderButtonPanel, 0));
            this.orderButtonPanel.add(Box.createHorizontalGlue());
            this.orderButtonPanel.add(this.getMoveSelectionUpButton());
            this.orderButtonPanel.add(this.getMoveSelectionDownButton());
            this.orderButtonPanel.add(this.getOrderAlphabeticalAsc());
            this.orderButtonPanel.add(this.getOrderAlphabeticalDesc());
            this.orderButtonPanel.add(Box.createHorizontalGlue());
        }
        return this.orderButtonPanel;
    }

    private void initialize(int mode, Action leaveAction) {
        this.mode = mode;
        this.leaveAction = leaveAction;
        this.initialize();
    }

    @Override
    public boolean isCorrect() {
        return true;
    }

    private JScrollPane getScrlpReactions() {
        if (this.scrlpReactions == null) {
            this.scrlpReactions = new JScrollPane();
            this.scrlpReactions.setMaximumSize(new Dimension(250, Short.MAX_VALUE));
            this.scrlpReactions.setPreferredSize(new Dimension(250, 130));
            this.scrlpReactions.setViewportView(this.getLstReactions());
        }
        return this.scrlpReactions;
    }

    protected JList getLstReactions() {
        if (this.lstReactions == null) {
            this.lstReactions = new JList(this.getListModel());
            this.lstReactions.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ReactionEditorPanel.this.getCmbReactions().getSelectedIndex() != ReactionEditorPanel.this.getLstReactions().getSelectedIndex() && ReactionEditorPanel.this.getLstReactions().getModel().getSize() != 0) {
                                ReactionEditorPanel.this.getCmbReactions().setSelectedIndex(ReactionEditorPanel.this.getLstReactions().getSelectedIndex());
                                ReactionEditorPanel.this.saveCurrentReactionToList();
                                ReactionEditorPanel.this.refreshPanelInformations();
                            }
                            ReactionEditorPanel.this.SELECTION_UP.setEnabled(ReactionEditorPanel.this.getLstReactions().getSelectedIndex() > 0);
                            ReactionEditorPanel.this.SELECTION_DOWN.setEnabled(ReactionEditorPanel.this.getLstReactions().getSelectedIndex() > -1 && ReactionEditorPanel.this.getLstReactions().getSelectedIndex() + ReactionEditorPanel.this.getLstReactions().getSelectedIndices().length - 1 < ReactionEditorPanel.this.getLstReactions().getModel().getSize() - 1);
                        }
                    });
                }
            });
            this.lstReactions.setSelectionMode(1);
            this.lstReactions.setCellRenderer(new NumberedRenderer(this.lstReactions.getCellRenderer()));
        }
        return this.lstReactions;
    }

    private JPanel getTestPanel() {
        if (this.testPanel == null) {
            this.testPanel = new JPanel(new BorderLayout());
            JPanel buttonHolderPanel = new JPanel();
            buttonHolderPanel.setLayout(new BoxLayout(buttonHolderPanel, 0));
            buttonHolderPanel.add(this.testCurrentReaction);
            buttonHolderPanel.add(this.testLibrary);
            this.setTestPane(new JTextPane());
            this.getTestPane().setEditable(false);
            JScrollPane scrollPane = new JScrollPane(this.getTestPane());
            this.testPanel.add((Component)buttonHolderPanel, "South");
            this.testPanel.add((Component)scrollPane, "Center");
        }
        return this.testPanel;
    }

    protected void setToolBarButtonStates() {
        int index = this.tbdpMain.getSelectedIndex();
        this.ADD_EXAMPLE_ACTION.setEnabled(index == 2);
        this.EDIT_EXAMPLE_ACTION.setEnabled(index == 2 && this.getExampleEditor().isExampleSelected());
        this.REMOVE_EXAMPLE_ACTION.setEnabled(index == 2 && this.getExampleEditor().isExampleSelected());
        this.EXAMPLE_EDITOR_RESIZE_ACTION.setEnabled(index == 2);
        this.ADD_PROPERTY_ACTION.setEnabled(index == 3);
        this.REMOVE_PROPERTY_ACTION.setEnabled(index == 3 && this.getPnlProperties().isPropertySelected());
        this.SORT_LIBRARY_ACTION.setEnabled(index == 3);
    }

    protected JTabbedPane getTbdpMain() {
        if (this.tbdpMain == null) {
            this.tbdpMain = new JTabbedPane();
            this.tbdpMain.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ReactionEditorPanel.this.getTbdpMain().requestFocus();
                    ReactionEditorPanel.this.setTabVisibility(ReactionEditorPanel.this.getTbdpMain().getSelectedIndex());
                    ReactionEditorPanel.this.setToolBarButtonStates();
                    if (ReactionEditorPanel.this.getTbdpMain().getSelectedIndex() == 4) {
                        ReactionEditorPanel.this.refreshStandardizationPanel();
                    }
                    if (ReactionEditorPanel.this.getLastTabIndex() == 3) {
                        ReactionEditorPanel.this.saveCurrentReactionToList();
                        ReactionEditorPanel.this.refreshPanelInformations();
                    }
                    ReactionEditorPanel.this.setLastTabIndex(ReactionEditorPanel.this.getTbdpMain().getSelectedIndex());
                }
            });
            this.tbdpMain.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.tbdpMain.addTab("Scheme", null, this.getPnlSchema(), null);
            this.tbdpMain.addTab("Rules", null, this.getPnlRules(), null);
            this.tbdpMain.addTab("Examples", null, this.getExampleEditor().getExamplePanel(), null);
            this.tbdpMain.addTab("Properties", null, this.getPnlProperties(), null);
            this.tbdpMain.addTab("Reactant standardization", null, this.getReactionStandardizationPanel(), null);
            this.tbdpMain.addTab("Test", null, this.getTestPanel(), null);
        }
        return this.tbdpMain;
    }

    protected void setTabVisibility(int selectedTabIndex) {
        this.getPnlSchema().setVisible(selectedTabIndex == 0);
        this.getPnlRules().setVisible(selectedTabIndex == 1);
        this.getExampleEditor().getExamplePanel().setVisible(selectedTabIndex == 2);
        this.getPnlProperties().setVisible(selectedTabIndex == 3);
        this.getReactionStandardizationPanel().setVisible(selectedTabIndex == 4);
        this.getTestPanel().setVisible(selectedTabIndex == 5);
    }

    private JPanel getPnlSchema() {
        if (this.pnlSchema == null) {
            this.pnlSchema = new JPanel();
            this.pnlSchema.setLayout(new BorderLayout());
            this.sketchUserSettings.setCheckerConfigFileName("ReactionEditorPanel_MarvinSketch_checkerconfig.xml");
            this.schemaSketch = new MSketchPane(this.sketchUserSettings);
            this.schemaSketch.setParams("implicitH=off");
            this.schemaSketch.setAutoScale(true);
            this.schemaSketch.setValenceErrorVisible(true);
            this.pnlSchema.add((Component)this.schemaSketch, "Center");
            this.pnlSchema.add((Component)this.getPnlCommand(), "South");
            this.pnlSchema.add((Component)this.getNamePanel(), "North");
        }
        return this.pnlSchema;
    }

    private JPanel getNamePanel() {
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        JLabel nameLabel = new JLabel("Reaction name: ");
        namePanel.add(nameLabel);
        namePanel.add(this.getNameField());
        return namePanel;
    }

    protected JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                private void handleChange() {
                    JList reactionList = ReactionEditorPanel.this.getLstReactions();
                    ListableMolecule reaction = (ListableMolecule)reactionList.getSelectedValue();
                    if (reaction != null) {
                        reaction.setName(ReactionEditorPanel.this.getNameField().getText().trim().equalsIgnoreCase("") ? "[empty name]" : ReactionEditorPanel.this.getNameField().getText().trim());
                        ReactionEditorPanel.this.updateUI();
                    }
                }
            });
        }
        return this.nameField;
    }

    protected ReactorPropertyEditorPanel getPnlProperties() {
        if (this.pnlProperties == null) {
            this.pnlProperties = new ReactorPropertyEditorPanel();
            this.pnlProperties.notifier.addPropertyChangeListener(this);
        }
        return this.pnlProperties;
    }

    protected JPanel getPnlList() {
        if (this.pnlList == null) {
            this.pnlList = new JPanel();
            this.pnlList.setLayout(new BorderLayout());
            this.pnlList.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.pnlList.add((Component)this.getScrlpReactions(), "Center");
            this.pnlList.add((Component)this.getOrderButtonPanel(), "North");
        }
        return this.pnlList;
    }

    private JPanel getPnlCommand() {
        if (this.pnlCommand == null) {
            this.pnlCommand = new JPanel();
            this.pnlCommand.setLayout(new BorderLayout());
            this.pnlCommand.setCursor(new Cursor(0));
            this.pnlCommand.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            if (this.mode == 0) {
                this.pnlCommand.add((Component)this.getPnlButtonHolder(), "East");
            }
        }
        return this.pnlCommand;
    }

    private JButton getButtApply() {
        if (this.buttApply == null) {
            this.buttApply = new JButton(this.APPLY_ACTION);
            this.buttApply.setText(APPLY);
        }
        return this.buttApply;
    }

    private JButton getButtCancel() {
        if (this.buttCancel == null) {
            this.buttCancel = new JButton(this.leaveAction);
            this.buttCancel.setText(CANCEL);
        }
        return this.buttCancel;
    }

    private JPanel getPnlButtonHolder() {
        if (this.pnlButtonHolder == null) {
            this.pnlButtonHolder = new JPanel();
            this.pnlButtonHolder.setLayout(new BoxLayout(this.getPnlButtonHolder(), 0));
            if (this.mode == 1) {
                this.pnlButtonHolder.add((Component)this.getButtApply(), null);
                this.pnlButtonHolder.add((Component)this.getButtCancel(), null);
            }
        }
        return this.pnlButtonHolder;
    }

    public static boolean isReservedProperty(String propertyName) {
        boolean reserved = false;
        int i = 0;
        while (i < Properties.CHEMAXON_RESERVED_PROPERTIES.length && !reserved) {
            if (propertyName.equalsIgnoreCase(Properties.CHEMAXON_RESERVED_PROPERTIES[i])) {
                reserved = true;
                continue;
            }
            ++i;
        }
        return reserved;
    }

    public static boolean hasCustomProperty(String[] propKeys) {
        for (int i = 0; i < propKeys.length; ++i) {
            if (ReactionEditorPanel.isReservedProperty(propKeys[i])) continue;
            return true;
        }
        return false;
    }

    protected void writeReactionFile(File oldOutput, File fileToWrite, String format2) {
        int status = this.writeReactionFile(fileToWrite, format2);
        this.handleWriteStatus(oldOutput, status);
    }

    private void handleWriteStatus(File oldOutput, int status) {
        if (status == -1) {
            this.setOutput(null);
            this.notifier.firePropertyChange(PROPERTY_KEY_FILE_CHANGED, null, NO_FILE);
        } else if (status == 0) {
            this.notifier.firePropertyChange(PROPERTY_KEY_FILE_CHANGED, null, this.getOutput().getAbsolutePath());
        } else if (status == 1) {
            this.setOutput(oldOutput);
        }
    }

    protected int writeReactionFile(File fileToWrite, String format2) {
        for (int i = 0; i < this.getListModel().getSize(); ++i) {
            int option;
            if (RxnMolecule.getReaction(((ListableMolecule)this.getListModel().getElementAt(i)).getMolecule()) != null || (option = JOptionPane.showConfirmDialog(this, "WARNING: Your reaction scheme is invalid at reaction #" + (i + 1) + ".\n Invalid reactions schemes can cause several problems until correction!\n Do you really want to save the library?", "Warning!", 0)) != 1) continue;
            return 1;
        }
        try {
            FileOutputStream ostream = new FileOutputStream(fileToWrite);
            MolExporter exporter = new MolExporter(ostream, format2);
            for (int i = 0; i < this.getListModel().getSize(); ++i) {
                exporter.write(((ListableMolecule)this.getListModel().getElementAt(i)).getMolecule());
            }
            exporter.close();
            ostream.close();
        }
        catch (Exception e) {
            AlchemistErrorDialog.showError("Error when writing file", e);
            return -1;
        }
        return 0;
    }

    private void exportReactionFile(File fileToExport, String format2) {
        try {
            FileOutputStream ostream = new FileOutputStream(fileToExport);
            MolExporter exporter = new MolExporter(ostream, format2);
            exporter.write(((ListableMolecule)this.lstReactions.getSelectedValue()).getMolecule());
            exporter.close();
            ostream.close();
        }
        catch (Exception e) {
            AlchemistErrorDialog.showError("Error when writing file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readReactionFile(File fileToRead, boolean appendToList) {
        MolImporter importer;
        block31: {
            if (fileToRead.length() == 0L) {
                return;
            }
            importer = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReactionEditorPanel.this.setLoading(true);
                    ReactionEditorPanel.this.setEnabled(false);
                    ReactionEditorPanel.this.setBottomTextVisible(true);
                    ReactionEditorPanel.this.showProgressBar("Loading...");
                    ReactionEditorPanel.this.getLoadProgressBarRefreshTimer().start();
                }
            });
            this.setMaxMolNum(0);
            importer = new MolImporter(fileToRead, "");
            while (importer.skipRecord()) {
                this.setMaxMolNum(this.getMaxMolNum() + 1);
            }
            if (this.getMaxMolNum() != 0) break block31;
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReactionEditorPanel.this.setLoading(false);
                    ReactionEditorPanel.this.setLastSelected(ReactionEditorPanel.this.getLstReactions().getSelectedIndex());
                    ReactionEditorPanel.this.getLoadProgressBarRefreshTimer().stop();
                    ReactionEditorPanel.this.hideProgressBar();
                    ReactionEditorPanel.this.setBottomTextVisible(false);
                    ReactionEditorPanel.this.setEnabled(true);
                }
            });
            return;
        }
        try {
            if (!appendToList) {
                this.clearEditor();
            }
            this.setCurrentMolNum(0);
            importer.close();
            importer = new MolImporter(fileToRead, "");
            Molecule mol = importer.read();
            block16: while (true) {
                if (mol == null) {
                    this.setCurrentMolNum(0);
                    this.setCurrentFormat(importer.getFormat());
                    importer.close();
                    this.getPnlProperties().setPropertyKeys(this.properties);
                    try {
                        if (importer != null) {
                            importer.close();
                        }
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                ListableMolecule item = new ListableMolecule(mol);
                this.getListModel().addElement(item);
                int i = 0;
                while (true) {
                    int j;
                    boolean found;
                    boolean exists;
                    if (i < mol.getPropertyCount()) {
                        exists = false;
                        found = false;
                        j = 0;
                    } else {
                        mol = importer.read();
                        this.setCurrentMolNum(this.getCurrentMolNum() + 1);
                        continue block16;
                    }
                    while (j < this.properties.size() && !exists && !found) {
                        if (this.properties.get(j).equalsIgnoreCase(mol.getPropertyKey(i))) {
                            exists = true;
                            continue;
                        }
                        if (this.properties.get(j).compareToIgnoreCase(mol.getPropertyKey(i)) > 0) {
                            found = true;
                            continue;
                        }
                        ++j;
                    }
                    if (!exists && !ReactionEditorPanel.isReservedProperty(mol.getPropertyKey(i))) {
                        this.properties.add(j, mol.getPropertyKey(i));
                    }
                    ++i;
                }
                break;
            }
        }
        catch (IOException e) {
            block32: {
                try {
                    this.clearEditor();
                    AlchemistErrorDialog.showError("Error occured while opening file", (Exception)e);
                    if (importer == null) break block32;
                    try {
                        importer.close();
                    }
                    catch (IOException e1) {
                        importer = null;
                        AlchemistErrorDialog.showError("Error occured while closing file. Resource can be locked");
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (importer != null) {
                            importer.close();
                        }
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
    }

    protected void clearEditor() {
        this.schemaSketch.setMol(new Molecule());
        this.getListModel().removeAllElements();
        this.properties.clear();
        this.getPnlProperties().clearTable();
        this.ruleEditor.clearAll();
        this.getExampleEditor().refreshInformations(null);
        this.getNameField().setText("");
        this.getTbdpMain().setSelectedIndex(0);
        this.getTestPane().setText("");
    }

    protected void saveCurrentReactionToList() {
        if (!this.isLoading()) {
            this.lastEdited = RxnMolecule.getReaction(this.schemaSketch.getMol());
            if (this.lastEdited == null) {
                Molecule molecule = this.lastEdited = this.schemaSketch.getMol() == null ? new RxnMolecule() : this.schemaSketch.getMol();
            }
            if (this.getLastSelected() != -1) {
                this.getPnlProperties().setReactionProperties(this.lastEdited);
                this.lastEdited.setProperty("REACTIVITY", !this.ruleEditor.getReactivity().equalsIgnoreCase("") ? this.ruleEditor.getReactivity().trim() : null);
                this.lastEdited.setProperty("EXPLAIN_REACTIVITY", this.ruleEditor.getReactivityExplanation().trim());
                this.lastEdited.setProperty("EXCLUDE", !this.ruleEditor.getExclude().equalsIgnoreCase("") ? this.ruleEditor.getExclude().trim() : null);
                this.lastEdited.setProperty("EXPLAIN_EXCLUDE", this.ruleEditor.getExcludeExplanation().trim());
                this.lastEdited.setProperty("SELECTIVITY", !this.ruleEditor.getSelectivity().equalsIgnoreCase("") ? this.ruleEditor.getSelectivity().trim() : null);
                this.lastEdited.setProperty("EXPLAIN_SELECTIVITY", this.ruleEditor.getSelectivityExplanation().trim());
                this.lastEdited.setProperty("TOLERANCE", this.ruleEditor.getTolerance().trim());
                this.lastEdited.setProperty("EXPLAIN_TOLERANCE", this.ruleEditor.getToleranceExplanation().trim());
                this.lastEdited.setProperty("NAME", this.getCmbReactions().getItemAt(this.getLastSelected()).toString().trim());
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                if (!this.separatedConfigBuilders.isSelected() && this.configBuilderPanels != null) {
                    StandardizerConfigurationWriter writer = new StandardizerConfigurationWriter(outputStream);
                    try {
                        writer.writeConfiguration(this.configBuilderPanels[0].getConfiguration());
                        outputStream.flush();
                    }
                    catch (IOException e) {
                        AlchemistErrorDialog.showError("Error when saving standardizer configuration", (Exception)e);
                    }
                    this.lastEdited.setProperty("STANDARDIZATION", outputStream.toString());
                } else {
                    String[][] groupnameArray = this.getGroupnameArray();
                    if (groupnameArray != null && this.configBuilderPanels != null && this.configBuilderPanels.length > 0) {
                        ArrayList<ConfigElement> configItems = new ArrayList<ConfigElement>();
                        for (int i = 0; i < this.configBuilderPanels.length; ++i) {
                            ConfigElement[] items = this.configBuilderPanels[i].getConfiguration();
                            for (int j = 0; j < items.length; ++j) {
                                items[j].addGroup(REACTANT + (i + 1));
                                configItems.add(items[j]);
                            }
                        }
                        StandardizerConfigurationWriter writer = new StandardizerConfigurationWriter(outputStream);
                        try {
                            writer.writeConfiguration(configItems.toArray(new ConfigElement[0]));
                            outputStream.flush();
                        }
                        catch (IOException e) {
                            AlchemistErrorDialog.showError("Error when merging and saving standardizer configuration", (Exception)e);
                        }
                        this.lastEdited.setProperty("STANDARDIZATION", outputStream.toString());
                    }
                }
                Molecule[] exampleMolecules = this.getExampleEditor().getMolecules();
                this.getPnlProperties().setExampleProperties(exampleMolecules);
                if (exampleMolecules.length != 0) {
                    ByteArrayOutputStream examples = new ByteArrayOutputStream();
                    try {
                        MolExporter exporter = new MolExporter(examples, "mrv");
                        for (int i = 0; i < exampleMolecules.length; ++i) {
                            exporter.write(exampleMolecules[i]);
                        }
                        exporter.close();
                    }
                    catch (Exception e) {
                        AlchemistErrorDialog.showError(e);
                    }
                    this.lastEdited.setProperty("EXAMPLE", examples.toString());
                } else {
                    this.lastEdited.setProperty("EXAMPLE", null);
                }
                ((ListableMolecule)this.getListModel().getElementAt(this.getLastSelected())).setMolecule(this.lastEdited);
                this.cmbReactions.setSelectedIndex(this.lstReactions.getSelectedIndex());
            }
            this.setLastSelected(this.lstReactions.getSelectedIndex());
        }
    }

    protected void refreshPanelInformations() {
        if (!this.isLoading()) {
            if (this.lstReactions.getSelectedIndex() != -1) {
                Molecule mol = ((ListableMolecule)this.lstReactions.getSelectedValue()).getMolecule();
                this.schemaSketch.setMol(mol);
                this.ruleEditor.setExclude(mol.getProperty("EXCLUDE"));
                this.ruleEditor.setExcludeExplanation(mol.getProperty("EXPLAIN_EXCLUDE"));
                this.ruleEditor.setReactivity(mol.getProperty("REACTIVITY"));
                this.ruleEditor.setReactivityExplanation(mol.getProperty("EXPLAIN_REACTIVITY"));
                this.ruleEditor.setSelectivity(mol.getProperty("SELECTIVITY"));
                this.ruleEditor.setSelectivityExplanation(mol.getProperty("EXPLAIN_SELECTIVITY"));
                this.ruleEditor.setTolerance(mol.getProperty("TOLERANCE"));
                this.ruleEditor.setToleranceExplanation(mol.getProperty("EXPLAIN_TOLERANCE"));
                if (mol.getProperty("STANDARDIZATION") != null) {
                    RxnMolecule reaction = RxnMolecule.getReaction(mol);
                    if (reaction != null) {
                        String standardization;
                        if (this.configBuilderPanels == null || this.configBuilderPanels.length < reaction.getReactantCount()) {
                            this.configBuilderPanels = new ConfigBuilderPanel[reaction.getReactantCount()];
                            try {
                                for (int i = 0; i < this.configBuilderPanels.length; ++i) {
                                    this.configBuilderPanels[i] = ConfigBuilderPanelFactory.createStandardizerPanel();
                                    this.configBuilderPanels[i].setIgnoreMissingLicense(true);
                                }
                            }
                            catch (Exception e) {
                                AlchemistErrorDialog.showError("Could not load standardization for reaction", e);
                            }
                        }
                        if ((standardization = mol.getProperty("STANDARDIZATION")) == null) {
                            standardization = "";
                        }
                        for (int i = 0; i < reaction.getReactantCount(); ++i) {
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(standardization.getBytes());
                            StandardizerConfigurationReader reader = new StandardizerConfigurationReader(new ConfigElementFactory("/chemaxon/alchemist/configbuilder/standardizer/StandardizerConfiguration.xml"), inputStream);
                            this.configBuilderPanels[i].readConfiguration(reader, new String[]{"", REACTANT + (i + 1)});
                        }
                    }
                } else {
                    this.configBuilderPanels = null;
                }
                this.getExampleEditor().refreshInformations(mol);
                this.getPnlProperties().refreshInformations(mol, this.getExampleEditor().getMolecules());
                this.refreshStandardizationPanel();
                if (this.getLstReactions().getSelectedValue() != null) {
                    this.getNameField().setText(this.getLstReactions().getSelectedValue().toString());
                }
                this.getTestPane().setText("");
            } else {
                this.schemaSketch.setMol(new Molecule());
                this.getExampleEditor().clearInformations();
                this.getPnlProperties().clearTable();
                this.refreshStandardizationPanel();
            }
        }
    }

    protected JComboBox getCmbReactions() {
        if (this.cmbReactions == null) {
            this.cmbReactions = new JComboBox(this.getListModel());
            this.cmbReactions.setAlignmentX(0.0f);
            this.cmbReactions.setPreferredSize(new Dimension(250, 20));
            this.cmbReactions.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ReactionEditorPanel.this.getLstReactions().getSelectedIndex() != ReactionEditorPanel.this.getCmbReactions().getSelectedIndex() && ReactionEditorPanel.this.getLstReactions().getModel().getSize() != 0) {
                                ReactionEditorPanel.this.getLstReactions().setSelectedIndex(ReactionEditorPanel.this.getCmbReactions().getSelectedIndex());
                                ReactionEditorPanel.this.saveCurrentReactionToList();
                                ReactionEditorPanel.this.refreshPanelInformations();
                            }
                        }
                    });
                }
            });
            this.cmbReactions.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    if (event.getKeyCode() == 10) {
                        ReactionEditorPanel.this.getCmbReactions().setEditable(false);
                        int selected = ReactionEditorPanel.this.getCmbReactions().getSelectedIndex();
                        ListableMolecule molecule = (ListableMolecule)ReactionEditorPanel.this.getListModel().getElementAt(selected);
                        String newName = (String)ReactionEditorPanel.this.getCmbReactions().getEditor().getItem();
                        molecule.setName(newName);
                        ReactionEditorPanel.this.getNameField().setText(newName);
                        ReactionEditorPanel.this.updateUI();
                    } else if (event.getKeyCode() == 27) {
                        ReactionEditorPanel.this.getCmbReactions().setEditable(false);
                        ReactionEditorPanel.this.saveCurrentReactionToList();
                        ReactionEditorPanel.this.updateUI();
                    }
                }
            });
            this.cmbReactions.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    ReactionEditorPanel.this.getCmbReactions().setEditable(false);
                    ReactionEditorPanel.this.saveCurrentReactionToList();
                    ReactionEditorPanel.this.updateUI();
                }
            });
            this.cmbReactions.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getButton() == 1 && event.getClickCount() > 1) {
                        ReactionEditorPanel.this.getCmbReactions().setEditable(true);
                    }
                }
            });
            this.cmbReactions.setRenderer(new NumberedComboBoxRenderer(this.cmbReactions.getRenderer(), this.cmbReactions));
        }
        return this.cmbReactions;
    }

    private JPanel getPnlCombo() {
        if (this.pnlCombo == null) {
            this.pnlCombo = new JPanel();
            this.pnlCombo.setLayout(new BorderLayout());
            this.pnlCombo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pnlCombo.add((Component)this.getCmbReactions(), "West");
            this.pnlCombo.add((Component)this.getPnlComboSwitch(), "Center");
        }
        return this.pnlCombo;
    }

    private JPanel getPnlComboSwitch() {
        if (this.pnlComboSwitch == null) {
            this.setLblInfo(new JLabel());
            this.getLblInfo().setText("Select a reaction");
            this.getLblInfo().setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.pnlComboSwitch = new JPanel();
            this.pnlComboSwitch.setLayout(new BorderLayout());
            this.pnlComboSwitch.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.pnlComboSwitch.add((Component)this.getjToggleButton(), "West");
            this.pnlComboSwitch.add((Component)this.getLblInfo(), "Center");
        }
        return this.pnlComboSwitch;
    }

    protected JToggleButton getjToggleButton() {
        if (this.jToggleButton == null) {
            this.jToggleButton = new JToggleButton();
            this.jToggleButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/down.gif"));
            this.jToggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReactionEditorPanel.this.getjToggleButton().isSelected()) {
                        ReactionEditorPanel.this.add((Component)ReactionEditorPanel.this.getPnlList(), "West");
                        ReactionEditorPanel.this.getjToggleButton().setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/up.gif"));
                    } else {
                        ReactionEditorPanel.this.remove(ReactionEditorPanel.this.getPnlList());
                        ReactionEditorPanel.this.getjToggleButton().setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/down.gif"));
                    }
                    ReactionEditorPanel.this.getLblInfo().setVisible(!ReactionEditorPanel.this.getjToggleButton().isSelected());
                    ReactionEditorPanel.this.getCmbReactions().setEnabled(!ReactionEditorPanel.this.getjToggleButton().isSelected());
                    ReactionEditorPanel.this.updateUI();
                }
            });
        }
        return this.jToggleButton;
    }

    private JTabbedPane getPnlRules() {
        if (this.pnlRules == null) {
            this.pnlRules = this.ruleEditor.getRuleEditor();
        }
        return this.pnlRules;
    }

    @Override
    public void enterPage(AlchemistState state) {
        this.setLastUsedDir((String)state.getProperty(PROPERTY_KEY_LAST_USED_DIR));
        if (this.getLastUsedDir() != null && this.getFileChooser() != null && new File(this.getLastUsedDir()).isDirectory()) {
            this.getFileChooser().setCurrentDirectory(new File(this.getLastUsedDir()));
        }
    }

    @Override
    public void leavePage(AlchemistState state) {
        try {
            this.sketchUserSettings.save("Save");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        state.setPersistentProperty(PROPERTY_KEY_LAST_USED_DIR, this.getLastUsedDir());
    }

    public void setReactionFile(String path) {
        this.setLastSelected(-1);
        if (!"".equalsIgnoreCase(path)) {
            this.setOutput(new File(path));
            this.readReactionFile(this.getOutput(), false);
        } else {
            this.setEnabled(false);
            this.setLastSelected(0);
            ListableMolecule molecule = new ListableMolecule(new Molecule());
            molecule.setName("empty reaction");
            this.getListModel().addElement(molecule);
            this.setLoading(false);
            this.setEnabled(true);
            this.setOutput(null);
            this.setSelectedReaction(0);
        }
        this.notifier.firePropertyChange(PROPERTY_KEY_FILE_CHANGED, null, "".equals(path) ? NO_FILE : path);
    }

    public void setReactionFile(String path, final int selectedIndex) {
        this.setReactionFile(path);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactionEditorPanel.this.setLoading(true);
                ReactionEditorPanel.this.getLstReactions().setSelectedIndex(selectedIndex);
                ReactionEditorPanel.this.setLoading(false);
                ReactionEditorPanel.this.refreshPanelInformations();
            }
        });
    }

    public void setSelectedReaction(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactionEditorPanel.this.setLoading(true);
                ReactionEditorPanel.this.getLstReactions().setSelectedIndex(index);
                ReactionEditorPanel.this.setLoading(false);
                ReactionEditorPanel.this.refreshPanelInformations();
            }
        });
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            this.northPanel.setLayout(new BorderLayout());
            this.northPanel.add((Component)this.getPnlCombo(), "Center");
            this.northPanel.add((Component)this.getMainToolBar(), "North");
        }
        return this.northPanel;
    }

    private JToolBar getMainToolBar() {
        if (this.mainToolBar == null) {
            this.mainToolBar = new JToolBar();
            this.mainToolBar.setFloatable(false);
            this.mainToolBar.setRollover(true);
            this.mainToolBar.add(this.getNewLibraryToolButton());
            this.mainToolBar.add(this.getOpenFileToolButton());
            this.mainToolBar.add(this.getSaveFileToolButton());
            this.mainToolBar.add(this.getSaveFileAsToolButton());
            this.mainToolBar.addSeparator();
            this.mainToolBar.add(this.getAddReactionToolButton());
            this.mainToolBar.add(this.getRemoveReactionToolButton());
            this.mainToolBar.add(this.getImportReactionsToolButton());
            this.mainToolBar.add(this.getExportReactionToFileToolButton());
            this.mainToolBar.addSeparator();
            this.mainToolBar.add(this.getAddExampleToolButton());
            this.mainToolBar.add(this.getEditExampleToolButton());
            this.mainToolBar.add(this.getRemoveExampleToolButton());
            this.mainToolBar.add(this.getSetExampleGridSizeToolButton());
            this.mainToolBar.add(this.getApplyEditExampleToolButton());
            this.mainToolBar.add(this.getCancelEditExampleToolButton());
            this.mainToolBar.addSeparator();
            this.mainToolBar.add(this.getAddPropertyToolButton());
            this.mainToolBar.add(this.getRemovePropertyToolButton());
            this.mainToolBar.add(this.getSortLibraryToolButton());
        }
        return this.mainToolBar;
    }

    private JButton getAddReactionToolButton() {
        if (this.addReactionToolButton == null) {
            this.addReactionToolButton = new JButton(this.ADD_REACTION_ACTION);
            this.addReactionToolButton.setToolTipText("Add New Reaction to Library");
            this.addReactionToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/addreaction.gif")));
        }
        return this.addReactionToolButton;
    }

    private JButton getRemoveReactionToolButton() {
        if (this.removeReactionToolButton == null) {
            this.removeReactionToolButton = new JButton(this.REMOVE_REACTION_ACTION);
            this.removeReactionToolButton.setToolTipText("Remove Reaction from Library");
            this.removeReactionToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/removereaction.gif")));
        }
        return this.removeReactionToolButton;
    }

    private JButton getOpenFileToolButton() {
        if (this.openFileToolButton == null) {
            this.openFileToolButton = new JButton(this.OPEN_REACTION_FILE_ACTION);
            this.openFileToolButton.setToolTipText("Open Reaction Library");
            this.openFileToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/opendocument.gif")));
        }
        return this.openFileToolButton;
    }

    private JButton getSaveFileToolButton() {
        if (this.saveFileToolButton == null) {
            this.saveFileToolButton = new JButton(this.SAVE_REACTION_FILE_ACTION);
            this.saveFileToolButton.setToolTipText("Save Current Library");
            this.saveFileToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/savedocument.gif")));
        }
        return this.saveFileToolButton;
    }

    private JButton getSaveFileAsToolButton() {
        if (this.saveFileAsToolButton == null) {
            this.saveFileAsToolButton = new JButton(this.SAVE_REACTION_FILE_AS_ACTION);
            this.saveFileAsToolButton.setToolTipText("Save Library As...");
            this.saveFileAsToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/savedocumentas.gif")));
        }
        return this.saveFileAsToolButton;
    }

    private JButton getImportReactionsToolButton() {
        if (this.importReactionsToolButton == null) {
            this.importReactionsToolButton = new JButton(this.IMPORT_REACTIONS_FROM_FILE_ACTION);
            this.importReactionsToolButton.setToolTipText("Import Reactions from File...");
            this.importReactionsToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/importreaction.gif")));
        }
        return this.importReactionsToolButton;
    }

    private JButton getExportReactionToFileToolButton() {
        if (this.exportReactionToFileToolButton == null) {
            this.exportReactionToFileToolButton = new JButton(this.EXPORT_REACTIONS_TO_FILE_ACTION);
            this.exportReactionToFileToolButton.setToolTipText("Export current reaction to File...");
            this.exportReactionToFileToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/exportreaction.gif")));
        }
        return this.exportReactionToFileToolButton;
    }

    private JButton getAddExampleToolButton() {
        if (this.addExampleToolButton == null) {
            this.addExampleToolButton = new JButton(this.ADD_EXAMPLE_ACTION);
            this.addExampleToolButton.setToolTipText("Add new Example to current Reaction");
            this.addExampleToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/addexample.gif")));
        }
        return this.addExampleToolButton;
    }

    private JButton getApplyEditExampleToolButton() {
        if (this.applyEditExampleToolButton == null) {
            this.applyEditExampleToolButton = new JButton(this.APPLY_EDIT_EXAMPLE_ACTION);
            this.applyEditExampleToolButton.setToolTipText("Apply example editing");
            this.applyEditExampleToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/accept.gif")));
        }
        return this.applyEditExampleToolButton;
    }

    private JButton getCancelEditExampleToolButton() {
        if (this.cancelEditExampleToolButton == null) {
            this.cancelEditExampleToolButton = new JButton(this.CANCEL_EDIT_EXAMPLE_ACTION);
            this.cancelEditExampleToolButton.setToolTipText("Cancel example editing");
            this.cancelEditExampleToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/cancel.gif")));
        }
        return this.cancelEditExampleToolButton;
    }

    private JButton getEditExampleToolButton() {
        if (this.editExampleToolButton == null) {
            this.editExampleToolButton = new JButton(this.EDIT_EXAMPLE_ACTION);
            this.editExampleToolButton.setToolTipText("Edit selected Example");
            this.editExampleToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/editexample.gif")));
        }
        return this.editExampleToolButton;
    }

    private JButton getRemoveExampleToolButton() {
        if (this.removeExampleToolButton == null) {
            this.removeExampleToolButton = new JButton(this.REMOVE_EXAMPLE_ACTION);
            this.removeExampleToolButton.setToolTipText("Delete selected Example from current Reaction");
            this.removeExampleToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/removeexample.gif")));
        }
        return this.removeExampleToolButton;
    }

    private JButton getSetExampleGridSizeToolButton() {
        if (this.exampleEditorResizeButton == null) {
            this.exampleEditorResizeButton = new JButton(this.EXAMPLE_EDITOR_RESIZE_ACTION);
            this.exampleEditorResizeButton.setToolTipText("Set up examples grid size");
            this.exampleEditorResizeButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/setgridsize.gif")));
        }
        return this.exampleEditorResizeButton;
    }

    private JButton getNewLibraryToolButton() {
        if (this.newLibraryToolButton == null) {
            this.newLibraryToolButton = new JButton(this.NEW_REACTION_LIBRARY_ACTION);
            this.newLibraryToolButton.setToolTipText("Create a new Reaction Library");
            this.newLibraryToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/newdocument.gif")));
        }
        return this.newLibraryToolButton;
    }

    private JButton getAddPropertyToolButton() {
        if (this.addPropertyToolButton == null) {
            this.addPropertyToolButton = new JButton(this.ADD_PROPERTY_ACTION);
            this.addPropertyToolButton.setToolTipText("Add new Property");
            this.addPropertyToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/addproperty.gif")));
        }
        return this.addPropertyToolButton;
    }

    private JButton getRemovePropertyToolButton() {
        if (this.removePropertyToolButton == null) {
            this.removePropertyToolButton = new JButton(this.REMOVE_PROPERTY_ACTION);
            this.removePropertyToolButton.setToolTipText("Remove selected Property");
            this.removePropertyToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/removeproperty.gif")));
        }
        return this.removePropertyToolButton;
    }

    private JButton getSortLibraryToolButton() {
        if (this.sortLibraryToolButton == null) {
            this.sortLibraryToolButton = new JButton(this.SORT_LIBRARY_ACTION);
            this.sortLibraryToolButton.setToolTipText("Sort all reactions' properties as current's order");
            this.sortLibraryToolButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/toolbar/sortlibrary.gif")));
        }
        return this.sortLibraryToolButton;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ReactorPropertyEditorPanel_SelectionChanged")) {
            this.setToolBarButtonStates();
        } else if (evt.getPropertyName().equals("Alchemist_Enable") && evt.getNewValue().equals(Boolean.TRUE)) {
            this.setEnabled(true);
            this.APPLY_EDIT_EXAMPLE_ACTION.setEnabled(false);
            this.CANCEL_EDIT_EXAMPLE_ACTION.setEnabled(false);
            Molecule mol = ((ListableMolecule)this.lstReactions.getSelectedValue()).getMolecule();
            this.getPnlProperties().refreshInformations(mol, this.getExampleEditor().getMolecules());
            this.tbdpMain.updateUI();
        } else if (evt.getPropertyName().equals("Alchemist_Enable") && evt.getNewValue().equals(Boolean.FALSE)) {
            this.setEnabled(false);
            this.APPLY_EDIT_EXAMPLE_ACTION.setEnabled(true);
            this.CANCEL_EDIT_EXAMPLE_ACTION.setEnabled(true);
            Molecule mol = ((ListableMolecule)this.lstReactions.getSelectedValue()).getMolecule();
            this.getPnlProperties().refreshInformations(mol, this.getExampleEditor().getMolecules());
            this.tbdpMain.updateUI();
        } else if (evt.getPropertyName().equals("ReactionExampleEditor_ExampleAdded") || evt.getPropertyName().equals("ReactionExampleEditor_ExampleEdited")) {
            Molecule mol = ((ListableMolecule)this.lstReactions.getSelectedValue()).getMolecule();
            this.getPnlProperties().refreshInformations(mol, this.getExampleEditor().getMolecules());
        } else if (evt.getPropertyName().equalsIgnoreCase("selectedIndex")) {
            this.setToolBarButtonStates();
        }
        if (evt.getPropertyName().equals("Added") || evt.getPropertyName().equals("Removed") || evt.getPropertyName().equals("OrderChanged")) {
            this.getPnlProperties().refreshInformations(((ListableMolecule)this.lstReactions.getSelectedValue()).getMolecule(), this.getExampleEditor().getMolecules());
        }
    }

    private JPanel getNorthSectionPanel() {
        if (this.northSectionPanel == null) {
            this.northSectionPanel = new JPanel();
            this.northSectionPanel.setLayout(new BorderLayout());
            this.northSectionPanel.add((Component)this.getNorthPanel(), "Center");
        }
        return this.northSectionPanel;
    }

    protected void saveReactionFileAs() {
        if (this.getFileChooser() != null) {
            this.getFileChooser().setDialogTitle("Save Reaction File As");
            this.getFileChooser().clearChoosableFileFilters();
            this.getFileChooser().addReactionLibrarySaveFileFilters();
            this.getFileChooser().setSelectedFile(this.getOutput());
            int rVal = this.getFileChooser().showSaveDialog(this);
            if (rVal == 0) {
                this.setCurrentFormat(((MolFileFilter)this.getFileChooser().getFileFilter()).getFormat());
                File oldOutput = this.getOutput();
                this.setOutput(this.getFileChooser().getSelectedFile());
                String path = this.getOutput().getAbsolutePath();
                this.setLastUsedDir(this.getFileChooser().getCurrentDirectory().getAbsolutePath());
                String extension = ((MolFileFilter)this.getFileChooser().getFileFilter()).getExtension();
                if (!path.endsWith(extension)) {
                    path = path + "." + extension;
                    this.setOutput(new File(path));
                }
                if (this.getOutput().exists()) {
                    if (JOptionPane.showConfirmDialog(this, "File exists. Do You want to Overwrite?", PROPERTY_VALUE_SAVE_REACTION_FILE, 0) == 0) {
                        this.writeReactionFile(oldOutput, this.getOutput(), this.getCurrentFormat());
                    } else {
                        this.setOutput(oldOutput);
                    }
                } else {
                    this.writeReactionFile(oldOutput, this.getOutput(), this.getCurrentFormat());
                }
            }
        }
    }

    protected void exportReactionToFile() {
        if (this.getFileChooser() != null) {
            File file;
            this.getFileChooser().clearChoosableFileFilters();
            this.getFileChooser().addReactionLibrarySaveFileFilters();
            this.getFileChooser().setDialogTitle("Export reaction to file");
            String fname = this.getNameField().getText().trim();
            if ("".equals(fname)) {
                fname = "UnnamedReaction";
            }
            if ((file = this.getFileChooser().getSelectedFile()) == null) {
                file = new File(System.getProperty("user.home"));
            }
            this.getFileChooser().setSelectedFile(new File(file.getParentFile().getAbsolutePath() + File.separatorChar + fname));
            int rVal = this.getFileChooser().showSaveDialog(this);
            if (rVal == 0) {
                this.setCurrentFormat(((MolFileFilter)this.getFileChooser().getFileFilter()).getFormat());
                File output = this.getFileChooser().getSelectedFile();
                String path = output.getAbsolutePath();
                String extension = ((MolFileFilter)this.getFileChooser().getFileFilter()).getExtension();
                if (!path.endsWith(extension)) {
                    path = path + "." + extension;
                    output = new File(path);
                }
                if (output.exists()) {
                    if (JOptionPane.showConfirmDialog(this, "File exists. Do You want to overwrite?", "Export Reaction to File", 0) == 0) {
                        this.exportReactionFile(output, this.getCurrentFormat());
                    }
                } else {
                    this.exportReactionFile(output, this.getCurrentFormat());
                }
            }
        }
    }

    protected void saveReactionFile() {
        if (this.getOutput() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReactionEditorPanel.this.writeReactionFile(ReactionEditorPanel.this.getOutput(), ReactionEditorPanel.this.getOutput(), ReactionEditorPanel.this.getCurrentFormat());
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReactionEditorPanel.this.saveReactionFileAs();
                }
            });
        }
    }

    private JPanel getReactionStandardizationPanel() {
        if (this.reactionStandardizationPanel == null) {
            this.reactionStandardizationPanel = new JPanel();
            this.reactionStandardizationPanel.setLayout(new BorderLayout());
            this.separatedConfigBuilders = new JCheckBox("Different standardization for reactants");
            this.separatedConfigBuilders.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionEditorPanel.this.refreshStandardizationPanel();
                }
            });
            this.separatedConfigBuilders.setSelected(true);
            this.reactionStandardizationPanel.add((Component)this.separatedConfigBuilders, "North");
            this.reactionStandardizationPanel.add((Component)this.getConfigPane(), "Center");
        }
        return this.reactionStandardizationPanel;
    }

    private JTabbedPane getConfigPane() {
        this.configPane = new JTabbedPane();
        RxnMolecule reaction = RxnMolecule.getReaction(this.schemaSketch.getMol());
        if (reaction == null) {
            return this.configPane;
        }
        try {
            int i;
            ConfigBuilderPanel[] newBuilders;
            if (!this.separatedConfigBuilders.isSelected()) {
                newBuilders = this.configBuilderPanels != null && this.configBuilderPanels.length > 0 && this.configBuilderPanels[0] != null ? new ConfigBuilderPanel[]{this.configBuilderPanels[0]} : new ConfigBuilderPanel[]{ConfigBuilderPanelFactory.createStandardizerPanel()};
            } else {
                newBuilders = new ConfigBuilderPanel[reaction.getReactantCount()];
                for (i = 0; i < newBuilders.length; ++i) {
                    if (this.configBuilderPanels != null && i < this.configBuilderPanels.length) {
                        if (this.configBuilderPanels[i] != null) {
                            newBuilders[i] = this.configBuilderPanels[i];
                            continue;
                        }
                        newBuilders[i] = ConfigBuilderPanelFactory.createStandardizerPanel();
                        continue;
                    }
                    newBuilders[i] = ConfigBuilderPanelFactory.createStandardizerPanel();
                }
            }
            this.configBuilderPanels = newBuilders;
            for (i = 0; i < this.configBuilderPanels.length; ++i) {
                this.configPane.addTab(REACTANT + (i + 1), this.configBuilderPanels[i]);
            }
        }
        catch (Exception e) {
            AlchemistErrorDialog.showError(e);
        }
        return this.configPane;
    }

    protected void refreshStandardizationPanel() {
        this.reactionStandardizationPanel.remove(this.configPane);
        this.reactionStandardizationPanel.add((Component)this.getConfigPane(), "Center");
        this.reactionStandardizationPanel.updateUI();
    }

    private String[][] getGroupnameArray() {
        RxnMolecule reaction = RxnMolecule.getReaction(this.schemaSketch.getMol());
        if (reaction == null) {
            return null;
        }
        String[][] groupnameArray = new String[reaction.getReactantCount()][];
        for (int i = 0; i < groupnameArray.length; ++i) {
            groupnameArray[i] = new String[]{REACTANT + (i + 1)};
        }
        return groupnameArray;
    }

    private void disablePanel() {
        this.schemaSketch.setEnabled(false);
        this.getCmbReactions().setEnabled(false);
        this.getLstReactions().setEnabled(false);
        this.getjToggleButton().setEnabled(false);
        this.getTbdpMain().setEnabled(false);
        this.getNameField().setEnabled(false);
        this.ADD_EXAMPLE_ACTION.setEnabled(false);
        this.ADD_PROPERTY_ACTION.setEnabled(false);
        this.ADD_REACTION_ACTION.setEnabled(false);
        this.EDIT_EXAMPLE_ACTION.setEnabled(false);
        this.EXPORT_REACTIONS_TO_FILE_ACTION.setEnabled(false);
        this.IMPORT_REACTIONS_FROM_FILE_ACTION.setEnabled(false);
        this.SAVE_REACTION_FILE_ACTION.setEnabled(false);
        this.SAVE_REACTION_FILE_AS_ACTION.setEnabled(false);
        this.REMOVE_EXAMPLE_ACTION.setEnabled(false);
        this.REMOVE_PROPERTY_ACTION.setEnabled(false);
        this.REMOVE_REACTION_ACTION.setEnabled(false);
        this.NEW_REACTION_LIBRARY_ACTION.setEnabled(false);
        this.OPEN_REACTION_FILE_ACTION.setEnabled(false);
        if (this.mode == 1) {
            this.leaveAction.setEnabled(false);
            this.APPLY_ACTION.setEnabled(false);
        }
    }

    private void enablePanel() {
        this.schemaSketch.setEnabled(true);
        this.getCmbReactions().setEnabled(true);
        this.getLstReactions().setEnabled(true);
        this.getjToggleButton().setEnabled(true);
        this.getTbdpMain().setEnabled(true);
        this.getNameField().setEnabled(true);
        this.ADD_PROPERTY_ACTION.setEnabled(true);
        this.ADD_REACTION_ACTION.setEnabled(true);
        this.EXPORT_REACTIONS_TO_FILE_ACTION.setEnabled(true);
        this.IMPORT_REACTIONS_FROM_FILE_ACTION.setEnabled(true);
        this.SAVE_REACTION_FILE_ACTION.setEnabled(true);
        this.SAVE_REACTION_FILE_AS_ACTION.setEnabled(true);
        this.REMOVE_REACTION_ACTION.setEnabled(true);
        this.NEW_REACTION_LIBRARY_ACTION.setEnabled(true);
        this.OPEN_REACTION_FILE_ACTION.setEnabled(true);
        this.setToolBarButtonStates();
        if (this.mode == 1) {
            this.leaveAction.setEnabled(true);
            this.APPLY_ACTION.setEnabled(true);
        }
    }

    public void clear() {
        this.setLastTabIndex(-1);
        this.clearEditor();
    }

    public void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReactionEditorPanel.this.refreshPanelInformations();
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.enablePanel();
        } else {
            this.disablePanel();
        }
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.add((Component)this.getTbdpMain(), "Center");
            this.contentPanel.add((Component)this.getNorthSectionPanel(), "North");
            if (this.mode == 1) {
                this.contentPanel.add((Component)this.getPnlButtonHolder(), "South");
            } else {
                this.setReactionFile("", 0);
            }
        }
        return this.contentPanel;
    }

    protected void sortReactionList(final boolean descending) {
        ArrayList<ListableMolecule> itemList = new ArrayList<ListableMolecule>(this.getListModel().getSize());
        for (int i = 0; i < this.getListModel().getSize(); ++i) {
            itemList.add((ListableMolecule)this.getListModel().getElementAt(i));
        }
        ListableMolecule[] items = itemList.toArray(new ListableMolecule[0]);
        Arrays.sort(items, new Comparator<ListableMolecule>(){

            @Override
            public int compare(ListableMolecule o1, ListableMolecule o2) {
                String name1 = null;
                String name2 = null;
                if (o1 != null && (name1 = o1.getMolecule().getProperty("NAME")) == null) {
                    name1 = "";
                }
                if (o2 != null && (name2 = o2.getMolecule().getProperty("NAME")) == null) {
                    name2 = "";
                }
                int c = name1.compareTo(name2);
                if (descending) {
                    c *= -1;
                }
                return c;
            }
        });
        Object selectedElement = this.getListModel().getElementAt(this.getLastSelected());
        this.getListModel().removeAllElements();
        for (int i = 0; i < items.length; ++i) {
            this.getListModel().addElement(items[i]);
            if (!items[i].equals(selectedElement)) continue;
            this.setLastSelected(i);
        }
        this.getLstReactions().setSelectedIndex(this.getLastSelected());
    }

    protected AlchemistTableSizeConfigurerComponent getTableSizeConfigurer() {
        if (this.tableSizeConfigurer == null) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReactionEditorPanel.this.getConfigurerPopupMenu() != null && ReactionEditorPanel.this.getConfigurerPopupMenu().isVisible()) {
                        ReactionEditorPanel.this.getConfigurerPopupMenu().setVisible(false);
                        if (ReactionEditorPanel.this.getExampleEditor().moleculeEditor.getColCount() != ReactionEditorPanel.this.getTableSizeConfigurer().getCurrentColCount()) {
                            ReactionEditorPanel.this.getExampleEditor().moleculeEditor.setColCount(ReactionEditorPanel.this.getTableSizeConfigurer().getCurrentColCount());
                        }
                        if (ReactionEditorPanel.this.getExampleEditor().moleculeEditor.getRowCount() != ReactionEditorPanel.this.getTableSizeConfigurer().getCurrentRowCount()) {
                            ReactionEditorPanel.this.getExampleEditor().moleculeEditor.setRowCount(ReactionEditorPanel.this.getTableSizeConfigurer().getCurrentRowCount());
                        }
                    }
                }
            };
            this.tableSizeConfigurer = new AlchemistTableSizeConfigurerComponent(listener, this.getExampleEditor().moleculeEditor.getRowCount(), this.getExampleEditor().moleculeEditor.getColCount(), this.getExampleEditor().moleculeEditor.getMaxRowCount(), this.getExampleEditor().moleculeEditor.getMaxColCount());
        }
        return this.tableSizeConfigurer;
    }

    protected JPopupMenu getConfigurerPopupMenu() {
        if (this.configurerPopupMenu == null) {
            this.configurerPopupMenu = new JPopupMenu();
            this.configurerPopupMenu.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.configurerPopupMenu.add(this.getTableSizeConfigurer());
        }
        return this.configurerPopupMenu;
    }

    protected void setGridSize(ActionEvent e) {
        Rectangle bounds = ((JComponent)e.getSource()).getBounds();
        this.getTableSizeConfigurer().setCurrentColCount(this.getExampleEditor().moleculeEditor.getColCount());
        this.getTableSizeConfigurer().setCurrentRowCount(this.getExampleEditor().moleculeEditor.getRowCount());
        this.getConfigurerPopupMenu().show((JComponent)e.getSource(), 0, bounds.height);
    }

    protected void setTestPane(JTextPane testPane) {
        this.testPane = testPane;
    }

    protected JTextPane getTestPane() {
        return this.testPane;
    }

    protected void setListModel(DefaultComboBoxModel listModel) {
        this.listModel = listModel;
    }

    protected DefaultComboBoxModel getListModel() {
        return this.listModel;
    }

    protected void setCurrentMolNum(int currentMolNum) {
        this.currentMolNum = currentMolNum;
    }

    protected int getCurrentMolNum() {
        return this.currentMolNum;
    }

    protected void setMaxMolNum(int maxMolNum) {
        this.maxMolNum = maxMolNum;
    }

    protected int getMaxMolNum() {
        return this.maxMolNum;
    }

    protected void setOutput(File output) {
        this.output = output;
    }

    protected File getOutput() {
        return this.output;
    }

    protected void setCurrentFormat(String currentFormat) {
        this.currentFormat = currentFormat;
    }

    protected String getCurrentFormat() {
        return this.currentFormat;
    }

    protected void setFileChooser(AlchemistFileChooserForJChem fileChooser) {
        this.fileChooser = fileChooser;
    }

    protected AlchemistFileChooserForJChem getFileChooser() {
        return this.fileChooser;
    }

    protected void setLastUsedDir(String lastUsedDir) {
        this.lastUsedDir = lastUsedDir;
    }

    protected String getLastUsedDir() {
        return this.lastUsedDir;
    }

    protected void setLastSelected(int lastSelected) {
        this.lastSelected = lastSelected;
    }

    protected int getLastSelected() {
        return this.lastSelected;
    }

    protected void setExampleEditor(ReactionExampleEditor exampleEditor) {
        this.exampleEditor = exampleEditor;
    }

    protected ReactionExampleEditor getExampleEditor() {
        return this.exampleEditor;
    }

    protected void setLastTabIndex(int lastTabIndex) {
        this.lastTabIndex = lastTabIndex;
    }

    protected int getLastTabIndex() {
        return this.lastTabIndex;
    }

    protected void setLoadProgressBarRefreshTimer(Timer loadProgressBarRefreshTimer) {
        this.loadProgressBarRefreshTimer = loadProgressBarRefreshTimer;
    }

    protected Timer getLoadProgressBarRefreshTimer() {
        return this.loadProgressBarRefreshTimer;
    }

    protected void setLoading(boolean loading) {
        this.loading = loading;
    }

    protected boolean isLoading() {
        return this.loading;
    }

    protected void setLblInfo(JLabel lblInfo) {
        this.lblInfo = lblInfo;
    }

    protected JLabel getLblInfo() {
        return this.lblInfo;
    }
}

