/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor.reactioneditor.ide;

import chemaxon.alchemist.AlchemistApplication;
import chemaxon.alchemist.reactor.reactioneditor.Properties;
import chemaxon.alchemist.reactor.reactioneditor.ide.ReactionEditorApplication;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.formats.MolImporter;
import chemaxon.reaction.tester.ReactionExampleTester;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

class ComponentFactory {
    static final String PROPERTY_KEY_BACKGROUND_LOADER = "BGLoader";
    static final String PROPERTY_KEY_DATA_IS_LOADING = "DataIsLoading";
    static final String PROPERTY_KEY_PENDING_SELECTION_INDEX = "PendingSelectionIndex";
    static final String PROPERTY_KEY_TEST_RESULTS = "ReactionTestResults";
    private static final Map<AlchemistApplication, JTable> TABLE_CACHE = new WeakHashMap<AlchemistApplication, JTable>();
    private static final Map<AlchemistApplication, JList> EXAMPLE_LIST_CACHE = new WeakHashMap<AlchemistApplication, JList>();
    private static final Map<AlchemistApplication, JComponent> SCHEMA_CANVAS_CACHE = new WeakHashMap<AlchemistApplication, JComponent>();
    private static final Map<AlchemistApplication, JTable> SCHEMA_PROPERTY_TABLE_CACHE = new WeakHashMap<AlchemistApplication, JTable>();
    private static final Map<AlchemistApplication, JTable> EXAPMPLE_PROPERTY_TABLE_CACHE = new WeakHashMap<AlchemistApplication, JTable>();
    private static final Comparator<File> FILE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            if (o1.isDirectory() && o2.isFile()) {
                return 1;
            }
            if (o1.isFile() && o2.isDirectory()) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    private ComponentFactory() {
    }

    private static JTable createPropertyEditorTable(final ReactionEditorApplication app, String propertyKey) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Name");
        columnNames.add("Value");
        final DefaultTableModel model = new DefaultTableModel(columnNames, 0);
        final JTable table = new JTable((TableModel)model){

            @Override
            public boolean isCellEditable(int row, int column) {
                String propertyKey = (String)this.getModel().getValueAt(row, 0);
                if (column == 0) {
                    return !Properties.isReserved(propertyKey);
                }
                if (column == 1 && row + 1 == this.getModel().getRowCount()) {
                    return false;
                }
                return super.isCellEditable(row, column);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                TableCellEditor editor = this.getCellEditor();
                if (editor != null) {
                    Object value = editor.getCellEditorValue();
                    if (this.editingColumn == 0) {
                        if (value == null || value.toString().equals("")) {
                            ((DefaultTableModel)this.getModel()).removeRow(this.editingRow);
                        } else {
                            app.setPropertyTableKey(this, value.toString(), this.editingRow);
                        }
                    } else {
                        this.setValueAt(value, this.editingRow, this.editingColumn);
                    }
                    this.removeEditor();
                }
                if (this.getRowCount() > 0 && this.getValueAt(this.getRowCount() - 1, 0) != null) {
                    ((DefaultTableModel)this.getModel()).addRow(new Object[]{null, null});
                }
            }
        };
        table.setAutoResizeMode(2);
        AbstractAction deletePropertyAction = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/clear.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyCellHandler editor = (PropertyCellHandler)table.getCellEditor();
                if (editor != null) {
                    if (table.getValueAt(table.getSelectedRow(), 1) != null && table.getValueAt(table.getSelectedRow(), 1).toString().length() > 0 && JOptionPane.showConfirmDialog(app.getApplicationFrame(), "Do you want to delete the selected property?", "Delete Property", 0, 3) != 0) {
                        return;
                    }
                    editor.clearEditor();
                    editor.stopCellEditing();
                }
            }
        };
        AbstractAction showValueInEditorAction = new AbstractAction("", AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/more.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = table.getCellEditor();
                if (editor != null && !editor.stopCellEditing()) {
                    editor.cancelCellEditing();
                }
                if (table.getValueAt(table.getSelectedRow(), 0) != null) {
                    if ("Schema".equals(table.getClientProperty("ReactionEditorApplication_PropertyEditorContent"))) {
                        app.editSelectedSchemaProperty();
                    } else if ("Example".equals(table.getClientProperty("ReactionEditorApplication_PropertyEditorContent"))) {
                        app.editSelectedExampleProperty();
                    }
                }
            }
        };
        PropertyCellHandler propertyKeyColumnHandler = new PropertyCellHandler(deletePropertyAction);
        table.getColumnModel().getColumn(0).setCellRenderer(propertyKeyColumnHandler);
        table.getColumnModel().getColumn(0).setCellEditor(propertyKeyColumnHandler);
        PropertyCellHandler propertyValueColumnHandler = new PropertyCellHandler(showValueInEditorAction);
        table.getColumnModel().getColumn(1).setCellRenderer(propertyValueColumnHandler);
        table.getColumnModel().getColumn(1).setCellEditor(propertyValueColumnHandler);
        app.addPropertyChangeListener(propertyKey, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                table.putClientProperty(ComponentFactory.PROPERTY_KEY_DATA_IS_LOADING, Boolean.TRUE);
                model.setRowCount(0);
                if (evt.getNewValue() instanceof Molecule) {
                    Molecule mol = (Molecule)evt.getNewValue();
                    for (int i = 0; i < mol.getPropertyCount(); ++i) {
                        String key = mol.getPropertyKey(i);
                        if ("EXAMPLE".equalsIgnoreCase(key)) continue;
                        model.addRow(ComponentFactory.getPropertyRow(key, mol));
                    }
                    ((DefaultTableModel)table.getModel()).addRow(new Object[]{null, null});
                }
                table.putClientProperty(ComponentFactory.PROPERTY_KEY_DATA_IS_LOADING, Boolean.FALSE);
            }
        });
        table.addPropertyChangeListener("tableCellEditor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyCellHandler handler;
                if (evt.getNewValue() instanceof PropertyCellHandler && (handler = (PropertyCellHandler)evt.getNewValue()).wrapper != null && handler.button != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (table.getEditingColumn() == 1) {
                                handler.button.getAction().actionPerformed(null);
                            }
                        }
                    });
                }
            }
        });
        table.getSelectionModel().setSelectionMode(0);
        return table;
    }

    static JTable getSchemaPropertyEditorTable(final ReactionEditorApplication app) {
        if (SCHEMA_PROPERTY_TABLE_CACHE.containsKey(app)) {
            return SCHEMA_PROPERTY_TABLE_CACHE.get(app);
        }
        final JTable table = ComponentFactory.createPropertyEditorTable(app, "SelectedSchema");
        table.putClientProperty("ReactionEditorApplication_PropertyEditorContent", "Schema");
        SCHEMA_PROPERTY_TABLE_CACHE.put(app, table);
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Molecule mol;
                Boolean value = (Boolean)table.getClientProperty(ComponentFactory.PROPERTY_KEY_DATA_IS_LOADING);
                if (!Boolean.TRUE.equals(value) && (mol = app.getSelectedSchema()) != null) {
                    mol.clearProperties();
                    for (int i = 0; i < table.getRowCount(); ++i) {
                        String propertyKey;
                        if (table.getModel().getValueAt(i, 0) == null || "EXAMPLE".equalsIgnoreCase(propertyKey = table.getModel().getValueAt(i, 0).toString())) continue;
                        String propertyValue = table.getModel().getValueAt(i, 1) == null ? "" : table.getModel().getValueAt(i, 1).toString();
                        mol.setProperty(propertyKey, propertyValue);
                    }
                    app.saveExampleData();
                    app.modified();
                }
            }
        });
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            app.getGUIModule().getActions().getAction("removeSchemaProperty").setEnabled(table.getSelectedRow() != -1);
                            app.getGUIModule().getActions().getAction("moveSchemaPropertyUpwards").setEnabled(table.getSelectedRow() > 0);
                            app.getGUIModule().getActions().getAction("moveSchemaPropertyDownwards").setEnabled(table.getSelectedRow() > -1 && table.getSelectedRow() < table.getRowCount() - 2);
                        }
                    });
                }
            }
        });
        table.setRowHeight((int)((float)table.getRowHeight() * 1.15f));
        return table;
    }

    static JTable getExamplePropertyEditorTable(final ReactionEditorApplication app) {
        if (EXAPMPLE_PROPERTY_TABLE_CACHE.containsKey(app)) {
            return EXAPMPLE_PROPERTY_TABLE_CACHE.get(app);
        }
        final JTable table = ComponentFactory.createPropertyEditorTable(app, "SelectedExample");
        table.putClientProperty("ReactionEditorApplication_PropertyEditorContent", "Example");
        EXAPMPLE_PROPERTY_TABLE_CACHE.put(app, table);
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Boolean value = (Boolean)table.getClientProperty(ComponentFactory.PROPERTY_KEY_DATA_IS_LOADING);
                if (!Boolean.TRUE.equals(value)) {
                    Molecule mol = app.getSelectedExample();
                    if (mol != null) {
                        mol.clearProperties();
                        for (int i = 0; i < table.getRowCount(); ++i) {
                            if (table.getModel().getValueAt(i, 0) == null) continue;
                            String propertyKey = table.getModel().getValueAt(i, 0).toString();
                            String propertyValue = table.getModel().getValueAt(i, 1) == null ? "" : table.getModel().getValueAt(i, 1).toString();
                            mol.setProperty(propertyKey, propertyValue);
                        }
                        app.saveExampleData();
                    }
                    app.modified();
                }
            }
        });
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            app.getGUIModule().getActions().getAction("removeExampleProperty").setEnabled(table.getSelectedRow() != -1);
                            app.getGUIModule().getActions().getAction("moveExamplePropertyUpwards").setEnabled(table.getSelectedRow() > 0);
                            app.getGUIModule().getActions().getAction("moveExamplePropertyDownwards").setEnabled(table.getSelectedRow() > -1 && table.getSelectedRow() < table.getRowCount() - 2);
                        }
                    });
                }
            }
        });
        table.setRowHeight((int)((float)table.getRowHeight() * 1.15f));
        return table;
    }

    static JTree createSuperTree() {
        return ComponentFactory.createSuperTree(null);
    }

    private static void addFilesToNode(DefaultTreeModel model, File[] files, MutableTreeNode root) {
        Arrays.sort(files, FILE_COMPARATOR);
        for (int i = 0; i < files.length; ++i) {
            model.insertNodeInto(new FileNode(files[i]), root, i);
        }
    }

    static JTree createSuperTree(File treeRoot) {
        File root;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        final DefaultTreeModel model = new DefaultTreeModel(rootNode);
        JTree tree = new JTree(model);
        tree.setRootVisible(false);
        tree.setCellRenderer(new FileTreeCellRenderer());
        for (root = treeRoot; root != null && !root.isDirectory(); root = root.getParentFile()) {
        }
        File[] topFiles = null;
        topFiles = root != null && root.isDirectory() ? root.listFiles() : File.listRoots();
        ComponentFactory.addFilesToNode(model, topFiles, rootNode);
        tree.expandPath(new TreePath(rootNode));
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultMutableTreeNode parent;
                if (event.getPath().getLastPathComponent() instanceof MutableTreeNode && (parent = (DefaultMutableTreeNode)event.getPath().getLastPathComponent()).getChildCount() > 0 && parent.getChildAt(0) instanceof FakeTreeNode) {
                    File file;
                    model.removeNodeFromParent((MutableTreeNode)parent.getChildAt(0));
                    if (parent.getUserObject() instanceof File && (file = (File)parent.getUserObject()).isDirectory()) {
                        ComponentFactory.addFilesToNode(model, file.listFiles(), parent);
                    }
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        if (rootNode.getChildCount() == 1) {
            tree.expandPath(new TreePath(new Object[]{rootNode, rootNode.getChildAt(0)}));
        }
        tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return tree;
    }

    static JTable getReactionTable(final ReactionEditorApplication app) {
        if (TABLE_CACHE.containsKey(app)) {
            return TABLE_CACHE.get(app);
        }
        final JTable table = new JTable(new DefaultTableModel(new Object[]{"Reactions"}, 0));
        table.getColumnModel().getColumn(0).setCellRenderer(new MoleculeNameTableCellRenderer());
        table.getColumnModel().getColumn(0).setCellEditor(new MoleculeNameTableCellEditor());
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    JTable propTable = ComponentFactory.getSchemaPropertyEditorTable(app);
                    for (int i = 0; i < propTable.getRowCount(); ++i) {
                        if (!"NAME".equals(propTable.getValueAt(i, 0))) continue;
                        Molecule mol = (Molecule)table.getValueAt(e.getFirstRow(), e.getColumn());
                        ((DefaultTableModel)propTable.getModel()).setValueAt(mol.getProperty("NAME"), i, 1);
                        return;
                    }
                }
            }
        });
        app.addPropertyChangeListener("DocumentPath", new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JTable jTable = table;
                synchronized (jTable) {
                    File file;
                    File file2 = file = evt.getNewValue() != null ? new File(evt.getNewValue().toString()) : null;
                    if (file != null && file.canRead()) {
                        app.firePropertyChange(ComponentFactory.PROPERTY_KEY_DATA_IS_LOADING, false, true);
                        Runnable moleculeRead = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                JTable jTable = table;
                                synchronized (jTable) {
                                    DefaultTableModel model = (DefaultTableModel)table.getModel();
                                    model.setRowCount(0);
                                    MolImporter importer = null;
                                    try {
                                        importer = new MolImporter(new FileInputStream(file));
                                        Molecule mol = importer.read();
                                        while (mol != null) {
                                            model.addRow(new Object[]{mol});
                                            mol = importer.read();
                                        }
                                    }
                                    catch (IOException e) {
                                    }
                                    finally {
                                        if (importer != null) {
                                            try {
                                                importer.close();
                                            }
                                            catch (Exception e) {}
                                        }
                                    }
                                    app.firePropertyChange(ComponentFactory.PROPERTY_KEY_DATA_IS_LOADING, true, false);
                                }
                            }
                        };
                        Executors.newSingleThreadScheduledExecutor().execute(moleculeRead);
                    }
                }
            }
        });
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private Object oldValue = null;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object selectedValue = table.getSelectedRow() == -1 ? null : table.getValueAt(table.getSelectedRow(), 0);
                    app.firePropertyChange("SelectedSchema", this.oldValue, selectedValue);
                    this.oldValue = selectedValue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            app.getGUIModule().getActions().getAction("addSchema").setEnabled(table.getSelectedRow() != -1);
                            app.getGUIModule().getActions().getAction("removeSchema").setEnabled(table.getSelectedRow() != -1);
                            app.getGUIModule().getActions().getAction("moveSchemaUpwards").setEnabled(table.getSelectedRow() > 0);
                            app.getGUIModule().getActions().getAction("moveSchemaDownwards").setEnabled(table.getSelectedRow() > -1 && table.getSelectedRow() < table.getRowCount() - 1);
                            app.getGUIModule().getActions().getAction("addSchemaProperty").setEnabled(table.getSelectedRow() != -1);
                            app.getGUIModule().getActions().getAction("removeSchemaProperty").setEnabled(ComponentFactory.getSchemaPropertyEditorTable(app).getSelectedRow() != -1);
                        }
                    });
                }
            }
        });
        app.addPropertyChangeListener("ReactionEditorApplication_SchemaStructure", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int row = table.getSelectedRow();
                if (row != -1) {
                    ((DefaultTableModel)table.getModel()).setValueAt(evt.getNewValue(), row, 0);
                } else {
                    ((DefaultTableModel)table.getModel()).addRow(new Object[]{evt.getNewValue()});
                }
            }
        });
        TABLE_CACHE.put(app, table);
        return table;
    }

    static JComponent getSchemaCanvas(final ReactionEditorApplication app) {
        if (SCHEMA_CANVAS_CACHE.containsKey(app)) {
            return SCHEMA_CANVAS_CACHE.get(app);
        }
        final JComponent component = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.dispose();
                if (app.getSelectedSchema() != null) {
                    AlchemistMoleculePainter.drawMolecule(15, 15, app.getSelectedSchema(), g, new Dimension(this.getWidth() - 30, this.getHeight() - 30));
                }
            }
        };
        PropertyChangeListener schemaListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.repaint();
            }
        };
        app.addPropertyChangeListener("SelectedSchema", schemaListener);
        app.addPropertyChangeListener("ReactionEditorApplication_SchemaStructure", schemaListener);
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    app.editSelectedSchema();
                }
            }
        });
        SCHEMA_CANVAS_CACHE.put(app, component);
        return component;
    }

    static JList getExampleList(final ReactionEditorApplication app) {
        if (EXAMPLE_LIST_CACHE.containsKey(app)) {
            return EXAMPLE_LIST_CACHE.get(app);
        }
        DefaultListModel model = new DefaultListModel();
        final JList list = new JList((ListModel)model){
            private static final long serialVersionUID = -5718350951057398918L;

            @Override
            protected void paintComponent(Graphics g) {
                if (Boolean.TRUE.equals(this.getClientProperty(ComponentFactory.PROPERTY_KEY_DATA_IS_LOADING))) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setColor(Color.WHITE);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    AlchemistGraphicsUtilities.renderMessageOnComponent(g2, "Loading...", Color.GRAY, this.getWidth(), this.getHeight());
                    g2.dispose();
                } else {
                    super.paintComponent(g);
                }
            }
        };
        list.addListSelectionListener(new ListSelectionListener(){
            private Object oldValue = null;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (list.getSelectedIndex() == -1 && list.getModel().getSize() > 0) {
                        list.setSelectedIndex(list.getFirstVisibleIndex());
                    }
                    app.firePropertyChange("SelectedExample", this.oldValue, list.getSelectedValue());
                    this.oldValue = list.getSelectedValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            app.getGUIModule().getActions().getAction("addExample").setEnabled(list.getSelectedIndex() != -1);
                            app.getGUIModule().getActions().getAction("removeExample").setEnabled(list.getSelectedIndex() != -1);
                            app.getGUIModule().getActions().getAction("moveExampleUpwards").setEnabled(list.getSelectedIndex() > 0);
                            app.getGUIModule().getActions().getAction("moveExampleDownwards").setEnabled(list.getSelectedIndex() > -1 && list.getSelectedIndex() < list.getModel().getSize() - 1);
                            app.getGUIModule().getActions().getAction("addExampleProperty").setEnabled(list.getSelectedIndex() != -1);
                            app.getGUIModule().getActions().getAction("removeExampleProperty").setEnabled(ComponentFactory.getExamplePropertyEditorTable(app).getSelectedRow() != -1);
                        }
                    });
                }
            }
        });
        list.setCellRenderer(new MoleculeListCellRenderer(list));
        final BackgroundMoleculeLoader loader = new BackgroundMoleculeLoader(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultListModel model = (DefaultListModel)list.getModel();
                model.removeAllElements();
                if (evt.getNewValue() instanceof List) {
                    for (Molecule mol : (List)evt.getNewValue()) {
                        model.addElement(mol);
                    }
                }
                list.putClientProperty(ComponentFactory.PROPERTY_KEY_TEST_RESULTS, ComponentFactory.testSelectedReaction(app));
                list.putClientProperty(ComponentFactory.PROPERTY_KEY_DATA_IS_LOADING, Boolean.FALSE);
                list.repaint();
            }
        });
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    app.editSelectedExample();
                }
            }
        });
        PropertyChangeListener schemaListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultListModel model = (DefaultListModel)list.getModel();
                model.removeAllElements();
                if (evt.getNewValue() instanceof Molecule) {
                    String examples = ((Molecule)evt.getNewValue()).getProperty("EXAMPLE");
                    loader.cancel();
                    if (examples != null) {
                        loader.setMoleculeInputStream(new ByteArrayInputStream(examples.getBytes()));
                        list.putClientProperty(ComponentFactory.PROPERTY_KEY_DATA_IS_LOADING, Boolean.TRUE);
                        Executors.newSingleThreadExecutor().execute(loader);
                    }
                } else {
                    loader.cancel();
                }
            }
        };
        app.addPropertyChangeListener("SelectedSchema", schemaListener);
        app.addPropertyChangeListener("ReactionEditorApplication_ExampleStructure", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int index = list.getSelectedIndex();
                if (index == -1 || evt.getOldValue() == null) {
                    ((DefaultListModel)list.getModel()).addElement(evt.getNewValue());
                    list.setSelectedIndex(list.getModel().getSize() - 1);
                } else {
                    ((DefaultListModel)list.getModel()).setElementAt(evt.getNewValue(), index);
                }
                list.putClientProperty(ComponentFactory.PROPERTY_KEY_TEST_RESULTS, ComponentFactory.testSelectedReaction(app));
                list.repaint();
                app.saveExampleData();
            }
        });
        EXAMPLE_LIST_CACHE.put(app, list);
        return list;
    }

    private static final Object[] getPropertyRow(String key, Molecule mol) {
        Object value = mol.getProperty(key);
        if ("STANDARDIZATION".equals(key)) {
            value = new PropertyWrapper(value);
        }
        return new Object[]{key, value};
    }

    private static final String createToolTip(String toolTipText) {
        String text = toolTipText;
        JLabel label = new JLabel();
        if (text == null || "".equals(text)) {
            return null;
        }
        if (text.length() > 300) {
            text = text.substring(0, 300) + "...";
        }
        String[] words = text.split(" |\n");
        StringBuffer textBuff = new StringBuffer();
        StringBuffer lineBuff = new StringBuffer();
        for (int i = 0; i < words.length; ++i) {
            if (SwingUtilities.computeStringWidth(label.getFontMetrics(label.getFont()), lineBuff.toString()) < 400) {
                lineBuff.append(' ');
                lineBuff.append(words[i]);
                continue;
            }
            textBuff.append(lineBuff.toString());
            textBuff.append('\n');
            lineBuff = new StringBuffer(words[i]);
        }
        textBuff.append(lineBuff.toString());
        text = textBuff.toString();
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("\n", "<br>");
        return "<html>" + text + "</html>";
    }

    private static final String[] testSelectedReaction(ReactionEditorApplication app) {
        ArrayList<String> result = new ArrayList<String>();
        JList list = ComponentFactory.getExampleList(app);
        Molecule example = null;
        RxnMolecule reaction = (RxnMolecule)ComponentFactory.getReactionTable(app).getValueAt(ComponentFactory.getReactionTable(app).getSelectedRow(), 0);
        for (int i = 0; i < list.getModel().getSize(); ++i) {
            example = (Molecule)list.getModel().getElementAt(i);
            if (example.isReaction()) {
                if (ReactionExampleTester.testReactionExamples((Molecule)reaction, Arrays.asList((RxnMolecule)example), true, false) != null) {
                    result.add("This example is not working!");
                    continue;
                }
                result.add("");
                continue;
            }
            result.add("This example is not a reaction!");
        }
        return result.toArray(new String[result.size()]);
    }

    private static class BackgroundMoleculeLoader
    implements Runnable {
        private InputStream moleculeInputStream = null;
        private volatile boolean canceled = false;
        private final PropertyChangeListener listener;

        public BackgroundMoleculeLoader(PropertyChangeListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            this.canceled = false;
            final ArrayList<Molecule> exampleList = new ArrayList<Molecule>();
            MolImporter importer = null;
            try {
                importer = new MolImporter(this.moleculeInputStream);
                Molecule mol = importer.read();
                while (mol != null && !this.canceled) {
                    exampleList.add(mol);
                    mol = importer.read();
                }
            }
            catch (Exception e) {
            }
            finally {
                if (importer != null) {
                    try {
                        importer.close();
                    }
                    catch (Exception e) {}
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BackgroundMoleculeLoader.this.listener.propertyChange(new PropertyChangeEvent(BackgroundMoleculeLoader.this, ComponentFactory.PROPERTY_KEY_BACKGROUND_LOADER, null, BackgroundMoleculeLoader.this.canceled ? new ArrayList() : exampleList));
                }
            });
        }

        public void cancel() {
            this.canceled = true;
        }

        public synchronized void setMoleculeInputStream(InputStream inputStream) {
            this.moleculeInputStream = inputStream;
        }
    }

    private static final class FileNode
    extends DefaultMutableTreeNode {
        private volatile boolean molfile = false;
        private volatile int molecules = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileNode(File file) {
            super(file);
            if (file.isDirectory()) {
                this.insert(new FakeTreeNode(), 0);
            } else if (file.isFile()) {
                MolImporter importer = null;
                try {
                    importer = new MolImporter(new FileInputStream(this.getFile()));
                    this.molfile = true;
                }
                catch (IOException e) {
                }
                finally {
                    if (importer != null) {
                        try {
                            importer.close();
                        }
                        catch (Exception e) {}
                    }
                }
                Runnable moleculeCheck = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        FileNode fileNode = FileNode.this;
                        synchronized (fileNode) {
                            MolImporter importer = null;
                            try {
                                importer = new MolImporter(new FileInputStream(FileNode.this.getFile()));
                                while (importer.skipRecord()) {
                                    FileNode.this.molecules++;
                                }
                            }
                            catch (IOException e) {
                            }
                            finally {
                                if (importer != null) {
                                    try {
                                        importer.close();
                                    }
                                    catch (Exception e) {}
                                }
                            }
                            if (FileNode.this.molecules > 0) {
                                FileNode.this.insert(new FakeTreeNode(), 0);
                            }
                        }
                    }
                };
                Executors.newSingleThreadExecutor().execute(moleculeCheck);
            }
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof File) {
                String name = ((File)this.getUserObject()).getName();
                return name;
            }
            return super.toString();
        }

        public File getFile() {
            return this.userObject instanceof File ? (File)this.userObject : null;
        }

        public boolean isMolFile() {
            return this.molfile;
        }
    }

    private static final class FakeTreeNode
    extends DefaultMutableTreeNode {
        public FakeTreeNode() {
            super("<Empty>");
        }
    }

    private static final class MoleculeNameTableCellEditor
    extends DefaultCellEditor {
        Object value = null;

        public MoleculeNameTableCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = value;
            JTextField text = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value instanceof Molecule) {
                text.setText(((Molecule)value).getProperty("NAME"));
            }
            return text;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.value instanceof Molecule) {
                ((Molecule)this.value).setProperty("NAME", ((JTextField)this.editorComponent).getText());
            }
            return this.value;
        }
    }

    private static final class MoleculeNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private MoleculeNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Molecule) {
                String name = ((Molecule)value).getProperty("NAME");
                if (name == null) {
                    name = "Structure #" + row;
                }
                label.setText(name);
                label.setToolTipText(ComponentFactory.createToolTip(name));
            }
            return label;
        }
    }

    private static final class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private FileTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof FileNode) {
                FileNode node = (FileNode)value;
                if (node.getFile().isDirectory()) {
                    label.setIcon(expanded ? this.getOpenIcon() : this.getClosedIcon());
                } else if (node.isMolFile()) {
                    label.setIcon(null);
                } else {
                    label.setIcon(this.getLeafIcon());
                }
            }
            return label;
        }
    }

    static final class PropertyCellHandler
    extends DefaultCellEditor
    implements TableCellRenderer {
        private static final DefaultTableCellRenderer RENDERER = new DefaultTableCellRenderer();
        private final JPanel panel = new JPanel((LayoutManager)new FormLayout("fill:min:grow, min", "min, fill:min:grow"));
        private final JButton button;
        private PropertyWrapper wrapper = null;

        public PropertyCellHandler(Action buttonAction) {
            super(new JTextField());
            CellConstraints cc = new CellConstraints();
            if (buttonAction != null) {
                this.button = new JButton(buttonAction);
                this.button.setFocusable(false);
                this.button.setBorder(null);
                this.button.setMinimumSize(new Dimension(16, 16));
                this.button.setMaximumSize(new Dimension(16, 16));
                this.button.setPreferredSize(new Dimension(16, 16));
                this.button.setSize(new Dimension(16, 16));
                this.panel.add((Component)this.button, cc.xy(2, 1));
            } else {
                this.button = null;
            }
            this.panel.add(super.getComponent(), cc.xywh(1, 1, 1, 2));
            this.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setEnabled(true);
            label.setFont(label.getFont().deriveFont(0));
            label.setToolTipText(ComponentFactory.createToolTip(label.getText()));
            if (column == 0) {
                if (row == table.getRowCount() - 1) {
                    label.setEnabled(false);
                    label.setText("<Click to Add>");
                    label.setToolTipText("Type a property name here to add new property.");
                } else if (Properties.isReserved(label.getText())) {
                    label.setFont(label.getFont().deriveFont(1));
                    label.setText(Properties.getUserFriendlyName(label.getText()));
                    label.setToolTipText(ComponentFactory.createToolTip(label.getText()));
                }
            } else if (value instanceof PropertyWrapper) {
                label.setEnabled(false);
                label.setText(((PropertyWrapper)value).getRendered());
                label.setToolTipText(ComponentFactory.createToolTip(label.getText()));
            }
            return label;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.button != null) {
                this.button.setVisible(false);
            }
            this.wrapper = value instanceof PropertyWrapper ? (PropertyWrapper)value : null;
            super.getTableCellEditorComponent(table, value, isSelected, row, column);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PropertyCellHandler.this.button != null) {
                        PropertyCellHandler.this.button.setVisible(true);
                    }
                    PropertyCellHandler.super.getComponent().requestFocus();
                }
            });
            return this.panel;
        }

        public void clearEditor() {
            ((JTextField)super.getComponent()).setText(null);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.wrapper != null) {
                this.wrapper.set((String)super.getCellEditorValue());
                return this.wrapper;
            }
            return super.getCellEditorValue();
        }
    }

    static final class MoleculeListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final Molecule EMPTY = new Molecule();
        private Molecule molecule = EMPTY;
        private final JList assignedList;
        private final JComponent moleculeComponent = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                AlchemistMoleculePainter.drawMolecule(MoleculeListCellRenderer.this.molecule, g, new Dimension(MoleculeListCellRenderer.this.assignedList.getFixedCellWidth(), MoleculeListCellRenderer.this.assignedList.getFixedCellHeight()));
            }
        };
        private final JLabel topComponent = new JLabel("");
        private final JLabel bottomComponent = new JLabel("");
        private static final long serialVersionUID = -1798448947968101596L;

        public MoleculeListCellRenderer(JList list) {
            this.assignedList = list;
            this.assignedList.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Rectangle rect = MoleculeListCellRenderer.this.assignedList.getVisibleRect();
                    Dimension dim = new Dimension(rect.width - rect.x, rect.height - rect.y);
                    MoleculeListCellRenderer.this.assignedList.setFixedCellWidth(dim.width);
                    MoleculeListCellRenderer.this.assignedList.setFixedCellHeight(dim.height);
                }
            });
            this.topComponent.setHorizontalAlignment(0);
            this.topComponent.setOpaque(false);
            this.bottomComponent.setHorizontalAlignment(0);
            this.bottomComponent.setOpaque(false);
            this.bottomComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
            this.moleculeComponent.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.topComponent, "North");
            this.add((Component)this.moleculeComponent, "Center");
            this.add((Component)this.bottomComponent, "South");
            this.setBackground(this.assignedList.getBackground());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.molecule = value instanceof Molecule ? (Molecule)value : EMPTY;
            this.topComponent.setText(index + 1 + "/" + list.getModel().getSize());
            if ("false".equalsIgnoreCase(this.molecule.getProperty("ENABLED"))) {
                this.bottomComponent.setForeground(Color.GRAY);
                this.bottomComponent.setText("This example is disabled.");
            } else {
                Object obj = list.getClientProperty(ComponentFactory.PROPERTY_KEY_TEST_RESULTS);
                if (obj instanceof String[]) {
                    String[] result = (String[])obj;
                    this.bottomComponent.setForeground(Color.RED);
                    this.bottomComponent.setText(result.length > index ? result[index] : "Example test failed.");
                } else {
                    this.bottomComponent.setText("");
                }
            }
            return this;
        }
    }

    static final class PropertyWrapper {
        private String data = null;
        private final String rendered;

        PropertyWrapper(Object obj) {
            this(obj, "<Click to Edit>");
        }

        PropertyWrapper(Object obj, String rendeded) {
            this.data = obj != null ? obj.toString() : null;
            this.rendered = rendeded;
        }

        void set(String data) {
            this.data = data;
        }

        String get() {
            return this.data;
        }

        String getRendered() {
            return this.rendered;
        }

        public String toString() {
            return this.data;
        }
    }
}

