/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.reactor.reactioneditor.ide;

import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanelFactory;
import chemaxon.alchemist.configbuilder.ConfigurationReaderFactory;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationWriter;
import chemaxon.alchemist.reactor.reactioneditor.ide.ComponentFactory;
import chemaxon.alchemist.reactor.reactioneditor.ide.ReactionEditorApplication;
import chemaxon.alchemist.utils.AlchemistInnerDialog;
import chemaxon.marvin.util.codeassist.CodeAssistDataProvider;
import chemaxon.marvin.util.codeassist.CodeAssistFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;

class PropertyEditorDialog
extends AlchemistInnerDialog {
    private final ReactionEditorApplication app;
    private final PresentationChooser presentationChooser = new PresentationChooser();
    private JScrollPane scrollPane = null;
    private final Action acceptAction = new AbstractAction("Accept"){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = null;
            if ("Schema".equals(PropertyEditorDialog.this.getClientProperty("ReactionEditorApplication_PropertyEditorContent"))) {
                table = ComponentFactory.getSchemaPropertyEditorTable(PropertyEditorDialog.this.app);
            } else if ("Example".equals(PropertyEditorDialog.this.getClientProperty("ReactionEditorApplication_PropertyEditorContent"))) {
                table = ComponentFactory.getExamplePropertyEditorTable(PropertyEditorDialog.this.app);
            }
            if (table != null) {
                table.getModel().setValueAt(PropertyEditorDialog.this.presentationChooser.getValue(), table.getSelectedRow(), 1);
            }
            PropertyEditorDialog.this.setVisible(false);
            PropertyEditorDialog.this.app.setEnabled(true);
        }
    };
    private final Action cancelAction = new AbstractAction("Cancel"){

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertyEditorDialog.this.setVisible(false);
            PropertyEditorDialog.this.app.setEnabled(true);
        }
    };

    PropertyEditorDialog(ReactionEditorApplication app) {
        super("Edit property", (LayoutManager)new FormLayout("4dlu, fill:min:grow, 4dlu", "4dlu, fill:min:grow, 4dlu"));
        this.setActions(new Action[]{this.acceptAction, this.cancelAction});
        this.setCloseAction(this.cancelAction);
        this.app = app;
        this.setMaximizable(true);
    }

    void initializeEditor(String context) {
        this.putClientProperty("ReactionEditorApplication_PropertyEditorContent", context);
        JTable table = null;
        if ("Schema".equals(context)) {
            table = ComponentFactory.getSchemaPropertyEditorTable(this.app);
        } else if ("Example".equals(context)) {
            table = ComponentFactory.getExamplePropertyEditorTable(this.app);
        }
        if (table != null) {
            CellConstraints cc = new CellConstraints();
            String propertyName = table.getModel().getValueAt(table.getSelectedRow(), 0) == null ? "" : table.getModel().getValueAt(table.getSelectedRow(), 0).toString();
            String propertyValue = table.getModel().getValueAt(table.getSelectedRow(), 1) == null ? "" : table.getModel().getValueAt(table.getSelectedRow(), 1).toString();
            Component newComponent = this.presentationChooser.getEditor(propertyName, propertyValue);
            if (this.scrollPane != null) {
                this.getContentPane().remove(this.scrollPane);
            }
            this.scrollPane = new JScrollPane(newComponent, 20, 31);
            this.getContentPane().add((Component)this.scrollPane, cc.xy(2, 2));
            if (newComponent instanceof ConfigBuilderPanel) {
                this.setNormal();
                this.setPreferredSize(new Dimension((int)((float)this.app.getApplicationFrame().getWidth() * 0.8f), (int)((float)this.app.getApplicationFrame().getHeight() * 0.8f)));
                AlchemistInnerDialog.setCentered(this);
            } else {
                this.setPreferredSize(new Dimension(320, 240));
                this.setNormal();
                this.pack();
            }
            this.validate();
        }
    }

    private static final class PresentationChooser {
        private static final JTextPane DEFAULT_EDITOR = new JTextPane();
        private static final Map<String, Component> CACHE = new HashMap<String, Component>();
        private Component editor = null;

        private PresentationChooser() {
        }

        Component getEditor(String propertyName, String propertyValue) {
            this.editor = CACHE.get(propertyName);
            if (this.editor == null) {
                this.editor = DEFAULT_EDITOR;
            }
            if (this.editor instanceof JTextPane) {
                ((JTextPane)this.editor).setText(propertyValue);
            } else if (this.editor instanceof ConfigBuilderPanel) {
                ((ConfigBuilderPanel)this.editor).readConfiguration(ConfigurationReaderFactory.createStandardizerConfigurationReader(propertyValue));
            }
            return this.editor;
        }

        Object getValue() {
            Object result = "";
            if (this.editor != null) {
                if (this.editor instanceof JTextPane) {
                    return ((JTextPane)this.editor).getText();
                }
                if (this.editor instanceof ConfigBuilderPanel) {
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    try {
                        ((ConfigBuilderPanel)this.editor).writeConfiguration(new StandardizerConfigurationWriter(ostream));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        result = ostream.toString("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        result = ostream.toString();
                    }
                    result = new ComponentFactory.PropertyWrapper(result);
                }
            }
            return result;
        }

        static {
            DEFAULT_EDITOR.setContentType("text");
            JTextPane codeAssistPane = CodeAssistFactory.createChemicalTermsTextPane(true, CodeAssistDataProvider.Context.REACTION);
            ConfigBuilderPanel configBuilder = null;
            try {
                configBuilder = ConfigBuilderPanelFactory.createStandardizerPanel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            CACHE.put("REACTIVITY", codeAssistPane);
            CACHE.put("SELECTIVITY", codeAssistPane);
            CACHE.put("EXCLUDE", codeAssistPane);
            if (configBuilder != null) {
                CACHE.put("STANDARDIZATION", configBuilder);
            }
        }
    }
}

