/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.standardizer;

import chemaxon.alchemist.Alchemist;
import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.standardizer.StandardizerAlchemistController;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.marvin.beans.splash.MarvinSplashScreen;
import chemaxon.util.SplashScreenUtils;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;

public class StandardizerAlchemist
implements AlchemistLaunchable {
    private StandardizerAlchemistController controller = null;

    public StandardizerAlchemist() {
        this(StandardizerAlchemistController.DEFAULT_TITLE);
    }

    public StandardizerAlchemist(String title) {
        this(title, "/chemaxon/alchemist/configbuilder/standardizer/StandardizerConfiguration.xml");
    }

    public StandardizerAlchemist(String title, String elementConfigurationPath) {
        this.controller = new StandardizerAlchemistController(title, elementConfigurationPath);
    }

    public void setVisible(boolean visible) {
        this.controller.getAlchemist().getApplicationFrame().setVisible(visible);
    }

    public boolean isVisible() {
        return this.controller.getAlchemist().getApplicationFrame().isVisible();
    }

    public Alchemist getAlchemist() {
        return this.controller.getAlchemist();
    }

    public StandardizerAlchemistController getController() {
        return this.controller;
    }

    private static void createAndShowGUI() {
        MarvinBasedAlchemistApplication.setLookAndFeel();
        SplashScreenUtils.showSplashScreen(SplashScreenUtils.Product.Standardizer, StandardizerAlchemist.class.getResource("/chemaxon/alchemist/images/standardizer_splash.jpg"));
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StandardizerAlchemistController controller = new StandardizerAlchemistController();
                    controller.getAlchemist().getApplicationFrame().setVisible(true);
                }
                catch (Exception e) {
                    AlchemistErrorDialog.showError(e);
                }
                finally {
                    MarvinSplashScreen.disposeSplash();
                }
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StandardizerAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    public void launch() {
        StandardizerAlchemist.main(null);
    }
}

