/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.standardizer;

import chemaxon.alchemist.AlchemistController;
import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.AlchemistProfile;
import chemaxon.alchemist.commonpages.FileListHandlerPanel;
import chemaxon.alchemist.commonpages.ProgressPanel;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanelFactory;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationWriter;
import chemaxon.alchemist.standardizer.StandardizerAlchemistTask;
import chemaxon.alchemist.standardizer.StandardizerOutputConfigPanel;
import chemaxon.alchemist.standardizer.StandardizerProgressPanel;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.DotfileUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class StandardizerAlchemistController
extends AlchemistController {
    private static final String PERSISTENT_PROPERTY_PATH = "/alchemist/.standardizer";
    private static final String DEFAULT_PROFILE_PATH = DotfileUtil.getDotFile("/alchemist/standardizer_configbuilder.profile").getAbsolutePath();
    public static final String PROPERTY_KEY_CONFIGURATION = "StandardizerAlchemist_ConfigBuilderConfiguration";
    public static final String DEFAULT_TITLE = "Standardizer " + VersionInfo.JCHEM_VERSION;
    private FileListHandlerPanel page1;
    private AlchemistPage page2;
    private StandardizerOutputConfigPanel page3;
    private ProgressPanel page4;
    private String elementConfigurationPath = null;
    private ConfigBuilderPanel configBuilderPanel = null;

    public StandardizerAlchemistController() {
        this(DEFAULT_TITLE);
    }

    public StandardizerAlchemistController(String title) {
        this(title, "/chemaxon/alchemist/configbuilder/standardizer/StandardizerConfiguration.xml");
    }

    public StandardizerAlchemistController(String title, String elementConfigurationPath) {
        this(title, AlchemistIconFactory.getImage("/chemaxon/alchemist/images/standardizer.png"), elementConfigurationPath);
    }

    public StandardizerAlchemistController(String title, Image image, String elementConfigurationPath) {
        super(title, image);
        this.elementConfigurationPath = elementConfigurationPath;
        this.initializePages();
        this.initAlchemist();
    }

    @Override
    protected void licenseManagerInvoked() {
        super.licenseManagerInvoked();
        if (this.configBuilderPanel != null) {
            this.configBuilderPanel.refreshLicenses();
        }
    }

    private void initializePages() {
        this.page1 = new FileListHandlerPanel(true);
        this.page1.setTopText("Select files", "Choose files you want standardizer to operate with.");
        this.page1.setTopTextVisible(true);
        this.page1.setBottomText("Press 'Next' to continue...");
        this.page1.setBottomTextVisible(true);
        this.addPage("Select input files", this.page1);
        try {
            AlchemistProfile profile = new AlchemistProfile();
            try {
                profile.read(new FileInputStream(DEFAULT_PROFILE_PATH));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.configBuilderPanel = ConfigBuilderPanelFactory.createStandardizerPanel(this.elementConfigurationPath, profile, true);
            this.configBuilderPanel.addElementPropertyChangeListener(this);
            this.page2 = new AlchemistPage(){
                private static final long serialVersionUID = -5987964303687862823L;

                @Override
                public void enterPage(AlchemistState state) {
                }

                @Override
                public boolean isCorrect() {
                    return StandardizerAlchemistController.this.configBuilderPanel.isValidConfiguration();
                }

                @Override
                public void performLeavePage() {
                    this.leavePage(StandardizerAlchemistController.this.state);
                    super.performLeavePage();
                }

                @Override
                public void leavePage(AlchemistState state) {
                    StandardizerAlchemistController.this.configBuilderPanel.updateProfile();
                    try {
                        StandardizerAlchemistController.this.configBuilderPanel.getProfile().write(new FileOutputStream(DEFAULT_PROFILE_PATH));
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    StandardizerConfigurationWriter writer = new StandardizerConfigurationWriter(ostream);
                    try {
                        StandardizerAlchemistController.this.configBuilderPanel.writeConfiguration(writer);
                        ostream.flush();
                        state.setProperty(StandardizerAlchemistController.PROPERTY_KEY_CONFIGURATION, ostream.toString());
                        ostream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.page2.setLayout(new BorderLayout());
            this.page2.add((Component)this.configBuilderPanel, "Center");
        }
        catch (MarshalException e) {
            e.printStackTrace();
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.page2.setBottomText("Press 'Next' to continue...");
        this.page2.setBottomTextVisible(true);
        this.addPage("Create action list", this.page2);
        this.page3 = new StandardizerOutputConfigPanel();
        this.page3.setTopText("Select output file and format", "Choose a file to save results into. You will be prompted if output file exists.");
        this.page3.setTopTextVisible(true);
        this.page3.setBottomText("Press 'Next' to continue...");
        this.page3.setBottomTextVisible(true);
        this.addPage("Specify output file", this.page3);
        this.page4 = new StandardizerProgressPanel(this.DONE_ACTION, new StandardizerAlchemistTask(this.state));
        this.addPage("Standardize", this.page4);
    }

    @Override
    protected void cancelPressed() {
        this.saveProperties();
    }

    @Override
    protected void finishPressed() {
        File outFile = new File((String)this.state.getProperty("StandardizerOutputConfigPanel_SingleFilePath"));
        if (outFile.exists() && JOptionPane.showConfirmDialog(null, outFile.getAbsolutePath() + " exists.\nDo you want to overwrite?", "Output file exists", 0) == 1) {
            this.FINISH_ACTION.setEnabled(true);
            this.CANCEL_ACTION.setEnabled(true);
            this.BACK_ACTION.setEnabled(true);
            return;
        }
        this.page4.runTask(4);
        this.page4.setPanelState(1);
    }

    @Override
    public File getPropertiesFile() {
        return DotfileUtil.getDotFile(PERSISTENT_PROPERTY_PATH);
    }

    @Override
    public String getHelpURL() {
        return "http://www.chemaxon.com/jchem/doc/user/Standardizer.html";
    }
}

