/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.standardizer;

import chemaxon.alchemist.AlchemistTask;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.reaction.ConcurrentStandardizerProcessor;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.struc.Molecule;
import chemaxon.util.ConfigUtils;
import chemaxon.util.iterator.MoleculeIteratorChain;
import chemaxon.util.iterator.MoleculeIteratorFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class StandardizerAlchemistTask
extends AlchemistTask {
    public static final String PROPERTY_KEY_MOLECULE_NUMBER = "StandardizerAlchemistTask_MoleculeNumber";
    public static final String PROPERTY_KEY_APPLIED_TASKS = "StandardizerAlchemistTask_AppliedTasks";
    private String outputPath;
    private ConcurrentStandardizerProcessor processor = new ConcurrentStandardizerProcessor();
    private boolean ignoreErrors;
    private long standardizedMolecules;
    private MolExporter exporter = null;
    private final AlchemistState state;
    private BlockingQueue<Molecule[]> sampleQueue = new ArrayBlockingQueue<Molecule[]>(5);

    public StandardizerAlchemistTask(AlchemistState state) {
        this.state = state;
    }

    @Override
    protected long initializeTask() {
        this.canceled = false;
        this.done = false;
        this.outputPath = (String)this.state.getProperty("StandardizerOutputConfigPanel_SingleFilePath");
        this.ignoreErrors = (Boolean)this.state.getProperty("StandardizerOutputConfigPanel_IgnoreErrors");
        this.standardizedMolecules = 0L;
        Object[] inputFiles = (Object[])this.state.getProperty("FileListHandlerPanel_InputFileList");
        String configString = (String)this.state.getProperty("StandardizerAlchemist_ConfigBuilderConfiguration");
        String outputFormat = (String)this.state.getProperty("StandardizerOutputConfigPanel_FileFormat");
        Standardizer standardizer = null;
        try {
            standardizer = configString != null ? new Standardizer(configString) : new Standardizer("");
            FileOutputStream output = new FileOutputStream(this.outputPath);
            this.exporter = new MolExporter(output, outputFormat);
        }
        catch (Exception e) {
            this.canceled = true;
            AlchemistErrorDialog.showError("Standardizer failed", e);
        }
        if (standardizer != null) {
            MolImporter[] in = new MolImporter[inputFiles.length];
            for (int i = 0; i < in.length; ++i) {
                try {
                    in[i] = ConfigUtils.getTargetMolImporter(((File)inputFiles[i]).getAbsolutePath());
                    continue;
                }
                catch (MolFormatException e) {
                    this.canceled = true;
                    AlchemistErrorDialog.showError("Invalid Molecule format", (Exception)e);
                    continue;
                }
                catch (IOException e) {
                    this.canceled = true;
                    AlchemistErrorDialog.showError("I/O Exception occurred", (Exception)e);
                }
            }
            MoleculeIteratorChain iterator = new MoleculeIteratorChain(MoleculeIteratorFactory.getMoleculeIterators(in));
            if (MFileFormatUtil.isOutputCleanable(outputFormat) && !standardizer.isLastTaskClean()) {
                try {
                    standardizer.setFinalClean();
                }
                catch (StandardizerException e) {
                    this.canceled = true;
                    AlchemistErrorDialog.showError("Standardizer failed", (Exception)e);
                }
            }
            this.processor.setStandardizer(standardizer);
            this.processor.setMoleculeIterator(iterator);
            this.processor.setStoreAppliedTaskData(true);
        }
        return this.canceled ? 0L : 100L;
    }

    @Override
    public void finished() {
        float num1 = this.current;
        float num2 = this.getLengthOfTask();
        int percent = num2 != 0.0f ? (int)Math.ceil(num1 / num2 * 100.0f) : 0;
        this.statMessage = this.canceled ? "Process has been canceled.\n\n" : "Process completed.\n\n";
        this.statMessage = this.statMessage + "Molecules standardized: \t" + this.standardizedMolecules + "\n" + "Overall progress: \t" + (percent > 100 ? 100 : percent) + "%\n" + "Time elapsed: \t\t" + this.calcTime() + "\n";
    }

    @Override
    public void calculate() {
        ArrayList<Exception> errorList = new ArrayList<Exception>();
        Molecule currentMolecule = null;
        while (!this.canceled && !this.done) {
            try {
                double progress;
                currentMolecule = this.processor.standardize();
                if (currentMolecule != null) {
                    ++this.standardizedMolecules;
                    if (this.sampleQueue.size() < 1 || this.sampleQueue.size() < 5 && !this.processor.getInputMolecule().toFormat("cxsmarts").equalsIgnoreCase(currentMolecule.toFormat("cxsmarts"))) {
                        Molecule oldM = this.processor.getInputMolecule().cloneMolecule();
                        Molecule newM = currentMolecule.cloneMolecule();
                        StringBuilder appliedTasksBuilder = new StringBuilder();
                        String[] taskIDs = this.processor.getAppliedTaskIDs();
                        for (int i = 0; i < taskIDs.length; ++i) {
                            appliedTasksBuilder.append(taskIDs[i]);
                            appliedTasksBuilder.append(":");
                        }
                        oldM.setProperty(PROPERTY_KEY_APPLIED_TASKS, appliedTasksBuilder.toString());
                        oldM.setProperty(PROPERTY_KEY_MOLECULE_NUMBER, String.valueOf(this.standardizedMolecules));
                        newM.setProperty(PROPERTY_KEY_MOLECULE_NUMBER, String.valueOf(this.standardizedMolecules));
                        try {
                            this.sampleQueue.add(new Molecule[]{oldM, newM});
                        }
                        catch (IllegalStateException e) {
                            // empty catch block
                        }
                    }
                }
                long l = this.current = (progress = this.processor.getProgress()) == -1.0 ? 1L : (long)((int)(progress * 100.0));
                if (currentMolecule != null) {
                    this.exporter.write(currentMolecule);
                    continue;
                }
                this.done = true;
            }
            catch (Exception e) {
                if (!this.ignoreErrors) {
                    this.canceled = true;
                    AlchemistErrorDialog.showError("Standardizer failed", e);
                    continue;
                }
                Exception ex = new Exception("Error at molecule No. " + (this.standardizedMolecules + 1L) + " ", e);
                errorList.add(ex);
            }
        }
        try {
            this.exporter.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.ignoreErrors && !errorList.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (int j = 0; j < errorList.size(); ++j) {
                Exception exception = (Exception)errorList.get(j);
                buffer.append("#" + (j + 1) + " " + exception.getMessage());
                buffer.append(exception.getCause().getMessage());
                buffer.append("\n\n");
            }
            AlchemistErrorDialog.showError("There were problems during the process", new Exception(buffer.toString()));
        }
    }

    public long getStandardizedMolecules() {
        return this.standardizedMolecules;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public Molecule[] getMolecules() {
        try {
            return this.sampleQueue.poll(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StandardizerAlchemistTask clone = (StandardizerAlchemistTask)super.clone();
        clone.exporter = null;
        clone.processor = new ConcurrentStandardizerProcessor();
        clone.sampleQueue = new ArrayBlockingQueue<Molecule[]>(5);
        return clone;
    }
}

