/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.standardizer;

import chemaxon.alchemist.AlchemistTask;
import chemaxon.alchemist.commonpages.ProgressPanel;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.ConfigElementFactory;
import chemaxon.alchemist.standardizer.StandardizerAlchemistTask;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.SimpleAlchemistMoleculeView;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StandardizerProgressPanel
extends ProgressPanel {
    private static final String PROPERTY_KEY_SHOW_SAMPLES = "StandardizerProgressPanel_ShowSamples";
    private static final long serialVersionUID = 2021632105551112742L;
    private static final int SAMPLE_REFRESH_RATE = 3000;
    private static final ConfigElementFactory CONFIG_ELEMENT_FACTORY = new ConfigElementFactory("/chemaxon/alchemist/configbuilder/standardizer/StandardizerConfiguration.xml");
    private static final Map<String, Icon> ICON_CACHE = new HashMap<String, Icon>();
    private final List<Icon> iconList = new ArrayList<Icon>();
    private SimpleAlchemistMoleculeView view;
    private JCheckBox sampleCheckBox;
    private JPanel panel;
    private long lastChecked = 0L;

    public StandardizerProgressPanel(Action doneAction, AlchemistTask task) {
        super(doneAction, task);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.sampleCheckBox = new JCheckBox("Show samples (may reduce performance)");
        this.sampleCheckBox.setAlignmentX(0.5f);
        this.sampleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardizerProgressPanel.this.panel.setVisible(StandardizerProgressPanel.this.sampleCheckBox.isSelected());
            }
        });
        this.sampleCheckBox.setOpaque(false);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.panel.setBackground(new Color(100, 100, 100));
        JPanel separator = new JPanel();
        separator.setPreferredSize(new Dimension(20, 20));
        separator.setOpaque(false);
        this.addProgressCustomComponent(separator);
        this.addProgressCustomComponent(this.sampleCheckBox);
        this.addProgressCustomComponent(separator);
        this.addProgressCustomComponent(this.panel);
        this.view = new SimpleAlchemistMoleculeView(1, 2, true, true){
            private static final long serialVersionUID = -7867647232315978170L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g) {
                super.paint(g);
                List list = StandardizerProgressPanel.this.iconList;
                synchronized (list) {
                    for (int i = 0; i < StandardizerProgressPanel.this.iconList.size(); ++i) {
                        Icon img = (Icon)StandardizerProgressPanel.this.iconList.get(i);
                        if (img == null) continue;
                        img.paintIcon(this.view, g, i / 10 * (img.getIconWidth() + 3) + 3, i % 10 * (img.getIconHeight() + 3) + 3);
                    }
                }
            }
        };
    }

    @Override
    public void refreshInformations() {
        super.refreshInformations();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block13: {
                    long standardizedMolecules = ((StandardizerAlchemistTask)StandardizerProgressPanel.this.getCurrentTask()).getStandardizedMolecules();
                    StandardizerProgressPanel.this.setCaption(standardizedMolecules + " molecules standardized", 1);
                    if (StandardizerProgressPanel.this.sampleCheckBox.isSelected()) {
                        try {
                            if (StandardizerProgressPanel.this.lastChecked + 3000L >= System.currentTimeMillis()) break block13;
                            Molecule[] molecules = ((StandardizerAlchemistTask)StandardizerProgressPanel.this.getCurrentTask()).getMolecules();
                            if (molecules != null) {
                                String number = molecules[0].getProperty("StandardizerAlchemistTask_MoleculeNumber");
                                String applied = molecules[0].getProperty("StandardizerAlchemistTask_AppliedTasks");
                                String[] tasks = null;
                                List list = StandardizerProgressPanel.this.iconList;
                                synchronized (list) {
                                    StandardizerProgressPanel.this.iconList.clear();
                                    if (applied != null) {
                                        tasks = applied.split("\\:");
                                    }
                                    if (tasks != null) {
                                        for (int i = 0; i < tasks.length; ++i) {
                                            if (!ICON_CACHE.containsKey(tasks[i])) {
                                                try {
                                                    ConfigElement element = CONFIG_ELEMENT_FACTORY.create(tasks[i]);
                                                    ICON_CACHE.put(tasks[i], element.getDefaultIcon());
                                                }
                                                catch (IllegalArgumentException e) {
                                                    // empty catch block
                                                }
                                            }
                                            StandardizerProgressPanel.this.iconList.add(ICON_CACHE.get(tasks[i]));
                                        }
                                    }
                                }
                                StandardizerProgressPanel.this.view.setMolecule(0, 0, molecules[0]);
                                StandardizerProgressPanel.this.view.setMolecule(0, 1, molecules[1]);
                                StandardizerProgressPanel.this.view.setMoleculeLabel(0, 0, "Before (no. " + (number == null ? "Unknown" : number) + ")");
                                StandardizerProgressPanel.this.view.setMoleculeLabel(0, 1, "After (no. " + (number == null ? "Unknown" : number) + ")");
                                StandardizerProgressPanel.this.view.repaint();
                            }
                            StandardizerProgressPanel.this.lastChecked = System.currentTimeMillis();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    @Override
    public void enterPage(AlchemistState state) {
        super.enterPage(state);
        Object[] inputFiles = (Object[])state.getProperty("FileListHandlerPanel_InputFileList");
        String outputPath = (String)state.getProperty("StandardizerOutputConfigPanel_SingleFilePath");
        String outputFormat = (String)state.getProperty("StandardizerOutputConfigPanel_FileFormat");
        Boolean samplesVisible = (Boolean)state.getProperty(PROPERTY_KEY_SHOW_SAMPLES);
        this.sampleCheckBox.setSelected(samplesVisible == null ? true : samplesVisible);
        this.panel.setVisible(this.sampleCheckBox.isSelected());
        StringBuilder builder = new StringBuilder();
        builder.append("Input files:");
        for (int i = 0; i < inputFiles.length; ++i) {
            builder.append('\t');
            builder.append(((File)inputFiles[i]).getAbsolutePath());
            builder.append('\n');
        }
        builder.append("\nOutput file:\t");
        builder.append(outputPath);
        builder.append("\n\nOutput format:\t");
        builder.append(outputFormat);
        builder.append('\n');
        this.setMessage(builder.toString(), 0);
        this.setOutputFilePath(outputPath);
        this.view.setMoleculeLabel(0, 0, "Before");
        this.view.setMoleculeLabel(0, 1, "After");
        this.panel.add(this.view);
        JPanel customResult = new JPanel();
        customResult.setOpaque(false);
        customResult.setLayout(new BorderLayout());
        customResult.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        customResult.add((Component)this.getResultButton(), "East");
        this.setResultCustomPanel(customResult);
    }

    @Override
    public void leavePage(AlchemistState state) {
        super.leavePage(state);
        this.panel.remove(this.view);
        this.view.clear();
        this.getResultView().clear();
        state.setPersistentProperty(PROPERTY_KEY_SHOW_SAMPLES, this.sampleCheckBox.isSelected());
    }

    @Override
    public void setPanelState(int state) {
        super.setPanelState(state);
        if (state == 2) {
            this.getResultButton().setEnabled(((StandardizerAlchemistTask)this.getCurrentTask()).getStandardizedMolecules() > 0L);
        }
    }
}

