/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.structurechecker;

import chemaxon.alchemist.Alchemist;
import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.structurechecker.StructureCheckerController;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import chemaxon.marvin.beans.splash.MarvinSplashScreen;
import chemaxon.util.SplashScreenUtils;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;

public class StructureCheckerAlchemist
implements AlchemistLaunchable {
    private StructureCheckerController controller = null;

    public StructureCheckerAlchemist() {
        this(StructureCheckerController.DEFAULT_TITLE);
    }

    public StructureCheckerAlchemist(String title) {
        this(title, "/chemaxon/checkers/resource/defaultcheckerconfig.xml");
    }

    public StructureCheckerAlchemist(String title, String elementConfigurationPath) {
        this.controller = new StructureCheckerController(title, elementConfigurationPath);
    }

    public void setVisible(boolean visible) {
        this.controller.getAlchemist().getApplicationFrame().setVisible(visible);
    }

    public boolean isVisible() {
        return this.controller.getAlchemist().getApplicationFrame().isVisible();
    }

    public Alchemist getAlchemist() {
        return this.controller.getAlchemist();
    }

    public StructureCheckerController getController() {
        return this.controller;
    }

    private static void createAndShowGUI() {
        MarvinBasedAlchemistApplication.setLookAndFeel();
        SplashScreenUtils.showSplashScreen(SplashScreenUtils.Product.Structure_Checker, StructureCheckerAlchemist.class.getResource("/chemaxon/alchemist/images/structurechecker_splash.jpg"));
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StructureCheckerController controller = new StructureCheckerController();
                    controller.getAlchemist().getApplicationFrame().setVisible(true);
                }
                catch (Exception e) {
                    AlchemistErrorDialog.showError(e);
                }
                finally {
                    MarvinSplashScreen.disposeSplash();
                }
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StructureCheckerAlchemist.createAndShowGUI();
            }
        });
    }

    @Override
    public void launch() {
        StructureCheckerAlchemist.main(null);
    }
}

