/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.structurechecker;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.configbuilder.FileFilterFactory;
import chemaxon.alchemist.utils.AlchemistFileChooser;
import chemaxon.alchemist.utils.AlchemistFileTextBox;
import chemaxon.alchemist.utils.AlchemistState;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class StructureCheckerOptionsPanel
extends AlchemistPage {
    private static final String PROPERTY_KEY_SERIAL = "serial";
    public static final String PROPERTY_KEY_LOG_FILE_PATH = "LogFilePath";
    public static final String PROPERTY_KEY_LOG_FIELD_NAME = "LogFieldName";
    public static final String PROPERTY_KEY_IGNORE_FIXERS = "IgnoreFixers";
    public static final String PROPERTY_KEY_ASK_ON_PROBLEM = "AskOnProblem";
    public static final String PROPERTY_KEY_FIX_MODE = "FixMode";
    public static final String PROPERTY_VALUE_FIX_AND_ASK = "FixAndAsk";
    public static final String PROPERTY_VALUE_AUTOMATIC = "Automatic";
    public static final String PROPERTY_VALUE_MANUAL = "Manual";
    public static final String PROPERTY_VALUE_CHECK = "Check";
    public static final String PROPERTY_KEY_LOG_MODE = "LogMode";
    public static final String PROPERTY_VALUE_NOLOG = "NoLog";
    public static final String PROPERTY_VALUE_FILELOG = "FileLog";
    public static final String PROPERTY_VALUE_FIELDLOG = "FieldLog";
    public static final String PROPERTY_KEY_OPERATION_MODE = "OperationMode";
    private static final String LOG_MATCHES_INPUT_TITLE = "Invalid report file";
    private static final String LOG_MATCHES_INPUT_MESSAGE = "Input and report can not be the same file.";
    private static final long serialVersionUID = 3300922543943456586L;
    private JPanel mainPanel = null;
    private AlchemistFileChooser saveLogDialog = null;
    private JLabel logFileLabel = null;
    private JLabel logFieldLabel = null;
    private AlchemistFileTextBox logFileText = null;
    private JTextField logFieldText = null;
    private JRadioButton fixAndAskRadio = null;
    private JRadioButton alwaysAskRadio = null;
    private JRadioButton neverAskRadio = null;
    private JRadioButton checkOnlyRadio = null;
    private JRadioButton noLogRadio = null;
    private JRadioButton fieldLogRadio = null;
    private JRadioButton fileLogRadio = null;
    private JPanel fixAndAskConfigPanel = null;
    private JPanel alwaysAskConfigPanel = null;
    private JPanel neverAskConfigPanel = null;
    private JPanel checkOnlyConfigPanel = null;
    private JPanel noLogConfigPanel = null;
    private JPanel fieldLogConfigPanel = null;
    private JPanel fileLogConfigPanel = null;
    private Object[] inputFiles = null;

    public StructureCheckerOptionsPanel() {
        this.initialize();
    }

    private void initialize() {
        try {
            this.saveLogDialog = new AlchemistFileChooser();
            this.saveLogDialog.addFileFilters(new FileFilter[]{FileFilterFactory.createFileFilter("Report file", new String[]{"txt"})});
            this.saveLogDialog.setDialogTitle("Save report");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
        this.getNotifier().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (StructureCheckerOptionsPanel.PROPERTY_KEY_LOG_FILE_PATH.equalsIgnoreCase(evt.getPropertyName()) && StructureCheckerOptionsPanel.this.isLogMatchesInput()) {
                    JOptionPane.showMessageDialog(StructureCheckerOptionsPanel.this, StructureCheckerOptionsPanel.LOG_MATCHES_INPUT_MESSAGE, StructureCheckerOptionsPanel.LOG_MATCHES_INPUT_TITLE, 2);
                }
            }
        });
    }

    private boolean isLogMatchesInput() {
        if (this.inputFiles != null) {
            File output = new File(this.getLogFileText().getFilePath());
            for (int i = 0; i < this.inputFiles.length; ++i) {
                File input = new File(this.inputFiles[i].toString());
                if (!output.equals(input)) continue;
                return true;
            }
        }
        return false;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            CellConstraints cc = new CellConstraints();
            ButtonGroup behaviour = new ButtonGroup();
            behaviour.add(this.getAlwaysAskRadio());
            behaviour.add(this.getFixAndAskRadio());
            behaviour.add(this.getNeverAskRadio());
            behaviour.add(this.getCheckOnlyRadio());
            ButtonGroup log = new ButtonGroup();
            log.add(this.getNoLogRadio());
            log.add(this.getFileLogRadio());
            log.add(this.getFieldLogRadio());
            this.mainPanel = new JPanel((LayoutManager)new FormLayout("4dlu, pref, fill:min:grow, 4dlu", "4dlu, min, 2dlu, fill:pref, 2dlu, fill:pref, 2dlu, fill:pref, 2dlu, fill:pref, 16dlu, min, 4dlu, fill:pref, 2dlu, fill:pref, 2dlu, fill:pref, 4dlu"));
            this.mainPanel.add((Component)new JLabel("Operation Mode"), cc.xy(2, 2));
            this.mainPanel.add((Component)new JSeparator(), cc.xy(3, 2));
            this.mainPanel.add((Component)this.getCheckOnlyConfigPanel(), cc.xyw(2, 4, 2));
            this.mainPanel.add((Component)this.getAlwaysAskConfigPanel(), cc.xyw(2, 6, 2));
            this.mainPanel.add((Component)this.getNeverAskConfigPanel(), cc.xyw(2, 8, 2));
            this.mainPanel.add((Component)this.getFixAndAskConfigPanel(), cc.xyw(2, 10, 2));
            this.mainPanel.add((Component)new JLabel("Report Options"), cc.xy(2, 12));
            this.mainPanel.add((Component)new JSeparator(), cc.xy(3, 12));
            this.mainPanel.add((Component)this.getNoLogConfigPanel(), cc.xyw(2, 14, 2));
            this.mainPanel.add((Component)this.getFileLogConfigPanel(), cc.xyw(2, 16, 2));
            this.mainPanel.add((Component)this.getFieldLogConfigPanel(), cc.xyw(2, 18, 2));
            this.getCheckOnlyRadio().setSelected(true);
            this.getNoLogRadio().setSelected(true);
            this.updateLayout();
        }
        return this.mainPanel;
    }

    private JRadioButton getFixAndAskRadio() {
        if (this.fixAndAskRadio == null) {
            this.fixAndAskRadio = new JRadioButton(new AbstractAction("<html><b>Fix</b><br>Solve problems with the fixer configured for each checker. Users are prompted to resolve any unfixable or conflicting problems.</html>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerOptionsPanel.this.getNotifier().firePropertyChange(StructureCheckerOptionsPanel.PROPERTY_KEY_FIX_MODE, "", StructureCheckerOptionsPanel.PROPERTY_VALUE_FIX_AND_ASK);
                    StructureCheckerOptionsPanel.this.updateLayout();
                }
            });
            this.fixAndAskRadio.setFocusPainted(false);
            this.fixAndAskRadio.setOpaque(false);
        }
        return this.fixAndAskRadio;
    }

    private JRadioButton getAlwaysAskRadio() {
        if (this.alwaysAskRadio == null) {
            this.alwaysAskRadio = new JRadioButton(new AbstractAction("<html><b>Manual</b><br>Ignores all configured fixers. Users are always prompted to resolve any issues detected.</html>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerOptionsPanel.this.getNotifier().firePropertyChange(StructureCheckerOptionsPanel.PROPERTY_KEY_FIX_MODE, "", StructureCheckerOptionsPanel.PROPERTY_VALUE_MANUAL);
                    StructureCheckerOptionsPanel.this.updateLayout();
                }
            });
            this.alwaysAskRadio.setFocusPainted(false);
            this.alwaysAskRadio.setOpaque(false);
        }
        return this.alwaysAskRadio;
    }

    private JRadioButton getCheckOnlyRadio() {
        if (this.checkOnlyRadio == null) {
            this.checkOnlyRadio = new JRadioButton(new AbstractAction("<html><b>Check</b><br>Validates the structures without fixing the detected issues.</html>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerOptionsPanel.this.getNotifier().firePropertyChange(StructureCheckerOptionsPanel.PROPERTY_KEY_FIX_MODE, "", StructureCheckerOptionsPanel.PROPERTY_VALUE_CHECK);
                    StructureCheckerOptionsPanel.this.updateLayout();
                }
            });
            this.checkOnlyRadio.setFocusPainted(false);
            this.checkOnlyRadio.setOpaque(false);
        }
        return this.checkOnlyRadio;
    }

    private JRadioButton getNeverAskRadio() {
        if (this.neverAskRadio == null) {
            this.neverAskRadio = new JRadioButton(new AbstractAction("<html><b>Automatic</b><br>Fixes the structures with the selected fixers if possible. Users are never prompted.</html>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerOptionsPanel.this.getNotifier().firePropertyChange(StructureCheckerOptionsPanel.PROPERTY_KEY_FIX_MODE, "", StructureCheckerOptionsPanel.PROPERTY_VALUE_AUTOMATIC);
                    StructureCheckerOptionsPanel.this.updateLayout();
                }
            });
            this.neverAskRadio.setFocusPainted(false);
            this.neverAskRadio.setOpaque(false);
        }
        return this.neverAskRadio;
    }

    private JRadioButton getNoLogRadio() {
        if (this.noLogRadio == null) {
            this.noLogRadio = new JRadioButton(new AbstractAction("<html><b>No Report</b><br>No report is created.</html>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerOptionsPanel.this.getNotifier().firePropertyChange(StructureCheckerOptionsPanel.PROPERTY_KEY_LOG_MODE, "", StructureCheckerOptionsPanel.PROPERTY_VALUE_NOLOG);
                    StructureCheckerOptionsPanel.this.updateLayout();
                }
            });
            this.noLogRadio.setFocusPainted(false);
            this.noLogRadio.setOpaque(false);
        }
        return this.noLogRadio;
    }

    private JRadioButton getFileLogRadio() {
        if (this.fileLogRadio == null) {
            this.fileLogRadio = new JRadioButton(new AbstractAction("<html><b>File Report</b><br>Report is saved to a text file.</html>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerOptionsPanel.this.getNotifier().firePropertyChange(StructureCheckerOptionsPanel.PROPERTY_KEY_LOG_MODE, "", StructureCheckerOptionsPanel.PROPERTY_VALUE_FILELOG);
                    StructureCheckerOptionsPanel.this.updateLayout();
                }
            });
            this.fileLogRadio.setFocusPainted(false);
            this.fileLogRadio.setOpaque(false);
        }
        return this.fileLogRadio;
    }

    private JRadioButton getFieldLogRadio() {
        if (this.fieldLogRadio == null) {
            this.fieldLogRadio = new JRadioButton(new AbstractAction("<html><b>Output Report</b><br>Report is saved to the output as property field. Note: Not all file format supports this option.</html>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructureCheckerOptionsPanel.this.getNotifier().firePropertyChange(StructureCheckerOptionsPanel.PROPERTY_KEY_LOG_MODE, "", StructureCheckerOptionsPanel.PROPERTY_VALUE_FIELDLOG);
                    StructureCheckerOptionsPanel.this.updateLayout();
                }
            });
            this.fieldLogRadio.setFocusPainted(false);
            this.fieldLogRadio.setOpaque(false);
        }
        return this.fieldLogRadio;
    }

    private JPanel getFixAndAskConfigPanel() {
        if (this.fixAndAskConfigPanel == null) {
            this.fixAndAskConfigPanel = new JPanel(new BorderLayout());
            this.fixAndAskConfigPanel.add((Component)this.getFixAndAskRadio(), "Center");
        }
        return this.fixAndAskConfigPanel;
    }

    private JPanel getAlwaysAskConfigPanel() {
        if (this.alwaysAskConfigPanel == null) {
            this.alwaysAskConfigPanel = new JPanel(new BorderLayout());
            this.alwaysAskConfigPanel.add((Component)this.getAlwaysAskRadio(), "Center");
        }
        return this.alwaysAskConfigPanel;
    }

    private JPanel getNeverAskConfigPanel() {
        if (this.neverAskConfigPanel == null) {
            this.neverAskConfigPanel = new JPanel(new BorderLayout());
            this.neverAskConfigPanel.add((Component)this.getNeverAskRadio(), "Center");
        }
        return this.neverAskConfigPanel;
    }

    private JPanel getCheckOnlyConfigPanel() {
        if (this.checkOnlyConfigPanel == null) {
            this.checkOnlyConfigPanel = new JPanel(new BorderLayout());
            this.checkOnlyConfigPanel.add((Component)this.getCheckOnlyRadio(), "Center");
        }
        return this.checkOnlyConfigPanel;
    }

    private JPanel getNoLogConfigPanel() {
        if (this.noLogConfigPanel == null) {
            this.noLogConfigPanel = new JPanel(new BorderLayout());
            this.noLogConfigPanel.add((Component)this.getNoLogRadio(), "Center");
        }
        return this.noLogConfigPanel;
    }

    private JPanel getFileLogConfigPanel() {
        if (this.fileLogConfigPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.fileLogConfigPanel = new JPanel((LayoutManager)new FormLayout("min, 2dlu, fill:min:grow", "fill:pref, 4dlu, fill:pref, 2dlu, fill:pref:grow"));
            this.fileLogConfigPanel.add((Component)this.getFileLogRadio(), cc.xyw(1, 1, 3));
            this.fileLogConfigPanel.add((Component)this.getLogFileLabel(), cc.xy(1, 5));
            this.fileLogConfigPanel.add((Component)this.getLogFileText(), cc.xy(3, 5));
        }
        return this.fileLogConfigPanel;
    }

    private JPanel getFieldLogConfigPanel() {
        if (this.fieldLogConfigPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.fieldLogConfigPanel = new JPanel((LayoutManager)new FormLayout("min, 2dlu, fill:min:grow", "fill:pref, 4dlu, fill:pref, 2dlu, fill:pref:grow"));
            this.fieldLogConfigPanel.add((Component)this.getFieldLogRadio(), cc.xyw(1, 1, 3));
            this.fieldLogConfigPanel.add((Component)this.getLogFieldLabel(), cc.xy(1, 5));
            this.fieldLogConfigPanel.add((Component)this.getLogFieldText(), cc.xy(3, 5));
        }
        return this.fieldLogConfigPanel;
    }

    private void updateLayout() {
        if (this.getNoLogRadio().isSelected()) {
            this.getLogFieldLabel().setVisible(false);
            this.getLogFieldText().setVisible(false);
            this.getLogFileLabel().setVisible(false);
            this.getLogFileText().setVisible(false);
        } else if (this.getFileLogRadio().isSelected()) {
            this.getLogFieldLabel().setVisible(false);
            this.getLogFieldText().setVisible(false);
            this.getLogFileLabel().setVisible(true);
            this.getLogFileText().setVisible(true);
        } else if (this.getFieldLogRadio().isSelected()) {
            this.getLogFieldLabel().setVisible(true);
            this.getLogFieldText().setVisible(true);
            this.getLogFileLabel().setVisible(false);
            this.getLogFileText().setVisible(false);
        }
        this.getMainPanel().revalidate();
    }

    private JLabel getLogFieldLabel() {
        if (this.logFieldLabel == null) {
            this.logFieldLabel = new JLabel("Report field name");
            this.logFieldLabel.setOpaque(false);
        }
        return this.logFieldLabel;
    }

    private JLabel getLogFileLabel() {
        if (this.logFileLabel == null) {
            this.logFileLabel = new JLabel("Report file");
            this.logFileLabel.setOpaque(false);
        }
        return this.logFileLabel;
    }

    private AlchemistFileTextBox getLogFileText() {
        if (this.logFileText == null) {
            this.logFileText = new AlchemistFileTextBox(1, this.saveLogDialog, this.getNotifier(), "", false, PROPERTY_KEY_LOG_FILE_PATH);
            this.logFileText.setOpaque(false);
            this.logFileText.setBorder(null);
        }
        return this.logFileText;
    }

    private JTextField getLogFieldText() {
        if (this.logFieldText == null) {
            this.logFieldText = new JTextField("StructureChecker Result");
            this.logFieldText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    StructureCheckerOptionsPanel.this.getNotifier().firePropertyChange(StructureCheckerOptionsPanel.PROPERTY_KEY_LOG_FIELD_NAME, null, StructureCheckerOptionsPanel.this.logFieldText.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.logFieldText;
    }

    @Override
    public void enterPage(AlchemistState state) {
        this.inputFiles = (Object[])state.getProperty("FileListHandlerPanel_InputFileList");
    }

    @Override
    public boolean isCorrect() {
        boolean logOk = true;
        if (this.getFileLogRadio().isSelected()) {
            logOk = this.getLogFileText().getFilePath() != null && this.getLogFileText().getFilePath().trim().length() > 0 && !this.isLogMatchesInput();
        } else if (this.getFieldLogRadio().isSelected()) {
            logOk = this.getLogFieldText().getText().trim().length() > 0;
        }
        return logOk;
    }

    @Override
    public void leavePage(AlchemistState state) {
        state.setProperty(PROPERTY_KEY_IGNORE_FIXERS, this.getAlwaysAskRadio().isSelected() || this.getCheckOnlyRadio().isSelected());
        state.setProperty(PROPERTY_KEY_ASK_ON_PROBLEM, this.getAlwaysAskRadio().isSelected() || this.getFixAndAskRadio().isSelected());
        state.setProperty(PROPERTY_KEY_LOG_FILE_PATH, this.getFileLogRadio().isSelected() ? this.getLogFileText().getFilePath() : null);
        state.setProperty(PROPERTY_KEY_LOG_FIELD_NAME, this.getFieldLogRadio().isSelected() ? this.getLogFieldText().getText().trim() : null);
        String opMode = "Unknown";
        if (this.getFixAndAskRadio().isSelected()) {
            opMode = "Fix (both manual and automatic fix according to the specific configurations)";
        } else if (this.getAlwaysAskRadio().isSelected()) {
            opMode = "Manual (manual fix)";
        } else if (this.getCheckOnlyRadio().isSelected()) {
            opMode = "Check (no fixes)";
        } else if (this.getNeverAskRadio().isSelected()) {
            opMode = "Automatic (automatic fix according to the specific configurations)";
        }
        state.setProperty(PROPERTY_KEY_OPERATION_MODE, opMode);
    }
}

