/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.structurechecker;

import chemaxon.alchemist.AlchemistTask;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.structurechecker.StructureCheckerConfigurationReader;
import chemaxon.alchemist.configbuilder.structurechecker.configelements.StructureCheckerWrapper;
import chemaxon.alchemist.structurechecker.log.StructureCheckerLog;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.AlchemistUtilities;
import chemaxon.checkers.FixMode;
import chemaxon.checkers.OCRErrorChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.BasicCheckerRunner;
import chemaxon.checkers.runner.CheckerRunner;
import chemaxon.checkers.runner.configuration.reader.XMLBasedConfigurationReader;
import chemaxon.fixers.StructureFixer;
import chemaxon.fixers.StructureFixerFactory;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StructureCheckerTask
extends AlchemistTask {
    public static final String PROPERTY_KEY_WAITING_FOR_MANUAL_FIX = "StructureCheckerTask_WaitingForManualFix";
    private static final StructureFixerFactory FIXER_FACTORY = new StructureFixerFactory();
    private final AlchemistState state;
    private MolImporter[] importers = null;
    private MolExporter resultExporter = null;
    private MolExporter errorExporter = null;
    private boolean ignoreFixers = false;
    private boolean askOnProblem = false;
    private String configuration = null;
    private String logFieldName = null;
    private String logFilePath = null;
    private boolean ignoreErrors;
    private int checkedMoleculeCount = 0;
    private int automaticallyFixedStructureCount = 0;
    private int userFixedStructureCount = 0;
    private int savedWithErrorsCount = 0;
    private int savedToOutputCount = 0;
    private int savedToProblemCount = 0;
    private int notSavedCount = 0;
    private int structureWithDetectedProblemsCount = 0;
    private UserOperation defaultUserOperation = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Molecule usersFix = null;
    private UserOperation userOperation = UserOperation.ACCEPT;
    private int currentFileIndex = 0;
    private long[] numberOfMolecules = null;
    private int currentMoleculeIndex = 0;
    private StructureCheckerLog log = null;
    private Boolean ignoreOCRErrors = false;

    public StructureCheckerTask(AlchemistState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculate() {
        ArrayList<Exception> errorList = new ArrayList<Exception>();
        this.log = this.logFieldName != null || this.logFilePath != null ? StructureCheckerLog.createLog() : null;
        if (!this.canceled) {
            StructureCheckerConfigurationReader reader = new StructureCheckerConfigurationReader(new ByteArrayInputStream(this.configuration.getBytes()));
            ConfigElement[] elements = reader.readConfiguration();
            XMLBasedConfigurationReader configurationReader = new XMLBasedConfigurationReader(new ByteArrayInputStream(this.configuration.getBytes()));
            if (this.ignoreOCRErrors.booleanValue()) {
                configurationReader.getCheckerList().add(0, new OCRErrorChecker());
            }
            BasicCheckerRunner runner = new BasicCheckerRunner(configurationReader);
            for (int i = 0; i < this.importers.length && !this.canceled && this.current < this.lengthOfTask; ++i) {
                this.currentFileIndex = i;
                this.currentMoleculeIndex = 0;
                this.done = false;
                while (!this.canceled && !this.done && this.current < this.lengthOfTask) {
                    try {
                        ++this.current;
                        Molecule mol = this.importers[i].read();
                        if (mol != null) {
                            List<StructureCheckerResult> originalResultList;
                            ++this.currentMoleculeIndex;
                            ++this.checkedMoleculeCount;
                            runner.setMolecule(mol);
                            List<StructureCheckerResult> resultList = originalResultList = runner.checkAndWait();
                            if (!originalResultList.isEmpty()) {
                                StructureCheckerResult result;
                                StructureCheckerResult result22;
                                ++this.structureWithDetectedProblemsCount;
                                Molecule original = mol.cloneMolecule();
                                ArrayList<Object[]> appliedFixers = new ArrayList<Object[]>();
                                if (!this.ignoreFixers) {
                                    for (int iterationCount = 0; !resultList.isEmpty() && iterationCount < elements.length + 1; ++iterationCount) {
                                        ArrayList<StructureFixer> fixerList = new ArrayList<StructureFixer>();
                                        for (StructureCheckerResult result22 : resultList) {
                                            StructureFixer fixer = StructureCheckerTask.getFixer(result22, elements);
                                            if (fixer == null) continue;
                                            fixerList.add(fixer);
                                        }
                                        while (!fixerList.isEmpty() && !this.canceled) {
                                            StructureFixer fixer = (StructureFixer)fixerList.remove(0);
                                            result22 = StructureCheckerTask.getResultForFixer(fixer, runner);
                                            if (result22 != null) {
                                                fixer.fix(result22);
                                                if (this.log != null) {
                                                    appliedFixers.add(new Object[]{result22, fixer});
                                                }
                                            }
                                            if (result22 != null) {
                                                runner.setMolecule(result22.getMolecule());
                                            }
                                            resultList = runner.checkAndWait();
                                        }
                                    }
                                }
                                if (!resultList.isEmpty()) {
                                    if (this.askOnProblem) {
                                        if (this.defaultUserOperation == null) {
                                            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_WAITING_FOR_MANUAL_FIX, null, original);
                                            StructureCheckerTask iterationCount = this;
                                            synchronized (iterationCount) {
                                                this.wait();
                                            }
                                        } else {
                                            this.userOperation = this.defaultUserOperation;
                                            this.usersFix = original;
                                        }
                                        if (this.canceled) continue;
                                        switch (this.userOperation) {
                                            case ACCEPT: {
                                                StringBuffer buffer;
                                                runner.setMolecule(this.usersFix);
                                                List<StructureCheckerResult> usersResultList = runner.checkAndWait();
                                                if (!usersResultList.isEmpty()) {
                                                    ++this.savedWithErrorsCount;
                                                    if (this.log != null) {
                                                        this.log.addEntry(this.importers[this.currentFileIndex].getFile(), this.currentMoleculeIndex, originalResultList.toArray(new StructureCheckerResult[originalResultList.size()]));
                                                    }
                                                    if (this.logFieldName != null) {
                                                        buffer = new StringBuffer();
                                                        for (int j = 0; j < usersResultList.size(); ++j) {
                                                            result22 = usersResultList.get(j);
                                                            buffer.append(result22.getName());
                                                            if (j + 1 >= usersResultList.size()) continue;
                                                            buffer.append("..");
                                                        }
                                                        this.usersFix.setProperty(this.logFieldName, buffer.toString());
                                                    }
                                                } else {
                                                    ++this.userFixedStructureCount;
                                                    if (this.log != null) {
                                                        this.log.addEntry(this.importers[this.currentFileIndex].getFile(), this.currentMoleculeIndex, originalResultList.toArray(new StructureCheckerResult[originalResultList.size()]), true);
                                                    }
                                                }
                                                this.resultExporter.write(this.usersFix);
                                                ++this.savedToOutputCount;
                                                break;
                                            }
                                            case DISCARD: {
                                                StringBuffer buffer;
                                                if (this.errorExporter != null) {
                                                    if (this.logFieldName != null) {
                                                        buffer = new StringBuffer();
                                                        for (int j = 0; j < originalResultList.size(); ++j) {
                                                            result22 = originalResultList.get(j);
                                                            buffer.append(result22.getName());
                                                            if (j + 1 >= originalResultList.size()) continue;
                                                            buffer.append("..");
                                                        }
                                                        original.setProperty(this.logFieldName, buffer.toString());
                                                    }
                                                    this.errorExporter.write(original);
                                                    ++this.savedToProblemCount;
                                                } else {
                                                    ++this.notSavedCount;
                                                }
                                                if (this.log == null) break;
                                                this.log.addEntry(this.importers[this.currentFileIndex].getFile(), this.currentMoleculeIndex, originalResultList.toArray(new StructureCheckerResult[originalResultList.size()]));
                                            }
                                        }
                                        continue;
                                    }
                                    if (this.errorExporter != null) {
                                        if (this.log != null) {
                                            this.log.addEntry(this.importers[this.currentFileIndex].getFile(), this.currentMoleculeIndex, originalResultList.toArray(new StructureCheckerResult[originalResultList.size()]));
                                        }
                                        if (this.logFieldName != null) {
                                            StringBuffer buffer = new StringBuffer();
                                            for (int j = 0; j < originalResultList.size(); ++j) {
                                                result = originalResultList.get(j);
                                                buffer.append(result.getName());
                                                if (j + 1 >= originalResultList.size()) continue;
                                                buffer.append("..");
                                            }
                                            original.setProperty(this.logFieldName, buffer.toString());
                                        }
                                        this.errorExporter.write(original);
                                        ++this.savedToProblemCount;
                                        continue;
                                    }
                                    if (this.log != null) {
                                        this.log.addEntry(this.importers[this.currentFileIndex].getFile(), this.currentMoleculeIndex, originalResultList.toArray(new StructureCheckerResult[originalResultList.size()]));
                                    }
                                    if (this.logFieldName != null) {
                                        StringBuffer buffer = new StringBuffer();
                                        for (int j = 0; j < originalResultList.size(); ++j) {
                                            result = originalResultList.get(j);
                                            buffer.append(result.getName());
                                            if (j + 1 >= originalResultList.size()) continue;
                                            buffer.append("..");
                                        }
                                        original.setProperty(this.logFieldName, buffer.toString());
                                    }
                                    ++this.savedWithErrorsCount;
                                    this.resultExporter.write(original);
                                    ++this.savedToOutputCount;
                                    continue;
                                }
                                if (this.log != null) {
                                    StringBuffer buffer = new StringBuffer();
                                    for (int j = 0; j < appliedFixers.size(); ++j) {
                                        result = (StructureCheckerResult)((Object[])appliedFixers.get(j))[0];
                                        StructureFixer fixer = (StructureFixer)((Object[])appliedFixers.get(j))[1];
                                        buffer.append(result.getName());
                                        buffer.append("->");
                                        buffer.append(fixer.getName());
                                        if (j + 1 < appliedFixers.size()) {
                                            buffer.append("..");
                                        }
                                        this.log.addEntry(this.importers[this.currentFileIndex].getFile(), this.currentMoleculeIndex, result, fixer);
                                    }
                                    if (this.logFieldName != null && buffer.length() > 0) {
                                        mol.setProperty(this.logFieldName, buffer.toString());
                                    }
                                }
                                ++this.automaticallyFixedStructureCount;
                                this.resultExporter.write(mol);
                                ++this.savedToOutputCount;
                                continue;
                            }
                            if (this.log != null && this.logFieldName != null) {
                                mol.setProperty(this.logFieldName, "");
                            }
                            ++this.savedToOutputCount;
                            this.resultExporter.write(mol);
                            continue;
                        }
                        --this.current;
                        this.done = true;
                    }
                    catch (Exception e) {
                        if (!this.ignoreErrors) {
                            this.canceled = true;
                            AlchemistErrorDialog.showError("Structure Checker failed", e);
                            continue;
                        }
                        Exception ex = new Exception("Error at molecule No. " + (this.current + 1L) + " ", e);
                        errorList.add(ex);
                    }
                }
                try {
                    this.importers[i].close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.errorExporter == null) continue;
                try {
                    this.importers[i].close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.resultExporter.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.errorExporter != null) {
                try {
                    this.errorExporter.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.done = true;
            if (this.ignoreErrors && !errorList.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                for (int j = 0; j < errorList.size(); ++j) {
                    Exception exception = (Exception)errorList.get(j);
                    buffer.append("#" + (j + 1) + " " + exception.getMessage());
                    buffer.append(exception.getCause().getMessage());
                    buffer.append("\n\n");
                }
                AlchemistErrorDialog.showError("There were problems during the process", new Exception(buffer.toString()));
            }
        }
        if (this.log != null) {
            this.log.setCanceled(this.canceled);
            this.log.setAutomaticallyFixedStructureCount(this.automaticallyFixedStructureCount);
            this.log.setCheckedStructureCount(this.checkedMoleculeCount);
            this.log.setNotSavedCount(this.notSavedCount);
            this.log.setSavedToOutputCount(this.savedToOutputCount);
            this.log.setSavedToProblemCount(this.savedToProblemCount);
            this.log.setSavedWithErrorsCount(this.savedWithErrorsCount);
            this.log.setStructureWithDetectedProblemsCount(this.structureWithDetectedProblemsCount);
            this.log.setUserFixedStructureCount(this.userFixedStructureCount);
            if (this.logFilePath != null) {
                try {
                    StructureCheckerLog.saveLog(new File(this.logFilePath), this.log);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StructureCheckerTask task = (StructureCheckerTask)super.clone();
        task.setDefaultUserOperation(this.getDefaultOperation());
        task.propertyChangeSupport = new PropertyChangeSupport(task);
        task.errorExporter = null;
        task.importers = null;
        task.resultExporter = null;
        return task;
    }

    @Override
    protected void finished() {
        float num1 = this.current;
        float num2 = this.getLengthOfTask();
        int percent = num2 != 0.0f ? (int)Math.ceil(num1 / num2 * 100.0f) : 0;
        StringBuffer buffer = new StringBuffer(this.canceled ? "Process has been canceled.\n\n" : "Process completed.\n\n");
        buffer.append("Structures checked: \t");
        buffer.append(this.checkedMoleculeCount);
        buffer.append("\nStructures with problems: \t");
        buffer.append(this.structureWithDetectedProblemsCount);
        buffer.append("\n\nStructures fixed automatically:\t");
        buffer.append(this.automaticallyFixedStructureCount);
        buffer.append("\nStructures fixed manually:     \t");
        buffer.append(this.userFixedStructureCount);
        buffer.append("\nStructures saved with errors:  \t");
        buffer.append(this.savedWithErrorsCount);
        buffer.append("\n\nAccepted structures: \t");
        buffer.append(this.savedToOutputCount);
        buffer.append("\nDiscarded structures: \t");
        buffer.append(this.errorExporter != null ? this.savedToProblemCount : this.notSavedCount);
        buffer.append("\n\nOverall progress: \t");
        buffer.append(percent > 100 ? 100 : percent);
        buffer.append("%\nTime elapsed: \t" + this.calcTime() + "\n");
        this.statMessage = buffer.toString();
    }

    @Override
    protected long initializeTask() {
        this.canceled = false;
        this.done = false;
        this.current = 0L;
        this.checkedMoleculeCount = 0;
        this.automaticallyFixedStructureCount = 0;
        this.userFixedStructureCount = 0;
        this.savedWithErrorsCount = 0;
        this.savedToOutputCount = 0;
        this.savedToProblemCount = 0;
        this.notSavedCount = 0;
        this.structureWithDetectedProblemsCount = 0;
        Object[] inputFiles = (Object[])this.state.getProperty("FileListHandlerPanel_InputFileList");
        String configString = (String)this.state.getProperty("StructureChecker_ConfigBuilderConfiguration");
        String outputPath = (String)this.state.getProperty("OutputFilePath");
        String errorPath = (String)this.state.getProperty("ProblemFilePath");
        String outputFormat = (String)this.state.getProperty("OutputFormat");
        String errorFormat = (String)this.state.getProperty("ProblemFormat");
        Boolean ignore = (Boolean)this.state.getProperty("IgnoreFixers");
        Boolean ask = (Boolean)this.state.getProperty("AskOnProblem");
        this.logFilePath = (String)this.state.getProperty("LogFilePath");
        this.logFieldName = (String)this.state.getProperty("LogFieldName");
        this.ignoreErrors = (Boolean)this.state.getProperty("IgnoreErrors");
        this.ignoreOCRErrors = (Boolean)this.state.getProperty("IgnoreOCRErrors");
        this.ignoreFixers = ignore != null ? ignore : false;
        this.askOnProblem = ask != null ? ask : true;
        this.configuration = configString != null ? configString : null;
        long taskLength = 0L;
        if (inputFiles != null) {
            this.numberOfMolecules = new long[inputFiles.length];
            this.importers = new MolImporter[inputFiles.length];
            for (int i = 0; i < inputFiles.length && !this.canceled; ++i) {
                try {
                    MolImporter counter = new MolImporter(inputFiles[i].toString());
                    boolean canReadMore = true;
                    while (canReadMore && !this.canceled) {
                        try {
                            canReadMore = counter.skipRecord();
                            if (!canReadMore) continue;
                            ++taskLength;
                            int n = i;
                            this.numberOfMolecules[n] = this.numberOfMolecules[n] + 1L;
                        }
                        catch (MolFormatException e) {
                        }
                        catch (IOException e) {}
                    }
                    counter.close();
                    this.importers[i] = new MolImporter(inputFiles[i].toString());
                    continue;
                }
                catch (Exception e) {
                    this.canceled = true;
                    AlchemistErrorDialog.showError(e);
                }
            }
        }
        if (outputPath != null && !AlchemistUtilities.isEmpty(outputPath)) {
            try {
                this.resultExporter = new MolExporter(new FileOutputStream(outputPath), outputFormat);
            }
            catch (IOException e) {
                this.canceled = true;
                AlchemistErrorDialog.showError(e);
            }
        }
        if (errorPath != null && !AlchemistUtilities.isEmpty(errorPath)) {
            try {
                this.errorExporter = new MolExporter(new FileOutputStream(errorPath), errorFormat);
            }
            catch (Exception e) {
                this.canceled = true;
                AlchemistErrorDialog.showError(e);
            }
        } else {
            this.errorExporter = null;
        }
        return this.canceled ? 0L : taskLength;
    }

    private static StructureCheckerResult getResultForFixer(StructureFixer fixer, CheckerRunner runner) {
        for (StructureCheckerResult result : runner.getResultList()) {
            List<StructureFixer> fixers = runner.getFixers(result);
            for (StructureFixer newFixer : fixers) {
                if (!newFixer.getName().equalsIgnoreCase(fixer.getName())) continue;
                return result;
            }
        }
        return null;
    }

    private static StructureFixer getFixer(StructureCheckerResult result, ConfigElement[] elements) {
        StructureChecker item = StructureCheckerTask.getConfigItem(result, elements);
        if (item != null && item.getDescriptor().getFixMode().equals((Object)FixMode.FIX)) {
            List<StructureFixer> fixerList = FIXER_FACTORY.getFixers();
            for (StructureFixer fixer : fixerList) {
                if (!fixer.getClass().getName().equals(item.getDescriptor().getFixerClassName())) continue;
                return fixer;
            }
        }
        return null;
    }

    private static StructureChecker getConfigItem(StructureCheckerResult result, ConfigElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            StructureCheckerWrapper wrapper;
            if (!(elements[i] instanceof StructureCheckerWrapper) || !(wrapper = (StructureCheckerWrapper)elements[i]).getItem().equals(result.getSource())) continue;
            return wrapper.getItem();
        }
        return null;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void setUserStructure(Molecule structure) {
        this.usersFix = structure;
    }

    public void setUserOperation(UserOperation operation) {
        this.userOperation = operation;
    }

    public void setDefaultUserOperation(UserOperation operation) {
        this.defaultUserOperation = operation;
    }

    public UserOperation getDefaultOperation() {
        return this.defaultUserOperation;
    }

    @Override
    public void stop() {
        this.getPropertyChangeSupport().firePropertyChange("canceled", false, true);
        super.stop();
    }

    public String getStatusText() {
        if (this.numberOfMolecules == null || this.importers == null) {
            return "Initializing...";
        }
        if (this.numberOfMolecules.length > this.currentFileIndex && this.importers.length > this.currentFileIndex && this.importers[this.currentFileIndex] != null) {
            return "Processing: " + this.currentMoleculeIndex + "/" + this.numberOfMolecules[this.currentFileIndex] + " of " + this.importers[this.currentFileIndex].getFileName();
        }
        return "Unexpected error.";
    }

    public StructureCheckerLog getLog() {
        return this.log;
    }

    public static enum UserOperation {
        ACCEPT,
        DISCARD;

    }
}

