/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.structurechecker.log;

import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.StructureFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class StructureCheckerLog {
    private final Date creationDate;
    final Map<File, FileWriter> loggers = new HashMap<File, FileWriter>();
    final Map<FileWriter, File> writers = new HashMap<FileWriter, File>();
    private int checkedStructureCount = 0;
    private int automaticallyFixedStructureCount = 0;
    private int userFixedStructureCount = 0;
    private int savedWithErrorsCount = 0;
    private int savedToOutputCount = 0;
    private int savedToProblemCount = 0;
    private int notSavedCount = 0;
    private int structureWithDetectedProblemsCount = 0;
    private boolean canceled = false;

    public static StructureCheckerLog createLog() {
        return new StructureCheckerLog();
    }

    public static void saveLog(OutputStream output, StructureCheckerLog log) throws IOException {
        File outputFile = File.createTempFile("structureChecker", "log");
        StructureCheckerLog.saveLog(outputFile, log);
        FileInputStream input = new FileInputStream(outputFile);
        byte[] buffer = new byte[1024];
        int length = input.read(buffer);
        while (length > 0) {
            byte[] fbuf = new byte[length];
            System.arraycopy(buffer, 0, fbuf, 0, length);
            output.write(fbuf);
            length = input.read(buffer);
        }
        output.flush();
    }

    public static void saveLog(File outputFile, StructureCheckerLog log) throws IOException {
        File[] files = log.loggers.keySet().toArray(new File[0]);
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        FileChannel out = new FileOutputStream(outputFile).getChannel();
        out.position(out.size());
        out.write(ByteBuffer.wrap(log.getHeaderData().getBytes()));
        for (int i = 0; i < files.length; ++i) {
            out.write(ByteBuffer.wrap(("\nInput File: " + files[i].getAbsolutePath() + "\n").getBytes()));
            out.write(ByteBuffer.wrap("Structure\tProblem\tApplied Fix\tFixed\n".getBytes()));
            FileWriter writer = log.loggers.get(files[i]);
            writer.flush();
            FileChannel in = new FileInputStream(log.writers.get(log.loggers.get(files[i]))).getChannel();
            in.transferTo(0L, in.size(), out);
            in.close();
        }
        out.close();
    }

    private StructureCheckerLog() {
        this.creationDate = new Date();
    }

    private void addEntry(LogEntry entry) {
        FileWriter writer = null;
        if (this.loggers.containsKey(entry.sourceFile)) {
            writer = this.loggers.get(entry.sourceFile);
        } else {
            try {
                File tempFile = File.createTempFile("structureChecker", "log");
                writer = new FileWriter(tempFile);
                this.loggers.put(entry.sourceFile, writer);
                this.writers.put(writer, tempFile);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (writer != null) {
            try {
                writer.write(entry.structureIndex + "\t" + entry.result.getName() + "\t" + (entry.appliedFixer == null ? "-" : entry.appliedFixer.getName()) + "\t" + entry.fixed + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addEntry(File sourceFile, int structureIndex, StructureCheckerResult result, boolean fixed) {
        this.addEntry(sourceFile, structureIndex, result, null, fixed);
    }

    public void addEntry(File sourceFile, int structureIndex, StructureCheckerResult result, StructureFixer appliedFixer) {
        this.addEntry(sourceFile, structureIndex, result, appliedFixer, true);
    }

    public void addEntry(File sourceFile, int structureIndex, StructureCheckerResult[] result) {
        this.addEntry(sourceFile, structureIndex, result, false);
    }

    public void addEntry(File sourceFile, int structureIndex, StructureCheckerResult[] result, boolean fixed) {
        for (int i = 0; i < result.length; ++i) {
            this.addEntry(sourceFile, structureIndex, result[i], fixed);
        }
    }

    private void addEntry(File sourceFile, int structureIndex, StructureCheckerResult result, StructureFixer appliedFixer, boolean fixed) {
        this.addEntry(new LogEntry(sourceFile, structureIndex, result, appliedFixer, fixed));
    }

    String getHeaderData() {
        StringBuffer header = new StringBuffer(350);
        header.append("Structure Checker Log File\n\nStructures checked: \t");
        header.append(this.checkedStructureCount);
        header.append("\nStructures with problems: \t");
        header.append(this.structureWithDetectedProblemsCount);
        header.append("\n\nStructures fixed automatically: \t");
        header.append(this.automaticallyFixedStructureCount);
        header.append("\nStructures fixed manually: \t");
        header.append(this.userFixedStructureCount);
        header.append("\nUnfixed structures: \t");
        header.append(this.savedWithErrorsCount);
        header.append("\n\nAccepted structures: \t");
        header.append(this.savedToOutputCount);
        header.append("\nDiscarded structures: \t");
        header.append(this.savedToOutputCount > 0 ? this.savedToProblemCount : this.notSavedCount);
        header.append(this.canceled ? "\n\nProgress has been cancelled.\n\n" : "\n\nProgress has been completed succesfully.\n\n");
        header.append("Created at " + this.creationDate.toString() + " with ChemAxon's Structure Checker\n\n");
        return header.toString();
    }

    public void setCheckedStructureCount(int checkedStructureCount) {
        this.checkedStructureCount = checkedStructureCount;
    }

    public void setAutomaticallyFixedStructureCount(int automaticallyFixedStructureCount) {
        this.automaticallyFixedStructureCount = automaticallyFixedStructureCount;
    }

    public void setUserFixedStructureCount(int userFixedStructureCount) {
        this.userFixedStructureCount = userFixedStructureCount;
    }

    public void setSavedWithErrorsCount(int savedWithErrorsCount) {
        this.savedWithErrorsCount = savedWithErrorsCount;
    }

    public void setSavedToOutputCount(int savedToOutputCount) {
        this.savedToOutputCount = savedToOutputCount;
    }

    public void setSavedToProblemCount(int savedToProblemCount) {
        this.savedToProblemCount = savedToProblemCount;
    }

    public void setNotSavedCount(int notSavedCount) {
        this.notSavedCount = notSavedCount;
    }

    public void setStructureWithDetectedProblemsCount(int structureWithDetectedProblemsCount) {
        this.structureWithDetectedProblemsCount = structureWithDetectedProblemsCount;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    static class LogEntry {
        private final File sourceFile;
        private final int structureIndex;
        private final StructureCheckerResult result;
        private final StructureFixer appliedFixer;
        private final boolean fixed;

        public LogEntry(File sourceFile, int structureIndex, StructureCheckerResult result, StructureFixer appliedFixer, boolean fixed) {
            this.sourceFile = sourceFile;
            this.structureIndex = structureIndex;
            this.result = result;
            this.appliedFixer = appliedFixer;
            this.fixed = fixed;
        }
    }
}

