/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.structurechecker.log;

import chemaxon.alchemist.structurechecker.log.StructureCheckerLog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class StructureCheckerLogView
extends JPanel {
    private JScrollPane scroll = null;
    private JPanel container = null;

    public StructureCheckerLogView() {
        super(new BorderLayout());
        this.add((Component)this.getScroll(), "Center");
    }

    private JScrollPane getScroll() {
        if (this.scroll == null) {
            this.scroll = new JScrollPane(20, 31);
            this.scroll.setViewportView(this.getInnerContainer());
        }
        return this.scroll;
    }

    private JPanel getInnerContainer() {
        if (this.container == null) {
            this.container = new JPanel();
            this.container.setLayout(new BoxLayout(this.container, 1));
            this.container.setBackground(Color.WHITE);
            this.container.setOpaque(true);
            this.container.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        }
        return this.container;
    }

    public void showLog(StructureCheckerLog log) {
        this.getInnerContainer().removeAll();
        if (log == null) {
            return;
        }
        File[] files = log.loggers.keySet().toArray(new File[0]);
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        JTextArea header = new JTextArea(log.getHeaderData());
        header.setOpaque(false);
        header.setBorder(null);
        header.setEditable(false);
        this.getInnerContainer().add(Box.createVerticalStrut(20));
        this.getInnerContainer().add(header);
        for (int i = 0; i < files.length; ++i) {
            this.getInnerContainer().add(Box.createVerticalStrut(20));
            this.addData(log, files[i]);
        }
    }

    private void addData(StructureCheckerLog log, File file) {
        JLabel label = new JLabel();
        DefaultTableModel model = new DefaultTableModel(new Object[]{"Structure", "Problem", "Applied Fix", "Fixed"}, 0);
        int[] prefColWidth = new int[4];
        try {
            FileWriter writer = log.loggers.get(file);
            writer.flush();
            BufferedReader reader = new BufferedReader(new FileReader(log.writers.get(log.loggers.get(file))));
            String line = "Structure\tProblem\tApplied Fix\tFixed";
            while (line != null) {
                Object[] data = line.split("\t");
                model.addRow(data);
                for (int i = 0; i < prefColWidth.length; ++i) {
                    int w = SwingUtilities.computeStringWidth(label.getFontMetrics(label.getFont()), " " + (String)data[i] + " ");
                    if (w <= prefColWidth[i]) continue;
                    prefColWidth[i] = w;
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        JTable table = new JTable(model){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        table.setTableHeader(null);
        table.setAutoResizeMode(0);
        table.setGridColor(Color.WHITE);
        for (int i = 0; i < prefColWidth.length; ++i) {
            table.getColumnModel().getColumn(i).setPreferredWidth(prefColWidth[i]);
        }
        table.setSelectionMode(2);
        JPanel holder = new JPanel(new BorderLayout());
        holder.setOpaque(false);
        holder.add((Component)table, "West");
        JLabel title = new JLabel("Input file: " + file.getAbsolutePath());
        title.setOpaque(false);
        holder.add((Component)title, "North");
        this.getInnerContainer().add(Box.createVerticalStrut(10));
        this.getInnerContainer().add(holder);
    }
}

