/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.toxicity;

import chemaxon.alchemist.utils.AlchemistMoleculeView;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AlchemistToxicityBrowser {
    private final AlchemistMoleculeView moleculeView = new AlchemistMoleculeView(1, 1, false);
    private final AlchemistMoleculeView toxicFragmentView = new AlchemistMoleculeView(1, 1, false);
    private final AlchemistMoleculeView toxicParentView = new AlchemistMoleculeView(1, 1, false);
    private final JPanel panel = new JPanel();
    private final PropertyChangeListener moleculeSelectionChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "SelectedMoleculeChanged" && evt.getNewValue() != null) {
                AlchemistToxicityBrowser.this.handleMoleculeSelectionChange(AlchemistToxicityBrowser.this.moleculeView, AlchemistToxicityBrowser.this.toxicFragmentView, "TOXICOPHORES");
            }
        }
    };
    private final PropertyChangeListener toxicFragmentSelectionChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "SelectedMoleculeChanged" && evt.getNewValue() != null) {
                AlchemistToxicityBrowser.this.handleMoleculeSelectionChange(AlchemistToxicityBrowser.this.toxicFragmentView, AlchemistToxicityBrowser.this.toxicParentView, "TOXIC_PARENTS");
            }
        }
    };

    private void handleMoleculeSelectionChange(AlchemistMoleculeView source, AlchemistMoleculeView target, String propertyKey) {
        Molecule molecule = source.getSelectedMolecule();
        if (molecule != null) {
            String molecules = molecule.getProperty(propertyKey);
            target.clear();
            target.importMolecules(new ByteArrayInputStream(molecules.getBytes()));
        } else {
            target.clear();
        }
    }

    public AlchemistToxicityBrowser() {
        this.initialize();
    }

    private void initialize() {
        this.moleculeView.addPropertyChangeListener(this.moleculeSelectionChangeListener);
        this.toxicFragmentView.addPropertyChangeListener(this.toxicFragmentSelectionChangeListener);
        JLabel molecules = new JLabel("Molecules", 0);
        JPanel moleculeViewPanel = new JPanel(new BorderLayout());
        moleculeViewPanel.add((Component)molecules, "North");
        moleculeViewPanel.add((Component)this.moleculeView, "Center");
        JLabel toxicFragments = new JLabel("Toxic fragments", 0);
        JPanel toxicFragmentViewPanel = new JPanel(new BorderLayout());
        toxicFragmentViewPanel.add((Component)this.toxicFragmentView, "Center");
        toxicFragmentViewPanel.add((Component)toxicFragments, "North");
        JLabel toxicParents = new JLabel("Toxic fragment parents", 0);
        JPanel toxicParentViewPanel = new JPanel(new BorderLayout());
        toxicParentViewPanel.add((Component)this.toxicParentView, "Center");
        toxicParentViewPanel.add((Component)toxicParents, "North");
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(moleculeViewPanel);
        this.panel.add(toxicFragmentViewPanel);
        this.panel.add(toxicParentViewPanel);
    }

    public void setToxicityFile(File toxicityFile) {
        this.setToxicityFile(toxicityFile.getAbsolutePath());
    }

    public void setToxicityFile(String toxicityFilePath) {
        this.validate();
        this.moleculeView.importMolecules(toxicityFilePath);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void validate() {
    }
}

